/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.PlayerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.checkerframework.checker.nullness.qual.NonNull;

public class WaterHolderTalent
extends TalentInstance {
    private static int EFFECT_RANGE = 5;
    private static int SEARCH_RADIUS = 12;
    private int waterUnitLeft;
    private int ticktillSearch;
    private int tickTillRegenWater;
    private int tickScheduledForExtinguish = 0;
    private boolean scheduledExtinguish = false;

    public WaterHolderTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dog) {
    }

    private int getMaxWaterHold() {
        return 5 + this.level() * 3;
    }

    private float getOnFireTickFactor() {
        return 0.2f * (float)this.level();
    }

    private int decreaseTickOnFire(int tickOnFire) {
        if (tickOnFire <= 2) {
            return 0;
        }
        return Mth.floor((float)((float)tickOnFire - this.getOnFireTickFactor() * (float)tickOnFire));
    }

    private int getWaterUnitleft() {
        return this.waterUnitLeft;
    }

    private void setWaterUnitLeft(int unit) {
        this.waterUnitLeft = Mth.clamp((int)unit, (int)0, (int)this.getMaxWaterHold());
    }

    private void incWaterUnitLeft() {
        this.setWaterUnitLeft(this.getWaterUnitleft() + 1);
    }

    private void decWaterUnitLeft() {
        this.setWaterUnitLeft(this.getWaterUnitleft() - 1);
    }

    @Override
    public void livingTick(AbstractDog abstractDog) {
        if (abstractDog.level().isClientSide) {
            return;
        }
        if (!(abstractDog instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)abstractDog;
        if (dog.readyForNonTrivialAction() && !dog.getMode().shouldAttack() && dog.onGround() && --this.ticktillSearch <= 0) {
            this.ticktillSearch = 10;
            LivingEntity target = this.findOnFireTarget(abstractDog);
            if (target != null && this.stillValidTarget(dog, target)) {
                this.triggerExtinguishAction(dog, target);
            }
        }
        if (this.scheduledExtinguish && abstractDog.tickCount >= this.tickScheduledForExtinguish) {
            this.extinguishNearby(abstractDog);
            this.scheduledExtinguish = false;
        }
        if (abstractDog.isInWaterOrRain() && --this.tickTillRegenWater <= 0) {
            this.tickTillRegenWater = 10;
            this.incWaterUnitLeft();
        }
    }

    public void triggerExtinguishAction(Dog dog, LivingEntity target) {
        dog.triggerAction(new ExtinguishAction(dog, this, target));
    }

    @Override
    public DogInteractionResult processInteract(AbstractDog dog, Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() instanceof BucketItem && !dog.level().isClientSide && player.isShiftKeyDown()) {
            MutableComponent c1 = Component.translatable((String)"talent.doggytalents.water_holder.amount", (Object[])new Object[]{dog.getName().getString()});
            c1.append((Component)Component.literal((String)": "));
            if (this.level < this.talent.getMaxLevel()) {
                c1.append((Component)Component.literal((String)("" + this.getWaterUnitleft())).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(239100)));
                c1.append((Component)Component.literal((String)("/" + this.getMaxWaterHold())));
            } else {
                c1.append((Component)Component.translatable((String)"talent.doggytalents.water_holder.amount.unlim").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(239100)));
            }
            PlayerUtil.sendSystemMessage((LivingEntity)player, (Component)c1);
            return DogInteractionResult.SUCCESS;
        }
        if (stack.getItem() == Items.WATER_BUCKET) {
            if (!dog.level().isClientSide) {
                if (this.getWaterUnitleft() >= this.getMaxWaterHold()) {
                    return DogInteractionResult.PASS;
                }
                this.setWaterUnitLeft(this.getMaxWaterHold());
                if (!player.getAbilities().instabuild) {
                    player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
                }
                dog.playSound(SoundEvents.BUCKET_FILL, dog.getSoundVolume(), 1.0f);
                Level level2 = dog.level();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level2;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SPLASH, dog.getX(), dog.getY(), dog.getZ(), this.level * 8, (double)dog.getBbWidth(), (double)0.8f, (double)dog.getBbWidth(), 0.5);
                }
            }
            return DogInteractionResult.SUCCESS;
        }
        return DogInteractionResult.PASS;
    }

    @Override
    public void writeToNBT(AbstractDog dog, CompoundTag compound) {
        super.writeToNBT(dog, compound);
        compound.putInt("DTwaterUnitLeft", this.getWaterUnitleft());
    }

    @Override
    public void readFromNBT(AbstractDog dog, CompoundTag_1_21_5 compound) {
        super.readFromNBT(dog, compound);
        this.setWaterUnitLeft(compound.getInt("DTwaterUnitLeft"));
    }

    private void extinguishNearby(AbstractDog dog) {
        List<LivingEntity> targets = this.getNearbyOnFire(dog);
        if (targets.isEmpty()) {
            return;
        }
        this.decWaterUnitLeft();
        for (LivingEntity e : targets) {
            this.extinguishEntity(dog, e);
        }
    }

    private void extinguishEntity(AbstractDog dog, LivingEntity e) {
        int a0 = e.getRemainingFireTicks();
        e.setRemainingFireTicks(this.decreaseTickOnFire(a0));
        e.playSound(SoundEvents.FIRE_EXTINGUISH, 0.5f, 2.6f + e.getRandom().nextFloat() - e.getRandom().nextFloat() * 0.8f);
        Level level = dog.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, e.getX(), e.getY(), e.getZ(), 15, (double)e.getBbWidth(), (double)0.8f, (double)e.getBbWidth(), 0.1);
        }
        BlockPos e_b0 = e.blockPosition();
        BlockPos.MutableBlockPos e_b0m = e_b0.mutable();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                e_b0m.setX(e_b0.getX() + i);
                e_b0m.setZ(e_b0.getZ() + j);
                if (e.level().getBlockState((BlockPos)e_b0m).getBlock() != Blocks.FIRE) continue;
                e.level().setBlockAndUpdate((BlockPos)e_b0m, Blocks.AIR.defaultBlockState());
            }
        }
    }

    public void scheduleDelayedExtinguish(AbstractDog dog) {
        if (this.scheduledExtinguish) {
            return;
        }
        this.scheduledExtinguish = true;
        this.tickScheduledForExtinguish = dog.tickCount + this.getDelay();
    }

    private List<LivingEntity> getNearbyOnFire(AbstractDog dog) {
        LivingEntity owner = dog.getOwner();
        if (owner == null) {
            return List.of();
        }
        return dog.level().getEntitiesOfClass(LivingEntity.class, dog.getBoundingBox().inflate((double)EFFECT_RANGE, 4.0, (double)EFFECT_RANGE), e -> {
            if (!e.isOnFire()) return false;
            if (!(owner == e || e instanceof AbstractDog && ((AbstractDog)e).getOwner() == owner || e instanceof Wolf && ((Wolf)e).getOwner() == owner)) {
                if (!(e instanceof Player)) return false;
                Player p = (Player)e;
                if (!(dog instanceof Dog)) return false;
                Dog d = (Dog)dog;
                if (!d.regardTeamPlayers()) return false;
                if (!p.isAlliedTo((Entity)owner)) return false;
            }
            if (!dog.getSensing().hasLineOfSight((Entity)e)) return false;
            return true;
        });
    }

    private LivingEntity findOnFireTarget(AbstractDog dog) {
        List teamPlayers;
        Dog ddog;
        List wolves;
        List dogs;
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        Predicate<LivingEntity> onFireAndWitness = e -> e.isOnFire() && e.onGround() && dog.getSensing().hasLineOfSight((Entity)e);
        LivingEntity owner = dog.getOwner();
        if (owner == null) {
            return null;
        }
        if (onFireAndWitness.test(owner)) {
            targets.add(owner);
        }
        if (!(dogs = dog.level().getEntitiesOfClass(AbstractDog.class, dog.getBoundingBox().inflate((double)SEARCH_RADIUS, 4.0, (double)SEARCH_RADIUS), d -> d.getOwner() == owner && onFireAndWitness.test((LivingEntity)d))).isEmpty()) {
            targets.addAll(dogs);
        }
        if (!(wolves = dog.level().getEntitiesOfClass(Wolf.class, dog.getBoundingBox().inflate((double)SEARCH_RADIUS, 4.0, (double)SEARCH_RADIUS), w -> w.getOwner() == owner && onFireAndWitness.test((LivingEntity)w))).isEmpty()) {
            targets.addAll(wolves);
        }
        if (dog instanceof Dog && (ddog = (Dog)dog).regardTeamPlayers() && !(teamPlayers = dog.level().getEntitiesOfClass(Player.class, dog.getBoundingBox().inflate((double)SEARCH_RADIUS, 4.0, (double)SEARCH_RADIUS), p -> p.isAlliedTo((Entity)owner) && onFireAndWitness.test((LivingEntity)p))).isEmpty()) {
            targets.addAll(teamPlayers);
        }
        return this.selectOnFireTarget(dog, targets);
    }

    private LivingEntity selectOnFireTarget(AbstractDog dog, List<LivingEntity> targets) {
        if (targets.isEmpty()) {
            return null;
        }
        LivingEntity target = targets.get(0);
        double mindistanceSqr = target.distanceToSqr((Entity)dog);
        LivingEntity owner = dog.getOwner();
        for (LivingEntity i : targets) {
            if (owner == i) {
                return i;
            }
            double d = i.distanceToSqr((Entity)dog);
            if (!(d < mindistanceSqr)) continue;
            target = i;
            mindistanceSqr = d;
        }
        return target;
    }

    public int getDelay() {
        return 10;
    }

    private boolean canAffordToExtinguish(AbstractDog dog) {
        return this.getWaterUnitleft() > 0 || this.level() >= this.talent.getMaxLevel();
    }

    private boolean stillValidTarget(Dog dog, LivingEntity target) {
        if (!target.isAlive()) {
            return false;
        }
        if (target.getRemainingFireTicks() < 30) {
            return false;
        }
        if (!this.canAffordToExtinguish(dog)) {
            return false;
        }
        if (target.isInLava()) {
            return false;
        }
        return !(dog.distanceToSqr((Entity)target) > 400.0);
    }

    public static class ExtinguishAction
    extends TriggerableAction {
        private WaterHolderTalent talentInst;
        private @NonNull LivingEntity target;
        private int ticksUntilPathRecalc = 0;
        private final int stopDist = 2;

        public ExtinguishAction(Dog dog, WaterHolderTalent talentInst, @NonNull LivingEntity target) {
            super(dog, false, true);
            this.talentInst = talentInst;
            this.target = target;
        }

        @Override
        public boolean shouldStopAndFollowOwner() {
            return true;
        }

        @Override
        public float getDistanceForFollowOwner() {
            return 20.0f;
        }

        @Override
        public void onStart() {
            this.ticksUntilPathRecalc = 0;
        }

        @Override
        public void tick() {
            if (this.dog.getMode().shouldAttack()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!this.talentInst.stillValidTarget(this.dog, this.target)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.distanceToSqr((Entity)this.target) > 4.0) {
                this.dog.getLookControl().setLookAt((Entity)this.target, 10.0f, (float)this.dog.getMaxHeadXRot());
                if (--this.ticksUntilPathRecalc <= 0) {
                    this.ticksUntilPathRecalc = 10;
                    if (!this.dog.isLeashed() && !this.dog.isPassenger()) {
                        this.dog.getNavigation().moveTo((Entity)this.target, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else {
                this.dog.getNavigation().stop();
                if (this.dog.canDogDoShakeAnim()) {
                    this.dog.startShakingAndBroadcast(false);
                    this.talentInst.scheduleDelayedExtinguish(this.dog);
                }
            }
        }

        @Override
        public void onStop() {
        }

        @Override
        public boolean canOverrideSit() {
            return true;
        }
    }
}

