/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.dogpromise.promise;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.CachedSearchUtil.CachedSearchUtil;
import doggytalents.common.util.dogpromise.promise.AbstractPromise;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;

public class DogBatchTeleportToDimensionPromise
extends AbstractPromise {
    private final List<Dog> dogs;
    private final UUID playerUUID;
    private final ResourceKey<Level> dimeansion;
    private final ServerLevel origin;
    private final Predicate<Dog> dogValidator;
    private int tickTillCheck;
    private int timeOut;

    public DogBatchTeleportToDimensionPromise(List<Dog> dogs, ServerLevel origin, UUID playerUUID, ResourceKey<Level> dimeansion, Predicate<Dog> dogValidator) {
        this.dogs = dogs;
        this.playerUUID = playerUUID;
        this.dimeansion = dimeansion;
        this.origin = origin;
        this.dogValidator = dogValidator;
    }

    @Override
    public void start() {
        this.forceDogChunk();
        this.tickTillCheck = 7;
        this.timeOut = 50;
    }

    @Override
    public void tick() {
        if (--this.timeOut <= 0) {
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        if (--this.tickTillCheck > 0) {
            return;
        }
        this.tickTillCheck = 20;
        MinecraftServer mcServer = this.origin.getServer();
        ServerLevel targetLevel = mcServer.getLevel(this.dimeansion);
        if (targetLevel == null) {
            return;
        }
        if (targetLevel == this.origin) {
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        Player owner = targetLevel.getPlayerByUUID(this.playerUUID);
        if (owner == null) {
            return;
        }
        BlockPos owner_b0 = owner.blockPosition();
        if (!this.allChunkInvoledAtTargetIsLoaded(targetLevel, owner_b0)) {
            return;
        }
        List<Dog> tp_dogs = this.dogs.stream().filter(d -> d.isDoingFine()).collect(Collectors.toList());
        if (tp_dogs.isEmpty()) {
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        List<BlockPos> safePosList = CachedSearchUtil.getAllSafePosUsingPool((Level)targetLevel, tp_dogs, owner_b0, 4, 1);
        if (safePosList.isEmpty()) {
            return;
        }
        for (Dog dog : tp_dogs) {
            int index = dog.getRandom().nextInt(safePosList.size());
            dog.unRide();
            this.teleportDog(dog, targetLevel, safePosList.get(index));
        }
        this.setState(AbstractPromise.State.FULFILLED);
    }

    private boolean allChunkInvoledAtTargetIsLoaded(ServerLevel target, BlockPos ownerPos) {
        ChunkPos center = new ChunkPos(ownerPos);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (target.getChunkSource().hasChunk(center.x + i, center.z + j)) continue;
                return false;
            }
        }
        return true;
    }

    private void teleportDog(Dog dog0, ServerLevel targetLevel, BlockPos pos) {
        if (!this.dogValidator.test(dog0)) {
            return;
        }
        dog0.authorizeChangeDimension();
        dog0.changeDimension(DogBatchTeleportToDimensionPromise.getDogTransition(targetLevel, dog0, pos));
    }

    @Override
    public void onFulfilled() {
    }

    @Override
    public void onRejected() {
    }

    private void forceDogChunk() {
        for (Dog dog : this.dogs) {
            if (!dog.isDoingFine()) continue;
            ChunkPos chunkpos = new ChunkPos(dog.blockPosition());
            this.accquireChunk(this.origin, chunkpos);
        }
    }

    private static TeleportTransition getDogTransition(ServerLevel level, Dog dog, BlockPos safePos) {
        return new TeleportTransition(level, Vec3.atBottomCenterOf((Vec3i)safePos), Vec3.ZERO, dog.getYRot(), dog.getXRot(), Set.of(), TeleportTransition.DO_NOTHING);
    }
}

