/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.variant;

import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.util.RandomUtil;
import doggytalents.common.util.Util;
import doggytalents.common.variant.DogVariant;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class MoltenWolfVariant
extends DogVariant
implements IDogAlteration {
    public MoltenWolfVariant(String name) {
        super(DogVariant.props(name).guiColor(-3453396).glowingOverlay(Util.getResource("textures/entity/dog/classical/compl/overlay/wolf_molten_overlay.png")).customInjuredTexture(Util.getResource("textures/entity/dog/classical/compl/overlay/wolf_molten_injured.png")).burnsPetter().preventWetShade());
    }

    @Override
    public void props(AbstractDog dog, DogAlterationProps props) {
        props.setFallImmune();
        props.setFireImmune();
    }

    @Override
    public void tick(AbstractDog dog) {
        double dz;
        double dx;
        boolean is_moving;
        if (!dog.level().isClientSide) {
            return;
        }
        if (!((Boolean)ConfigHandler.CLIENT.DOG_VARIANT_CLIENT_EFFECT.get()).booleanValue()) {
            return;
        }
        if (dog.isDefeated() || !dog.isDogVariantRenderEffective()) {
            return;
        }
        RandomSource random = dog.getRandom();
        Level level = dog.level();
        if (random.nextInt(100) == 0) {
            double d0 = dog.getX() + (double)(RandomUtil.nextFloatRemapped(random) * (dog.getBbWidth() / 2.0f));
            double d1 = dog.getY() + (double)(random.nextFloat() * dog.getBbHeight());
            double d2 = dog.getZ() + (double)(RandomUtil.nextFloatRemapped(random) * (dog.getBbWidth() / 2.0f));
            level.addParticle((ParticleOptions)ParticleTypes.LAVA, d0, d1, d2, 0.0, 0.0, 0.0);
            level.playLocalSound(d0, d1, d2, SoundEvents.LAVA_POP, SoundSource.AMBIENT, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
        boolean bl = is_moving = (dx = dog.getX() - dog.xo) * dx + (dz = dog.getZ() - dog.zo) * dz > 2.500000277905201E-7;
        if (is_moving && dog.getRandom().nextInt(3) == 0) {
            int r = dog.getRandom().nextInt(3);
            SimpleParticleType type = null;
            type = r == 0 ? ParticleTypes.FLAME : ParticleTypes.LANDING_LAVA;
            if (type != null) {
                double d0 = dog.getX() + (double)(RandomUtil.nextFloatRemapped(random) * (dog.getBbWidth() / 2.0f));
                double d1 = dog.getY() + (double)random.nextFloat() * ((double)dog.getBbHeight() * 0.8);
                double d2 = dog.getZ() + (double)(RandomUtil.nextFloatRemapped(random) * (dog.getBbWidth() / 2.0f));
                level.addParticle((ParticleOptions)type, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }
}

