/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model.animation;

import doggytalents.client.entity.model.AnimatedSyncedAccessoryModel;
import doggytalents.client.entity.model.animation.SimpleAnimatedModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.common.entity.Dog;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_630;
import net.minecraft.class_7179;
import net.minecraft.class_7184;
import net.minecraft.class_7186;
import org.apache.commons.lang3.function.Consumers;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class DogKeyframeAnimations {
    public static void animate(DogModel model, Dog dog, class_7184 animation, long elapsed_in_millis, float interpolation_scale, Vector3f temp_buffer) {
        DogKeyframeAnimations.keyframeAnimate(AnimationContext.of(model::searchForPartWithName, part -> model.resetPart((class_630)part, dog), part -> model.adjustAnimatedPart((class_630)part, dog)), animation, elapsed_in_millis, interpolation_scale, temp_buffer);
    }

    public static void animate(AnimatedSyncedAccessoryModel model, Dog dog, class_7184 animation, long elapsed_in_millis, float interpolation_scale, Vector3f temp_buffer) {
        DogKeyframeAnimations.keyframeAnimate(AnimationContext.of(model::searchForPartWithName, part -> model.resetPart((class_630)part, dog)), animation, elapsed_in_millis, interpolation_scale, temp_buffer);
    }

    public static void animateSimple(SimpleAnimatedModel model, class_7184 animation, long elapsed_in_millis, float interpolation_scale, Vector3f temp_buffer) {
        DogKeyframeAnimations.keyframeAnimate(AnimationContext.of(model::getPartFromName, model::resetPart), animation, elapsed_in_millis, interpolation_scale, temp_buffer);
    }

    public static float getCurrentAnimatedYRot(Dog dog, class_7184 animation, long elapsed_in_millis, float swing) {
        float elapsed_in_seconds = DogKeyframeAnimations.getElapsedSeconds(animation, elapsed_in_millis);
        List rootChannelList = (List)animation.comp_599().get("root");
        if (rootChannelList == null || rootChannelList.isEmpty()) {
            return 0.0f;
        }
        class_7179 rotationChannel = null;
        for (class_7179 channel : rootChannelList) {
            if (channel.comp_595() != class_7179.class_7183.field_37887) continue;
            rotationChannel = channel;
        }
        if (rotationChannel == null) {
            return 0.0f;
        }
        Vector3f result = new Vector3f(0.0f, 0.0f, 0.0f);
        DogKeyframeAnimations.getAnimationValueForChannel(result, rotationChannel, elapsed_in_seconds, swing);
        return result.y;
    }

    public static void keyframeAnimate(AnimationContext context, class_7184 animation, long elapsed_in_millis, float swing, Vector3f buffer) {
        float elapsed_in_seconds = DogKeyframeAnimations.getElapsedSeconds(animation, elapsed_in_millis);
        for (Map.Entry entry : animation.comp_599().entrySet()) {
            Optional<class_630> partOptional = context.getPart((String)entry.getKey());
            if (partOptional.isEmpty()) continue;
            class_630 part = partOptional.get();
            context.resetPart(part);
            List channelList = (List)entry.getValue();
            for (class_7179 channel : channelList) {
                DogKeyframeAnimations.getAnimationValueForChannel(buffer, channel, elapsed_in_seconds, swing);
                channel.comp_595().apply(part, buffer);
                context.adjustAnimatedPart(part);
            }
        }
    }

    public static void getAnimationValueForChannel(Vector3f buffer, class_7179 channel, float elapsed_seconds, float swing) {
        class_7186[] keyframes = channel.comp_596();
        if (keyframes.length <= 0) {
            return;
        }
        int kf_indx_now = class_3532.method_15360((int)0, (int)keyframes.length, compare_indx -> elapsed_seconds <= keyframes[compare_indx].comp_600()) - 1;
        kf_indx_now = class_3532.method_15340((int)kf_indx_now, (int)0, (int)(keyframes.length - 1));
        int kf_indx_next = class_3532.method_15340((int)(kf_indx_now + 1), (int)0, (int)(keyframes.length - 1));
        class_7186 kf_now = keyframes[kf_indx_now];
        class_7186 kf_next = keyframes[kf_indx_next];
        float time_between = kf_next.comp_600() - kf_now.comp_600();
        float t_since_kf_now = elapsed_seconds - kf_now.comp_600();
        float progress = 0.0f;
        if (time_between > 0.0f) {
            progress = class_3532.method_15363((float)(t_since_kf_now / time_between), (float)0.0f, (float)1.0f);
        }
        kf_next.comp_602().apply(buffer, progress, keyframes, kf_indx_now, kf_indx_next, swing);
    }

    public static float getElapsedSeconds(class_7184 animation, long raw_millis) {
        float f = (float)raw_millis / 1000.0f;
        return animation.comp_598() ? f % animation.comp_597() : f;
    }

    public static Optional<class_630> searchForPartWithName(class_630 root, String name) {
        return DogKeyframeAnimations.searchForPartWithName(root, name, true);
    }

    public static Optional<class_630> searchForPartWithName(class_630 root, String name, boolean check_root) {
        if (root.method_41919(name)) {
            return Optional.of(root.method_32086(name));
        }
        if (check_root && name.equals("root")) {
            return Optional.of(root);
        }
        Optional<class_630> partOptional = root.method_32088().filter(part -> part.method_41919(name)).findFirst();
        return partOptional.map(part -> part.method_32086(name));
    }

    public static interface AnimationContext {
        public static AnimationContext of(Function<String, Optional<class_630>> partGetter, Consumer<class_630> partReset) {
            return AnimationContext.of(partGetter, partReset, Consumers.nop());
        }

        public static AnimationContext of(final Function<String, Optional<class_630>> partGetter, final Consumer<class_630> partReset, final Consumer<class_630> partAdjust) {
            return new AnimationContext(){

                @Override
                public Optional<class_630> getPart(String name) {
                    return (Optional)partGetter.apply(name);
                }

                @Override
                public void resetPart(class_630 part) {
                    partReset.accept(part);
                }

                @Override
                public void adjustAnimatedPart(class_630 part) {
                    partAdjust.accept(part);
                }
            };
        }

        public Optional<class_630> getPart(String var1);

        public void resetPart(class_630 var1);

        public void adjustAnimatedPart(class_630 var1);
    }
}

