/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer.accessory;

import doggytalents.client.backward_imitate.DogRenderLayer_21_3;
import doggytalents.client.backward_imitate.DogRenderState_21_3;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.render.DogRenderer;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogIncapacitatedMananger;
import doggytalents.common.lib.Resources;
import java.util.Optional;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_9848;

public class IncapacitatedRenderer
extends DogRenderLayer_21_3 {
    private DogModel defaultModel = DogModelRegistry.getDogModelHolder("default").getValue();

    public IncapacitatedRenderer(class_3883 parentRenderer, class_5617.class_5618 ctx) {
        super((class_3883<DogRenderState_21_3, DogModel>)parentRenderer);
    }

    @Override
    public void render(class_4587 poseStack, class_4597 buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DogIncapacitatedMananger.IncapacitatedSyncState sync_state;
        class_2960 texture_rl;
        DogModel model;
        if (!dog.method_6181() || dog.method_5767()) {
            return;
        }
        if (!dog.isDefeated()) {
            return;
        }
        DogSkin skin = dog.getClientSkin();
        if (skin.useCustomModel() && !(model = skin.getCustomModel().getValue()).incapShouldRender(dog)) {
            return;
        }
        if (!((Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_INCAPACITATED_TEXTURE)).booleanValue()) {
            return;
        }
        DogModel dogModel = (DogModel)this.method_17165();
        if (dogModel.useDefaultModelForAccessories()) {
            dogModel.copyPropertiesTo(this.defaultModel);
            this.defaultModel.copyFrom(dogModel);
            dogModel = this.defaultModel;
        }
        if ((texture_rl = this.pickInjuredTexture(dog, sync_state = dog.getIncapSyncState())) != null) {
            float alpha = this.getInjureOpascity(dog);
            IncapacitatedRenderer.renderTranslucentModel(dogModel, texture_rl, poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, alpha);
        }
        DogIncapacitatedMananger.BandaidState bandaid_state = sync_state.bandaid;
        class_2960 bandaid_texture_rl = null;
        switch (bandaid_state) {
            case FULL: {
                bandaid_texture_rl = Resources.BANDAID_OVERLAY_FULL;
                break;
            }
            case HALF: {
                bandaid_texture_rl = Resources.BANDAID_OVERLAY_HALF;
                break;
            }
        }
        if (bandaid_texture_rl != null) {
            IncapacitatedRenderer.renderTranslucentModel(dogModel, bandaid_texture_rl, poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private class_2960 pickInjuredTexture(Dog dog, DogIncapacitatedMananger.IncapacitatedSyncState state) {
        Optional<class_2960> variant_custom_overlay;
        if (dog.isDogVariantRenderEffective() && (variant_custom_overlay = dog.dogVariant().customInjuredTexture()).isPresent()) {
            return null;
        }
        boolean isLowGraphic = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_INCAP_TXT_LESS_GRAPHIC);
        if (isLowGraphic) {
            return Resources.INCAPACITATED_LESS_GRAPHIC;
        }
        DogIncapacitatedMananger.DefeatedType type = state.type;
        class_2960 ret = Resources.INCAPACITATED_BLOOD;
        switch (type) {
            case BLOOD: {
                ret = Resources.INCAPACITATED_BLOOD;
                break;
            }
            case BURN: {
                ret = Resources.INCAPACITATED_BURN;
                break;
            }
            case POISON: {
                ret = Resources.INCAPACITATED_POISON;
                break;
            }
            case DROWN: {
                ret = Resources.INCAPACITATED_DROWN;
                break;
            }
            case STARVE: {
                ret = null;
                break;
            }
        }
        return ret;
    }

    private float getInjureOpascity(Dog dog) {
        int default_val = dog.getDefaultInitIncapVal();
        int dog_val = dog.getDogIncapValue();
        if ((float)default_val <= 0.0f) {
            return 0.0f;
        }
        if (dog_val >= default_val) {
            return 1.0f;
        }
        float ret = (float)dog_val / (float)default_val;
        return class_3532.method_15363((float)ret, (float)0.0f, (float)1.0f);
    }

    public static void renderTranslucentModel(DogModel p_117377_, class_2960 p_117378_, class_4587 p_117379_, class_4597 p_117380_, int p_117381_, Dog p_117382_, float p_117383_, float p_117384_, float p_117385_, float opascity) {
        class_4588 vertexconsumer = p_117380_.getBuffer(class_1921.method_23580((class_2960)p_117378_));
        p_117377_.method_62100(p_117379_, vertexconsumer, p_117381_, DogRenderer.getOverlayCoords(p_117382_, 0.0f), class_9848.method_61318((float)opascity, (float)p_117383_, (float)p_117384_, (float)p_117385_));
    }
}

