/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.element.view.StyleView.view.SkinView;

import com.mojang.blaze3d.systems.RenderSystem;
import doggytalents.client.DogTextureManager;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.client.entity.skin.DogSkinHolder;
import doggytalents.client.screen.DogNewInfoScreen.element.view.MainInfoView.DogStatusViewBoxElement;
import doggytalents.client.screen.DogNewInfoScreen.store.slice.ActiveSkinSlice;
import doggytalents.client.screen.DogNewInfoScreen.widget.AccessoryStatusHover;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.element.DivElement;
import doggytalents.client.screen.framework.element.ElementPosition;
import doggytalents.client.screen.framework.element.ScrollView;
import doggytalents.client.screen.framework.widget.TextOnlyButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.lib.Resources;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class DogSkinElement
extends AbstractElement {
    private static int LINE_SPACING = 2;
    Dog dog;
    List<DogSkin> locList;
    final Dog dummyDog;
    int activeSkinId;
    class_327 font;
    boolean showInfo;
    private TextOnlyButton copy_sha1_button;

    public DogSkinElement(AbstractElement parent, class_437 screen, Dog dog, Dog dummy, List<DogSkin> locList, int active_id) {
        super(parent, screen);
        this.dog = dog;
        this.locList = locList;
        this.activeSkinId = active_id;
        this.font = class_310.method_1551().field_1772;
        this.dummyDog = dummy;
    }

    @Override
    public AbstractElement init() {
        if (this.locList.isEmpty()) {
            return this;
        }
        if (this.activeSkinId < 0) {
            return this;
        }
        if (this.activeSkinId >= this.locList.size()) {
            return this;
        }
        this.addAccStateHover();
        this.showInfo = this.getStateAndSubscribesTo(ActiveSkinSlice.class, ActiveSkinSlice.class, new ActiveSkinSlice()).showInfo;
        if (!this.showInfo) {
            return this;
        }
        DogSkin manifestSkin = this.locList.get(this.activeSkinId);
        if (!manifestSkin.hasExtraInfo()) {
            return this;
        }
        ScrollView scrollView = new ScrollView(this, this.getScreen());
        scrollView.setPosition(ElementPosition.PosType.ABSOLUTE, class_3532.method_15375((float)((float)this.getParent().getSizeX() * 0.45f)), 0).setSize(0.55f, 1.0f).init();
        this.addChildren((class_364)scrollView);
        AbstractElement scroll = scrollView.getContainer();
        scroll.addChildren((class_364)new DivElement(scroll, this.getScreen()).setSize(1.0f, Math.max(10, this.getSizeY() / 2 - 40)).init());
        if (!manifestSkin.getName().isEmpty()) {
            scroll.addChildren((class_364)new SkinStrEntry(scroll, this.getScreen(), (class_2561)class_2561.method_43470((String)"Name: "), (class_2561)class_2561.method_43470((String)manifestSkin.getName())).init());
        }
        if (!manifestSkin.getBasedOn().isEmpty()) {
            scroll.addChildren((class_364)new SkinStrEntry(scroll, this.getScreen(), (class_2561)class_2561.method_43470((String)"Based On: "), (class_2561)class_2561.method_43470((String)manifestSkin.getBasedOn())).init());
        }
        if (!manifestSkin.getAuthor().isEmpty()) {
            scroll.addChildren((class_364)new SkinStrEntry(scroll, this.getScreen(), (class_2561)class_2561.method_43470((String)"Author: "), (class_2561)class_2561.method_43470((String)manifestSkin.getAuthor())).init());
        }
        if (!manifestSkin.getDesc().isEmpty()) {
            scroll.addChildren((class_364)new SkinStrEntry(scroll, this.getScreen(), (class_2561)class_2561.method_43470((String)"Desciption: "), (class_2561)class_2561.method_43470((String)manifestSkin.getDesc())).init());
        }
        if (!manifestSkin.getTags().isEmpty()) {
            scroll.addChildren((class_364)new SkinStrEntry(scroll, this.getScreen(), (class_2561)class_2561.method_43470((String)"Tags: "), (class_2561)class_2561.method_43470((String)manifestSkin.getTags())).init());
        }
        if (manifestSkin.isCustom()) {
            this.initSha1Button();
            scroll.addChildren((class_364)new DivElement(scroll, this.getScreen()){

                @Override
                public AbstractElement init() {
                    this.setPosition(ElementPosition.PosType.RELATIVE, 0, 0);
                    this.setSize(1.0f, 20);
                    TextOnlyButton button = DogSkinElement.this.copy_sha1_button;
                    Objects.requireNonNull(DogSkinElement.this.font);
                    button.method_53533(9 + 5);
                    button.method_46421(this.getRealX() + 10);
                    button.method_46419(this.getRealY() + this.getSizeY() - button.method_25364());
                    this.addChildren((class_364)button);
                    return super.init();
                }
            }.init());
        }
        return this;
    }

    private void addAccStateHover() {
        DogSkin skin = this.locList.get(this.activeSkinId);
        DogModel.AccessoryState state = this.getStateFromSkin(skin);
        AccessoryStatusHover button = new AccessoryStatusHover(0, 0, state);
        button.method_46421(this.getRealX() + 6);
        button.method_46419(this.getRealY() + this.getSizeY() - 25);
        this.addChildren((class_364)button);
    }

    private DogModel.AccessoryState getStateFromSkin(DogSkin skin) {
        if (!skin.useCustomModel()) {
            return DogModel.AccessoryState.RECOMMENDED;
        }
        DogModelRegistry.DogModelHolder model = skin.getCustomModel();
        return model.getValue().getAccessoryState();
    }

    private void copySha1() {
        DogSkin skin = this.locList.get(this.activeSkinId);
        if (!skin.isCustom()) {
            return;
        }
        String sha1 = DogTextureManager.INSTANCE.getHash(skin);
        if (sha1 == null || sha1.isEmpty()) {
            return;
        }
        class_310.method_1551().field_1774.method_1455(sha1);
    }

    private void initSha1Button() {
        class_5250 sha1_txt = class_2561.method_43470((String)"Copy SHA-1").method_27696(class_2583.field_24360.method_36139(0x696868));
        this.copy_sha1_button = new TextOnlyButton(0, 0, this.font.method_27525((class_5348)sha1_txt), 10, (class_2561)sha1_txt, b -> {
            this.copySha1();
            b.method_25355((class_2561)class_2561.method_43470((String)"SHA-1 Copied!").method_27696(class_2583.field_24360.method_36139(-14702592)));
        }, this.font);
    }

    @Override
    public void renderElement(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.locList == null) {
            return;
        }
        if (this.locList.isEmpty()) {
            return;
        }
        if (this.activeSkinId < 0) {
            return;
        }
        if (this.activeSkinId >= this.locList.size()) {
            return;
        }
        if (this.showInfo) {
            this.renderShowInfo(graphics, mouseX, mouseY, partialTicks);
        } else {
            this.renderNonShowInfo(graphics, mouseX, mouseY, partialTicks);
        }
    }

    private void renderNonShowInfo(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int mX = this.getSizeX() / 2;
        int mY = this.getSizeY() / 2;
        int e_mX = this.getRealX() + mX;
        int e_mY = this.getRealY() + mY - 10;
        int maxLen = this.getSizeX() - 120;
        Object nameStr = this.locList.get(this.activeSkinId).getName();
        int nameStrLen = this.font.method_1727((String)nameStr);
        if (nameStrLen > maxLen) {
            int cutLen = Math.max(0, maxLen - this.font.method_1727(".."));
            nameStr = this.font.method_27523((String)nameStr, cutLen) + "..";
        }
        class_5250 c1 = class_2561.method_43470((String)nameStr);
        c1.method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        int nameX = this.getRealX() + mX - this.font.method_27525((class_5348)c1) / 2;
        int nameY = this.getRealY() + this.getSizeY() - 13;
        graphics.method_27535(this.font, (class_2561)c1, nameX, nameY, -1);
        int prevId = this.activeSkinId - 1;
        int nextId = this.activeSkinId + 1;
        if (nextId < this.locList.size()) {
            this.renderSkinAndDogModel(nextId, false, graphics, mouseX, mouseY, e_mX + 32 + 25 + 25, e_mY + 32, 50, true);
        }
        if (prevId >= 0) {
            this.renderSkinAndDogModel(prevId, false, graphics, mouseX, mouseY, e_mX - 32 - 25 - 25, e_mY + 32, 50, true);
        }
        this.renderSkinAndDogModel(this.activeSkinId, true, graphics, mouseX, mouseY, e_mX, e_mY + 36, 64, false);
    }

    private void renderShowInfo(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int mX = this.getSizeX() / 2;
        int mY = this.getSizeY() / 2;
        int e_mX = this.getRealX() + mX;
        int e_mY = this.getRealY() + mY - 10;
        this.renderSkinAndDogModel(this.activeSkinId, true, graphics, mouseX, mouseY, this.getRealX() + 70, e_mY + 36, 64, true);
        DogSkin manifestSkin = this.locList.get(this.activeSkinId);
        if (!manifestSkin.hasExtraInfo()) {
            this.renderNoInfo(graphics, mouseX, mouseY, partialTicks);
            return;
        }
    }

    private void renderNoInfo(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int mX = this.getSizeX() / 2;
        int mY = this.getSizeY() / 2;
        class_5250 c1 = class_2561.method_43470((String)"No info to show.");
        int tX = this.getRealX() + mX - 10;
        int n = this.getRealY() + mY;
        Objects.requireNonNull(this.font);
        int tY = n - 9 / 2;
        graphics.method_27535(this.font, (class_2561)c1, tX, tY, -1);
    }

    private void renderSkinAndDogModel(int indx, boolean followMouse, class_332 graphics, int mouseX, int mouseY, int e_mX, int e_mY, int size, boolean useDummy) {
        DogSkinHolder oldSkin = this.dog.getClientSkinHolder();
        DogSkin manifestSkin = this.locList.get(indx);
        if (manifestSkin.mystery()) {
            manifestSkin = DogSkin.MYSTERY;
            this.renderMysteriousKanji(graphics, e_mX, e_mY);
            this.dummyDog.setClientSkinHolder(DogSkinHolder.resolved(manifestSkin));
            DogStatusViewBoxElement.renderDogInside(graphics, this.dummyDog, e_mX, e_mY, size, followMouse ? e_mX - mouseX : -64, followMouse ? e_mY - mouseY : -64);
        } else if (useDummy && this.dummyDog != null) {
            this.dummyDog.setClientSkinHolder(DogSkinHolder.resolved(manifestSkin));
            DogStatusViewBoxElement.renderDogInside(graphics, this.dummyDog, e_mX, e_mY, size, followMouse ? e_mX - mouseX : -64, followMouse ? e_mY - mouseY : -64);
        } else {
            this.dog.setClientSkinHolder(DogSkinHolder.resolved(manifestSkin));
            DogStatusViewBoxElement.renderDogInside(graphics, this.dog, e_mX, e_mY, size, followMouse ? e_mX - mouseX : -64, followMouse ? e_mY - mouseY : -64);
            this.dog.setClientSkinHolder(oldSkin);
        }
        if (oldSkin.getOrElse(DogSkin.CLASSICAL) == manifestSkin) {
            class_327 font = class_310.method_1551().field_1772;
            class_5250 c1 = class_2561.method_43471((String)"doggui.style.skins.selected");
            c1.method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(-14702592));
            int c1_len = font.method_27525((class_5348)c1);
            int tX = e_mX - c1_len / 2;
            int tY = e_mY + 28;
            graphics.method_27535(font, (class_2561)c1, tX, tY, -1);
        }
    }

    private void renderMysteriousKanji(class_332 graphics, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int imgeSize = 100;
        ScreenUtil.blit_21_3(graphics, Resources.KANJI_MYSTERY_BKG, x - imgeSize / 2, y - imgeSize / 2 - 27, 0, 0.0f, 0.0f, imgeSize, imgeSize, imgeSize, imgeSize);
        class_4587 stack = graphics.method_51448();
        stack.method_22903();
        stack.method_46416(0.0f, 0.0f, 400.0f);
        ScreenUtil.blit_21_3(graphics, Resources.KANJI_MYSTERY, x - imgeSize / 2, y - imgeSize / 2 - 27, 0, 0.0f, 0.0f, imgeSize, imgeSize, imgeSize, imgeSize);
        stack.method_22909();
    }

    public static class SkinStrEntry
    extends AbstractElement {
        private class_2561 title;
        private class_2561 content;
        private List<class_5481> components;
        private class_327 font;

        public SkinStrEntry(AbstractElement parent, class_437 screen, class_2561 title, class_2561 content) {
            super(parent, screen);
            this.title = title;
            this.content = content;
            this.font = class_310.method_1551().field_1772;
        }

        @Override
        public AbstractElement init() {
            this.setPosition(ElementPosition.PosType.RELATIVE, 0, 0);
            this.title = this.title.method_27661().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
            this.components = this.font.method_1728((class_5348)this.content, this.getParent().getSizeX() - 20);
            Objects.requireNonNull(this.font);
            int n = this.components.size();
            Objects.requireNonNull(this.font);
            int totalH = LINE_SPACING + 9 + LINE_SPACING + n * (LINE_SPACING + 9) + LINE_SPACING;
            this.setSize(1.0f, totalH);
            return this;
        }

        @Override
        public void renderElement(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            int pX = this.getRealX();
            int pY = this.getRealY() + LINE_SPACING;
            graphics.method_27535(this.font, this.title, pX, pY, -1);
            Objects.requireNonNull(this.font);
            pY += 9 + LINE_SPACING;
            for (class_5481 line : this.components) {
                graphics.method_35720(this.font, line, pX, pY, -1);
                Objects.requireNonNull(this.font);
                pY += 9 + LINE_SPACING;
            }
        }
    }
}

