/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block.tileentity;

import doggytalents.DoggyItems;
import doggytalents.DoggyTileEntityTypes;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.ListTag_1_21_5;
import doggytalents.api.forge_imitate.inventory.ContainerWrapper;
import doggytalents.common.block.RiceMillBlock;
import doggytalents.common.inventory.container.RiceMillMenu;
import doggytalents.common.util.InventoryUtil;
import doggytalents.forge_imitate.network.NetworkHooks;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2609;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3723;
import net.minecraft.class_3866;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;

public class RiceMillBlockEntity
extends class_2586 {
    public static final int TOTOAL_SLOTS = 3;
    public static final int[] GRAIN_SLOTS = new int[]{0};
    public static final int BOWL_SLOT = 1;
    public static final int[] INPUT_SLOT = new int[]{0, 1};
    public static final int[] OUTPUT_SLOT = new int[]{2};
    private RiceMillContainer container = new RiceMillContainer(this);
    private ContainerWrapper containerWrapper = new ContainerWrapper((class_1263)this.container);
    public static final int TOTOAL_DATA_SLOT = 2;
    public static final int GRINDING_TIME_ID = 0;
    public static final int GRINDING_TINE_FINISH_ID = 1;
    private int grindingTime;
    private int grindingTimeWhenFinish = 50;
    private RiceMillSyncedData syncedData = new RiceMillSyncedData(this);
    private RiceMillMenuProvider menuProvider = new RiceMillMenuProvider(this);
    public static final int GRIND_ANIM_TICK_LEN = 200;
    private int animationTick = 0;
    private boolean isSpinning = false;
    private MillRecipe currentRecipe = MillRecipe.EMPTY;
    private class_1799 prevInputStack = class_1799.field_8037;
    private boolean prevHasBowl = false;
    private static final ArrayList<MillRecipe> MILL_RECIPES = new ArrayList();
    private int tickTillUpdateWaterSource = 20;
    private int tickTillUpdateEject = 8;

    public static void initGrindMap() {
        MILL_RECIPES.clear();
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.RICE_GRAINS.get(), 3).needsBowl().withOutput(DoggyItems.UNCOOKED_RICE_BOWL.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.RICE_GRAINS.get(), 1).withOutput(DoggyItems.UNCOOKED_RICE.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.RICE_WHEAT.get(), 1).needsBowl().withOutput(DoggyItems.UNCOOKED_RICE_BOWL.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.RICE_WHEAT.get(), 1).withOutput(DoggyItems.UNCOOKED_RICE.get(), 3).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.UNCOOKED_RICE.get(), 3).needsBowl().withOutput(DoggyItems.UNCOOKED_RICE_BOWL.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.SOY_BEANS_DRIED.get(), 3).needsBowl().withOutput(DoggyItems.SOY_MILK.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.SOY_PODS_DRIED.get(), 1).needsBowl().withOutput(DoggyItems.SOY_MILK.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.SOY_PODS.get(), 1).withOutput(DoggyItems.SOY_BEANS.get(), 3).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.SOY_PODS_DRIED.get(), 1).withOutput(DoggyItems.SOY_BEANS_DRIED.get(), 3).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.EDAMAME.get(), 1).withOutput(DoggyItems.EDAMAME_UNPODDED.get(), 3).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(class_1802.field_8861, 1).withOutput(class_1802.field_8229, 1).build());
    }

    public RiceMillBlockEntity(class_2338 pos, class_2680 blockState) {
        super(DoggyTileEntityTypes.RICE_MILL.get(), pos, blockState);
    }

    public static void openContainer(class_3222 player, class_1937 level, class_2338 pos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof RiceMillBlockEntity)) {
            return;
        }
        RiceMillBlockEntity mill = (RiceMillBlockEntity)blockEntity;
        NetworkHooks.openScreen(player, mill.menuProvider, mill.method_11016());
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 blockState, class_2586 blockEntity) {
        if (level == null) {
            return;
        }
        if (!(blockEntity instanceof RiceMillBlockEntity)) {
            return;
        }
        RiceMillBlockEntity mill = (RiceMillBlockEntity)blockEntity;
        RiceMillBlockEntity.updateSpinning(level, mill);
        RiceMillBlockEntity.updateAnimation(mill);
        RiceMillBlockEntity.grindTick(level, pos, blockState, mill);
        RiceMillBlockEntity.ejectTick(level, mill);
    }

    private static void updateSpinning(class_1937 level, RiceMillBlockEntity mill) {
        if (--mill.tickTillUpdateWaterSource > 0) {
            return;
        }
        mill.tickTillUpdateWaterSource = 20;
        mill.isSpinning = RiceMillBlockEntity.scanIfMillCanSpin(level, mill);
    }

    public boolean isSpinning() {
        return this.isSpinning;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    private static void updateAnimation(RiceMillBlockEntity mill) {
        if (mill.isSpinning) {
            ++mill.animationTick;
        }
        if (mill.animationTick >= 200) {
            mill.animationTick = 0;
        }
    }

    private static boolean scanIfMillCanSpin(class_1937 level, RiceMillBlockEntity mill) {
        class_2338 pos = mill.method_11016();
        class_2680 state = mill.method_11010();
        class_2350 facing = RiceMillBlock.getFacing(state);
        class_2350.class_2351 side_axis = facing.method_10170().method_10166();
        for (int i = 0; i < 3; ++i) {
            class_2338 middle_pos;
            class_2680 middle_state;
            boolean waterPart = i <= 0;
            if (!RiceMillBlockEntity.isValidBlockForSpiningInPart(waterPart, middle_state = level.method_8320(middle_pos = pos.method_10069(facing.method_10148(), i - 1, facing.method_10165())))) {
                return false;
            }
            class_2338 side_pos_1 = null;
            class_2338 side_pos_2 = null;
            if (side_axis == class_2350.class_2351.field_11048) {
                side_pos_1 = middle_pos.method_10069(1, 0, 0);
                side_pos_2 = middle_pos.method_10069(-1, 0, 0);
            } else {
                side_pos_1 = middle_pos.method_10069(0, 0, 1);
                side_pos_2 = middle_pos.method_10069(0, 0, -1);
            }
            class_2680 side_state_1 = level.method_8320(side_pos_1);
            if (!RiceMillBlockEntity.isValidBlockForSpiningInPart(waterPart, side_state_1)) {
                return false;
            }
            class_2680 side_state_2 = level.method_8320(side_pos_2);
            if (RiceMillBlockEntity.isValidBlockForSpiningInPart(waterPart, side_state_2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidBlockForSpiningInPart(boolean waterPart, class_2680 state) {
        if (waterPart) {
            return state.method_27852(class_2246.field_10382);
        }
        return state.method_26215();
    }

    private static void grindTick(class_1937 level, class_2338 pos, class_2680 blockState, RiceMillBlockEntity mill) {
        if (level.field_9236) {
            return;
        }
        class_1799 inputStack = mill.container.method_5438(INPUT_SLOT[0]);
        RiceMillBlockEntity.recipeUpdateTick(mill, inputStack);
        MillRecipe currentRecipe = mill.currentRecipe;
        if (RiceMillBlockEntity.isGrinding(mill, inputStack, currentRecipe)) {
            ++mill.grindingTime;
            if (mill.grindingTime >= mill.grindingTimeWhenFinish) {
                RiceMillBlockEntity.createFinishProduct(mill, inputStack, currentRecipe);
                mill.grindingTime = 0;
            }
        } else {
            mill.grindingTime = 0;
        }
    }

    private static void recipeUpdateTick(RiceMillBlockEntity mill, class_1799 currentInputStack) {
        class_1799 bowlStack = mill.container.method_5438(1);
        boolean hasBowl = bowlStack.method_31574(class_1802.field_8428);
        boolean changed = RiceMillBlockEntity.checkAndDetectChangeInMillInput(mill, currentInputStack, hasBowl);
        if (changed) {
            RiceMillBlockEntity.changeRecipeIfNeeded(mill, currentInputStack, hasBowl);
        }
    }

    private static void changeRecipeIfNeeded(RiceMillBlockEntity mill, class_1799 currentInputStack, boolean hasBowl) {
        if (currentInputStack.method_7960()) {
            return;
        }
        if (RiceMillBlockEntity.currentRecipeStillMatch(mill, currentInputStack, hasBowl)) {
            return;
        }
        mill.currentRecipe = RiceMillBlockEntity.findMillRecipe(currentInputStack, hasBowl);
    }

    private static boolean currentRecipeStillMatch(RiceMillBlockEntity mill, class_1799 currentInputStack, boolean hasBowl) {
        MillRecipe currentRecipe = mill.currentRecipe;
        if (currentRecipe.empty()) {
            return false;
        }
        boolean isMatch = currentRecipe.matches(currentInputStack, hasBowl);
        return isMatch;
    }

    private static boolean checkAndDetectChangeInMillInput(RiceMillBlockEntity mill, class_1799 currentInputStack, boolean hasBowl) {
        if (!RiceMillBlockEntity.isChanged(mill, currentInputStack, hasBowl)) {
            return false;
        }
        mill.prevHasBowl = hasBowl;
        mill.prevInputStack = currentInputStack.method_7960() ? class_1799.field_8037 : currentInputStack.method_7972();
        return true;
    }

    private static boolean isChanged(RiceMillBlockEntity mill, class_1799 currentInputStack, boolean hasBowl) {
        if (currentInputStack.method_7960() && mill.prevInputStack.method_7960()) {
            return false;
        }
        if (currentInputStack.method_7960() != mill.prevInputStack.method_7960()) {
            return true;
        }
        if (currentInputStack.method_7909() != mill.prevInputStack.method_7909()) {
            return true;
        }
        if (currentInputStack.method_7947() != mill.prevInputStack.method_7947()) {
            return true;
        }
        return mill.prevHasBowl != hasBowl;
    }

    private static MillRecipe findMillRecipe(class_1799 stack, boolean hasBowl) {
        if (stack.method_7960()) {
            return MillRecipe.EMPTY;
        }
        for (MillRecipe recipe : MILL_RECIPES) {
            if (!recipe.matches(stack, hasBowl)) continue;
            return recipe;
        }
        return MillRecipe.EMPTY;
    }

    private static boolean isGrinding(RiceMillBlockEntity mill, class_1799 inputStack, MillRecipe currentRecipe) {
        if (currentRecipe.empty()) {
            return false;
        }
        return mill.isSpinning && RiceMillBlockEntity.hasEnoughIngredient(mill, inputStack, currentRecipe) && RiceMillBlockEntity.productSlotIsAvailable(mill, currentRecipe);
    }

    private static boolean productSlotIsAvailable(RiceMillBlockEntity mill, MillRecipe recipe) {
        if (recipe.empty()) {
            return false;
        }
        class_1799 currentOutputStack = mill.container.method_5438(OUTPUT_SLOT[0]);
        if (currentOutputStack.method_7960()) {
            return true;
        }
        class_1792 outputItemFromInput = recipe.outputItem();
        if (outputItemFromInput == null) {
            return false;
        }
        if (!currentOutputStack.method_31574(outputItemFromInput)) {
            return false;
        }
        return currentOutputStack.method_7947() + recipe.outputAmount() <= InventoryUtil.maxStackSizeWithContainer((class_1263)mill.container, OUTPUT_SLOT[0], currentOutputStack);
    }

    private static boolean hasEnoughIngredient(RiceMillBlockEntity mill, class_1799 inputStack, MillRecipe recipe) {
        if (recipe.empty()) {
            return false;
        }
        class_1799 bowSlotStack = mill.container.method_5438(1);
        if (recipe.needBowl() && !bowSlotStack.method_31574(class_1802.field_8428)) {
            return false;
        }
        int requireGrainLeft = recipe.inputAmount();
        class_1792 inputItem = inputStack.method_7909();
        for (int grainSlot : GRAIN_SLOTS) {
            if (requireGrainLeft < 0) break;
            class_1799 grainSlotStack = mill.container.method_5438(grainSlot);
            if (!grainSlotStack.method_31574(inputItem)) continue;
            requireGrainLeft -= grainSlotStack.method_7947();
        }
        return requireGrainLeft <= 0;
    }

    private static void createFinishProduct(RiceMillBlockEntity mill, class_1799 currentInput, MillRecipe currentRecipe) {
        class_1799 resultStack;
        if (!RiceMillBlockEntity.isGrinding(mill, currentInput, currentRecipe)) {
            return;
        }
        class_1792 inputItem = currentInput.method_7909();
        if (currentRecipe.empty()) {
            return;
        }
        class_1799 bowSlotStack = mill.container.method_5438(1);
        if (currentRecipe.needBowl() && bowSlotStack.method_31574(class_1802.field_8428)) {
            bowSlotStack = bowSlotStack.method_7972();
            bowSlotStack.method_7934(1);
            mill.container.method_5447(1, bowSlotStack);
        }
        int grainsNeeded = currentRecipe.inputAmount();
        for (int grainSlot : GRAIN_SLOTS) {
            if (grainsNeeded <= 0) break;
            class_1799 grainSlotStack = mill.container.method_5438(grainSlot);
            if (!grainSlotStack.method_31574(inputItem)) continue;
            int stackCount = (grainSlotStack = grainSlotStack.method_7972()).method_7947();
            if (stackCount <= grainsNeeded) {
                grainsNeeded -= stackCount;
                grainSlotStack = class_1799.field_8037;
            } else {
                grainSlotStack.method_7934(grainsNeeded);
                grainsNeeded = 0;
            }
            mill.container.method_5447(grainSlot, grainSlotStack);
        }
        if ((resultStack = currentRecipe.produce()) == class_1799.field_8037) {
            return;
        }
        mill.containerWrapper.insertItem(OUTPUT_SLOT[0], resultStack, false);
    }

    private boolean isInputMaterialForSlotId(class_1799 stack, int slotId) {
        if (slotId == 1) {
            return stack.method_31574(class_1802.field_8428);
        }
        return RiceMillBlockEntity.isInputSlotValid(stack);
    }

    public static boolean isInputSlotValid(class_1799 stack) {
        return !stack.method_31574(class_1802.field_8428);
    }

    private static void ejectTick(class_1937 level, RiceMillBlockEntity mill) {
        if (level.field_9236) {
            return;
        }
        if (--mill.tickTillUpdateEject > 0) {
            return;
        }
        mill.tickTillUpdateEject = 8;
        class_1799 output = mill.container.method_5438(OUTPUT_SLOT[0]);
        if (output.method_7960()) {
            return;
        }
        Optional<class_2586> recipentOptional = RiceMillBlockEntity.getAttachedRecipent(mill);
        if (!recipentOptional.isPresent()) {
            return;
        }
        class_2586 recipent = recipentOptional.get();
        class_1799 remaining = RiceMillBlockEntity.tryEjectToRecipent(recipent, output);
        if (remaining != output) {
            mill.container.method_5447(OUTPUT_SLOT[0], remaining);
        }
    }

    private static Optional<class_2586> getAttachedRecipent(RiceMillBlockEntity mill) {
        class_2338 pos = mill.method_11016();
        class_2680 state = mill.method_11010();
        class_1937 level = mill.method_10997();
        if (level == null) {
            return Optional.empty();
        }
        class_2350 facing = RiceMillBlock.getFacing(state);
        class_2350 attached_dir = facing.method_10170();
        class_2338 attach_pos = pos.method_10069(attached_dir.method_10148(), 0, attached_dir.method_10165());
        class_2586 attach_blockEntity = level.method_8321(attach_pos);
        if (attach_blockEntity instanceof class_3866) {
            return Optional.of(attach_blockEntity);
        }
        if (attach_blockEntity instanceof class_3723) {
            return Optional.of(attach_blockEntity);
        }
        if (attach_blockEntity instanceof class_2595) {
            return Optional.of(attach_blockEntity);
        }
        if (attach_blockEntity instanceof class_2614) {
            return Optional.of(attach_blockEntity);
        }
        return Optional.empty();
    }

    private static class_1799 tryEjectToRecipent(class_2586 recipent, class_1799 currentStack) {
        if (currentStack.method_7960()) {
            return currentStack;
        }
        if (recipent instanceof class_2609) {
            class_2609 furnace = (class_2609)recipent;
            int furnaceIn = FurnaceBlockEntityDelegate.FURNACE_IN;
            class_1799 current_in = furnace.method_5438(furnaceIn);
            if (!current_in.method_7960() && !class_1799.method_7984((class_1799)currentStack, (class_1799)current_in)) {
                return currentStack;
            }
            if (!current_in.method_7960() && current_in.method_7947() >= InventoryUtil.maxStackSizeWithContainer((class_1263)furnace, furnaceIn, current_in)) {
                return currentStack;
            }
            if (!furnace.method_5437(furnaceIn, currentStack)) {
                return currentStack;
            }
            if (current_in.method_7960()) {
                current_in = new class_1799((class_1935)currentStack.method_7909());
            } else {
                current_in = current_in.method_7972();
                current_in.method_7933(1);
            }
            furnace.method_5447(furnaceIn, current_in);
            currentStack = currentStack.method_7972();
            currentStack.method_7934(1);
            return currentStack;
        }
        if (recipent instanceof class_2595) {
            class_2595 chest = (class_2595)recipent;
            currentStack = RiceMillBlockEntity.tryInputStackInContainer(currentStack, (class_1263)chest);
        } else if (recipent instanceof class_2614) {
            class_2614 hopper = (class_2614)recipent;
            currentStack = RiceMillBlockEntity.tryInputStackInContainer(currentStack, (class_1263)hopper);
        }
        return currentStack;
    }

    private static class_1799 tryInputStackInContainer(class_1799 currentStack, class_1263 target) {
        int freeSlot = -1;
        for (int i = 0; i < target.method_5439(); ++i) {
            class_1799 item = target.method_5438(i);
            if (item.method_7960()) {
                freeSlot = i;
                break;
            }
            if (!class_1799.method_7984((class_1799)currentStack, (class_1799)item) || item.method_7947() >= InventoryUtil.maxStackSizeWithContainer(target, i, item)) continue;
            freeSlot = i;
            break;
        }
        if (freeSlot < 0) {
            return currentStack;
        }
        class_1799 targetItem = target.method_5438(freeSlot);
        if (!targetItem.method_7960() && !class_1799.method_7984((class_1799)currentStack, (class_1799)targetItem)) {
            return currentStack;
        }
        if (!targetItem.method_7960() && targetItem.method_7947() >= InventoryUtil.maxStackSizeWithContainer(target, freeSlot, targetItem)) {
            return currentStack;
        }
        if (!target.method_5437(freeSlot, targetItem)) {
            return currentStack;
        }
        if (targetItem.method_7960()) {
            targetItem = new class_1799((class_1935)currentStack.method_7909());
        } else {
            targetItem = targetItem.method_7972();
            targetItem.method_7933(1);
        }
        target.method_5447(freeSlot, targetItem);
        currentStack = currentStack.method_7972();
        currentStack.method_7934(1);
        return currentStack;
    }

    public class_1278 getWorldlyContainer() {
        return this.container;
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 prov) {
        super.method_11014(tag, prov);
        this.container.deserializeNBT(tag, prov);
        this.grindingTime = CompoundTag_1_21_5.wrap(tag).getInt("grindingTime");
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 prov) {
        super.method_11007(tag, prov);
        this.container.serializeNBT(tag, prov);
        tag.method_10569("grindingTime", this.grindingTime);
    }

    public static class MillRecipe {
        public static MillRecipe EMPTY = Builder.empty().build();
        private class_1792 inputItem = null;
        private int inputAmount = 0;
        private boolean needBowl = true;
        private class_1792 outputItem = null;
        private int outputAmount = 1;

        private MillRecipe() {
        }

        public class_1792 inputItem() {
            return this.inputItem;
        }

        public int inputAmount() {
            return this.inputAmount;
        }

        public boolean needBowl() {
            return this.needBowl;
        }

        @Nullable
        public class_1792 outputItem() {
            return this.outputItem;
        }

        public int outputAmount() {
            return this.outputAmount;
        }

        public boolean empty() {
            return this.outputItem == null || this.inputItem == null;
        }

        public boolean matches(class_1799 inputStack, boolean hasBowl) {
            if (this.empty()) {
                return false;
            }
            if (hasBowl != this.needBowl) {
                return false;
            }
            if (inputStack == null) {
                return false;
            }
            if (!inputStack.method_31574(this.inputItem)) {
                return false;
            }
            return inputStack.method_7947() >= this.inputAmount;
        }

        public class_1799 produce() {
            if (this.empty()) {
                return class_1799.field_8037;
            }
            if (this.outputItem == null) {
                return class_1799.field_8037;
            }
            return new class_1799((class_1935)this.outputItem, this.outputAmount);
        }

        public static class Builder {
            private class_1792 inputItem = null;
            private int inputAmount = 0;
            private boolean needBowl = false;
            private class_1792 outputItem = null;
            private int outputAmount = 1;

            private Builder() {
            }

            public static Builder empty() {
                return new Builder();
            }

            public static Builder withInput(class_1792 item, int amount) {
                Builder ret = new Builder();
                ret.inputItem = item;
                ret.inputAmount = amount;
                return ret;
            }

            public Builder needsBowl() {
                this.needBowl = true;
                return this;
            }

            public Builder withOutput(class_1792 item, int amount) {
                this.outputAmount = amount;
                this.outputItem = item;
                return this;
            }

            public MillRecipe build() {
                MillRecipe ret = new MillRecipe();
                ret.inputItem = this.inputItem;
                ret.inputAmount = this.inputAmount;
                ret.needBowl = this.needBowl;
                ret.outputItem = this.outputItem;
                ret.outputAmount = this.outputAmount;
                return ret;
            }
        }
    }

    public static class RiceMillContainer
    extends class_1277
    implements class_1278 {
        private final RiceMillBlockEntity mill;

        public RiceMillContainer(RiceMillBlockEntity mill) {
            super(3);
            this.mill = mill;
        }

        public int[] method_5494(class_2350 dir) {
            if (dir.method_10166() == class_2350.class_2351.field_11052) {
                return new int[0];
            }
            class_2680 state = this.mill.method_11010();
            class_2350 facing = RiceMillBlock.getFacing(state);
            if (facing.method_10160() == dir) {
                return INPUT_SLOT;
            }
            return new int[0];
        }

        public boolean method_5492(int slotId, class_1799 stack, @Nullable class_2350 dir) {
            if (dir == null) {
                return false;
            }
            if (dir.method_10166() == class_2350.class_2351.field_11052) {
                return false;
            }
            class_2680 state = this.mill.method_11010();
            class_2350 facing = RiceMillBlock.getFacing(state);
            if (facing.method_10160() == dir) {
                return this.mill.isInputMaterialForSlotId(stack, slotId);
            }
            return false;
        }

        public boolean method_5493(int slotId, class_1799 stack, class_2350 dir) {
            return false;
        }

        public void method_5431() {
            this.mill.method_5431();
        }

        public boolean method_5443(class_1657 player) {
            return class_1263.method_49105((class_2586)this.mill, (class_1657)player);
        }

        public void serializeNBT(class_2487 compound, class_7225.class_7874 prov) {
            class_2499 itemsList = new class_2499();
            for (int i = 0; i < this.method_5439(); ++i) {
                class_1799 stack = this.method_5438(i);
                if (stack.method_7960()) continue;
                class_2487 itemTag = new class_2487();
                itemTag.method_10567("Slot", (byte)i);
                itemsList.add((Object)stack.method_57376(prov, (class_2520)itemTag));
            }
            compound.method_10566("MillItems", (class_2520)itemsList);
        }

        public void deserializeNBT(class_2487 compound_1_21_5, class_7225.class_7874 prov) {
            CompoundTag_1_21_5 compound = CompoundTag_1_21_5.wrap(compound_1_21_5);
            if (compound.contains("MillItems", 9)) {
                ListTag_1_21_5 tagList = compound.getList("MillItems", 10);
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundTag_1_21_5 itemTag = tagList.getCompound(i);
                    int slot = itemTag.getInt("Slot");
                    if (slot < 0 || slot >= this.method_5439()) continue;
                    this.method_5447(slot, class_1799.method_57360((class_7225.class_7874)prov, (class_2520)itemTag.wrapped()).orElse(class_1799.field_8037));
                }
            }
        }
    }

    public static class RiceMillSyncedData
    implements class_3913 {
        private final RiceMillBlockEntity mill;

        public RiceMillSyncedData(RiceMillBlockEntity mill) {
            this.mill = mill;
        }

        public int method_17390(int syncedSlotId) {
            switch (syncedSlotId) {
                case 0: {
                    return this.mill.grindingTime;
                }
                case 1: {
                    return this.mill.grindingTimeWhenFinish;
                }
            }
            return 0;
        }

        public void method_17391(int syncedSlotId, int val) {
        }

        public int method_17389() {
            return 2;
        }
    }

    public static class RiceMillMenuProvider
    implements class_3908 {
        private final RiceMillBlockEntity mill;

        public RiceMillMenuProvider(RiceMillBlockEntity mill) {
            this.mill = mill;
        }

        @Nullable
        public class_1703 createMenu(int containerId, class_1661 inv, class_1657 player) {
            return new RiceMillMenu(containerId, inv, (class_1263)this.mill.container, this.mill.syncedData);
        }

        public class_2561 method_5476() {
            return class_2561.method_43471((String)"container.doggytalents.rice_mill");
        }
    }

    public static class FurnaceBlockEntityDelegate
    extends class_2609 {
        public static int FURNACE_IN = 0;

        protected FurnaceBlockEntityDelegate(class_2591<?> p_154991_, class_2338 p_154992_, class_2680 p_154993_, class_3956<? extends class_1874> p_154994_) {
            super(p_154991_, p_154992_, p_154993_, p_154994_);
        }

        protected class_2561 method_17823() {
            return class_2561.method_43473();
        }

        protected class_1703 method_5465(int p_58627_, class_1661 p_58628_) {
            return null;
        }
    }
}

