/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import doggytalents.DogSounds;
import doggytalents.DoggyAccessories;
import doggytalents.DoggyAttributes;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyEffects;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.DoggyTags;
import doggytalents.DoggyTalentsNext;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.HurtSuperCall;
import doggytalents.api.backward_imitate.InteractionResultHolder;
import doggytalents.api.backward_imitate.ItemUtil_1_21_5;
import doggytalents.api.backward_imitate.ListTag_1_21_5;
import doggytalents.api.enu.WetSource;
import doggytalents.api.feature.DogGender;
import doggytalents.api.feature.DogLevel;
import doggytalents.api.feature.DogMode;
import doggytalents.api.feature.DogSize;
import doggytalents.api.feature.FoodHandler;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.impl.IDogRangedAttackManager;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.api.inferface.IDogItem;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.api.inferface.InferTypeContext;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.AccessoryType;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.client.DTNClientPettingManager;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.client.entity.skin.DogSkinHolder;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.client.screen.DogNewInfoScreen.DogNewInfoScreen;
import doggytalents.client.screen.DogNewInfoScreen.screen.DogCannotInteractWithScreen;
import doggytalents.common.artifacts.DoggyArtifact;
import doggytalents.common.backward_imitate.EntityUtil_1_21_5;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.effects.NattoBiteEffect;
import doggytalents.common.entity.DogAllyCheck;
import doggytalents.common.entity.DogAttackManager;
import doggytalents.common.entity.DogAvoidGoingInFrontOfOwnerManager;
import doggytalents.common.entity.DogDuplicationDetection;
import doggytalents.common.entity.DogGroupsManager;
import doggytalents.common.entity.DogHungerManager;
import doggytalents.common.entity.DogIncapacitatedMananger;
import doggytalents.common.entity.DogMoodManager;
import doggytalents.common.entity.DogOwnerDistanceManager;
import doggytalents.common.entity.DogPettingManager;
import doggytalents.common.entity.DogPushAvoidManager;
import doggytalents.common.entity.DogSleepOnManager;
import doggytalents.common.entity.DogSoundManager;
import doggytalents.common.entity.DogSwimmingManager;
import doggytalents.common.entity.DogTrackingTracker;
import doggytalents.common.entity.ai.DogAiManager;
import doggytalents.common.entity.ai.nav.DogBodyRotationControl;
import doggytalents.common.entity.ai.nav.DogJumpControl;
import doggytalents.common.entity.ai.nav.DogMoveControl;
import doggytalents.common.entity.ai.nav.DogPathNavigation;
import doggytalents.common.entity.ai.nav.IDogNavLock;
import doggytalents.common.entity.ai.triggerable.AnimationAction;
import doggytalents.common.entity.ai.triggerable.DogBackFlipAction;
import doggytalents.common.entity.ai.triggerable.DogDrownAction;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.entity.anim.DogAnimationManager;
import doggytalents.common.entity.anim.DogPose;
import doggytalents.common.entity.datasync.DogDataSyncManager;
import doggytalents.common.entity.serializers.Dimension2BlockPosMap;
import doggytalents.common.entity.stats.StatsTracker;
import doggytalents.common.entity.texture.DogSkinData;
import doggytalents.common.event.EventHandler;
import doggytalents.common.fabric_helper.entity.DogFabricHelper;
import doggytalents.common.fabric_helper.entity.network.SyncTypes;
import doggytalents.common.fabric_helper.util.FabricUtil;
import doggytalents.common.inventory.DogArmorItemHandlerImpl;
import doggytalents.common.item.DoggyArtifactItem;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.ParticlePackets;
import doggytalents.common.network.packet.data.DogMountData;
import doggytalents.common.network.packet.data.DogShakingData;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.storage.OnlineDogLocationManager;
import doggytalents.common.util.Cache;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.PlayerUtil;
import doggytalents.common.util.WorldUtil;
import doggytalents.common.variant.DogVariant;
import doggytalents.common.variant.util.DogVariantUtil;
import doggytalents.forge_imitate.network.PacketDistributor;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10209;
import net.minecraft.class_10583;
import net.minecraft.class_124;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1330;
import net.minecraft.class_1352;
import net.minecraft.class_14;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1548;
import net.minecraft.class_1590;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4076;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5418;
import net.minecraft.class_5425;
import net.minecraft.class_5454;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.minecraft.class_9273;
import net.minecraft.class_9381;
import org.apache.commons.lang3.ObjectUtils;

public class Dog
extends AbstractDog {
    private static final class_2940<Optional<class_2561>> LAST_KNOWN_NAME = class_2945.method_12791(Dog.class, (class_2941)class_2943.field_13325);
    private static final class_2940<Integer> DOG_FLAGS = class_2945.method_12791(Dog.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> HUNGER_INT = class_2945.method_12791(Dog.class, (class_2941)class_2943.field_13320);
    private static final class_2940<class_1799> BONE_VARIANT = class_2945.method_12791(Dog.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Integer> INCAP_VAL = class_2945.method_12791(Dog.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> ANIMATION = class_2945.method_12791(Dog.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> ANIM_SYNC_TIME = class_2945.method_12791(Dog.class, (class_2941)class_2943.field_13327);
    private final Cache<Integer> spendablePoints = Cache.make(this::getSpendablePointsInternal);
    private final List<IDogAlteration> alterations = new ArrayList<IDogAlteration>(4);
    private final List<IDogFoodHandler> foodHandlers = new ArrayList<IDogFoodHandler>(4);
    public final DogAnimationManager animationManager = new DogAnimationManager(this);
    private DogSkinHolder clientSkin = DogSkinHolder.getNone();
    private ArrayList<AccessoryInstance> clientAccessories = new ArrayList();
    private class_2960 missingDogVariant = null;
    public final StatsTracker statsTracker = new StatsTracker();
    public final DogDataSyncManager dogSyncedDataManager = new DogDataSyncManager(this);
    public final DogTrackingTracker dogTrackingTracker = new DogTrackingTracker();
    public final DogOwnerDistanceManager dogOwnerDistanceManager = new DogOwnerDistanceManager(this);
    public final DogAvoidGoingInFrontOfOwnerManager avoidGoInFrontOfOwnerManager = new DogAvoidGoingInFrontOfOwnerManager(this);
    public final DogGroupsManager dogGroupsManager = new DogGroupsManager();
    public final DogIncapacitatedMananger incapacitatedMananger = new DogIncapacitatedMananger(this);
    private final DogHungerManager hungerManager = new DogHungerManager(this);
    public final DogPettingManager pettingManager = new DogPettingManager(this);
    public final DogSleepOnManager.PerDog sleepOnManager = new DogSleepOnManager.PerDog(this);
    public final DogSwimmingManager dogSwimmingManager = new DogSwimmingManager(this);
    public final DogPushAvoidManager dogPushAvoidManager = new DogPushAvoidManager(this);
    public final DogAttackManager dogAttackManager = new DogAttackManager(this);
    public final DogAiManager dogAi;
    public final DogMoodManager dogMood = new DogMoodManager(this);
    public final DogSoundManager dogSoundManager = new DogSoundManager(this);
    private DogAlterationProps alterationProps = new DogAlterationProps();
    private IDogRangedAttackManager dogRangedAttackManager = IDogRangedAttackManager.NONE;
    private final DogArmorItemHandlerImpl dogArmors = new DogArmorItemHandlerImpl(this);
    private class_1799 mouthStack = class_1799.field_8037;
    private class_1799 wolfArmorStack = class_1799.field_8037;
    protected final DogPathNavigation defaultNavigation;
    protected final DogMoveControl defaultMoveControl;
    @Nullable
    protected IDogNavLock navigationLock;
    protected class_1408 currentNavigation;
    protected int switchNavCooldown = 0;
    private Optional<class_2338> lastSitPos = Optional.empty();
    private int lastSitPosSaveTimestamp = 0;
    private int healingTick;
    private int drunkTickLeft = 0;
    private int silentTickLeft = 0;
    private float headRotationCourse;
    private float headRotationCourseOld;
    @Nonnull
    private WetSource wetSource = WetSource.NONE;
    private boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    private int tickUntilRest;
    private int onFireSmokeTick;
    private boolean shakeFire = false;
    private float percentDecreasePerHealthLost;
    private float maxHealth0;
    protected boolean dogJumping;
    protected float jumpPower;
    protected boolean isDogSwimming;
    public int lastOrderedToSitTick;
    public int randomStrollCooldown;
    private int tickChopinTail;
    private boolean dogAnimHurtImpules = false;
    private int idleAnimHurtCooldown = 0;
    private class_4048 visualDimension = null;
    private boolean isProtesting = false;
    private boolean ridingAuthorized = false;
    private boolean authorizedChangingOwner = false;
    private boolean authorizedChangingName = false;
    public static int MAX_NAME_LEN = 32;
    private boolean changeDimensionAuthorized = false;
    private boolean DTN_dogChangingDim = false;
    public OnlineDogLocationManager.RemoveState locationUpdatedUponRemove = OnlineDogLocationManager.RemoveState.NONE;
    private Optional<class_1282> dogDeathCause = Optional.empty();
    private final DogDuplicationDetection dogDuplicateDetection = new DogDuplicationDetection(this);
    private DogAnimation sitAnim = DogAnimation.SIT_DOWN;
    private DogAnimation standAnim = DogAnimation.STAND_QUICK;
    private boolean isDogFollowingSomeone;
    private boolean isDogResistingPush;
    private boolean isDogCurious;
    private AnimationAction animAction;
    private DogPose activePose = DogPose.STAND;
    private final DogFabricHelper dogFabricHelper = new DogFabricHelper(this);
    private boolean isAddedToWorld = false;

    public Dog(class_1299<? extends Dog> type, class_1937 worldIn) {
        super(type, worldIn);
        this.method_6173(false, true);
        this.setGender(DogGender.random(this.method_59922()));
        this.setLowHealthStrategy(LowHealthStrategy.STICK_TO_OWNER);
        this.authorizedChangingOwner = true;
        this.setOwnerUUID(null);
        this.authorizedChangingOwner = false;
        this.resetTickTillRest();
        this.field_6207 = new DogMoveControl(this);
        this.field_6204 = new DogJumpControl(this);
        this.defaultNavigation = (DogPathNavigation)this.field_6189;
        this.defaultMoveControl = (DogMoveControl)this.field_6207;
        this.dogAi = new DogAiManager(this, class_10209::method_64146);
        this.dogAi.init();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LAST_KNOWN_NAME, Optional.empty());
        builder.method_56912(DOG_FLAGS, (Object)0);
        builder.method_56912(HUNGER_INT, (Object)Float.valueOf(60.0f));
        builder.method_56912(BONE_VARIANT, (Object)class_1799.field_8037);
        builder.method_56912(INCAP_VAL, (Object)0);
        builder.method_56912(ANIMATION, (Object)0);
        builder.method_56912(ANIM_SYNC_TIME, (Object)0);
    }

    protected final void method_5959() {
    }

    public void method_5712(class_2338 pos, class_2680 blockIn) {
        float vol = this.isDogSilent() ? 0.01f : 0.15f;
        this.method_5783(class_3417.field_14772, vol, 1.0f);
    }

    protected class_3414 method_5994() {
        boolean whine_health;
        if (this.dogSoundManager.isAmbientLocked()) {
            return null;
        }
        if (this.isDefeated()) {
            if (this.getDogIncapValue() > 20) {
                int chance_window = this.incapacitatedMananger.canMove() ? 5 : 8;
                return this.field_5974.method_43048(chance_window) == 0 ? this.dogMood.getInjuredAmbient() : null;
            }
            return DogSounds.CLASSIC_PANTING.get();
        }
        if (this.pettingManager.isPetting() || this.isDogSilent()) {
            return null;
        }
        boolean bl = whine_health = this.method_6181() && this.method_6032() < 10.0f && this.field_5974.method_43048(3) == 0;
        if (whine_health) {
            return this.dogMood.getLowHealthWhine();
        }
        return this.dogMood.getAmbientSound();
    }

    public void method_5783(class_3414 sound, float vol, float pitch) {
        if (this.dogMood.isForceInteruptibleSound(sound)) {
            this.dogSoundManager.playInterruptible(sound, vol, pitch);
            return;
        }
        super.method_5783(sound, vol, pitch);
    }

    @Override
    public float method_6107() {
        float default_val = 0.4f;
        if (this.isDefeated() && this.getDogIncapValue() > 20) {
            default_val = this.incapacitatedMananger.canMove() ? 0.2f : 0.05f;
        }
        return default_val;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        if (this.canWolfArmorAbsorb(damageSourceIn)) {
            return class_3417.field_49176;
        }
        return this.dogMood.getHurtSound(damageSourceIn);
    }

    protected void method_6013(class_1282 source) {
        this.field_6191 = -this.method_5970();
        this.dogSoundManager.playNonInterruptible(this.method_6011(source), this.method_6107(), this.method_6017());
    }

    protected class_3414 method_6002() {
        return this.dogMood.getDeathSound();
    }

    protected class_3414 getHowlSound() {
        return EntityUtil_1_21_5.legacyWolfHowlSound(this);
    }

    public void howl() {
        this.method_5783(this.getHowlSound(), 1.0f, this.method_6017());
    }

    public boolean isDogSoaked() {
        return this.wetSource.soaked();
    }

    @Environment(value=EnvType.CLIENT)
    public float getShadingWhileWet(float partialTicks) {
        return Math.min(0.5f + class_3532.method_16439((float)partialTicks, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) / 2.0f * 0.5f, 1.0f);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public float getShakeAngle(float partialTicks, float offset) {
        float f = (class_3532.method_16439((float)partialTicks, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) + offset) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return class_3532.method_15374((float)(f * (float)Math.PI)) * class_3532.method_15374((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public float getInterestedAngle(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.headRotationCourseOld, (float)this.headRotationCourse) * 0.15f * (float)Math.PI;
    }

    public void method_5711(byte id) {
        super.method_5711(id);
    }

    public void handleDogShakingUpdate(DogShakingData.State state) {
        switch (state) {
            case SHAKE_WATER: {
                this.startShaking();
                break;
            }
            case SHAKE_LAVA: {
                this.startShakingLava();
                break;
            }
            case STOP: {
                this.finishShaking();
                break;
            }
            default: {
                this.finishShaking();
            }
        }
        if (this.method_37908().field_9236) {
            this.dogSoundManager.interuptPlaying();
        }
    }

    public float getTailRotation() {
        if (!this.method_6181()) {
            return 0.62831855f;
        }
        float full_health_angle = 1.73f;
        float lost_health = this.method_6063() - this.method_6032();
        float lost_health_percent = lost_health * this.percentDecreasePerHealthLost;
        float lost_rad_percent = lost_health_percent * lost_health_percent;
        float lost_rad = 1.5707964f * lost_rad_percent;
        lost_rad = class_3532.method_15363((float)lost_rad, (float)0.0f, (float)1.5707964f);
        return 1.73f - lost_rad;
    }

    @Override
    public float getWagAngle(float limbSwing, float limbSwingAmount, float partialTickTime) {
        return class_3532.method_15362((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.6f * this.method_5751()), (double)(this.method_17681() * 0.4f));
    }

    public int method_5978() {
        return this.method_6172() ? 20 : super.method_5978();
    }

    protected void method_5627(class_1297 passanger) {
        super.method_5627(passanger);
        this.method_18382();
    }

    protected void method_5793(class_1297 passanger) {
        super.method_5793(passanger);
        this.method_18382();
    }

    public class_4048 method_18377(class_4050 pose) {
        boolean collide_passeneger;
        class_4048 self_dim = super.method_18377(pose);
        this.visualDimension = null;
        if (self_dim.comp_2185() >= 1.0f) {
            self_dim = new class_4048(1.0f, self_dim.comp_2186(), self_dim.comp_2187(), self_dim.comp_2188(), self_dim.comp_2189());
        }
        if (!(collide_passeneger = ((Boolean)ConfigHandler.SERVER.WOLF_MOUNT_PASSENGER_COLLISION.get()).booleanValue())) {
            return self_dim;
        }
        if (this.method_5782() && !this.method_5685().isEmpty()) {
            this.visualDimension = self_dim;
            self_dim = this.computeRidingDimension(self_dim);
        }
        return self_dim;
    }

    public double getPassengersRidingOffset(class_4048 self_dim) {
        return (double)self_dim.comp_2186() * 0.75;
    }

    public class_4048 getRealDimensions() {
        return super.method_18377(this.method_18376());
    }

    @Override
    public float getDogVisualBbHeight() {
        if (this.visualDimension != null) {
            return this.visualDimension.comp_2186();
        }
        return this.method_17682();
    }

    @Override
    public float getDogVisualBbWidth() {
        if (this.visualDimension != null) {
            return this.visualDimension.comp_2185();
        }
        return this.method_17681();
    }

    private class_4048 computeRidingDimension(class_4048 self_dim) {
        float total_width = self_dim.comp_2185();
        class_1297 passenger = (class_1297)this.method_5685().get(0);
        float total_height = self_dim.comp_2186();
        total_width = Math.max(total_width, passenger.method_17681());
        total_height = (float)((double)total_height + ((double)passenger.method_17682() - passenger.method_55668((class_1297)this).field_1351));
        if (total_width >= 1.0f) {
            total_width = 1.0f;
        }
        return new class_4048(total_width, total_height, self_dim.comp_2187(), self_dim.comp_2188(), self_dim.comp_2189());
    }

    public void method_5773() {
        class_1309 owner;
        super.method_5773();
        this.updateClassicalAnim();
        if (this.method_5805()) {
            this.updateDogPose();
        }
        this.alterations.forEach(alter -> alter.tick(this));
        if (this.method_5805() && this.method_6063() != this.maxHealth0) {
            this.maxHealth0 = this.method_6063();
            this.percentDecreasePerHealthLost = 1.0f / this.maxHealth0;
        }
        if (this.method_5805() && !this.method_37908().field_9236 && this.field_6012 % 40 == 0 && (owner = this.method_35057()) != null) {
            this.setOwnersName(owner.method_5477());
        }
        if (this.method_5805()) {
            this.animationManager.tick();
            if (!this.method_37908().field_9236) {
                this.tickAnimAction();
            }
        }
        this.pettingManager.tick();
        this.sleepOnManager.tick();
        this.dogSoundManager.tick();
        if (this.method_37908().field_9236) {
            // empty if block
        }
        if (this.method_37908().field_9236 && ((Boolean)ConfigHandler.CLIENT.DISPLAY_SMOKE_WHEN_ON_FIRE.get()).booleanValue()) {
            this.addAdditionalOnFireEffect();
        }
        if (!this.method_37908().field_9236) {
            this.dogSyncedDataManager.tick();
        }
        if (!this.method_37908().field_9236) {
            this.getDogFabricHelper().tick();
        }
    }

    private void addAdditionalOnFireEffect() {
        if (this.method_5809()) {
            if (this.method_59922().method_43048(3) == 0) {
                float f1 = (this.method_59922().method_43057() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                float f2 = (this.method_59922().method_43057() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                this.method_37908().method_8406((class_2394)class_2398.field_17430, this.method_23317() + (double)f1, this.method_23318() + (double)this.method_5751(), this.method_23321() + (double)f2, 0.0, 0.05, 0.0);
            }
            if (this.onFireSmokeTick <= 300) {
                ++this.onFireSmokeTick;
            } else if (this.onFireSmokeTick <= 600 && this.field_6012 % 4 == 0) {
                ++this.onFireSmokeTick;
            }
            this.onFireSmokeTick = class_3532.method_15340((int)this.onFireSmokeTick, (int)20, (int)300);
        } else if (this.onFireSmokeTick > 0) {
            --this.onFireSmokeTick;
            if (this.method_59922().method_43048(3) == 0) {
                float f1 = (this.method_59922().method_43057() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                float f2 = (this.method_59922().method_43057() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23317() + (double)f1, this.method_23318() + (double)this.method_5751(), this.method_23321() + (double)f2, 0.0, 0.05, 0.0);
            }
        }
    }

    private void updateClassicalAnim() {
        if (!this.method_5805()) {
            return;
        }
        this.updateClassicalBegAnim();
        boolean val = this.checkDogInWetSourceAndWetTheDog();
        this.updateClassicalShakeAnim(val);
    }

    private void updateClassicalBegAnim() {
        if (!this.canDogDoBegAnim()) {
            this.headRotationCourse = 0.0f;
            this.headRotationCourseOld = 0.0f;
            return;
        }
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
    }

    private boolean checkDogInWetSourceAndWetTheDog() {
        if (this.method_5771()) {
            this.wetSource = WetSource.LAVA;
            return true;
        }
        if (this.method_5799()) {
            this.wetSource = WetSource.WATER;
            return true;
        }
        if (this.method_5721()) {
            this.wetSource = WetSource.RAIN;
            return true;
        }
        if (this.method_5799()) {
            this.wetSource = WetSource.BUBBLE_COLUMN;
            return true;
        }
        return false;
    }

    private void updateClassicalShakeAnim(boolean currentlyInWater) {
        if (!this.method_37908().field_9236 && this.isShaking && (!this.canDogDoShakeAnim() || currentlyInWater)) {
            this.finishShaking();
            ParticlePackets.DogShakingPacket.sendDogShakingPacket(this, DogShakingData.State.STOP);
            return;
        }
        if (!this.isShaking) {
            return;
        }
        if (this.timeWolfIsShaking == 0.0f && this.method_37908().field_9236 && !this.shakeFire) {
            this.dogSoundManager.playInterruptible(class_3417.field_15042, this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        }
        this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
        this.timeWolfIsShaking += 0.05f;
        if (this.prevTimeWolfIsShaking >= 2.0f) {
            for (IDogAlteration alter : this.alterations) {
                alter.onShakingDry(this, this.wetSource);
            }
            this.wetSource = WetSource.NONE;
            this.finishShaking();
        }
        if (this.timeWolfIsShaking > 0.4f) {
            float f = (float)this.method_23318();
            int i = (int)(class_3532.method_15374((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
            class_243 vec3d = this.method_18798();
            for (int j = 0; j < i; ++j) {
                float f1 = (this.field_5974.method_43057() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                float f2 = (this.field_5974.method_43057() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                if (this.shakeFire) {
                    float r = this.method_59922().method_43057();
                    class_2400 type = class_2398.field_11251;
                    if (r <= 0.15f) {
                        type = class_2398.field_18305;
                    } else if (r <= 0.6f) {
                        type = class_2398.field_11239;
                    }
                    this.method_37908().method_8406((class_2394)type, this.method_23317() + (double)f1, (double)(f + 0.8f), this.method_23321() + (double)f2, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
                    continue;
                }
                this.method_37908().method_8406((class_2394)class_2398.field_11202, this.method_23317() + (double)f1, (double)(f + 0.8f), this.method_23321() + (double)f2, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
            }
        }
        if ((double)this.timeWolfIsShaking > 0.5 && this.shakeFire && this.field_5974.method_43048(6) == 0) {
            this.method_5783(class_3417.field_15102, this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        }
    }

    public boolean canDoIdileAnim() {
        if (!this.method_5805()) {
            return false;
        }
        if (this.method_5765() || this.method_5782()) {
            return false;
        }
        if (this.idleAnimHurtCooldown > 0) {
            return false;
        }
        return !this.isShaking && !this.getAnim().interupting();
    }

    public boolean canContinueDoIdileAnim() {
        if (this.dogAnimHurtImpules) {
            this.dogAnimHurtImpules = false;
            this.idleAnimHurtCooldown = 20;
            return false;
        }
        if (this.method_5765() || this.method_5782()) {
            return false;
        }
        return this.method_5805() && !this.isShaking;
    }

    public void setAnimForIdle(DogAnimation anim) {
        this.setAnim(anim);
        this.dogAnimHurtImpules = false;
    }

    public boolean canDogDoBegAnim() {
        DogPose pose = this.getDogPose();
        if (!pose.canBeg) {
            return false;
        }
        return !this.animationManager.started() || this.getAnim().freeHead();
    }

    public boolean canDogDoShakeAnim() {
        DogPose pose = this.getDogPose();
        if (!pose.canShake) {
            return false;
        }
        return !this.animationManager.started();
    }

    public void method_6007() {
        if (this.field_6189 != this.currentNavigation) {
            this.field_6189 = this.currentNavigation;
        }
        if (this.navigationLock != null) {
            this.navigationLock.unlockDogNavigation();
        }
        this.validateGoalsAndTickNonRunningIfNeeded();
        if (!this.method_37908().field_9236) {
            this.method_5985().method_6370();
            this.dogAi.tickServer();
            this.dogSwimmingManager.tickServer();
        }
        super.method_6007();
        this.updateDogBeginShake();
        if (!this.method_37908().field_9236 && !this.isDefeated()) {
            this.hungerManager.tick();
            this.tickDogHealing();
            this.dogOwnerDistanceManager.tick();
            this.avoidGoInFrontOfOwnerManager.tick();
        }
        if (!this.method_37908().field_9236) {
            this.dogMood.tickServer();
            this.dogPushAvoidManager.tickServer();
            this.dogAttackManager.tickServer();
        }
        if (this.method_37908().field_9236 && this.getDogLevel().isFullKami() && ((Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.KAMI_PARTICLES)).booleanValue()) {
            for (int i = 0; i < 2; ++i) {
                this.method_37908().method_8406((class_2394)class_2398.field_11214, this.method_23322(0.5), this.method_23319() - 0.25, this.method_23325(0.5), (this.field_5974.method_43058() - 0.5) * 2.0, -this.field_5974.method_43058(), (this.field_5974.method_43058() - 0.5) * 2.0);
            }
        }
        if (this.method_37908().field_9236 && this.isInDrunkPose() && this.field_6012 % 16 == 0) {
            int color = 10101987;
            this.method_37908().method_8406((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)color), this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 1.0, 1.0, 1.0);
        }
        if (this.field_6012 % 50 == 0) {
            class_5321 dimKey = this.method_37908().method_27983();
            Optional<class_2338> bowlPos = this.getBowlPos((class_5321<class_1937>)dimKey);
            if (bowlPos.isPresent() && this.method_5707(class_243.method_24955((class_2382)((class_2382)bowlPos.get()))) >= 64.0) {
                this.setBowlPos((class_5321<class_1937>)dimKey, Optional.empty());
            }
            if (bowlPos.isPresent() && this.method_37908().method_22340(bowlPos.get()) && !this.method_37908().method_8320(bowlPos.get()).method_27852((class_2248)DoggyBlocks.FOOD_BOWL.get())) {
                this.setBowlPos((class_5321<class_1937>)dimKey, Optional.empty());
            }
        }
        this.alterations.forEach(alter -> alter.livingTick(this));
        if (this.isDefeated()) {
            this.incapacitatedMananger.tick();
        }
        if (this.tickChopinTail > 0) {
            --this.tickChopinTail;
        }
        if (this.randomStrollCooldown > 0) {
            --this.randomStrollCooldown;
        }
        if (this.switchNavCooldown > 0) {
            --this.switchNavCooldown;
        }
        if (this.idleAnimHurtCooldown > 0) {
            --this.idleAnimHurtCooldown;
        }
        if (this.drunkTickLeft > 0) {
            --this.drunkTickLeft;
        }
        if (this.silentTickLeft > 0) {
            --this.silentTickLeft;
        }
        if (!this.method_37908().field_9236 && this.method_6172() && !this.isDogResting() && this.tickUntilRest > 0) {
            --this.tickUntilRest;
        }
        if (!this.method_37908().field_9236 && this.method_5753()) {
            this.mayFloatDogInLava();
        }
        if (this.navigationLock != null) {
            this.navigationLock.lockDogNavigation();
        }
    }

    private void tickDogHealing() {
        int healingTick_add = 8;
        if (this.method_6172()) {
            healingTick_add += 4;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.healingTick(this, healingTick_add);
            if (!result.getResult().shouldSwing()) continue;
            healingTick_add = result.getObject();
        }
        if (healingTick_add < 0) {
            healingTick_add = 0;
        }
        this.healingTick += healingTick_add;
        if (this.healingTick >= 6000) {
            if (this.method_6032() < this.method_6063()) {
                this.method_6025(2.0f);
            }
            this.healingTick = 0;
        }
    }

    private void updateDogBeginShake() {
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.isShaking) {
            return;
        }
        if (this.method_6150()) {
            return;
        }
        if (!this.method_24828()) {
            return;
        }
        if (!this.canDogDoShakeAnim()) {
            return;
        }
        if (this.wetSource.isNone()) {
            return;
        }
        if (this.checkDogInWetSourceAndWetTheDog()) {
            return;
        }
        if (this.wetSource.flame() && this.method_5809()) {
            return;
        }
        this.startShakingAndBroadcast(this.wetSource.flame());
    }

    private void validateGoalsAndTickNonRunningIfNeeded() {
        if (this.method_37908().field_9236) {
            return;
        }
        Set availableGoals = this.field_6201.method_35115();
        if (!availableGoals.isEmpty()) {
            availableGoals.clear();
        }
    }

    public boolean triggerAction(TriggerableAction action) {
        return this.dogAi.triggerAction(action);
    }

    public boolean isBusy() {
        if (!this.isDoingFine()) {
            return true;
        }
        if (this.method_6172() && this.forceSit()) {
            return true;
        }
        if (this.dogAi.isBusy()) {
            return true;
        }
        return this.method_42148();
    }

    public boolean readyForNonTrivialAction() {
        if (!this.isDoingFine()) {
            return false;
        }
        if (this.method_6172() && this.forceSit()) {
            return false;
        }
        if (!this.dogAi.readyForNonTrivivalAction()) {
            return false;
        }
        return !this.method_42148();
    }

    public void clearTriggerableAction() {
        this.dogAi.clearTriggerableAction();
    }

    public boolean triggerActionDelayed(int delay, TriggerableAction action) {
        return this.dogAi.triggerActionDelayed(action, delay);
    }

    public boolean isOnSwitchNavCooldown() {
        return this.switchNavCooldown > 0;
    }

    public boolean canUpdateDogAi() {
        return !this.method_6062() && this.method_6034() && !this.isDogInAnimDebug();
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.isDefeated()) {
            return this.incapacitatedMananger.interact(stack, player, hand).toVanilla();
        }
        if (this.handleOpenDogScreenDedicated(player, stack).shouldSwing()) {
            return class_1269.field_5812;
        }
        if (this.handleTameDogIfNotTamed(player, stack, hand).shouldSwing()) {
            return class_1269.field_5812;
        }
        if (this.dogCheckAndRidePlayer(player, stack).shouldSwing()) {
            return class_1269.field_5812;
        }
        if (this.handleSetWolfArmor(player, stack).shouldSwing()) {
            return class_1269.field_5812;
        }
        if (this.handleRepairWolfArmor(player, stack).shouldSwing()) {
            return class_1269.field_5812;
        }
        if (this.handleUnsetWolfArmor(player, stack, hand).shouldSwing()) {
            return class_1269.field_5812;
        }
        Optional<DogInteractionResult> otherHandlerResult = this.handleAlterationsAndOtherHandlers(player, stack, hand);
        if (otherHandlerResult.isPresent()) {
            return otherHandlerResult.get().toVanilla();
        }
        if (this.handleBreeding(player, hand, stack).shouldSwing()) {
            return class_1269.field_5812;
        }
        if (this.handleOpenDogScreen(player).shouldSwing()) {
            return class_1269.field_5812;
        }
        if (this.handleDogSitStand(player).shouldSwing()) {
            return class_1269.field_5812;
        }
        if (this.method_37908().field_9236) {
            this.displayToastIfNoPermission(player);
        }
        return class_1269.field_5811;
    }

    private DogInteractionResult handleDogSitStand(class_1657 player) {
        if (!this.canInteract((class_1309)player)) {
            return DogInteractionResult.FAIL;
        }
        if (this.isProtesting()) {
            return DogInteractionResult.FAIL;
        }
        if (!this.method_37908().field_9236) {
            this.checkAndDoBackFlip();
        }
        if (!this.method_37908().field_9236 && !this.method_24345()) {
            this.lastOrderedToSitTick = this.field_6012;
        }
        this.method_24346(!this.method_24345());
        this.field_6282 = false;
        this.field_6189.method_6340();
        this.method_5980(null);
        return DogInteractionResult.SUCCESS;
    }

    private void checkAndDoBackFlip() {
        if (!this.method_24345()) {
            return;
        }
        if (!this.method_6172()) {
            return;
        }
        int sit_interval = this.field_6012 - this.lastOrderedToSitTick;
        float r = this.method_59922().method_43057();
        if (!this.checkDogBackflipRandom(r, sit_interval)) {
            return;
        }
        if (!this.checkDogBackflipAreaAbove()) {
            return;
        }
        this.setStandAnim(DogAnimation.NONE);
        this.method_6179(false);
        this.triggerAnimationAction(new DogBackFlipAction(this));
    }

    private boolean checkDogBackflipRandom(float r, int sit_interval) {
        if (sit_interval <= 30) {
            return false;
        }
        if (sit_interval >= 1200) {
            return r <= 0.7f;
        }
        return r <= 0.3f;
    }

    private boolean checkDogBackflipAreaAbove() {
        return this.method_37908().method_8320(this.method_24515().method_10084()).method_26215();
    }

    private DogInteractionResult handleOpenDogScreen(class_1657 player) {
        if (!player.method_5715()) {
            return DogInteractionResult.PASS;
        }
        if (!this.canInteract((class_1309)player)) {
            return DogInteractionResult.PASS;
        }
        if (this.method_37908().field_9236) {
            DogNewInfoScreen.open(this);
        }
        return DogInteractionResult.SUCCESS;
    }

    private DogInteractionResult handleOpenDogScreenDedicated(class_1657 player, class_1799 stack) {
        if (stack.method_7909() != class_1802.field_8600) {
            return DogInteractionResult.FAIL;
        }
        if (!this.method_6181()) {
            return DogInteractionResult.FAIL;
        }
        if (!this.method_37908().field_9236) {
            return DogInteractionResult.SUCCESS;
        }
        if (this.canInteract((class_1309)player)) {
            DogNewInfoScreen.open(this);
        } else {
            DogCannotInteractWithScreen.open(this);
        }
        return DogInteractionResult.SUCCESS;
    }

    private DogInteractionResult dogCheckAndRidePlayer(class_1657 player, class_1799 stack) {
        if (player.method_5626((class_1297)this)) {
            if (!this.method_37908().field_9236) {
                this.method_18375();
            }
            return DogInteractionResult.SUCCESS;
        }
        if (stack.method_7909() != class_1802.field_8606) {
            return DogInteractionResult.PASS;
        }
        if (!player.method_5715()) {
            return DogInteractionResult.PASS;
        }
        if (this.method_5782()) {
            return DogInteractionResult.PASS;
        }
        if (!this.canInteract((class_1309)player)) {
            return DogInteractionResult.PASS;
        }
        if (!this.method_37908().field_9236 && this.method_5804((class_1297)player)) {
            player.method_7353((class_2561)class_2561.method_43469((String)"talent.doggytalents.bed_finder.dog_mount", (Object[])new Object[]{this.getGenderPronoun()}), true);
        }
        return DogInteractionResult.SUCCESS;
    }

    private DogInteractionResult handleSetWolfArmor(class_1657 player, class_1799 stack) {
        if (!stack.method_31574(class_1802.field_47831)) {
            return DogInteractionResult.PASS;
        }
        if (this.hasWolfArmor()) {
            return DogInteractionResult.PASS;
        }
        if (!this.canInteract((class_1309)player)) {
            return DogInteractionResult.PASS;
        }
        if (this.method_37908().field_9236) {
            return DogInteractionResult.SUCCESS;
        }
        this.setWolfArmor(stack.method_46651(1));
        stack.method_57008(1, (class_1309)player);
        return DogInteractionResult.SUCCESS;
    }

    private DogInteractionResult handleRepairWolfArmor(class_1657 player, class_1799 stack) {
        if (!DogUtil.isScute(stack)) {
            return DogInteractionResult.PASS;
        }
        if (!this.hasWolfArmor()) {
            return DogInteractionResult.PASS;
        }
        if (!this.canInteract((class_1309)player)) {
            return DogInteractionResult.PASS;
        }
        class_1799 wolf_armor = this.wolfArmor();
        if (!wolf_armor.method_7986()) {
            return DogInteractionResult.PASS;
        }
        if (this.method_37908().field_9236) {
            return DogInteractionResult.SUCCESS;
        }
        stack.method_7934(1);
        this.method_43077(class_3417.field_49177);
        int repair_val = DogUtil.getWolfArmorRepairVal(wolf_armor);
        int new_damage_val = wolf_armor.method_7919() - repair_val;
        if (new_damage_val < 0) {
            new_damage_val = 0;
        }
        wolf_armor.method_7974(new_damage_val);
        return DogInteractionResult.SUCCESS;
    }

    private DogInteractionResult handleUnsetWolfArmor(class_1657 player, class_1799 stack, class_1268 hand) {
        if (!stack.method_31574(class_1802.field_8868)) {
            return DogInteractionResult.PASS;
        }
        if (!this.hasWolfArmor()) {
            return DogInteractionResult.PASS;
        }
        if (!this.canInteract((class_1309)player)) {
            return DogInteractionResult.PASS;
        }
        if (this.method_37908().field_9236) {
            return DogInteractionResult.SUCCESS;
        }
        stack.method_7970(1, (class_1309)player, Dog.method_56079((class_1268)hand));
        this.method_43077(class_3417.field_47722);
        class_1799 wolf_armor0 = this.wolfArmor();
        this.setWolfArmor(class_1799.field_8037);
        this.method_5775((class_3218)this.method_37908(), wolf_armor0);
        return DogInteractionResult.SUCCESS;
    }

    private Optional<DogInteractionResult> handleAlterationsAndOtherHandlers(class_1657 player, class_1799 stack, class_1268 hand) {
        Optional<IDogFoodHandler> foodHandler = FoodHandler.getMatch(this, stack, (class_1297)player);
        if (foodHandler.isPresent()) {
            return Optional.of(foodHandler.get().consume(this, stack, (class_1297)player));
        }
        DogInteractionResult dog_item_result = IDogItem.getMatch(this, stack, player, hand);
        if (dog_item_result != DogInteractionResult.PASS) {
            return Optional.of(dog_item_result);
        }
        for (IDogAlteration alter : this.alterations) {
            DogInteractionResult result = alter.processInteract(this, this.method_37908(), player, hand);
            if (result == DogInteractionResult.PASS) continue;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private DogInteractionResult handleBreeding(class_1657 player, class_1268 hand, class_1799 stack) {
        if (!stack.method_31574(DoggyItems.BREEDING_BONE.get())) {
            return DogInteractionResult.PASS;
        }
        if (!this.canInteract((class_1309)player)) {
            return DogInteractionResult.PASS;
        }
        if (this.method_37908().field_9236) {
            return DogInteractionResult.SUCCESS;
        }
        int age = this.method_5618();
        if (age == 0 && this.method_6482()) {
            this.method_6475(player, hand, stack);
            this.method_6480(player);
        } else if (this.method_6109()) {
            this.method_6475(player, hand, stack);
            this.method_5620(Dog.method_41321((int)(-age)), true);
        }
        return DogInteractionResult.SUCCESS;
    }

    private DogInteractionResult handleTameDogIfNotTamed(class_1657 player, class_1799 stack, class_1268 hand) {
        boolean alwaysTame;
        if (this.method_6181()) {
            return DogInteractionResult.FAIL;
        }
        if (!this.isDogTameItem(stack)) {
            return DogInteractionResult.FAIL;
        }
        if (this.method_37908().field_9236) {
            return DogInteractionResult.SUCCESS;
        }
        this.method_6475(player, hand, stack);
        boolean bl = alwaysTame = stack.method_7909() == DoggyItems.TRAINING_TREAT.get();
        if (alwaysTame || this.field_5974.method_43048(3) == 0) {
            this.method_6170(player);
            this.field_6189.method_6340();
            this.method_5980(null);
            this.method_24346(true);
            this.maxHealth();
            this.method_37908().method_8421((class_1297)this, (byte)7);
        } else {
            this.method_37908().method_8421((class_1297)this, (byte)6);
        }
        return DogInteractionResult.SUCCESS;
    }

    private boolean isDogTameItem(class_1799 stack) {
        return stack.method_31574(class_1802.field_8606) || stack.method_31574(DoggyItems.TRAINING_TREAT.get());
    }

    @Override
    public boolean canStillEat() {
        if (this.method_37908().field_9236) {
            return false;
        }
        if (((Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get()).booleanValue() && this.method_6032() < this.method_6063() && this.hungerManager.saturation() <= 0) {
            return true;
        }
        return this.getDogHunger() < this.getMaxHunger();
    }

    public boolean isProtesting() {
        return this.isProtesting;
    }

    public void setProtesting(boolean p) {
        this.isProtesting = p;
    }

    private void displayToastIfNoPermission(class_1657 player) {
        if (this.canInteract((class_1309)player)) {
            return;
        }
        player.method_7353((class_2561)class_2561.method_43469((String)"doggui.invalid_dog.no_permission.title", (Object[])new Object[]{this.getGenderPronoun()}).method_27692(class_124.field_1061), true);
    }

    public boolean method_49693() {
        if (this.canSwimUnderwater() && this.alterationProps.canBreatheUnderwater()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            DogInteractionResult result = alter.canBeRiddenInWater(this);
            if (result.shouldSwing()) {
                return false;
            }
            if (result != DogInteractionResult.FAIL) continue;
            return true;
        }
        return super.method_49693();
    }

    public void method_5848() {
        if (!this.method_37908().field_9236) {
            class_1297 e0 = this.method_5854();
            super.method_5848();
            class_1297 e1 = this.method_5854();
            if (e0 != e1 && e0 instanceof class_3222) {
                class_3222 player = (class_3222)e0;
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new DogMountData(this.method_5628(), false));
            }
        } else {
            super.method_5848();
        }
    }

    public boolean method_5873(class_1297 entity, boolean force_ride) {
        boolean not_authorized;
        boolean result = false;
        boolean bl = not_authorized = this.requireRidingAuthorization(entity) && !this.isRidingAuthorized();
        if (!not_authorized) {
            result = super.method_5873(entity, force_ride);
        }
        this.ridingAuthorized = false;
        if (!this.method_37908().field_9236 && result && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new DogMountData(this.method_5628(), true));
        }
        return result;
    }

    public boolean isRidingAuthorized() {
        return this.ridingAuthorized;
    }

    public void authorizeRiding() {
        this.ridingAuthorized = true;
    }

    public boolean requireRidingAuthorization(class_1297 entity) {
        Dog otherDog;
        if (this.dogAutoMount()) {
            return false;
        }
        UUID ownerUUID = this.getOwnerUUID();
        if (ownerUUID == null) {
            return false;
        }
        if (!ObjectUtils.notEqual((Object)ownerUUID, (Object)entity.method_5667())) {
            return false;
        }
        return !(entity instanceof Dog) || ObjectUtils.notEqual((Object)ownerUUID, (Object)(otherDog = (Dog)entity).getOwnerUUID());
    }

    public boolean method_5709() {
        if (this.method_37908().field_9236) {
            return ClientEventHandler.showWolfMountHealth();
        }
        return super.method_5709();
    }

    public boolean canTrample(class_3218 level, class_2680 state, class_2338 pos, double fallDistance) {
        return false;
    }

    public class_1315 method_5943(class_5425 p_332775_, class_1266 p_332793_, class_3730 p_332761_, @Nullable class_1315 p_332782_) {
        return null;
    }

    public double method_45325(class_6880<class_1320> attrib) {
        if (attrib == class_5134.field_23717) {
            DogAttackManager attack_manager = this.dogAttackManager;
            if (attack_manager != null && attack_manager.isDogFarChasingTarget()) {
                return 32.0;
            }
            IDogRangedAttackManager ranged_attack = this.getDogRangedAttack();
            if (ranged_attack != null && ranged_attack.isApplicable(this)) {
                return 20.0;
            }
        }
        return super.method_45325(attrib);
    }

    public boolean method_5747(double distance, float damageMultiplier, class_1282 source) {
        if (this.dogFallImmune()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            DogInteractionResult result = alter.onLivingFall(this, (float)distance, damageMultiplier);
            if (result.shouldSwing()) {
                return true;
            }
            if (result != DogInteractionResult.FAIL) continue;
            return false;
        }
        double[] ret = new double[]{distance, damageMultiplier};
        int i = this.method_23329(distance = ret[0], damageMultiplier = (float)ret[1]);
        if (i > 0) {
            if (this.method_5782()) {
                for (class_1297 e : this.method_5685()) {
                    e.method_64419(this.method_48923().method_48827(), (float)i);
                }
            }
            this.method_5783(i > 4 ? this.method_39760().comp_302() : this.method_39760().comp_301(), 1.0f, 1.0f);
            this.method_23328();
            this.method_64419(this.method_48923().method_48827(), i);
            return true;
        }
        return false;
    }

    public boolean dogFallImmune() {
        return this.alterationProps.fallImmune();
    }

    public int method_5850() {
        return 3;
    }

    protected int method_23329(double distance, float damageMultiplier) {
        class_1293 effectInst = this.method_6112(class_1294.field_5913);
        float f = effectInst == null ? 0.0f : (float)(effectInst.method_5578() + 1);
        distance -= (double)f;
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.calculateFallDistance(this, (float)distance);
            if (!result.getResult().shouldSwing()) continue;
            distance = result.getObject().floatValue();
            break;
        }
        return class_3532.method_15384((double)((distance - 3.0 - (double)f) * (double)damageMultiplier));
    }

    protected void method_5623(double fallVelocity, boolean onGround, class_2680 state, class_2338 pos) {
        if (this.method_5753() && state.method_26204() == class_2246.field_10164) {
            this.method_38785();
        }
        super.method_5623(fallVelocity, onGround, state, pos);
    }

    public boolean method_6094() {
        return this.alterationProps.canBreatheUnderwater();
    }

    protected int method_6130(int air) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.decreaseAirSupply(this, air);
            if (!result.getResult().shouldSwing()) continue;
            return result.getObject();
        }
        return super.method_6130(air);
    }

    public boolean method_26319(class_3610 state) {
        if (this.method_5753() && state.method_15767(class_3486.field_15518)) {
            return true;
        }
        return super.method_26319(state);
    }

    public boolean method_5659(class_1927 x) {
        for (IDogAlteration alter : this.alterations) {
            DogInteractionResult result = alter.negateExplosion(this);
            if (!result.shouldSwing()) continue;
            return true;
        }
        return super.method_5659(x);
    }

    protected int method_6064(int currentAir) {
        currentAir += 4;
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.determineNextAir(this, currentAir);
            if (!result.getResult().shouldSwing()) continue;
            currentAir = result.getObject();
            break;
        }
        return Math.min(currentAir, this.method_5748());
    }

    public boolean method_18395(class_1309 target) {
        if (!this.getMode().shouldAttack()) {
            return false;
        }
        if (this.getMode().minorAttack() && this.dogMinorAttackCheckToAvoid(target)) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            DogInteractionResult result = alter.canAttack(this, target);
            if (result.shouldSwing()) {
                return true;
            }
            if (result != DogInteractionResult.FAIL) continue;
            return false;
        }
        if (target instanceof class_1548) {
            return false;
        }
        return super.method_18395(target);
    }

    private boolean dogMinorAttackCheckToAvoid(class_1309 target) {
        class_1309 owner;
        if (target instanceof class_1590) {
            return true;
        }
        if (target instanceof class_5418 && (owner = this.method_35057()) != null) {
            for (class_1799 stack : EntityUtil_1_21_5.getArmorSlots(owner)) {
                if (!FabricUtil.makesPiglinsNeutral(stack)) continue;
                return true;
            }
        }
        return target.method_5864().method_20210(DoggyTags.DOG_SHOULD_IGNORE);
    }

    public boolean method_5973(class_1299<?> entityType) {
        if (!this.getMode().shouldAttack()) {
            return false;
        }
        return entityType != class_1299.field_6107 || this.canDogFly();
    }

    public boolean method_6178(class_1309 target, class_1309 owner) {
        if (!this.getMode().shouldAttack()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            DogInteractionResult result = alter.shouldAttackEntity(this, target, owner);
            if (result.shouldSwing()) {
                return true;
            }
            if (result != DogInteractionResult.FAIL) continue;
            return false;
        }
        if (target instanceof class_1548) {
            return false;
        }
        return !DogAllyCheck.isAlliedToDog(this, (class_1297)target, owner);
    }

    protected boolean stillIdleOrSitWhenHurt(class_1282 source, float amount) {
        if (this.isDogDrunk()) {
            return true;
        }
        if (this.method_5765()) {
            return true;
        }
        for (IDogAlteration alt : this.alterations) {
            if (!alt.stillIdleOrSitWhenHurt(this, source, amount).shouldSwing()) continue;
            return true;
        }
        return false;
    }

    public boolean hurtDog(Optional<class_3218> level, class_1282 source, Optional<Float> amount, HurtSuperCall super_call) {
        boolean flag;
        class_1297 attacker = source.method_5529();
        if (this.isDefeated() && !source.method_48789(class_8103.field_42242)) {
            class_1308 mob;
            class_1309 target;
            this.incapacitatedMananger.onHurt();
            if (attacker instanceof class_1308 && (target = (mob = (class_1308)attacker).method_5968()) == this) {
                mob.method_5980(null);
            }
            return false;
        }
        if (amount.isPresent()) {
            for (IDogAlteration alter : this.alterations) {
                InteractionResultHolder<Float> result = alter.gettingAttackedFrom(this, source, amount.get().floatValue());
                if (result.getResult() == DogInteractionResult.FAIL) {
                    return false;
                }
                amount = Optional.of(result.getObject());
            }
        }
        if (level.isPresent() && this.method_5679(level.get(), source)) {
            return false;
        }
        boolean allPlayerCannotAttackDog = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.SERVER.ALL_PLAYER_CANNOT_ATTACK_DOG);
        if (allPlayerCannotAttackDog && attacker instanceof class_1657) {
            return false;
        }
        if (!this.canOwnerAttack() && (flag = DogAllyCheck.isAlliedToDog(this, attacker))) {
            return false;
        }
        float health0 = this.method_6032();
        this.dogMood.onStartHurting(health0);
        boolean ret = super_call.hurt(source, amount);
        float actual_hurt_amount = health0 - this.method_6032();
        if (!this.method_37908().field_9236) {
            this.mayStandUpAndPlayHurtAnim(source, actual_hurt_amount, health0);
            if (actual_hurt_amount > 0.0f) {
                DogSleepOnManager.onHurt(this);
            }
        }
        if (this.method_37908().field_9236 && ((Boolean)ConfigHandler.CLIENT.BLOCK_RED_OVERLAY_WHEN_HURT.get()).booleanValue()) {
            this.field_6235 = 0;
            this.field_6254 = 0;
        }
        return ret;
    }

    protected void method_6074(class_3218 level, class_1282 source, float amount) {
        if (this.mayWolfArmorAbsorb(source, amount)) {
            return;
        }
        super.method_6074(level, source, amount);
    }

    private boolean mayWolfArmorAbsorb(class_1282 source, float amount) {
        if (!this.canWolfArmorAbsorb(source)) {
            return false;
        }
        class_1799 wolf_armor_stack = this.wolfArmor();
        int damage_val0 = wolf_armor_stack.method_7919();
        int damage_max0 = wolf_armor_stack.method_7936();
        wolf_armor_stack.method_7970(class_3532.method_15386((float)amount), (class_1309)this, class_1304.field_48824);
        this.playWolfArmorCrackSound(this.field_6277, damage_val0, damage_max0);
        return true;
    }

    private boolean canWolfArmorAbsorb(class_1282 source) {
        if (((Boolean)ConfigHandler.SERVER.DISABLE_WOLF_ARMOR_FUNCTION.get()).booleanValue()) {
            return false;
        }
        return this.hasWolfArmor() && !source.method_48789(class_8103.field_49182);
    }

    private void playWolfArmorCrackSound(class_1799 wolf_armor_stack, int damage_val0, int damage_max0) {
        class_9273.class_4621 crackiness0 = class_9273.field_49211.method_57283(damage_val0, damage_max0);
        class_9273.class_4621 crackiness = class_9273.field_49211.method_57284(wolf_armor_stack);
        if (crackiness == crackiness0) {
            return;
        }
        this.method_43077(class_3417.field_49175);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 sLevel = (class_3218)class_19372;
            sLevel.method_65096((class_2394)new class_2392(class_2398.field_11218, class_1802.field_47830.method_7854()), this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 20, 0.2, 0.1, 0.2, 0.1);
        }
    }

    private void mayStandUpAndPlayHurtAnim(class_1282 source, float real_hurt_amount, float health0) {
        if (this.isDefeated()) {
            return;
        }
        if (this.method_29504()) {
            this.method_24346(false);
            this.method_6179(false);
            this.setAnim(DogAnimation.HURT_1);
            return;
        }
        if (this.stillIdleOrSitWhenHurt(source, real_hurt_amount)) {
            return;
        }
        this.dogAnimHurtImpules = true;
        this.method_24346(false);
        boolean wasSitting = this.method_6172();
        if (wasSitting) {
            this.setStandAnim(DogAnimation.NONE);
            this.method_6179(false);
        }
        if (wasSitting || real_hurt_amount >= 6.0f) {
            this.setAnim(DogAnimation.HURT_1);
            return;
        }
        if (source.method_5529() != null && real_hurt_amount >= 1.0f) {
            this.setAnim(DogAnimation.HURT_2);
            return;
        }
    }

    public boolean method_6121(class_3218 level, class_1297 target) {
        for (IDogAlteration alter : this.alterations) {
            alter.doInitialAttackEffects(this, target);
        }
        class_1324 attackDamageInst = this.method_5996(class_5134.field_23721);
        class_1324 critDamageInst = this.method_5996(DoggyAttributes.CRIT_CHANCE.holder());
        Set critModifiers = null;
        if (critDamageInst != null && critDamageInst.method_6194() > this.method_59922().method_43058()) {
            class_1324 critBonusInst = this.method_5996(DoggyAttributes.CRIT_BONUS.holder());
            Set set = critModifiers = critBonusInst == null ? null : critBonusInst.method_6195();
            if (critModifiers != null && attackDamageInst != null) {
                critModifiers.forEach(arg_0 -> ((class_1324)attackDamageInst).method_26835(arg_0));
            }
        }
        float damage = (float)(attackDamageInst == null ? 0.0 : attackDamageInst.method_6194());
        class_1799 stack = this.method_6047();
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverlevel = (class_3218)class_19372;
            damage = class_1890.method_60120((class_3218)serverlevel, (class_1799)stack, (class_1297)target, (class_1282)this.method_48923().method_48812((class_1309)this), (float)damage);
        }
        if (critModifiers != null && attackDamageInst != null) {
            critModifiers.forEach(arg_0 -> ((class_1324)attackDamageInst).method_6202(arg_0));
        }
        this.doInitialEnchantDamageEffects((class_1309)this, target);
        boolean flag = target.method_64397(level, this.method_48923().method_48812((class_1309)this), damage);
        if (!flag) {
            return false;
        }
        class_1937 class_19373 = this.method_37908();
        if (class_19373 instanceof class_3218) {
            class_3218 serverlevel1 = (class_3218)class_19373;
            class_1890.method_60107((class_3218)serverlevel1, (class_1297)target, (class_1282)this.method_48923().method_48812((class_1309)this));
        }
        this.statsTracker.increaseDamageDealt(damage);
        if (critModifiers != null) {
            ParticlePackets.CritEmitterPacket.sendCritEmitterPacketToNearClients(target);
            this.method_5783(class_3417.field_15016, 0.5f, 1.0f);
        }
        for (IDogAlteration alter : this.alterations) {
            alter.doAdditionalAttackEffects(this, target);
        }
        if (this.method_6059(DoggyEffects.NATTO_BITE.holder()) && target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            ((NattoBiteEffect)DoggyEffects.NATTO_BITE.get()).doAdditionalAttackEffects(this, living);
        }
        this.method_6114(target);
        return true;
    }

    public boolean method_5874(class_3218 level, class_1309 entity) {
        if (!((Boolean)ConfigHandler.SERVER.DISABLE_KILL_STATS.get()).booleanValue()) {
            this.statsTracker.incrementKillCount((class_1297)entity);
        }
        return true;
    }

    protected void doInitialEnchantDamageEffects(class_1309 dog, class_1297 target) {
        float knockback = this.method_59924(target, this.method_48923().method_48812((class_1309)this));
        if (knockback > 0.0f && target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            living.method_6005((double)(knockback * 0.5f), (double)class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
            this.method_18799(this.method_18798().method_18805(0.6, 1.0, 0.6));
        }
    }

    public boolean method_33190() {
        return !this.isDefeated() && super.method_33190();
    }

    public void method_20803(int ticks) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.setFire(this, ticks);
            if (!result.getResult().shouldSwing()) continue;
            ticks = result.getObject();
        }
        super.method_20803(ticks);
    }

    public boolean method_5753() {
        return this.alterationProps.fireImmune();
    }

    public boolean method_32316() {
        return !this.alterationProps.fireImmune();
    }

    public boolean shouldDogNotAfraidOfFire() {
        for (IDogAlteration alter : this.alterations) {
            DogInteractionResult result = alter.shouldNotAfraidOfFire(this);
            if (!result.shouldSwing()) continue;
            return true;
        }
        return false;
    }

    public boolean method_5679(class_3218 level, class_1282 source) {
        for (IDogAlteration alter : this.alterations) {
            DogInteractionResult result = alter.isInvulnerableTo(this, source);
            if (result.shouldSwing()) {
                return true;
            }
            if (result != DogInteractionResult.FAIL) continue;
            return false;
        }
        return super.method_5679(level, source);
    }

    public boolean method_5655() {
        for (IDogAlteration alter : this.alterations) {
            DogInteractionResult result = alter.isInvulnerable(this);
            if (result.shouldSwing()) {
                return true;
            }
            if (result != DogInteractionResult.FAIL) continue;
            return false;
        }
        return super.method_5655();
    }

    public boolean method_37222(class_1293 effectInst, @Nullable class_1297 adder) {
        if (this.isDefeated()) {
            return false;
        }
        return super.method_37222(effectInst, adder);
    }

    public void method_26082(class_1293 p_147216_, @Nullable class_1297 adder) {
        if (this.isDefeated()) {
            return;
        }
        super.method_26082(p_147216_, adder);
    }

    public boolean method_6049(class_1293 effectIn) {
        if (this.isDefeated()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            DogInteractionResult result = alter.isPotionApplicable(this, effectIn);
            if (result.shouldSwing()) {
                return true;
            }
            if (result != DogInteractionResult.FAIL) continue;
            return false;
        }
        return super.method_6049(effectIn);
    }

    public boolean method_60969() {
        return false;
    }

    public void method_60964(class_1297 p_21464_, boolean p_21465_) {
    }

    public boolean method_60953() {
        return false;
    }

    @Nullable
    public class_1297 method_60952() {
        return null;
    }

    public boolean method_5947() {
        return true;
    }

    public boolean method_5974(double distance) {
        return false;
    }

    public void method_5982() {
        this.field_6278 = 0;
    }

    public void method_5826(UUID uniqueIdIn) {
        UUID oldUniqueId = this.method_5667();
        if (uniqueIdIn.equals(oldUniqueId)) {
            return;
        }
        super.method_5826(uniqueIdIn);
        if (!this.isAddedToWorld()) {
            return;
        }
        if (this.method_37908() != null && !this.method_37908().field_9236) {
            DogLocationStorage.get(this.method_37908()).remove(oldUniqueId);
            DogLocationStorage.get(this.method_37908()).getOrCreateData(this).update(this);
        }
    }

    public void method_6170(class_1657 player) {
        super.method_6170(player);
        this.setOwnersName(player.method_5477());
    }

    public void method_6173(boolean tame, boolean update_tame_props) {
        super.method_6173(tame, update_tame_props);
        if (tame) {
            float maxHealth = this.getDogLevel().getMaxHealth();
            this.method_5996(class_5134.field_23716).method_6192((double)maxHealth);
        } else {
            this.method_5996(class_5134.field_23716).method_6192(8.0);
        }
        this.method_5996(class_5134.field_23721).method_6192(4.0);
    }

    public void maxHealth() {
        this.method_6033(this.method_6063());
    }

    @Override
    public void setOwnerUUID(@Nullable UUID uuid) {
        boolean isChangingOwner;
        UUID currentUUID = this.getOwnerUUID();
        boolean bl = isChangingOwner = currentUUID != null && ObjectUtils.notEqual((Object)currentUUID, (Object)uuid);
        if (isChangingOwner && !this.authorizedChangingOwner) {
            return;
        }
        this.setOwnerUUID_1_21_3_Under_SuperCall(uuid);
        if (uuid == null) {
            this.setOwnersName((class_2561)null);
        }
    }

    public void method_5665(@Nullable class_2561 name) {
        if (!this.authorizedChangingName) {
            return;
        }
        name = this.checkDogNameLength(name);
        name = this.checkDogValidName(name);
        super.method_5665(name);
    }

    private class_2561 checkDogNameLength(class_2561 name) {
        if (name == null) {
            return null;
        }
        String str = name.getString();
        if (str.length() <= MAX_NAME_LEN) {
            return name;
        }
        String new_str = str.substring(0, MAX_NAME_LEN);
        class_5250 new_name = class_2561.method_43470((String)new_str).method_27696(name.method_10866());
        return new_name;
    }

    private class_2561 checkDogValidName(class_2561 name) {
        if (name == null) {
            return null;
        }
        String str = name.getString();
        String newStr = DogUtil.checkAndCorrectInvalidName(str);
        if (newStr == str) {
            return name;
        }
        return class_2561.method_43470((String)newStr).method_27696(name.method_10866());
    }

    public void setDogCustomName(@Nullable class_2561 name) {
        this.authorizedChangingName = true;
        this.method_5665(name);
        this.authorizedChangingName = false;
    }

    public boolean method_5698(class_1297 entityIn) {
        boolean allPlayerCannotAttackDog = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.SERVER.ALL_PLAYER_CANNOT_ATTACK_DOG);
        if (allPlayerCannotAttackDog && entityIn instanceof class_1657) {
            return true;
        }
        if (!this.canOwnerAttack() && DogAllyCheck.isAlliedToDog(this, entityIn)) {
            return true;
        }
        for (IDogAlteration alter : this.alterations) {
            DogInteractionResult result = alter.shouldSkipAttackFrom(this, entityIn);
            if (result.shouldSwing()) {
                return true;
            }
            if (result != DogInteractionResult.FAIL) continue;
            return false;
        }
        return false;
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public boolean method_6474(class_1429 otherAnimal) {
        if (this.isDefeated()) {
            return false;
        }
        if (otherAnimal == this) {
            return false;
        }
        if (!this.method_6181()) {
            return false;
        }
        if (!(otherAnimal instanceof Dog)) {
            return false;
        }
        Dog entitydog = (Dog)otherAnimal;
        if (!entitydog.method_6181()) {
            return false;
        }
        if (entitydog.method_6172()) {
            return false;
        }
        if (!((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DISABLE_GENDER)).booleanValue() && !this.getGender().canMateWith(entitydog.getGender())) {
            return false;
        }
        return !entitydog.isDefeated() && this.method_6479() && entitydog.method_6479();
    }

    public class_1296 method_5613(class_3218 worldIn, class_1296 partner) {
        Dog child = (Dog)DoggyEntityTypes.DOG.get().method_5883((class_1937)worldIn, class_3730.field_16466);
        UUID uuid = this.getOwnerUUID();
        if (uuid != null) {
            child.setOwnerUUID(uuid);
            child.method_6173(true, true);
            child.maxHealth();
        }
        if (partner instanceof Dog && ((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.PUPS_GET_PARENT_LEVELS)).booleanValue()) {
            child.setLevel(this.getDogLevel().combine(((Dog)partner).getDogLevel()));
        }
        return child;
    }

    public void method_24650(class_3218 level, class_1429 otherDog) {
        if (!this.checkOwnerTrainLimitBeforeBreed()) {
            this.method_5614(6000);
            otherDog.method_5614(6000);
            this.method_6477();
            otherDog.method_6477();
            this.method_37908().method_8421((class_1297)this, (byte)6);
            return;
        }
        super.method_24650(level, otherDog);
    }

    private boolean checkOwnerTrainLimitBeforeBreed() {
        class_1309 owner = this.method_35057();
        if (owner == null) {
            return false;
        }
        if (!(owner instanceof class_3222)) {
            return false;
        }
        class_3222 sP = (class_3222)owner;
        return EventHandler.isWithinTrainWolfLimit((class_1657)sP);
    }

    public boolean method_5733() {
        return this.method_16914() || super.method_5733();
    }

    public float method_55693() {
        if (this.method_6109()) {
            return 0.5f;
        }
        return this.getDogSize().getScale();
    }

    public float method_17825() {
        return 1.0f;
    }

    public void authorizeChangeDimension() {
        this.changeDimensionAuthorized = true;
    }

    public class_1297 changeDimension(class_5454 tansition) {
        if (this.checkBlockPortal()) {
            return null;
        }
        this.DTN_dogChangingDim = true;
        class_1297 transportedEntity = super.method_5731(tansition);
        this.DTN_dogChangingDim = false;
        if (transportedEntity instanceof Dog) {
            Dog dog = (Dog)transportedEntity;
            DogLocationStorage.get(this.method_37908()).getOrCreateData(this).update(dog);
            if (dog.getMode().canWander()) {
                dog.setMode(DogMode.DOCILE);
            }
        }
        return transportedEntity;
    }

    private boolean checkBlockPortal() {
        boolean default_block;
        boolean defeated_bypass;
        boolean changeDimensionAuth0 = this.changeDimensionAuthorized;
        this.changeDimensionAuthorized = false;
        boolean bl = defeated_bypass = this.isDefeated() && (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.INJURED_DOG_BLOCK_PORTAL) == false;
        if (defeated_bypass) {
            return false;
        }
        boolean bl2 = default_block = !changeDimensionAuth0 && (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.ALL_DOG_BLOCK_PORTAL) != false;
        return default_block;
    }

    public void onRemovedFromWorld() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 server_level = (class_3218)class_19372;
        DogLocationData data = DogLocationStorage.get((class_1937)server_level).getData(this);
        if (data == null) {
            return;
        }
        if (this.method_5805()) {
            data.update(this);
            this.locationUpdatedUponRemove = OnlineDogLocationManager.RemoveState.UPDATED;
        }
        data.invalidateCachedDog();
    }

    public void onAddedToWorld() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.method_5805()) {
                DogLocationStorage storage = DogLocationStorage.get((class_1937)serverLevel);
                DogLocationData data = storage.getOrCreateData(this);
                if (data != null) {
                    data.update(this);
                }
                storage.getOnlineDogsManager().onDogGoOnline(this);
                DogDuplicationDetection.afterDogJoinLevel(this, data);
            }
        }
    }

    public void onDogStartTracking() {
        this.locationUpdatedUponRemove = OnlineDogLocationManager.RemoveState.NONE;
    }

    public void onDogStopTracking() {
    }

    public void method_5650(class_1297.class_5529 removalReason) {
        if (this.method_37908() != null && !this.method_37908().field_9236) {
            boolean remove_trusted;
            boolean bl = remove_trusted = (Boolean)ConfigHandler.SERVER.TRUST_THIRD_PARTY_STORAGE.get() != false && removalReason == class_1297.class_5529.field_26999;
            if (!remove_trusted && removalReason.method_31486()) {
                DogLocationStorage.get(this.method_37908()).remove(this);
                if (this.getOwnerUUID() != null) {
                    DogRespawnStorage.get(this.method_37908()).putData(this);
                    this.locationUpdatedUponRemove = OnlineDogLocationManager.RemoveState.UNLOADED_TO_RESPAWN;
                } else {
                    this.locationUpdatedUponRemove = OnlineDogLocationManager.RemoveState.REMOVED;
                }
            }
            if (remove_trusted) {
                DogLocationStorage.get(this.method_37908()).remove(this);
                this.locationUpdatedUponRemove = OnlineDogLocationManager.RemoveState.REMOVE_TRUSTED;
            }
        }
        super.method_5650(removalReason);
        for (IDogAlteration x : this.alterations) {
            x.remove(this);
        }
    }

    public boolean method_31746() {
        if (this.doDogRidingPlayerSave()) {
            return true;
        }
        return super.method_31746();
    }

    public boolean method_5662(class_2487 compound) {
        if (this.doDogRidingPlayerSave()) {
            return this.method_5786(compound);
        }
        return super.method_5662(compound);
    }

    private boolean doDogRidingPlayerSave() {
        if (!((Boolean)ConfigHandler.SERVER.SAVE_DOG_RIDING_PLAYER.get()).booleanValue()) {
            return false;
        }
        class_1297.class_5529 remove_reason = this.method_35049();
        if (remove_reason != null && !remove_reason.method_31487()) {
            return false;
        }
        if (!this.method_5765()) {
            return false;
        }
        return this.method_5854() instanceof class_1657;
    }

    public void method_23327(double x, double y, double z) {
        int y_cap;
        boolean max_build_height_check;
        class_243 current_pos = this.method_19538();
        boolean bl = max_build_height_check = y != current_pos.field_1351 && ConfigHandler.ServerConfig.getConfigOrDefault(ConfigHandler.SERVER.DOG_MAX_BUILD_Y_CAP, false) != false;
        if (max_build_height_check && y > (double)(y_cap = this.method_37908().method_31600())) {
            y = y_cap;
        }
        this.mayDogLoadChunkBeforeMoveTo(x, y, z);
        super.method_23327(x, y, z);
    }

    private void mayDogLoadChunkBeforeMoveTo(double x, double y, double z) {
        boolean changed_chunk;
        boolean changed_xz;
        class_243 current_pos = this.method_19538();
        boolean bl = changed_xz = current_pos.field_1352 != x || current_pos.field_1350 != z;
        if (!changed_xz) {
            return;
        }
        class_1923 current_chunk_pos = this.method_31476();
        boolean bl2 = changed_chunk = class_4076.method_42615((double)x) != current_chunk_pos.field_9181 || class_4076.method_42615((double)z) != current_chunk_pos.field_9180;
        if (!changed_chunk) {
            return;
        }
        if (!((Boolean)ConfigHandler.SERVER.DOG_LOAD_CHUNK_BEFORE_MOVE.get()).booleanValue()) {
            return;
        }
        if (!this.dogTrackingTracker.isTracking()) {
            return;
        }
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.method_31481()) {
            return;
        }
        this.method_37908().method_8497(class_4076.method_42615((double)x), class_4076.method_42615((double)z));
    }

    private void startShaking() {
        if (this.isShaking) {
            return;
        }
        this.isShaking = true;
        this.shakeFire = false;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public void startShakingAndBroadcast(boolean shakeFire) {
        if (this.isShaking) {
            return;
        }
        if (this.method_37908().field_9236) {
            return;
        }
        if (shakeFire) {
            this.startShakingLava();
            ParticlePackets.DogShakingPacket.sendDogShakingPacket(this, DogShakingData.State.SHAKE_LAVA);
            return;
        }
        this.startShaking();
        ParticlePackets.DogShakingPacket.sendDogShakingPacket(this, DogShakingData.State.SHAKE_WATER);
    }

    private void finishShaking() {
        this.isShaking = false;
        this.shakeFire = false;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public void startShakingLava() {
        if (this.isShaking) {
            return;
        }
        this.isShaking = true;
        this.shakeFire = true;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public boolean isShakingLava() {
        return this.isShaking && this.shakeFire;
    }

    public void resetBeggingRotation() {
        this.headRotationCourse = 0.0f;
        this.headRotationCourseOld = 0.0f;
    }

    public void method_6078(class_1282 cause) {
        if (this.checkAndHandleIncapacitated(cause)) {
            return;
        }
        this.wetSource = WetSource.NONE;
        this.finishShaking();
        this.alterations.forEach(alter -> alter.onDeath(this, cause));
        this.dogDeathCause = Optional.empty();
        if (((Boolean)ConfigHandler.SERVER.DOG_RESPAWN_INCAPACITATED_WHEN_KILLED.get()).booleanValue() && !cause.method_48789(class_8103.field_42242)) {
            this.dogDeathCause = Optional.ofNullable(cause);
            this.setDogIncapValue(this.getInitalDogIncapVal(cause));
        }
        this.dogProccessAndBroadcastDieVanilla(cause);
    }

    public Optional<class_1282> getDogDeathCause() {
        return this.dogDeathCause;
    }

    private void dogProccessAndBroadcastDieVanilla(class_1282 cause) {
        if (this.method_31481()) {
            return;
        }
        if (this.field_6272) {
            return;
        }
        class_2561 deathMessage = this.method_6066().method_5548();
        this.field_6272 = true;
        this.method_6066().method_5539();
        class_1937 level = this.method_37908();
        class_1297 entity = cause.method_5529();
        if (level instanceof class_3218) {
            class_3218 serverlevel = (class_3218)level;
            if (entity == null || entity.method_5874(serverlevel, (class_1309)this)) {
                this.method_32876((class_6880)class_5712.field_37676);
                this.method_16080(serverlevel, cause);
            }
            this.method_37908().method_8421((class_1297)this, (byte)3);
        }
        class_1309 owner = this.method_35057();
        if (!this.method_37908().field_9236 && ((class_3218)this.method_37908()).method_64395().method_8355(class_1928.field_19398) && owner instanceof class_3222) {
            PlayerUtil.sendSystemMessage(owner, deathMessage);
        }
    }

    private boolean checkAndHandleIncapacitated(class_1282 cause) {
        if (this.method_37908().field_9236) {
            return false;
        }
        if (!((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.IMMORTAL_DOGS)).booleanValue()) {
            return false;
        }
        if (cause.method_48789(class_8103.field_42242)) {
            return false;
        }
        if (this.getOwnerUUID() == null) {
            return false;
        }
        this.handleIncapacitated(cause);
        return true;
    }

    private void handleIncapacitated(class_1282 source) {
        this.method_6033(1.0f);
        this.setMode(DogMode.INJURED);
        this.setDogHunger(0.0f);
        this.method_6012();
        this.setDogIncapValue(this.getInitalDogIncapVal(source));
        this.method_20417();
        this.dogAi.forceStopAllGoal();
        this.method_5942().method_6340();
        this.method_18375();
        this.createAndSetIncapSyncState(source);
        if (this.method_5799() || !this.method_5753() && this.method_5771()) {
            this.triggerAnimationAction(new DogDrownAction(this));
        } else {
            this.setAnim(this.incapacitatedMananger.getAnim());
        }
        class_1309 owner = this.method_35057();
        if (owner != null) {
            this.sendIncapacitatedMsg(owner, source);
        }
        this.incapacitatedMananger.setIncapMsg(source.method_5506((class_1309)this).getString());
        this.wetSource = WetSource.NONE;
        this.finishShaking();
    }

    public int getInitalDogIncapVal(class_1282 source) {
        class_1267 difficulty = this.method_37908().method_8407();
        if (difficulty == class_1267.field_5801) {
            return this.getDefaultInitIncapVal() / 2;
        }
        if (difficulty == class_1267.field_5805) {
            return this.getDefaultInitIncapVal();
        }
        if (source.method_48789(class_8103.field_42242)) {
            return this.getDefaultInitIncapVal();
        }
        float fatal_damage = this.field_6253;
        if (fatal_damage <= 0.0f) {
            return this.getDefaultInitIncapVal();
        }
        fatal_damage = this.method_6132(source, fatal_damage);
        if ((fatal_damage = this.method_6036(source, fatal_damage)) <= 0.0f) {
            return this.getDefaultInitIncapVal();
        }
        int multipler = difficulty == class_1267.field_5807 ? 2 : 1;
        int additional_incap = class_3532.method_15375((float)((float)multipler * fatal_damage));
        return this.getDefaultInitIncapVal() + additional_incap;
    }

    private void sendIncapacitatedMsg(class_1309 owner, class_1282 source) {
        class_5250 msg = source.method_5506((class_1309)this).method_27661();
        String genderStr = class_2561.method_43471((String)this.getGender().getUnlocalisedSubject()).getString();
        String msg005 = ". " + genderStr.substring(0, 1).toUpperCase() + genderStr.substring(1) + " ";
        class_5250 msg01 = class_2561.method_43469((String)"dog.mode.incapacitated.msg.partition1", (Object[])new Object[]{class_2561.method_43470((String)msg005), class_2561.method_43471((String)DogMode.INJURED.getUnlocalisedName()).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(14025732))});
        msg.method_10852((class_2561)msg01);
        PlayerUtil.sendSystemMessage(owner, (class_2561)msg);
    }

    public DogIncapacitatedMananger.IncapacitatedSyncState createIncapSyncState(class_1282 source) {
        DogIncapacitatedMananger.DefeatedType type = source.method_48789(class_8103.field_42246) || this.method_5809() && !this.method_5753() ? DogIncapacitatedMananger.DefeatedType.BURN : (source.method_49708(class_8111.field_42349) ? DogIncapacitatedMananger.DefeatedType.POISON : (source.method_49708(class_8111.field_42342) ? DogIncapacitatedMananger.DefeatedType.DROWN : (source.method_49708(class_8111.field_42343) ? DogIncapacitatedMananger.DefeatedType.STARVE : DogIncapacitatedMananger.DefeatedType.BLOOD)));
        int poseId = this.method_59922().method_43048(2);
        return new DogIncapacitatedMananger.IncapacitatedSyncState(type, DogIncapacitatedMananger.BandaidState.NONE, poseId);
    }

    private void createAndSetIncapSyncState(class_1282 source) {
        DogIncapacitatedMananger.IncapacitatedSyncState state = this.createIncapSyncState(source);
        this.setIncapSyncState(state);
    }

    public double method_29241() {
        float defeated_threshold = this.method_5771() ? 0.9f : 1.0f;
        return this.isDefeated() ? (double)defeated_threshold : super.method_29241();
    }

    public void method_6010(class_6862<class_3611> tagKey) {
        if (this.method_5942().method_6350()) {
            this.method_18799(this.method_18798().method_1031(0.0, (double)0.04f, 0.0));
        } else {
            this.method_18799(this.method_18798().method_1031(0.0, 0.3, 0.0));
        }
    }

    public void method_16078(class_3218 level) {
        this.alterations.forEach(alter -> alter.dropInventory(this));
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        this.addDTNAdditionalSavedData(compound);
    }

    public void addDTNAdditionalSavedData(class_2487 compound) {
        Dimension2BlockPosMap bowlsData;
        Dimension2BlockPosMap bedsData;
        class_2499 talentList = new class_2499();
        List<TalentInstance> talents = this.getTalentMap();
        for (int i = 0; i < talents.size(); ++i) {
            class_2487 talentTag = new class_2487();
            talents.get(i).writeInstance(this, talentTag);
            talentList.add((Object)talentTag);
        }
        compound.method_10566("talents", (class_2520)talentList);
        class_2499 accessoryList = new class_2499();
        List<AccessoryInstance> accessories = this.getAccessories();
        for (int i = 0; i < accessories.size(); ++i) {
            class_2487 accessoryTag = new class_2487();
            accessories.get(i).writeInstance(accessoryTag);
            accessoryList.add((Object)accessoryTag);
        }
        compound.method_10566("accessories", (class_2520)accessoryList);
        class_2499 artifactsListTag = new class_2499();
        List<DoggyArtifactItem> artifacts = this.getArtifactsList();
        for (DoggyArtifactItem x : artifacts) {
            class_2487 artifactTag = DoggyArtifactItem.writeCompound(x);
            if (artifactTag == null) continue;
            artifactsListTag.add((Object)artifactTag);
        }
        compound.method_10566("doggy_artifacts", (class_2520)artifactsListTag);
        compound.method_10582("classicalVariant", DogVariantUtil.toSaveString(this.dogVariant(), () -> Optional.ofNullable(this.missingDogVariant)));
        compound.method_10582("mode", this.getMode().getSaveName());
        compound.method_10582("dogGender", this.getGender().getSaveName());
        compound.method_10548("dogHunger", this.getDogHunger());
        compound.method_10569("dogIncapacitatedValue", this.getDogIncapValue());
        this.getOwnersName().ifPresent(comp -> NBTUtil.putTextComponent(compound, "lastKnownOwnerName", comp));
        this.getSkinData().save(compound);
        compound.method_10556("willObey", this.willObeyOthers());
        compound.method_10556("friendlyFire", this.canOwnerAttack());
        compound.method_10556("regardTeamPlayers", this.regardTeamPlayers());
        compound.method_10556("forceSit", this.forceSit());
        compound.method_10556("dogAutoMount", this.dogAutoMount());
        compound.method_10567("lowHealthStrategy", this.getLowHealthStrategy().getId());
        compound.method_10567("combatReturnStrategy", this.getCombatReturnStrategy().getId());
        compound.method_10556("crossOriginTp", this.crossOriginTp());
        compound.method_10556("patrolTargetLock", this.patrolTargetLock());
        compound.method_10556("hideDogArmor", this.hideArmor());
        compound.method_10556("dogOnDuty", this.dogOnDuty());
        compound.method_10569("dogSize", this.getDogSize().getId());
        compound.method_10569("level_normal", this.getDogLevel().getLevel(DogLevel.Type.NORMAL));
        compound.method_10569("level_kami", this.getDogLevel().getLevel(DogLevel.Type.KAMI));
        NBTUtil.writeItemStack((class_7225.class_7874)this.method_56673(), compound, "fetchItem", this.getBoneVariant());
        class_1799 wolf_armor = this.wolfArmor();
        if (wolf_armor != null && !wolf_armor.method_7960()) {
            NBTUtil.writeItemStack((class_7225.class_7874)this.method_56673(), compound, "wolfArmorItem", wolf_armor);
        }
        if (!(bedsData = this.dogFabricHelper.getBedPos()).isEmpty()) {
            class_2499 bedsList = new class_2499();
            for (Map.Entry<class_5321<class_1937>, class_2338> entry : bedsData.entrySet()) {
                class_2487 class_24872 = new class_2487();
                NBTUtil.putResourceLocation(class_24872, "dim", entry.getKey().method_29177());
                NBTUtil.putBlockPos(class_24872, "pos", entry.getValue());
                bedsList.add((Object)class_24872);
            }
            compound.method_10566("beds", (class_2520)bedsList);
        }
        if (!(bowlsData = this.dogFabricHelper.getBowlPos()).isEmpty()) {
            class_2499 bowlsList = new class_2499();
            for (Map.Entry<class_5321<class_1937>, class_2338> entry : bowlsData.entrySet()) {
                class_2487 bowlsNBT = new class_2487();
                NBTUtil.putResourceLocation(bowlsNBT, "dim", entry.getKey().method_29177());
                NBTUtil.putBlockPos(bowlsNBT, "pos", entry.getValue());
                bowlsList.add((Object)bowlsNBT);
            }
            compound.method_10566("bowls", (class_2520)bowlsList);
        }
        this.statsTracker.writeAdditional(compound);
        this.dogOwnerDistanceManager.save(compound);
        this.pettingManager.save(compound);
        this.animationManager.save(compound);
        this.alterations.forEach(alter -> alter.onWrite(this, compound));
        this.dogGroupsManager.save(compound);
        if (this.isDefeated()) {
            this.incapacitatedMananger.save(compound);
        }
        if (this.getMode().canWander() && this.method_18410()) {
            class_2338 restrict = this.method_18412();
            int n = (int)this.method_18413();
            if (restrict != null) {
                class_2487 class_24873 = new class_2487();
                class_24873.method_10569("wanderX", restrict.method_10263());
                class_24873.method_10569("wanderY", restrict.method_10264());
                class_24873.method_10569("wanderZ", restrict.method_10260());
                class_24873.method_10569("wanderR", n);
                compound.method_10566("dogWanderCenter", (class_2520)class_24873);
            }
        }
        if (!this.method_37908().field_9236 && !this.DTN_dogChangingDim) {
            this.dogDuplicateDetection.save(compound);
        }
    }

    public void addNonDTNAdditionalData(class_2487 tag) {
        super.method_5652(tag);
    }

    public void method_5651(class_2487 compound) {
        this.authorizedChangingOwner = true;
        this.authorizedChangingName = true;
        super.method_5651(compound);
        this.authorizedChangingOwner = false;
        this.authorizedChangingName = false;
    }

    public void method_5749(class_2487 compound_1_21_5) {
        super.method_5749(compound_1_21_5);
        CompoundTag_1_21_5 compound = CompoundTag_1_21_5.wrap(compound_1_21_5);
        ArrayList<TalentInstance> newTlInstLs = new ArrayList<TalentInstance>();
        this.tryReadAllTalents(compound, newTlInstLs);
        this.dogSyncedDataManager.talents().clear();
        this.dogSyncedDataManager.talents().addAll(newTlInstLs);
        this.dogSyncedDataManager.setTalentsDirty();
        ArrayList<AccessoryInstance> newAccInstLs = new ArrayList<AccessoryInstance>();
        this.tryReadAllAccessories(compound, newAccInstLs);
        this.dogSyncedDataManager.accessories().clear();
        this.dogSyncedDataManager.accessories().addAll(newAccInstLs);
        this.dogSyncedDataManager.setAccessoriesDirty();
        ArrayList<DoggyArtifactItem> artifactsList = new ArrayList<DoggyArtifactItem>(3);
        try {
            if (compound.contains("doggy_artifacts", 9)) {
                ListTag_1_21_5 artifactsListTag = compound.getList("doggy_artifacts", 10);
                for (int i = 0; i < artifactsListTag.size(); ++i) {
                    DoggyArtifactItem artifactItem = DoggyArtifactItem.readCompound(artifactsListTag.getCompound(i));
                    if (artifactItem == null) continue;
                    artifactsList.add(artifactItem);
                }
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load artifacts : " + String.valueOf(e));
        }
        this.dogFabricHelper.setArtifacts(artifactsList);
        try {
            this.spendablePoints.markForRefresh();
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to init alteration: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.setDogVariant(DogVariantUtil.fromSaveString(compound.getString("classicalVariant"), id -> {
                this.missingDogVariant = id;
            }));
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load Dog Variant: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            DogSkinData dogSkinData = DogSkinData.readFromTag(compound);
            this.setDogSkinData(dogSkinData);
            if (compound.contains("wolfArmorItem", 10)) {
                this.setWolfArmor(NBTUtil.readItemStack((class_7225.class_7874)this.method_56673(), compound, "wolfArmorItem"));
            }
            if (compound.contains("fetchItem", 10)) {
                this.setBoneVariant(NBTUtil.readItemStack((class_7225.class_7874)this.method_56673(), compound, "fetchItem"));
            }
        }
        catch (Exception dogSkinData) {
            // empty catch block
        }
        try {
            this.setGender(DogGender.bySaveName(compound.getString("dogGender")));
            if (compound.contains("mode", 8)) {
                this.setMode(DogMode.bySaveName(compound.getString("mode")));
            }
            this.setHungerDirectly(compound.getFloat("dogHunger"));
            this.setDogIncapValue(compound.getInt("dogIncapacitatedValue"));
            this.setOwnersName(NBTUtil.getTextComponent(compound, "lastKnownOwnerName"));
            this.setWillObeyOthers(compound.getBoolean("willObey"));
            this.setCanPlayersAttack(compound.getBoolean("friendlyFire"));
            this.setRegardTeamPlayers(compound.getBoolean("regardTeamPlayers"));
            this.setDogAutoMount(compound.getBoolean("dogAutoMount"));
            this.setForceSit(compound.getBoolean("forceSit"));
            this.setCrossOriginTp(compound.getBoolean("crossOriginTp"));
            this.setPatrolTargetLock(compound.getBoolean("patrolTargetLock"));
            this.setHideArmor(compound.getBoolean("hideDogArmor"));
            this.setDogOnDuty(compound.getBoolean("dogOnDuty"));
            byte low_health_strategy_id = compound.getByte("lowHealthStrategy");
            this.setLowHealthStrategy(LowHealthStrategy.fromId(low_health_strategy_id));
            byte combat_return_strategy_id = compound.getByte("combatReturnStrategy");
            this.setCombatReturnStrategy(CombatReturnStrategy.fromId(combat_return_strategy_id));
            if (compound.containsAnyNumeric("dogSize")) {
                this.setDogSize(DogSize.fromId(compound.getInt("dogSize")));
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load levels: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            int level_normal = 0;
            int level_kami = 0;
            if (compound.containsAnyNumeric("level_normal")) {
                level_normal = compound.getInt("level_normal");
            }
            if (compound.containsAnyNumeric("level_kami")) {
                level_kami = compound.getInt("level_kami");
            } else if (compound.containsAnyNumeric("level_dire")) {
                level_kami = compound.getInt("level_dire");
            }
            this.dogFabricHelper.setDogLevel(new DogLevel(level_normal, level_kami));
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load levels: " + e.getMessage());
            e.printStackTrace();
        }
        Dimension2BlockPosMap bedsData = new Dimension2BlockPosMap();
        try {
            if (compound.contains("beds", 9)) {
                ListTag_1_21_5 bedsList = compound.getList("beds", 10);
                for (int i = 0; i < bedsList.size(); ++i) {
                    CompoundTag_1_21_5 bedNBT = bedsList.getCompound(i);
                    class_2960 loc = NBTUtil.getResourceLocation(bedNBT, "dim");
                    class_5321 type = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)loc);
                    Optional<class_2338> pos = NBTUtil.getBlockPos(bedNBT, "pos");
                    if (!pos.isPresent()) continue;
                    bedsData.put((class_5321<class_1937>)type, pos.get());
                }
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load beds: " + e.getMessage());
            e.printStackTrace();
        }
        this.dogFabricHelper.setBedPos(bedsData);
        Dimension2BlockPosMap bowlsData = new Dimension2BlockPosMap();
        try {
            if (compound.contains("bowls", 9)) {
                ListTag_1_21_5 bowlsList = compound.getList("bowls", 10);
                for (int i = 0; i < bowlsList.size(); ++i) {
                    CompoundTag_1_21_5 bowlsNBT = bowlsList.getCompound(i);
                    class_2960 loc = NBTUtil.getResourceLocation(bowlsNBT, "dim");
                    class_5321 type = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)loc);
                    Optional<class_2338> pos = NBTUtil.getBlockPos(bowlsNBT, "pos");
                    if (!pos.isPresent()) continue;
                    bowlsData.put((class_5321<class_1937>)type, pos.get());
                }
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load bowls: " + e.getMessage());
            e.printStackTrace();
        }
        this.dogFabricHelper.setBowlPos(bowlsData);
        try {
            this.statsTracker.readAdditional(compound);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load stats tracker: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.dogOwnerDistanceManager.load(compound);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load owner distance manager: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.pettingManager.load(compound);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load dog petting manager: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.animationManager.load(compound);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load dog animation manager: " + e.getMessage());
            e.printStackTrace();
        }
        this.alterations.forEach(alter -> {
            try {
                alter.onRead(this, compound);
            }
            catch (Exception e) {
                DoggyTalentsNext.LOGGER.error("Failed to load alteration: " + e.getMessage());
                e.printStackTrace();
            }
        });
        try {
            this.dogGroupsManager.load(compound);
            if (this.isDefeated()) {
                this.incapacitatedMananger.load(compound);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.getMode().canWander() && compound.contains("dogWanderCenter", 10)) {
                CompoundTag_1_21_5 wanderTg = compound.getCompound("dogWanderCenter");
                class_2338 restrictPos = new class_2338(wanderTg.getInt("wanderX"), wanderTg.getInt("wanderY"), wanderTg.getInt("wanderZ"));
                int restrict_r = wanderTg.getInt("wanderR");
                restrict_r = Math.max(0, restrict_r);
                this.method_18408(restrictPos, restrict_r);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.method_37908().field_9236) {
            try {
                this.dogDuplicateDetection.load(compound, new_owner_uuid -> {
                    boolean prevAuthorized = this.authorizedChangingOwner;
                    this.authorizedChangingOwner = true;
                    this.setOwnerUUID((UUID)new_owner_uuid);
                    this.authorizedChangingOwner = prevAuthorized;
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.method_37908().field_9236) {
            try {
                this.setAnim(DogAnimation.NONE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void tryReadAllTalents(CompoundTag_1_21_5 compound, ArrayList<TalentInstance> target) {
        try {
            if (compound.contains("talents", 9)) {
                ListTag_1_21_5 talentList = compound.getList("talents", 10);
                for (int i = 0; i < talentList.size(); ++i) {
                    try {
                        TalentInstance.readInstance(this, talentList.getCompound(i)).ifPresent(target::add);
                        continue;
                    }
                    catch (Exception e) {
                        DoggyTalentsNext.LOGGER.error(e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load talents : " + String.valueOf(e));
        }
    }

    private void tryReadAllAccessories(CompoundTag_1_21_5 compound, ArrayList<AccessoryInstance> target) {
        try {
            if (compound.contains("accessories", 9)) {
                ListTag_1_21_5 accessoryList = compound.getList("accessories", 10);
                for (int i = 0; i < accessoryList.size(); ++i) {
                    try {
                        AccessoryInstance.readInstance(accessoryList.getCompound(i)).ifPresent(target::add);
                        continue;
                    }
                    catch (Exception e) {
                        DoggyTalentsNext.LOGGER.error(e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load accessories : " + String.valueOf(e));
        }
    }

    public DogDuplicationDetection getDogDuplicationDetection() {
        return this.dogDuplicateDetection;
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (ANIMATION.equals(key)) {
            this.animationManager.onAnimationChange(this.getAnim());
        }
        if (ANIM_SYNC_TIME.equals(key)) {
            this.animationManager.onSyncTimeUpdated();
        }
        if (HUNGER_INT.equals(key)) {
            this.hungerManager.onHungerUpdated(this.getDogHunger());
        }
    }

    public void onDogSyncedDataUpdated(boolean talents, boolean accessories) {
        if (talents || accessories) {
            this.refreshAlterations();
            this.spendablePoints.markForRefresh();
        }
        if (talents && this.method_37908().field_9236) {
            ClientEventHandler.onDogTalentUpdated(this);
        }
        if (accessories && this.method_37908().field_9236) {
            this.clientAccessories = new ArrayList<AccessoryInstance>(this.getAccessories());
            this.clientAccessories.sort(AccessoryInstance.RENDER_SORTER);
        }
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.dogSyncedDataManager.onStartBeingSeenBy(player);
        this.getDogFabricHelper().onStartBeingSeenBy(player);
    }

    private void updateWanderState(DogMode mode) {
        class_2338 bowlPos;
        if (!mode.canWander()) {
            this.method_35055();
            return;
        }
        class_2338 restrictPos = this.method_24515();
        int restrictRadius = 12;
        Optional<class_2338> bowlPosOptional = this.getBowlPos();
        if (bowlPosOptional.isPresent() && (bowlPos = bowlPosOptional.get()).method_10262((class_2382)this.method_24515()) < 64.0) {
            restrictRadius = 5;
            restrictPos = bowlPos;
        }
        this.method_18408(restrictPos, restrictRadius);
    }

    private boolean invalidateWanderCenter(int distanceSqr) {
        if (!this.method_18410()) {
            return false;
        }
        class_2338 restrict_pos = this.method_18412();
        if (restrict_pos == null) {
            return false;
        }
        if (restrict_pos.method_10262((class_2382)this.method_24515()) >= (double)distanceSqr) {
            this.method_35055();
            return true;
        }
        return false;
    }

    public void refreshAlterations() {
        for (IDogAlteration iDogAlteration : this.alterations) {
            iDogAlteration.remove(this);
        }
        this.alterations.clear();
        this.foodHandlers.clear();
        this.alterationProps = new DogAlterationProps();
        this.dogRangedAttackManager = IDogRangedAttackManager.NONE;
        DogVariant dogVariant = this.dogVariant();
        if (dogVariant instanceof IDogAlteration) {
            IDogAlteration alter_var = (IDogAlteration)((Object)dogVariant);
            this.alterations.add(alter_var);
        }
        for (AccessoryInstance accessoryInstance : this.getAccessories()) {
            if (accessoryInstance instanceof IDogAlteration) {
                this.alterations.add((IDogAlteration)((Object)accessoryInstance));
            }
            if (!(accessoryInstance instanceof IDogFoodHandler)) continue;
            this.foodHandlers.add((IDogFoodHandler)((Object)accessoryInstance));
        }
        List<TalentInstance> talents = this.getTalentMap();
        this.alterations.addAll(talents);
        for (TalentInstance inst3 : talents) {
            if (!(inst3 instanceof IDogFoodHandler)) continue;
            this.foodHandlers.add((IDogFoodHandler)((Object)inst3));
        }
        List<DoggyArtifactItem> list = this.getArtifactsList();
        for (DoggyArtifactItem artifactItem : list) {
            DoggyArtifact artifact = artifactItem.createArtifact();
            this.alterations.add(artifact);
        }
        for (IDogAlteration inst4 : this.alterations) {
            inst4.props(this, this.alterationProps);
            inst4.init(this);
            if (this.dogRangedAttackManager != IDogRangedAttackManager.NONE || !inst4.getRangedAttack().isPresent()) continue;
            this.dogRangedAttackManager = inst4.getRangedAttack().get();
        }
        this.onPropsUpdated();
    }

    private void onPropsUpdated() {
        if (this.method_37908().field_9236) {
            return;
        }
        this.dogArmors.onPropsUpdated(this.alterationProps);
        if (!this.alterationProps.canUseTools()) {
            this.method_5673(class_1304.field_6173, class_1799.field_8037);
        }
        this.dogSwimmingManager.onPropsUpdated(this.alterationProps);
    }

    public IDogRangedAttackManager getDogRangedAttack() {
        if (this.dogRangedAttackManager == null) {
            return IDogRangedAttackManager.NONE;
        }
        return this.dogRangedAttackManager;
    }

    @Override
    public boolean canInteract(class_1309 livingEntity) {
        if (!this.isDoingFine()) {
            return false;
        }
        return this.willObeyOthers() || this.method_6171(livingEntity);
    }

    @Override
    public List<AccessoryInstance> getAccessories() {
        return this.dogSyncedDataManager.accessories();
    }

    @Override
    public boolean addAccessory(@Nonnull AccessoryInstance accessoryInst) {
        List<AccessoryInstance> accessories = this.getAccessories();
        AccessoryType type = accessoryInst.getAccessory().getType();
        List filtered = accessories.stream().filter(inst -> type == inst.getAccessory().getType()).collect(Collectors.toList());
        if (filtered.size() >= type.numberToPutOn()) {
            return false;
        }
        this.dogSyncedDataManager.accessories().add(accessoryInst);
        this.dogSyncedDataManager.setAccessoriesDirty();
        return true;
    }

    @Override
    public List<AccessoryInstance> removeAccessories() {
        ArrayList<AccessoryInstance> removed = new ArrayList<AccessoryInstance>(this.getAccessories());
        this.dogSyncedDataManager.accessories().clear();
        this.dogSyncedDataManager.setAccessoriesDirty();
        return removed;
    }

    public Optional<AccessoryInstance> getAccessory(AccessoryType typeIn) {
        List<AccessoryInstance> accessories = this.getAccessories();
        for (AccessoryInstance inst : accessories) {
            if (inst.getAccessory().getType() != typeIn) continue;
            return Optional.of(inst);
        }
        return Optional.empty();
    }

    public Optional<AccessoryInstance> getAccessory(Accessory typeIn) {
        List<AccessoryInstance> accessories = this.getAccessories();
        for (AccessoryInstance inst : accessories) {
            if (inst.getAccessory() != typeIn) continue;
            return Optional.of(inst);
        }
        return Optional.empty();
    }

    public Optional<class_2561> getOwnersName() {
        return (Optional)this.field_6011.method_12789(LAST_KNOWN_NAME);
    }

    public void setOwnersName(@Nullable class_2561 comp) {
        this.setOwnersName(Optional.ofNullable(comp));
    }

    public void setOwnersName(Optional<class_2561> collar) {
        this.field_6011.method_12778(LAST_KNOWN_NAME, collar);
    }

    public DogVariant dogVariant() {
        return this.dogFabricHelper.getDogVariant();
    }

    public void setDogVariant(DogVariant val) {
        this.dogFabricHelper.setDogVariant(val);
    }

    public DogGender getGender() {
        return this.dogFabricHelper.getDogGender();
    }

    public void setGender(DogGender collar) {
        this.dogFabricHelper.setDogGender(collar);
    }

    @Override
    public DogMode getMode() {
        return this.dogFabricHelper.getDogMode();
    }

    public boolean isMode(DogMode ... modes) {
        DogMode mode = this.getMode();
        for (DogMode test : modes) {
            if (mode != test) continue;
            return true;
        }
        return false;
    }

    public void setMode(DogMode collar) {
        this.dogFabricHelper.setDogMode(collar);
    }

    public Optional<class_2338> getBedPos() {
        return this.getBedPos((class_5321<class_1937>)this.method_37908().method_27983());
    }

    public Optional<class_2338> getBedPos(class_5321<class_1937> registryKey) {
        return this.dogFabricHelper.getBedPos().get(registryKey);
    }

    public void setBedPos(@Nullable class_2338 pos) {
        this.setBedPos((class_5321<class_1937>)this.method_37908().method_27983(), pos);
    }

    public void setBedPos(class_5321<class_1937> registryKey, @Nullable class_2338 pos) {
        this.setBedPos(registryKey, WorldUtil.toImmutable(pos));
    }

    public void setBedPos(class_5321<class_1937> registryKey, Optional<class_2338> pos) {
        this.dogFabricHelper.setBedPos(this.dogFabricHelper.getBedPos().copyAndSet(registryKey, pos));
    }

    public Optional<class_2338> getBowlPos() {
        return this.getBowlPos((class_5321<class_1937>)this.method_37908().method_27983());
    }

    public Optional<class_2338> getBowlPos(class_5321<class_1937> registryKey) {
        return this.dogFabricHelper.getBowlPos().get(registryKey);
    }

    public void setBowlPos(@Nullable class_2338 pos) {
        this.setBowlPos((class_5321<class_1937>)this.method_37908().method_27983(), pos);
    }

    public void setBowlPos(class_5321<class_1937> registryKey, @Nullable class_2338 pos) {
        this.setBowlPos(registryKey, WorldUtil.toImmutable(pos));
    }

    public void setBowlPos(class_5321<class_1937> registryKey, Optional<class_2338> pos) {
        this.dogFabricHelper.setBowlPos(this.dogFabricHelper.getBowlPos().copyAndSet(registryKey, pos));
    }

    @Override
    public int getDefaultInitIncapVal() {
        return 64;
    }

    @Override
    public int getMaxDogIncapVal() {
        return 256;
    }

    @Override
    public int getDogIncapValue() {
        return (Integer)this.field_6011.method_12789(INCAP_VAL);
    }

    @Override
    public void setDogIncapValue(int val) {
        val = class_3532.method_15340((int)val, (int)0, (int)this.getMaxDogIncapVal());
        this.field_6011.method_12778(INCAP_VAL, (Object)val);
    }

    @Override
    public float getMaxHunger() {
        float maxHunger = 120.0f;
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.getMaxHunger(this, maxHunger);
            if (!result.getResult().shouldSwing()) continue;
            maxHunger = result.getObject().floatValue();
        }
        return maxHunger;
    }

    @Override
    public float getDogHunger() {
        return ((Float)this.field_6011.method_12789(HUNGER_INT)).floatValue();
    }

    @Override
    public void addHunger(float add) {
        this.hungerManager.addHunger(add);
    }

    @Override
    public void setDogHunger(float hunger) {
        float diff = hunger - this.getDogHunger();
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.setDogHunger(this, hunger, diff);
            if (!result.getResult().shouldSwing()) continue;
            hunger = result.getObject().floatValue();
            diff = hunger - this.getDogHunger();
        }
        this.setHungerDirectly(class_3532.method_15363((float)hunger, (float)0.0f, (float)this.getMaxHunger()));
    }

    private void setHungerDirectly(float hunger) {
        this.field_6011.method_12778(HUNGER_INT, (Object)Float.valueOf(hunger));
    }

    public void method_6025(float add) {
        if (add <= 0.0f) {
            return;
        }
        float h = this.method_6032();
        if (h > 0.0f) {
            this.method_6033(h + add);
        }
    }

    public void method_5980(@Nullable class_1309 target) {
        if (target == this) {
            target = null;
        }
        UUID owner_id = this.getOwnerUUID();
        if (target != null && owner_id != null && owner_id.equals(target.method_5667())) {
            target = null;
        }
        class_1309 oldTarget = this.method_5968();
        super.method_5980(target);
        class_1309 newTarget = this.method_5968();
        if (oldTarget != newTarget) {
            for (IDogAlteration alt : this.alterations) {
                alt.onDogSetTarget(this, newTarget, oldTarget);
            }
            this.dogAttackManager.onTargetChange();
        }
    }

    public boolean hasCustomSkin() {
        return !Strings.isNullOrEmpty((String)this.getSkinData().getHash());
    }

    public DogSkinData getSkinData() {
        return this.dogFabricHelper.getDogSkin();
    }

    public void setDogSkinData(DogSkinData data) {
        if (data == null) {
            data = DogSkinData.NULL;
        }
        this.dogFabricHelper.setDogSkin(data);
    }

    @Override
    public DogLevel getDogLevel() {
        return this.dogFabricHelper.getDogLevel();
    }

    public void setLevel(DogLevel level) {
        this.dogFabricHelper.setDogLevel(level);
    }

    public DogIncapacitatedMananger.IncapacitatedSyncState getIncapSyncState() {
        return this.dogFabricHelper.getIncapSyncState();
    }

    public void setIncapSyncState(DogIncapacitatedMananger.IncapacitatedSyncState state) {
        this.dogFabricHelper.setIncapSyncState(state);
    }

    public DogPettingManager.DogPettingState getPettingState() {
        return this.dogFabricHelper.getDogPettingState();
    }

    public void setPettingState(DogPettingManager.DogPettingState state) {
        this.dogFabricHelper.setDogPettingState(state);
    }

    public DogSleepOnManager.DogSleepOnState getSleepOnState() {
        return this.dogFabricHelper.getDogSleepOnState();
    }

    public void setSleepOnState(DogSleepOnManager.DogSleepOnState state) {
        this.dogFabricHelper.setDogSleepOnState(state);
    }

    @Override
    public void increaseLevel(DogLevel.Type typeIn) {
        DogLevel copy = this.getDogLevel().copy();
        copy.incrementLevel(typeIn);
        this.setLevel(copy);
    }

    @Override
    public void setDogSize(DogSize size) {
        this.dogFabricHelper.setDogSize(size);
    }

    @Override
    public DogSize getDogSize() {
        return this.dogFabricHelper.getDogSize();
    }

    public boolean method_6109() {
        if (this.getDogSize() == DogSize.PPP) {
            return true;
        }
        return super.method_6109();
    }

    public void setBoneVariant(class_1799 stack) {
        this.field_6011.method_12778(BONE_VARIANT, (Object)stack);
    }

    public class_1799 getBoneVariant() {
        return (class_1799)this.field_6011.method_12789(BONE_VARIANT);
    }

    @Nullable
    public IThrowableItem getThrowableItem() {
        class_1792 item = ((class_1799)this.field_6011.method_12789(BONE_VARIANT)).method_7909();
        return item instanceof IThrowableItem ? (IThrowableItem)item : null;
    }

    public boolean hasBone() {
        return !this.getBoneVariant().method_7960();
    }

    private boolean getDogFlag(int bit) {
        return ((Integer)this.field_6011.method_12789(DOG_FLAGS) & bit) != 0;
    }

    private void setDogFlag(int bits, boolean flag) {
        int c = (Integer)this.field_6011.method_12789(DOG_FLAGS);
        this.field_6011.method_12778(DOG_FLAGS, (Object)(flag ? c | bits : c & ~bits));
    }

    public void setBegging(boolean begging) {
        this.setDogFlag(1, begging);
    }

    public boolean isBegging() {
        return this.getDogFlag(1);
    }

    public void setWillObeyOthers(boolean obeyOthers) {
        this.setDogFlag(2, obeyOthers);
    }

    public boolean willObeyOthers() {
        return this.getDogFlag(2);
    }

    public void setCanPlayersAttack(boolean flag) {
        this.setDogFlag(4, flag);
    }

    public boolean canOwnerAttack() {
        return this.getDogFlag(4);
    }

    public void setForceSit(boolean val) {
        this.setDogFlag(8, val);
    }

    public boolean forceSit() {
        return this.getDogFlag(8);
    }

    public LowHealthStrategy getLowHealthStrategy() {
        int msb = this.getDogFlag(32) ? 1 : 0;
        int lsb = this.getDogFlag(16) ? 1 : 0;
        return LowHealthStrategy.fromId(msb * 2 + lsb);
    }

    public void setLowHealthStrategy(LowHealthStrategy strategy) {
        byte id = strategy.getId();
        boolean lsb = (id & 1) == 1;
        boolean msb = (id >> 1 & 1) == 1;
        this.setDogFlag(32, msb);
        this.setDogFlag(16, lsb);
    }

    public CombatReturnStrategy getCombatReturnStrategy() {
        int msb = this.getDogFlag(8192) ? 1 : 0;
        int lsb = this.getDogFlag(4096) ? 1 : 0;
        return CombatReturnStrategy.fromId(msb * 2 + lsb);
    }

    public void setCombatReturnStrategy(CombatReturnStrategy strategy) {
        byte id = strategy.getId();
        boolean lsb = (id & 1) == 1;
        boolean msb = (id >> 1 & 1) == 1;
        this.setDogFlag(8192, msb);
        this.setDogFlag(4096, lsb);
    }

    public void setRegardTeamPlayers(boolean val) {
        this.setDogFlag(128, val);
    }

    public boolean regardTeamPlayers() {
        return this.getDogFlag(128);
    }

    public boolean crossOriginTp() {
        return this.getDogFlag(64);
    }

    public void setCrossOriginTp(boolean val) {
        this.setDogFlag(64, val);
    }

    public RestingState getDogRestingState() {
        boolean isResting = this.getDogFlag(32768);
        if (!isResting) {
            return RestingState.NONE;
        }
        boolean bellyUp = this.getDogFlag(65536);
        return bellyUp ? RestingState.BELLY : RestingState.LYING;
    }

    public void setDogRestingState(RestingState val) {
        if (val == null) {
            val = RestingState.NONE;
        }
        switch (val.ordinal()) {
            default: {
                this.setDogFlag(32768, false);
                this.setDogFlag(65536, false);
                break;
            }
            case 1: {
                this.setDogFlag(32768, true);
                this.setDogFlag(65536, false);
                break;
            }
            case 2: {
                this.setDogFlag(32768, true);
                this.setDogFlag(65536, true);
            }
        }
    }

    public boolean isDogResting() {
        return this.getDogRestingState() != RestingState.NONE;
    }

    public boolean patrolTargetLock() {
        return this.getDogFlag(512);
    }

    public boolean isInDrunkPose() {
        return this.getDogFlag(131072);
    }

    public void setInDrunkPose(boolean val) {
        this.setDogFlag(131072, val);
    }

    public void setForcedActionAnim(boolean val) {
        this.setDogFlag(262144, val);
    }

    @Override
    public boolean forcedWhenNoneAnim() {
        return this.getDogFlag(262144);
    }

    public void setDogOnDuty(boolean val) {
        this.setDogFlag(256, val);
    }

    public boolean dogOnDuty() {
        return this.getDogFlag(256);
    }

    public void setDrunkTicks(int ticks) {
        this.drunkTickLeft = ticks;
    }

    public boolean isDogDrunk() {
        return this.drunkTickLeft > 0;
    }

    public void setSilentTickLeft(int ticks) {
        this.silentTickLeft = ticks;
    }

    public boolean isDogSilent() {
        return this.silentTickLeft > 0;
    }

    public void setPatrolTargetLock(boolean val) {
        this.setDogFlag(512, val);
    }

    public boolean hideArmor() {
        return this.getDogFlag(2048);
    }

    public void setHideArmor(boolean val) {
        this.setDogFlag(2048, val);
    }

    public boolean dogAutoMount() {
        return this.getDogFlag(16384);
    }

    public void setDogAutoMount(boolean val) {
        this.setDogFlag(16384, val);
    }

    public boolean wantsToRest() {
        return this.tickUntilRest <= 0 && this.method_59922().method_43057() < 0.02f;
    }

    public void resetTickTillRest() {
        this.tickUntilRest = 600 + this.method_59922().method_43048(271) * 20;
    }

    public List<TalentInstance> getTalentMap() {
        return this.dogSyncedDataManager.talents();
    }

    public class_1269 setTalentLevel(Talent talent, int level) {
        if (0 > level || level > talent.getMaxLevel()) {
            return class_1269.field_5814;
        }
        List<TalentInstance> activeTalents = this.getTalentMap();
        TalentInstance inst = null;
        int selected_id = -1;
        for (int i = 0; i < activeTalents.size(); ++i) {
            TalentInstance activeInst = activeTalents.get(i);
            if (!activeInst.of(talent)) continue;
            inst = activeInst;
            selected_id = i;
            break;
        }
        if (inst == null) {
            if (level == 0) {
                return class_1269.field_5811;
            }
            TalentInstance newTalent = talent.getDefault(level);
            this.dogSyncedDataManager.talents().add(newTalent);
        } else {
            int remove_id;
            int previousLevel = inst.level();
            if (previousLevel == level) {
                return class_1269.field_5811;
            }
            inst.setLevel(level);
            inst.set(this, previousLevel);
            if (level <= 0 && (remove_id = selected_id) >= 0) {
                this.dogSyncedDataManager.talents().remove(remove_id);
            }
        }
        this.dogSyncedDataManager.setTalentsDirty();
        return class_1269.field_5812;
    }

    public List<DoggyArtifactItem> getArtifactsList() {
        List<DoggyArtifactItem> array = this.dogFabricHelper.getArtifacts();
        return array;
    }

    public boolean addArtifact(DoggyArtifactItem artifact) {
        if (artifact == null) {
            return false;
        }
        List<DoggyArtifactItem> array = this.getArtifactsList();
        if (array.size() >= 3) {
            return false;
        }
        if (array.contains((Object)artifact)) {
            return false;
        }
        this.modifyArtifact(artifacts -> artifacts.add(artifact));
        return true;
    }

    public class_1799 removeArtifact(int indx) {
        List<DoggyArtifactItem> array = this.getArtifactsList();
        if (indx < 0 || indx >= array.size()) {
            return null;
        }
        DoggyArtifactItem removedArtifact = array.get(indx);
        this.modifyArtifact(artifacts -> artifacts.remove(indx));
        return new class_1799((class_1935)removedArtifact);
    }

    public void modifyArtifact(Consumer<List<DoggyArtifactItem>> modify) {
        ArrayList<DoggyArtifactItem> list = new ArrayList<DoggyArtifactItem>(this.dogFabricHelper.getArtifacts());
        modify.accept(list);
        this.dogFabricHelper.setArtifacts(list);
    }

    public <T> void modifyListSyncedData(class_2940<List<T>> key, Consumer<List<T>> modify) {
        this.modifySyncedData(key, modify, x -> new ArrayList(x));
    }

    public <T> void modifySyncedData(class_2940<T> key, Consumer<T> modify, Function<T, T> copyFunc) {
        Object result = copyFunc.apply(this.field_6011.method_12789(key));
        modify.accept(result);
        this.field_6011.method_12778(key, result);
    }

    @Override
    public Optional<TalentInstance> getTalent(Talent talentIn) {
        List<TalentInstance> activeTalents = this.getTalentMap();
        for (TalentInstance activeInst : activeTalents) {
            if (!activeInst.of(talentIn)) continue;
            return Optional.of(activeInst);
        }
        return Optional.empty();
    }

    public <T extends TalentInstance> Optional<T> getTalent(Talent talent, Class<T> type) {
        Optional<TalentInstance> inst_optional = this.getTalent(talent);
        return inst_optional.map(x -> x.cast(type));
    }

    @Override
    public int getDogLevel(Talent talentIn) {
        return this.getTalent(talentIn).map(TalentInstance::level).orElse(0);
    }

    public void untame() {
        this.field_6189.method_6340();
        this.clearTriggerableAction();
        this.dogAi.forceStopAllGoal();
        this.method_24346(false);
        this.method_6033(8.0f);
        this.setDogCustomName(null);
        this.dogSyncedDataManager.talents().clear();
        this.dogSyncedDataManager.setTalentsDirty();
        this.authorizedChangingOwner = true;
        this.method_6173(false, true);
        this.setOwnerUUID(null);
        this.setWillObeyOthers(false);
        this.setCanPlayersAttack(true);
        this.setMode(DogMode.DOCILE);
        this.authorizedChangingOwner = false;
    }

    public void migrateOwner(UUID newOwnerUUID) {
        this.field_6189.method_6340();
        this.clearTriggerableAction();
        this.dogAi.forceStopAllGoal();
        this.setMode(DogMode.DOCILE);
        this.authorizedChangingOwner = true;
        this.setOwnerUUID(newOwnerUUID);
        this.authorizedChangingOwner = false;
    }

    public boolean canSpendPoints(int amount) {
        return this.getSpendablePoints() >= amount || this.getAccessory(DoggyAccessories.GOLDEN_COLLAR.get()).isPresent();
    }

    private final int getSpendablePointsInternal() {
        int totalPoints = 15 + this.getDogLevel().getLevel(DogLevel.Type.NORMAL) + this.getDogLevel().getLevel(DogLevel.Type.KAMI);
        for (TalentInstance entry : this.getTalentMap()) {
            totalPoints -= entry.getTalent().getCummulativeCost(entry.level());
        }
        return totalPoints;
    }

    public int getSpendablePoints() {
        return this.spendablePoints.get();
    }

    public class_1309 method_5642() {
        List passengers = this.method_5685();
        if (passengers.isEmpty()) {
            return null;
        }
        class_1297 first_passenger = (class_1297)passengers.get(0);
        if (!(first_passenger instanceof class_1657)) {
            return null;
        }
        class_1657 player = (class_1657)first_passenger;
        return this.canInteract((class_1309)player) ? player : null;
    }

    public class_243 method_24829(class_1309 passenger) {
        float a1 = this.method_36454();
        float dx1 = -class_3532.method_15374((float)(a1 * ((float)Math.PI / 180)));
        float dz1 = class_3532.method_15362((float)(a1 * ((float)Math.PI / 180)));
        double newX = this.method_23317() + (double)dx1;
        double newZ = this.method_23321() + (double)dz1;
        class_243 newPos = new class_243(newX, this.method_23318() + 0.5, newZ);
        class_2338 b0 = class_2338.method_49638((class_2374)newPos);
        class_7 type = class_14.method_57625((class_1308)this, (class_2338)b0.method_25503());
        if (type == class_7.field_12) {
            return newPos;
        }
        return super.method_24829(passenger);
    }

    public boolean method_5863() {
        if (this.method_37908().field_9236 && ClientEventHandler.shouldClientBlockPick(this)) {
            return false;
        }
        return super.method_5863();
    }

    public boolean method_5810() {
        return (!this.method_5782() || !this.method_42148()) && super.method_5810();
    }

    public boolean isDogJumping() {
        return this.dogJumping;
    }

    public void setDogJumping(boolean jumping) {
        this.dogJumping = jumping;
    }

    public void setJumpPower(int jumpPowerIn) {
        this.jumpPower = 1.0f;
    }

    public boolean canJump() {
        return true;
    }

    public void method_6091(class_243 positionIn) {
        if (this.isDogResistingPush()) {
            this.mayDogResistPush();
        }
        super.method_6091(positionIn);
        if (this.isDogFlying()) {
            class_243 moveVec = this.method_18798();
            double down = moveVec.field_1351;
            double gravity = -0.112102;
            class_1324 attrib = this.method_5996(class_5134.field_49078);
            if (attrib != null) {
                gravity = -attrib.method_6194();
            }
            down = down < 0.0 ? Math.min(down * 0.7, gravity) : (down *= 0.7);
            this.method_18800(moveVec.field_1352 * 0.67, down, moveVec.field_1350 * 0.67);
        }
        this.addMovementStat(this.method_23317() - this.field_6014, this.method_23318() - this.field_6036, this.method_23321() - this.field_5969);
    }

    private void mayDogResistPush() {
        double moveZ;
        if (!this.canDogResistPush()) {
            return;
        }
        double max_XZ_push_len = this.getDogPushResistXZCap();
        class_243 move = this.method_18798();
        double moveX = move.method_10216();
        double moveXZ_lSqr = moveX * moveX + (moveZ = move.method_10215()) * moveZ;
        if (moveXZ_lSqr <= max_XZ_push_len * max_XZ_push_len) {
            return;
        }
        double moveXZ_l = Math.sqrt(moveXZ_lSqr);
        moveX = moveX / moveXZ_l * max_XZ_push_len;
        moveZ = moveZ / moveXZ_l * max_XZ_push_len;
        this.method_18799(new class_243(moveX, move.method_10214(), moveZ));
    }

    public boolean canDogResistPush() {
        if (!this.method_24828()) {
            return false;
        }
        if (!this.isDoingFine()) {
            return false;
        }
        if (this.isDogCurious()) {
            return false;
        }
        if (this.method_5782()) {
            return false;
        }
        return !this.method_6150();
    }

    private void mayFloatDogInLava() {
        if (!this.method_5771()) {
            return;
        }
        class_3726 collisioncontext = class_3726.method_16195((class_1297)this);
        if (collisioncontext.method_16192(class_2404.field_24412, this.method_24515(), true) && !this.method_37908().method_8316(this.method_24515().method_10084()).method_15767(class_3486.field_15518)) {
            this.method_24830(true);
        } else {
            this.method_18799(this.method_18798().method_1031(0.0, 0.085, 0.0));
        }
    }

    protected float method_49484() {
        return this.isDogFlying() ? 0.49f : super.method_49484();
    }

    public boolean canDogFly() {
        return this.alterationProps.canFly() && this.alterationProps.willFly();
    }

    protected void method_49481(class_1657 rider, class_243 rideVec) {
        if (this.isDefeated()) {
            return;
        }
        this.method_36456(rider.method_36454());
        this.field_5982 = this.method_36454();
        this.method_36457(rider.method_36455() * 0.5f);
        this.method_5710(this.method_36454(), this.method_36455());
        this.field_6241 = this.field_6283 = this.method_36454();
        this.checkAndJumpWhenBeingRidden((class_1309)rider);
        if (this.method_6101()) {
            this.field_6017 = 0.0;
        }
        this.addMovementStat(this.method_23317() - this.field_6014, this.method_23318() - this.field_6036, this.method_23321() - this.field_5969);
    }

    protected class_1330 method_5963() {
        return new DogBodyRotationControl(this);
    }

    private void checkAndJumpWhenBeingRidden(class_1309 rider) {
        float forward = rider.field_6250;
        if (this.jumpPower > 0.0f) {
            if (this.method_5799() && this.canSwimUnderwater()) {
                this.doDogRideFloat();
            } else if (!this.isDogJumping() && this.method_24828()) {
                this.doDogRideJump(forward);
            }
        }
        if (this.method_24828()) {
            this.jumpPower = 0.0f;
            this.setDogJumping(false);
        } else {
            this.jumpPower = 0.0f;
        }
    }

    protected class_243 method_49482(class_1657 rider, class_243 rideVec) {
        float straf = rider.field_6212 * 0.7f;
        float forward = rider.field_6250;
        double downward = rideVec.field_1351;
        if (forward > 0.0f && !this.isDogRidingConstraintToGround()) {
            float l = forward;
            downward = -l * class_3532.method_15374((float)(rider.method_36455() * ((float)Math.PI / 180)));
            forward = l * class_3532.method_15362((float)(rider.method_36455() * ((float)Math.PI / 180)));
        }
        if (forward <= 0.0f) {
            forward *= 0.5f;
        }
        return new class_243((double)straf, downward, (double)forward);
    }

    protected boolean isDogRidingConstraintToGround() {
        if (this.method_5799() && this.canSwimUnderwater()) {
            return false;
        }
        return !this.canDogFly();
    }

    protected float method_49485(class_1657 rider) {
        return (float)this.method_5996(class_5134.field_23719).method_6194() * 0.5f;
    }

    private void doDogRideFloat() {
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352, 0.1, vec3d.field_1350);
        this.jumpPower = 0.0f;
    }

    private void doDogRideJump(double forward) {
        double jumpValue = this.method_5996(DoggyAttributes.JUMP_POWER.holder()).method_6194() * (double)this.method_23313() * (double)this.jumpPower;
        if (this.method_6059(class_1294.field_5913)) {
            jumpValue += (double)((float)(this.method_6112(class_1294.field_5913).method_5578() + 1) * 0.1f);
        }
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352, jumpValue, vec3d.field_1350);
        this.setDogJumping(true);
        this.field_6007 = true;
        if (forward > 0.0) {
            float amount = 0.4f;
            float compX = class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)));
            float compZ = class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)));
            this.method_18799(this.method_18798().method_1031((double)(-0.4f * compX * this.jumpPower), 0.0, (double)(0.4f * compZ * this.jumpPower)));
        }
        this.jumpPower = 0.0f;
    }

    public void addMovementStat(double xD, double yD, double zD) {
        int j;
        if (this.method_5782()) {
            j = Math.round(class_3532.method_15355((float)((float)(xD * xD + zD * zD))) * 100.0f);
            this.statsTracker.increaseDistanceRidden(j);
        }
        if (!this.method_5765()) {
            if (this.method_5777(class_3486.field_15517)) {
                j = Math.round(class_3532.method_15355((float)((float)(xD * xD + yD * yD + zD * zD))) * 100.0f);
                if (j > 0) {
                    this.statsTracker.increaseDistanceOnWater(j);
                }
            } else if (this.method_5799()) {
                int k = Math.round(class_3532.method_15355((float)((float)(xD * xD + zD * zD))) * 100.0f);
                if (k > 0) {
                    this.statsTracker.increaseDistanceInWater(k);
                }
            } else if (this.method_24828()) {
                int l = Math.round(class_3532.method_15355((float)((float)(xD * xD + zD * zD))) * 100.0f);
                if (l > 0) {
                    if (this.method_5624()) {
                        this.statsTracker.increaseDistanceSprint(l);
                    } else if (this.method_18276()) {
                        this.statsTracker.increaseDistanceSneaking(l);
                    } else {
                        this.statsTracker.increaseDistanceWalk(l);
                    }
                }
            } else {
                int n = Math.round(class_3532.method_15355((float)((float)(xD * xD + zD * zD))) * 100.0f);
            }
        }
    }

    public boolean method_5675() {
        if (this.method_5753()) {
            return false;
        }
        if (this.alterationProps.resistWaterPush()) {
            return false;
        }
        if (this.isDogForcePushAvoid()) {
            return false;
        }
        if (this.getDefaultNavigationIfActive().map(DogPathNavigation::shouldDogBlockFluidPush).orElse(false).booleanValue()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            DogInteractionResult result = alter.canResistPushFromFluidType();
            if (!result.shouldSwing()) continue;
            return false;
        }
        return super.method_5675();
    }

    public class_5250 getTranslationKey(Function<DogGender, String> function) {
        return class_2561.method_43471((String)((String)function.apply((Object)((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DISABLE_GENDER) == false ? this.getGender() : DogGender.UNISEX))));
    }

    @Override
    public boolean isLying() {
        boolean ownerSleeping;
        class_1309 owner = this.method_35057();
        boolean bl = ownerSleeping = owner != null && owner.method_6113();
        if (ownerSleeping) {
            return true;
        }
        if (this.isDefeated()) {
            boolean onBed;
            class_2680 blockBelow = this.method_37908().method_8320(this.method_24515());
            boolean bl2 = onBed = blockBelow.method_27852((class_2248)DoggyBlocks.DOG_BED.get()) || blockBelow.method_26164(class_3481.field_16443);
            if (onBed) {
                return true;
            }
        }
        return false;
    }

    public void method_6179(boolean sit) {
        if (!this.method_37908().field_9236 && this.animAction == null) {
            boolean sit0 = this.method_6172();
            if (sit0 != sit) {
                DogAnimation anim;
                DogAnimation dogAnimation = anim = sit ? this.getSitAnim() : this.getStandAnim();
                if (!sit0 && this.isLying()) {
                    anim = DogAnimation.NONE;
                }
                if (anim != DogAnimation.NONE) {
                    this.setAnim(anim);
                }
            }
            this.sitAnim = DogAnimation.SIT_DOWN;
            this.standAnim = DogAnimation.STAND_QUICK;
        }
        super.method_6179(sit);
    }

    public void setSitAnim(DogAnimation anim) {
        if (anim == null) {
            this.sitAnim = DogAnimation.SIT_DOWN;
            return;
        }
        this.sitAnim = anim;
    }

    public DogAnimation getStandAnim() {
        return this.standAnim;
    }

    public void setStandAnim(DogAnimation anim) {
        if (anim == null) {
            this.standAnim = DogAnimation.STAND_QUICK;
            return;
        }
        this.standAnim = anim;
    }

    public DogAnimation getSitAnim() {
        return this.sitAnim;
    }

    public void method_24346(boolean val) {
        super.method_24346(val);
        this.mayDogCorrectSittingPose(val);
    }

    private void mayDogCorrectSittingPose(boolean sit_ordered) {
        if (this.method_37908().field_9236) {
            return;
        }
        if (sit_ordered) {
            return;
        }
        if (this.dogAi == null) {
            return;
        }
        if (this.dogAi.isSitGoalRunning()) {
            return;
        }
        this.method_6179(false);
    }

    public void setChopinTailFor(int ticks) {
        this.tickChopinTail = ticks;
    }

    public boolean isChopinTail() {
        return this.tickChopinTail > 0;
    }

    @Override
    public List<IDogFoodHandler> getFoodHandlers() {
        return this.foodHandlers;
    }

    @Override
    public void resetNavigation() {
        this.setNavigation(this.defaultNavigation);
    }

    @Override
    public void resetMoveControl() {
        this.setMoveControl(this.defaultMoveControl);
    }

    @Override
    public void setNavigation(class_1408 p) {
        super.setNavigation(p);
        this.switchNavCooldown = 5;
        if (p instanceof IDogNavLock) {
            IDogNavLock lock = (IDogNavLock)p;
            this.currentNavigation = p;
            this.navigationLock = lock;
        }
    }

    @Override
    public DogPathNavigation getDefaultNavigation() {
        return this.defaultNavigation;
    }

    @Override
    public DogMoveControl getDefaultMoveControl() {
        return this.defaultMoveControl;
    }

    public boolean isDefaultNavigation() {
        return this.defaultNavigation == this.method_5942();
    }

    public Optional<DogPathNavigation> getDefaultNavigationIfActive() {
        if (this.isDefaultNavigation()) {
            return Optional.of(this.defaultNavigation);
        }
        return Optional.empty();
    }

    protected DogPathNavigation createNavigation(class_1937 p_21480_) {
        DogPathNavigation dogPathNav = new DogPathNavigation(this, p_21480_);
        this.currentNavigation = dogPathNav;
        this.navigationLock = dogPathNav;
        this.navigationLock.lockDogNavigation();
        return dogPathNav;
    }

    public void setDogSitOverridePos(@Nonnull class_2338 pos) {
        this.lastSitPos = Optional.of(pos);
        this.lastSitPosSaveTimestamp = this.field_6012;
    }

    public void clearDogSitOverridePos() {
        this.lastSitPos = Optional.empty();
    }

    public Optional<class_2338> getDogSitOverridePos() {
        return this.lastSitPos;
    }

    public int getDogSitOverridePosTimestamp() {
        return this.lastSitPosSaveTimestamp;
    }

    public float method_5944(class_7 type) {
        switch (type) {
            default: {
                break;
            }
            case field_18: 
            case field_4: {
                if (!this.shouldDogOmitWaterPathWeight()) break;
                return 0.0f;
            }
            case field_14: 
            case field_3: 
            case field_9: {
                if (!this.method_5753()) break;
                return 0.0f;
            }
            case field_23: {
                if (!this.canDogPassGate()) break;
                return 8.0f;
            }
            case field_36432: 
            case field_33534: {
                return -1.0f;
            }
            case field_47413: 
            case field_19: {
                return -1.0f;
            }
        }
        return super.method_5944(type);
    }

    private boolean shouldDogOmitWaterPathWeight() {
        if (this.isDogFollowingSomeone()) {
            return true;
        }
        if (!this.method_5799()) {
            return false;
        }
        if (this.alterationProps.canBreatheUnderwater()) {
            return true;
        }
        return this.canSwimUnderwater() && !this.isLowAirSupply();
    }

    public boolean shouldDogBlockFloat() {
        return this.method_5753() && this.method_5771();
    }

    public boolean isDogFollowingSomeone() {
        return this.isDogFollowingSomeone;
    }

    public void setDogFollowingSomeone(boolean val) {
        this.isDogFollowingSomeone = val;
    }

    public void setDogResistingPush(boolean val) {
        this.isDogResistingPush = val;
    }

    public boolean isDogResistingPush() {
        return this.isDogResistingPush;
    }

    public double getDogPushResistXZCap() {
        return 5.0E-4;
    }

    public List<IDogAlteration> getAlterations() {
        return this.alterations;
    }

    @Override
    public boolean canSwimUnderwater() {
        return this.alterationProps.canSwimUnderwater();
    }

    @Override
    public boolean canDogWearArmor() {
        return this.alterationProps.canWearArmor();
    }

    @Override
    public boolean canDogUseTools() {
        return this.alterationProps.canUseTools();
    }

    @Override
    public DogArmorItemHandlerImpl dogArmors() {
        return this.dogArmors;
    }

    @Override
    public class_1799 wolfArmor() {
        class_1799 stack = this.method_6118(class_1304.field_48824);
        if (stack == null || !stack.method_31574(class_1802.field_47831)) {
            return class_1799.field_8037;
        }
        return stack;
    }

    public void setWolfArmor(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            this.method_5673(class_1304.field_48824, class_1799.field_8037);
        }
        if (!stack.method_31574(class_1802.field_47831)) {
            return;
        }
        this.method_5673(class_1304.field_48824, stack);
    }

    public boolean hasWolfArmor() {
        return !this.wolfArmor().method_7960();
    }

    public Iterable<class_1799> getHandSlots() {
        if (!this.canDogUseTools() || this.mouthStack == null) {
            return List.of();
        }
        return List.of(this.mouthStack);
    }

    public Iterable<class_1799> getArmorSlots() {
        if (!this.canDogWearArmor()) {
            return List.of();
        }
        return this.dogArmors.armors();
    }

    public Iterable<class_1799> getArmorAndBodyArmorSlots() {
        return this.getArmorSlots();
    }

    public class_1799 method_6118(class_1304 slot) {
        boolean getMouth;
        boolean getArmor;
        class_1304.class_1305 type = slot.method_5925();
        boolean bl = getArmor = type == class_1304.class_1305.field_6178 && (this.alterationProps.canWearArmor() || this.method_37908().field_9236);
        if (getArmor) {
            return this.dogArmors.getArmorFromSlot(slot);
        }
        boolean bl2 = getMouth = slot == class_1304.field_6173 && (this.alterationProps.canUseTools() || this.method_37908().field_9236) && this.mouthStack != null;
        if (getMouth) {
            return this.mouthStack;
        }
        if (slot == class_1304.field_48824 && this.wolfArmorStack != null && this.wolfArmorStack.method_31574(class_1802.field_47831)) {
            return this.wolfArmorStack;
        }
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
        if (this.trySetDogArmorSlot(slot, stack)) {
            return;
        }
        if (this.trySetDogToolSlot(slot, stack)) {
            return;
        }
        if (this.trySetWolfArmor(slot, stack)) {
            return;
        }
    }

    private boolean trySetDogArmorSlot(class_1304 slot, class_1799 stack) {
        if (slot.method_5925() != class_1304.class_1305.field_6178) {
            return false;
        }
        if (!this.method_37908().field_9236 && !this.canDogWearArmor()) {
            return false;
        }
        class_1799 oldStack = this.dogArmors.getArmorFromSlot(slot);
        this.dogArmors.setArmorInSlot(stack, slot);
        this.method_6116(slot, oldStack, stack);
        return true;
    }

    private boolean trySetDogToolSlot(class_1304 slot, class_1799 stack) {
        if (slot != class_1304.field_6173) {
            return false;
        }
        if (!this.method_37908().field_9236 && !this.canDogUseTools()) {
            return false;
        }
        class_1799 oldStack = this.mouthStack == null ? class_1799.field_8037 : this.mouthStack;
        this.mouthStack = stack;
        this.method_6116(slot, oldStack, stack);
        return true;
    }

    private boolean trySetWolfArmor(class_1304 slot, class_1799 stack) {
        boolean is_not_empty_not_wolf_armor;
        if (slot != class_1304.field_48824) {
            return false;
        }
        boolean bl = is_not_empty_not_wolf_armor = stack != null && !stack.method_7960() && !stack.method_31574(class_1802.field_47831);
        if (is_not_empty_not_wolf_armor) {
            return false;
        }
        if (stack == null) {
            stack = class_1799.field_8037;
        }
        class_1799 oldStack = this.wolfArmorStack == null ? class_1799.field_8037 : this.wolfArmorStack;
        this.wolfArmorStack = stack;
        this.method_6116(slot, oldStack, stack);
        return true;
    }

    public void method_6116(class_1304 slot, class_1799 oldStack, class_1799 newStack) {
        boolean is_slot_should_be_handled;
        class_1304.class_1305 type = slot.method_5925();
        boolean bl = is_slot_should_be_handled = type == class_1304.class_1305.field_6178 || type == class_1304.class_1305.field_48825;
        if (!is_slot_should_be_handled) {
            return;
        }
        super.method_6116(slot, oldStack, newStack);
    }

    private boolean checkEligibleArmorItemAndAvailableSlot(class_1799 stack) {
        if (!this.canDogWearArmor()) {
            return false;
        }
        if (!ItemUtil_1_21_5.isHumanoidArmor(stack)) {
            return false;
        }
        class_1304 slot = this.method_32326(stack);
        if (slot.method_5925() != class_1304.class_1305.field_6178) {
            return false;
        }
        class_1799 current = this.method_6118(slot);
        return current == null || current.method_7960();
    }

    protected void method_16080(class_3218 p_348524_, class_1282 source) {
        this.method_16078(p_348524_);
    }

    public boolean isLowAirSupply() {
        return (double)this.method_5669() < (double)this.method_5748() * 0.3;
    }

    @Override
    public boolean isDogLowHealth() {
        return this.method_6032() < 6.0f;
    }

    @Override
    public void setDogSwimming(boolean s) {
        this.isDogSwimming = s;
    }

    public boolean isDogSwimming() {
        return this.isDogSwimming;
    }

    public void setDogForcePushAvoid(boolean val) {
        this.setDogFlag(524288, val);
    }

    public boolean isDogForcePushAvoid() {
        return this.getDogFlag(524288);
    }

    public boolean isDogCurious() {
        return this.isDogCurious;
    }

    public void setDogCurious(boolean val) {
        this.isDogCurious = val;
    }

    @Override
    public void setDogFlying(boolean s) {
        this.setDogFlag(1024, s);
    }

    @Override
    public boolean isDogFlying() {
        return this.getDogFlag(1024);
    }

    public boolean isLowHunger() {
        return this.hungerManager.isLowHunger();
    }

    protected void method_20417() {
        boolean incapBlockedMove = this.isDefeated() && !this.incapacitatedMananger.canMove();
        boolean animBlockedMove = this.animAction != null;
        boolean animBlockedLook = this.animAction != null;
        boolean notControlledByPlayer = !(this.method_5642() instanceof class_3222);
        boolean notRidingBoat = !(this.method_5854() instanceof class_1690);
        this.dogAi.setLockedFlag(class_1352.class_4134.field_18405, notControlledByPlayer && !incapBlockedMove && !animBlockedMove);
        this.dogAi.setLockedFlag(class_1352.class_4134.field_18407, notControlledByPlayer && notRidingBoat);
        this.dogAi.setLockedFlag(class_1352.class_4134.field_18406, notControlledByPlayer && !animBlockedLook);
    }

    protected void method_6087(class_1297 pushTarget) {
        if (this.pettingManager.checkPush(pushTarget)) {
            return;
        }
        if (this.dogPushAvoidManager.shouldBlockPush(pushTarget)) {
            return;
        }
        if (DogSleepOnManager.shouldBlockPush(this)) {
            return;
        }
        if (this.isDefeated() && this.incapacitatedMananger.shouldApplyCustomPushBehaviour(pushTarget)) {
            return;
        }
        if (pushTarget.method_5854() == this || this.method_5854() == pushTarget) {
            return;
        }
        if (this.method_5782() && !this.method_42148()) {
            this.pushDogAsVehicle(pushTarget);
        } else {
            super.method_6087(pushTarget);
        }
    }

    public void method_5697(class_1297 source) {
        if (source.method_5854() == this || this.method_5854() == source) {
            return;
        }
        if (this.pettingManager.checkPush(source)) {
            return;
        }
        if (this.isDefeated() && this.incapacitatedMananger.shouldApplyCustomPushBehaviour(source)) {
            this.incapacitatedMananger.customBeingPushed(source, this::calcDogPushVec);
            return;
        }
        if (DogSleepOnManager.shouldBlockPush(this)) {
            return;
        }
        if (this.method_5782() && !this.method_42148()) {
            this.pushDogAsVehicle(source);
        } else {
            if (this.isDogCurious()) {
                this.setDogCurious(false);
            }
            super.method_5697(source);
        }
    }

    private void pushDogAsVehicle(class_1297 source) {
        Optional<class_243> push_vec_optional = this.calcDogPushVec(source);
        if (!push_vec_optional.isPresent()) {
            return;
        }
        class_243 push_vec = push_vec_optional.get();
        if (this.method_5810()) {
            this.method_5762(-push_vec.method_10216(), 0.0, -push_vec.method_10215());
        }
        if (source.method_5810()) {
            source.method_5762(push_vec.method_10216(), 0.0, push_vec.method_10215());
        }
    }

    private Optional<class_243> calcDogPushVec(class_1297 source) {
        double dz_vec;
        if (this.method_5794(source)) {
            return Optional.empty();
        }
        if (source.field_5960 || this.field_5960) {
            return Optional.empty();
        }
        double dx_vec = source.method_23317() - this.method_23317();
        double max_magnitude = class_3532.method_15391((double)dx_vec, (double)(dz_vec = source.method_23321() - this.method_23321()));
        if (max_magnitude < 0.01) {
            return Optional.empty();
        }
        max_magnitude = Math.sqrt(max_magnitude);
        dx_vec /= max_magnitude;
        dz_vec /= max_magnitude;
        double max_magnitude_inv = 1.0 / max_magnitude;
        if (max_magnitude_inv > 1.0) {
            max_magnitude_inv = 1.0;
        }
        dx_vec *= max_magnitude_inv;
        dz_vec *= max_magnitude_inv;
        return Optional.of(new class_243(dx_vec *= 0.05, 0.0, dz_vec *= 0.05));
    }

    public boolean method_30949(class_1297 otherEntity) {
        if (this.dogPushAvoidManager.shouldBlockPush(otherEntity)) {
            return false;
        }
        if (DogSleepOnManager.shouldBlockPush(this)) {
            return false;
        }
        if (this.isDefeated() && this.incapacitatedMananger.shouldApplyCustomPushBehaviour(otherEntity)) {
            return false;
        }
        if (otherEntity.method_5854() == this || this.method_5854() == otherEntity) {
            return false;
        }
        return super.method_30949(otherEntity);
    }

    public class_7 getBlockPathTypeViaAlterations(class_2338 pos) {
        class_7 blockType = class_14.method_57625((class_1308)this, (class_2338)pos.method_25503());
        blockType = this.inferType(blockType, InferTypeContext.getDefault());
        return blockType;
    }

    public class_7 inferType(class_7 type, InferTypeContext context) {
        if (this.method_5753()) {
            if (type == class_7.field_9) {
                return class_7.field_12;
            }
            if (type == class_7.field_14) {
                return class_7.field_22;
            }
        }
        if (this.canSwimUnderwater() && this.alterationProps.canBreatheUnderwater() && type == class_7.field_18) {
            return class_7.field_12;
        }
        for (IDogAlteration alt : this.alterations) {
            InteractionResultHolder<class_7> result = alt.inferType(this, type, context);
            if (!result.getResult().shouldSwing()) continue;
            type = result.getObject();
            break;
        }
        return type;
    }

    public boolean canDogPassGate() {
        for (IDogAlteration alt : this.alterations) {
            if (!alt.canDogPassGate(this).shouldSwing()) continue;
            return true;
        }
        return false;
    }

    public float getTimeDogIsShaking() {
        return this.timeWolfIsShaking;
    }

    public float getUrgentSpeedModifier() {
        if (this.method_45325((class_6880<class_1320>)class_5134.field_23719) <= 0.3) {
            return 1.5f;
        }
        return 1.0f;
    }

    public StatsTracker getStatTracker() {
        return this.statsTracker;
    }

    public DogGroupsManager getGroups() {
        return this.dogGroupsManager;
    }

    public void setAnim(DogAnimation animation) {
        this.field_6011.method_12778(ANIMATION, (Object)animation.getId());
    }

    @Override
    public DogAnimation getAnim() {
        return DogAnimation.byId((Integer)this.field_6011.method_12789(ANIMATION));
    }

    public DogAnimationManager.DogAnimDebugState getDogAnimDebugState() {
        return this.dogFabricHelper.getDogAnimDebugState();
    }

    public void setDogAnimDebugState(DogAnimationManager.DogAnimDebugState state) {
        if (state.isNone()) {
            state = DogAnimationManager.DogAnimDebugState.NONE;
        }
        this.dogFabricHelper.setDogAnimDebugState(state);
    }

    public boolean isDogInAnimDebug() {
        return !this.getDogAnimDebugState().isNone();
    }

    public void setAnimSyncTime(int val) {
        this.field_6011.method_12778(ANIM_SYNC_TIME, (Object)val);
    }

    public int getAnimSyncTime() {
        return (Integer)this.field_6011.method_12789(ANIM_SYNC_TIME);
    }

    public void triggerAnimationAction(AnimationAction action) {
        if (this.animAction != null) {
            this.animAction.stop();
        }
        this.animAction = action;
        if (this.animAction != null) {
            this.method_5942().method_6340();
            this.method_20417();
            this.forceStopAllGoalWithFlag(class_1352.class_4134.field_18405);
            this.forceStopAllGoalWithFlag(class_1352.class_4134.field_18406);
            this.animAction.start();
        }
    }

    private void forceStopAllGoalWithFlag(class_1352.class_4134 flag) {
        this.dogAi.forceStopAllGoalWithFlag(flag);
    }

    protected void tickAnimAction() {
        if (this.animAction == null) {
            return;
        }
        switch (this.animAction.getState()) {
            case FINISHED: {
                this.triggerAnimationAction(null);
                break;
            }
            default: {
                this.animAction.tick();
            }
        }
    }

    public DogPose getDogPose() {
        return this.activePose;
    }

    private void setDogPose(DogPose pose) {
        this.activePose = pose;
    }

    public void updateDogPose() {
        if (this.isDefeated() && !this.incapacitatedMananger.canMove()) {
            this.setDogPose(this.incapacitatedMananger.getPose());
            return;
        }
        if (this.isInDrunkPose()) {
            this.setDogPose(DogPose.REST_BELLY);
            return;
        }
        if (this.method_6172()) {
            RestingState restState = this.getDogRestingState();
            if (restState == RestingState.LYING) {
                this.setDogPose(DogPose.REST);
                return;
            }
            if (restState == RestingState.BELLY) {
                this.setDogPose(DogPose.REST_BELLY);
                return;
            }
            this.setDogPose(this.isLying() ? DogPose.LYING_2 : DogPose.SIT);
            return;
        }
        if (this.isDogFlying() && !this.forcedWhenNoneAnim()) {
            this.setDogPose(DogPose.FLYING);
            return;
        }
        this.setDogPose(DogPose.STAND);
    }

    @Override
    public float getClientAnimatedYBodyRotInRadians() {
        if (!this.method_37908().field_9236) {
            return this.field_6283 * ((float)Math.PI / 180);
        }
        return this.field_6283 * ((float)Math.PI / 180) + ClientEventHandler.getAnimatedYRot(this);
    }

    public DogSkin getClientSkin() {
        if (((Boolean)ConfigHandler.CLIENT.ALWAYS_RENDER_CLASSICAL.get()).booleanValue()) {
            return DogSkin.CLASSICAL;
        }
        this.clientSkin = DogSkinHolder.update(this, this.clientSkin);
        return this.clientSkin.getOrElse(DogSkin.CLASSICAL);
    }

    @Override
    public boolean isDogVariantRenderEffective() {
        DogSkin skin = this.getClientSkin();
        return skin == null || !skin.isCustom();
    }

    public void setClientSkinHolder(DogSkinHolder skin) {
        if (skin == null) {
            skin = DogSkinHolder.getNone();
        }
        this.clientSkin = skin;
    }

    public DogSkinHolder getClientSkinHolder() {
        return this.clientSkin;
    }

    public List<AccessoryInstance> getClientSortedAccessories() {
        return this.clientAccessories;
    }

    public Optional<class_1799> getMouthItemForRender() {
        if (this.hasBone()) {
            class_1799 customStack;
            class_1799 renderStack = this.getBoneVariant();
            IThrowableItem throwableItem = this.getThrowableItem();
            if (throwableItem != null && (customStack = throwableItem.getCustomRenderStack(renderStack)) != null) {
                renderStack = customStack;
            }
            return Optional.of(renderStack);
        }
        class_1799 stack = this.method_6047();
        if (stack != null && !stack.method_7960()) {
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public DogFabricHelper getDogFabricHelper() {
        return this.dogFabricHelper;
    }

    public void onFabricDataUpdated(SyncTypes.SyncType<?> type) {
        if (type == SyncTypes.ARTIFACTS) {
            this.refreshAlterations();
        }
        if (type == SyncTypes.DOG_PETTING_STATE && this.method_37908().field_9236) {
            DTNClientPettingManager.get().onPettingUpdate(this, this.getPettingState());
        }
        if (type == SyncTypes.DOG_VARIANT) {
            this.refreshAlterations();
        }
        if (type == SyncTypes.DOG_LEVEL) {
            this.spendablePoints.markForRefresh();
            float h = this.getDogLevel().getMaxHealth();
            if (h != this.method_6063()) {
                this.method_5996(class_5134.field_23716).method_6192((double)h);
            }
        }
        if (type == SyncTypes.DOG_SIZE) {
            this.method_18382();
        }
        if (this.method_37908().field_9236 && type == SyncTypes.DOG_SKIN) {
            this.clientSkin = DogSkinHolder.pendingResolve();
        }
        if (!this.method_37908().field_9236 && type == SyncTypes.DOG_MODE) {
            DogMode mode = this.getMode();
            this.incapacitatedMananger.onModeUpdate(mode);
            if (mode == DogMode.INJURED) {
                this.hungerManager.onBeingIncapacitated();
            }
            this.updateWanderState(mode);
        }
        if (type == SyncTypes.DOG_ANIM_DEBUG_STATE) {
            DogAnimationManager.DogAnimDebugState debug_state = this.getDogAnimDebugState();
            if (!debug_state.isNone() && !this.method_37908().field_9236) {
                this.dogAi.forceStopAllGoal();
            }
            this.animationManager.onDebugUpdate(debug_state);
        }
        if (type == SyncTypes.DOG_SLEEP_ON_STATE) {
            DogSleepOnManager.onDogSleepOnDataUpdated(this, this.getSleepOnState());
        }
    }

    public boolean isAddedToWorld() {
        return this.isAddedToWorld;
    }

    public void setAddedToWorld(boolean val) {
        this.isAddedToWorld = val;
    }

    public Optional<class_6862<class_3611>> getMaxFluidHeight() {
        return this.field_5964.object2DoubleEntrySet().stream().max(Comparator.comparingDouble(Object2DoubleMap.Entry::getDoubleValue)).map(Map.Entry::getKey);
    }

    @Nullable
    public class_1297 method_5731(class_5454 transition) {
        boolean is_change_dim;
        boolean bl = is_change_dim = transition.comp_2820() != this.method_37908();
        if (is_change_dim) {
            return this.changeDimension(transition);
        }
        return super.method_5731(transition);
    }

    public boolean method_64397(class_3218 server_level, class_1282 source, float amount) {
        return this.hurtDog(Optional.of(server_level), source, Optional.of(Float.valueOf(amount)), (source_1, amount_1) -> super.method_64397(server_level, source_1, ((Float)amount_1.get()).floatValue()));
    }

    public boolean method_5643(class_1282 source) {
        return this.hurtDog(Optional.empty(), source, Optional.empty(), (source_1, amount_1) -> super.method_5643(source_1));
    }

    @Override
    public UUID getOwnerUUID() {
        class_10583 owner_ref = this.method_66287();
        if (owner_ref == null) {
            return null;
        }
        return owner_ref.method_66263();
    }

    public void setOwnerUUID_1_21_3_Under_SuperCall(UUID uuid) {
        class_10583 owner_ref = uuid == null ? null : new class_10583(uuid);
        super.method_66288(owner_ref);
    }

    public void method_66288(@Nullable class_10583<class_1309> owner_ref) {
        UUID uuid = owner_ref != null ? owner_ref.method_66263() : null;
        this.setOwnerUUID(uuid);
    }

    public void method_6174(@Nullable class_1309 entity) {
        UUID uuid = entity != null ? entity.method_5667() : null;
        this.setOwnerUUID(uuid);
    }

    public static enum LowHealthStrategy {
        NONE(0),
        RUN_AWAY(1),
        STICK_TO_OWNER(2);

        public static final LowHealthStrategy[] VALUES;
        private final byte id;

        private LowHealthStrategy(int id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }

        public String getUnlocalisedTitle() {
            return "dog.low_health_strategy." + this.getId();
        }

        public String getUnlocalisedInfo() {
            return "dog.low_health_strategy." + this.getId() + ".help";
        }

        public static LowHealthStrategy fromId(int id) {
            if (0 > id || id > 2) {
                return NONE;
            }
            return VALUES[id];
        }

        public LowHealthStrategy prev() {
            int i = this.getId() - 1;
            if (i < 0) {
                i = VALUES.length - 1;
            }
            return VALUES[i];
        }

        public LowHealthStrategy next() {
            int i = this.getId() + 1;
            if (i >= VALUES.length) {
                i = 0;
            }
            return VALUES[i];
        }

        static {
            VALUES = (LowHealthStrategy[])Arrays.stream(LowHealthStrategy.values()).sorted(Comparator.comparingInt(LowHealthStrategy::getId)).toArray(LowHealthStrategy[]::new);
        }
    }

    public static enum CombatReturnStrategy {
        STANDARD(0),
        FAR(1),
        NONE(2);

        public static final CombatReturnStrategy[] VALUES;
        private final byte id;

        private CombatReturnStrategy(int id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }

        public String getUnlocalisedTitle() {
            return "dog.combat_return_strategy." + this.getId();
        }

        public String getUnlocalisedInfo() {
            return "dog.combat_return_strategy." + this.getId() + ".help";
        }

        public static CombatReturnStrategy fromId(int id) {
            if (0 > id || id > 2) {
                return NONE;
            }
            return VALUES[id];
        }

        public CombatReturnStrategy prev() {
            int i = this.getId() - 1;
            if (i < 0) {
                i = VALUES.length - 1;
            }
            return VALUES[i];
        }

        public CombatReturnStrategy next() {
            int i = this.getId() + 1;
            if (i >= VALUES.length) {
                i = 0;
            }
            return VALUES[i];
        }

        static {
            VALUES = (CombatReturnStrategy[])Arrays.stream(CombatReturnStrategy.values()).sorted(Comparator.comparingInt(CombatReturnStrategy::getId)).toArray(CombatReturnStrategy[]::new);
        }
    }

    public static enum RestingState {
        NONE,
        LYING,
        BELLY;

    }
}

