/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.DoggyEntityTypes;
import doggytalents.common.backward_imitate.EntityUtil_1_21_5;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class DogAllyCheck {
    private static final ThreadLocal<Boolean> isMixinCalling = ThreadLocal.withInitial(() -> false);

    public static boolean isAlliedToDog(Dog dog, class_1297 entity) {
        return DogAllyCheck.isAlliedToDog(dog, entity, dog.method_35057());
    }

    public static boolean isAlliedToDog(Dog dog, class_1297 entity, @Nullable class_1309 owner) {
        boolean ally_check;
        if (dog == null || entity == null) {
            return false;
        }
        if (entity == dog) {
            return true;
        }
        UUID owner_uuid = dog.getOwnerUUID();
        if (owner_uuid == null) {
            return false;
        }
        boolean bl = ally_check = owner != null ? DogAllyCheck.checkOwnerAvailable(dog, entity, owner_uuid, owner) : DogAllyCheck.checkOwnerNotAvailable(dog, entity, owner_uuid);
        if (ally_check) {
            return true;
        }
        boolean all_player_ally_to_dog = DogAllyCheck.checkAllPlayerCannotHitDog(dog, entity);
        return all_player_ally_to_dog;
    }

    private static boolean checkOwnerAvailable(Dog dog, class_1297 entity, UUID owner_uuid, class_1309 owner) {
        class_1321 other_dog;
        if (entity == owner) {
            return true;
        }
        if (entity.method_5864() != DoggyEntityTypes.DOG.get() && owner.method_5722(entity)) {
            return true;
        }
        if (entity instanceof class_1321 && EntityUtil_1_21_5.getOwnerUUID(other_dog = (class_1321)entity) != null) {
            if (DogAllyCheck.checkSameOwnerUUIDWithDog(owner_uuid, other_dog)) {
                return true;
            }
            class_1309 owner_other = other_dog.method_35057();
            if (owner_other != null) {
                return owner.method_5722((class_1297)owner_other);
            }
            if (other_dog instanceof Dog) {
                Dog other_dog_actual = (Dog)other_dog;
                return DogAllyCheck.checkSameTeamWithOfflineOwner(other_dog_actual, (class_1297)owner);
            }
            Optional<class_270> other_team = DogAllyCheck.findOwnerTeam(other_dog);
            if (other_team.isPresent()) {
                return owner.method_5645(other_team.get());
            }
            return false;
        }
        return false;
    }

    private static boolean checkOwnerNotAvailable(Dog dog, class_1297 entity, UUID owner_uuid) {
        class_1321 other_dog;
        if (entity instanceof class_1321 && EntityUtil_1_21_5.getOwnerUUID(other_dog = (class_1321)entity) != null) {
            if (DogAllyCheck.checkSameOwnerUUIDWithDog(owner_uuid, other_dog)) {
                return true;
            }
            return DogAllyCheck.checkSameTeamWithOfflineOwnerTamable(dog, other_dog);
        }
        return DogAllyCheck.checkSameTeamWithOfflineOwner(dog, entity);
    }

    private static boolean checkSameTeamWithOfflineOwner(Dog dog, class_1297 entity) {
        return DogAllyCheck.checkSameTeamWithOfflineOwner(dog, (class_270)entity.method_5781());
    }

    private static boolean checkSameTeamWithOfflineOwnerTamable(Dog dog, class_1321 entity) {
        return DogAllyCheck.checkSameTeamWithOfflineOwner(dog, DogAllyCheck.findTamableTeam(entity));
    }

    private static class_270 findTamableTeam(class_1321 other_dog) {
        return DogAllyCheck.findOwnerTeam(other_dog).orElseGet(() -> ((class_1321)other_dog).method_5781());
    }

    private static Optional<class_270> findOwnerTeam(class_1321 other_dog) {
        UUID uuid = EntityUtil_1_21_5.getOwnerUUID(other_dog);
        if (uuid == null) {
            return Optional.empty();
        }
        MinecraftServer server = other_dog.method_37908().method_8503();
        if (server == null) {
            return Optional.empty();
        }
        class_3222 player = server.method_3760().method_14602(uuid);
        if (player == null) {
            return Optional.empty();
        }
        class_2995 scoreboard = server.method_3845();
        class_268 ret = scoreboard.method_1164(player.method_5820());
        return Optional.ofNullable(ret);
    }

    private static boolean checkSameTeamWithOfflineOwner(Dog dog, class_270 other_team) {
        if (other_team == null) {
            return false;
        }
        Optional<class_2561> owner_name_optional = dog.getOwnersName();
        if (!owner_name_optional.isPresent()) {
            return false;
        }
        String owner_name = owner_name_optional.get().getString();
        if (owner_name == null || owner_name.isEmpty()) {
            return false;
        }
        return other_team.method_1204().contains(owner_name);
    }

    private static boolean checkSameOwnerUUIDWithDog(UUID dog_owner_uuid, class_1321 entity) {
        UUID other_owner_uuid = EntityUtil_1_21_5.getOwnerUUID(entity);
        if (other_owner_uuid == null) {
            return false;
        }
        return dog_owner_uuid.equals(other_owner_uuid);
    }

    private static boolean checkAllPlayerCannotHitDog(Dog dog, class_1297 entity) {
        if (!((Boolean)ConfigHandler.SERVER.ALL_PLAYER_CANNOT_ATTACK_DOG.get()).booleanValue()) {
            return false;
        }
        if (entity instanceof class_1657) {
            return true;
        }
        if (entity instanceof class_1321) {
            class_1321 other_dog = (class_1321)entity;
            return EntityUtil_1_21_5.getOwnerUUID(other_dog) != null;
        }
        return false;
    }

    public static boolean onEntityIsAlliedToServer(class_1297 self, class_1297 entity) {
        boolean entity_type_check;
        boolean bl = entity_type_check = self.method_5864() == class_1299.field_6097 && entity.method_5864() == DoggyEntityTypes.DOG.get();
        if (!entity_type_check) {
            return false;
        }
        if (isMixinCalling.get().booleanValue()) {
            return false;
        }
        if (!(entity instanceof Dog)) {
            return false;
        }
        Dog dog = (Dog)entity;
        isMixinCalling.set(true);
        boolean result = DogAllyCheck.isAlliedToDog(dog, self);
        isMixinCalling.set(false);
        return result;
    }
}

