/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.impl.IDogRangedAttackManager;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogAttackManager;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public class DogRangedAttackGoal
extends class_1352 {
    private static final int default_attack_radius = 20;
    private final Dog dog;
    private final int timeOutTick = 40;
    private int waitingTick;
    private class_2338.class_2339 dogPos0;
    private int seeTime = 0;
    private int attackCooldown = 0;
    private int tickTillPathRecalc = 0;

    public DogRangedAttackGoal(Dog dog) {
        this.dog = dog;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 target;
        if (!this.dog.getMode().shouldAttack()) {
            return false;
        }
        if (this.dog.isDogLowHealth() && this.dog.getLowHealthStrategy() == Dog.LowHealthStrategy.RUN_AWAY) {
            return false;
        }
        if (this.dog.field_6017 > 7.0) {
            return false;
        }
        boolean restriction = false;
        if (this.dog.getMode().shouldFollowOwner() && this.dog.getCombatReturnStrategy() != Dog.CombatReturnStrategy.NONE) {
            class_1309 owner = this.dog.method_35057();
            if (owner != null && this.dog.method_5858((class_1297)owner) > this.getMaxDistanceAwayFromOwner()) {
                return false;
            }
        } else {
            restriction = !this.dog.patrolTargetLock();
        }
        if ((target = this.dog.method_5968()) == null) {
            return false;
        }
        if (!target.method_5805()) {
            this.dog.method_5980(null);
            return false;
        }
        if (target.method_23318() >= (double)this.dog.method_37908().method_31600()) {
            return false;
        }
        if (!this.dog.getDogRangedAttack().isApplicable(this.dog)) {
            return false;
        }
        return !restriction || !this.checkRestriction(target, this.dog);
    }

    public boolean method_6266() {
        if (!this.dog.getMode().shouldAttack()) {
            return false;
        }
        if (!this.dog.getDogRangedAttack().isApplicable(this.dog)) {
            return false;
        }
        if (this.dog.field_6017 > 7.0) {
            return false;
        }
        boolean restriction = false;
        if (this.dog.getMode().shouldFollowOwner() && this.dog.getCombatReturnStrategy() != Dog.CombatReturnStrategy.NONE) {
            class_1309 owner = this.dog.method_35057();
            if (owner != null && this.dog.method_5858((class_1297)owner) > this.getMaxDistanceAwayFromOwner()) {
                return false;
            }
        } else {
            boolean bl = restriction = !this.dog.patrolTargetLock();
        }
        if (this.waitingTick > this.timeOutTick) {
            return false;
        }
        class_1309 livingentity = this.dog.method_5968();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.method_5805()) {
            return false;
        }
        if (livingentity.method_23318() >= (double)this.dog.method_37908().method_31600()) {
            return false;
        }
        if (!this.dog.getDogRangedAttack().isApplicable(this.dog)) {
            return false;
        }
        if (restriction && this.checkRestriction(livingentity, this.dog)) {
            return false;
        }
        return !(livingentity instanceof class_1657) || !livingentity.method_7325() && !((class_1657)livingentity).method_68878();
    }

    private boolean checkRestriction(class_1309 target, Dog dog) {
        class_2338 restrict_pos = dog.method_18412();
        if (restrict_pos == null) {
            return false;
        }
        float restrict_r = dog.method_18413();
        if (restrict_r < 0.0f) {
            return false;
        }
        float max_dist = this.getAttackRadius(target) - 2.0f + restrict_r;
        return !(target.method_5707(class_243.method_24955((class_2382)restrict_pos)) <= (double)(max_dist * max_dist));
    }

    public boolean method_38846() {
        return true;
    }

    protected double getMaxDistanceAwayFromOwner() {
        if (this.dog.getCombatReturnStrategy() == Dog.CombatReturnStrategy.FAR) {
            return 1024.0;
        }
        return 400.0;
    }

    public void method_6269() {
        this.seeTime = 0;
        this.tickTillPathRecalc = 0;
        this.waitingTick = 0;
        this.dogPos0 = this.dog.method_24515().method_25503();
        this.dog.getDogRangedAttack().onStart(this.dog);
        DogAttackManager attack_manager = this.dog.dogAttackManager;
        attack_manager.attacking = true;
        if (attack_manager.hasTaticalTarget()) {
            attack_manager.setDogFarChasingTarget(true);
        }
    }

    public void method_6270() {
        this.seeTime = 0;
        this.attackCooldown = -1;
        this.dog.getDogRangedAttack().onStop(this.dog);
        this.dog.method_5942().method_6340();
        this.dog.method_5980(null);
        DogAttackManager attack_manager = this.dog.dogAttackManager;
        attack_manager.attacking = false;
        attack_manager.setDogFarChasingTarget(false);
    }

    public void method_6268() {
        double min_dist;
        double d0;
        class_1309 target = this.dog.method_5968();
        if (target == null) {
            return;
        }
        DogAttackManager attack_manager = this.dog.dogAttackManager;
        if (attack_manager.isDogFarChasingTarget() && (d0 = this.dog.method_5649(target.method_23317(), target.method_23318(), target.method_23321())) < (min_dist = (double)(attack_manager.getStandardFollowRange() / 2 + 1)) * min_dist) {
            attack_manager.setDogFarChasingTarget(false);
        }
        double d_dog_target_sqr = this.dog.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        boolean can_see_target = this.dog.method_5985().method_6369((class_1297)target);
        this.updateSeeTime(can_see_target);
        this.chaseTargetOrPositionSelf(target, d_dog_target_sqr, can_see_target);
        this.updateUsingWeapon(can_see_target, target);
    }

    private float getAttackRadius(class_1309 target) {
        if (!this.dog.isDefaultNavigation()) {
            return 6.0f + target.method_17681() / 2.0f;
        }
        return 20.0f;
    }

    private void updateSeeTime(boolean canSeeTarget) {
        boolean was_seeing_target;
        boolean bl = was_seeing_target = this.seeTime > 0;
        if (canSeeTarget != was_seeing_target) {
            this.seeTime = 0;
        }
        this.seeTime = canSeeTarget ? ++this.seeTime : --this.seeTime;
    }

    private void chaseTargetOrPositionSelf(class_1309 target, double d_dog_target_sqr, boolean can_see_target) {
        boolean should_chase_target;
        float attack_r = this.getAttackRadius(target);
        boolean bl = should_chase_target = d_dog_target_sqr > (double)(attack_r * attack_r) || this.seeTime < -40;
        if (should_chase_target) {
            this.chaseTarget(target);
        } else {
            this.positionSelf(target, d_dog_target_sqr, can_see_target);
        }
    }

    private void chaseTarget(class_1309 target) {
        class_2338 dog_bp = this.dog.method_24515();
        if (dog_bp.equals((Object)this.dogPos0)) {
            ++this.waitingTick;
        } else {
            this.waitingTick = 0;
            this.dogPos0.method_10103(dog_bp.method_10263(), dog_bp.method_10264(), dog_bp.method_10260());
        }
        this.dog.method_5988().method_6226((class_1297)target, 30.0f, (float)this.dog.method_5978());
        if (--this.tickTillPathRecalc <= 0) {
            this.tickTillPathRecalc = 10;
            this.dog.method_5942().method_6335((class_1297)target, 1.0);
        }
    }

    private void positionSelf(class_1309 target, double d_dog_target_sqr, boolean can_see_target) {
        this.dog.method_5942().method_6340();
        this.waitingTick = 0;
        this.dog.method_5988().method_6226((class_1297)target, 30.0f, (float)this.dog.method_5978());
        this.dog.method_5951((class_1297)target, 30.0f, this.dog.method_5978());
        if (this.dog.isDefaultNavigation()) {
            this.strafeAtTarget(target, d_dog_target_sqr);
        }
    }

    private void updateUsingWeapon(boolean can_see_target, class_1309 target) {
        boolean attacked;
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (attacked = this.dog.getDogRangedAttack().updateUsingWeapon(new IDogRangedAttackManager.UsingWeaponContext(this.dog, can_see_target, this.seeTime, this.attackCooldown, target))) {
            this.attackCooldown = 20;
        }
    }

    private void strafeAtTarget(class_1309 target, double d_dog_target_sqr) {
        int strafe_dir = 0;
        double foward_threshold = this.getAttackRadius(target) * 0.75f;
        double backup_threshold = 6.0;
        if (d_dog_target_sqr > foward_threshold * foward_threshold) {
            strafe_dir = 1;
        } else if (d_dog_target_sqr < backup_threshold * backup_threshold) {
            strafe_dir = -1;
        }
        this.dog.method_5962().method_6243((float)strafe_dir * 0.5f, 0.0f);
    }
}

