/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.client.screen.ConductingBoneScreen;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.ConductingBoneData;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.PlayerUtil;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import org.apache.commons.lang3.tuple.Pair;

public class ConductingBonePackets {

    public static class RequestDistantTeleportDogPacket
    implements IPacket<ConductingBoneData.RequestDistantTeleportDogData> {
        @Override
        public void encode(ConductingBoneData.RequestDistantTeleportDogData data, class_2540 buf) {
            buf.method_10797(data.dogUUID);
            buf.method_52964(data.toBed);
        }

        @Override
        public ConductingBoneData.RequestDistantTeleportDogData decode(class_2540 buf) {
            UUID uuid = buf.method_10790();
            boolean toBed = buf.readBoolean();
            return new ConductingBoneData.RequestDistantTeleportDogData(uuid, toBed);
        }

        @Override
        public void handle(ConductingBoneData.RequestDistantTeleportDogData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                    class_3222 sender = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                    class_1792 item = sender.method_5998(class_1268.field_5808).method_7909();
                    if (item != DoggyItems.CONDUCTING_BONE.get()) {
                        return;
                    }
                    if (PlayerUtil.isOnCooldown((class_1657)sender, DoggyItems.CONDUCTING_BONE.get())) {
                        return;
                    }
                    UUID uuid = data.dogUUID;
                    if (uuid == null) {
                        return;
                    }
                    DogLocationStorage storage = DogLocationStorage.get(sender.method_37908());
                    DogLocationData dogData = storage.getData(uuid);
                    if (dogData == null) {
                        return;
                    }
                    if (!sender.method_5667().equals(dogData.getOwnerId())) {
                        return;
                    }
                    if (!data.toBed) {
                        DogUtil.attemptToTeleportDogNearbyOrSendPromise(uuid, sender);
                    } else {
                        class_3218 sL;
                        class_1297 e;
                        class_1937 patt0$temp = sender.method_37908();
                        if (patt0$temp instanceof class_3218 && (e = (sL = (class_3218)patt0$temp).method_66347(data.dogUUID)) instanceof Dog) {
                            Dog d = (Dog)e;
                            DogUtil.attemptToTeleportDogToBedOrSendPromise(d);
                        }
                    }
                    PlayerUtil.addCooldown((class_1657)sender, DoggyItems.CONDUCTING_BONE.get(), 20);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class ResponseDogsPackets
    implements IPacket<ConductingBoneData.ResponseDogsData> {
        @Override
        public void encode(ConductingBoneData.ResponseDogsData data, class_2540 buf) {
            int size = data.entries.size();
            buf.method_53002(size);
            for (int i = 0; i < size; ++i) {
                Pair<UUID, String> payload = data.entries.get(i);
                UUID uuid = (UUID)payload.getLeft();
                String name = (String)payload.getRight();
                if (uuid == null) {
                    uuid = class_156.field_25140;
                }
                if (name == null) {
                    name = "noname";
                }
                buf.method_10797(uuid);
                buf.method_10814(name);
            }
        }

        @Override
        public ConductingBoneData.ResponseDogsData decode(class_2540 buf) {
            int size = buf.readInt();
            ArrayList<Pair<UUID, String>> newDogsLs = new ArrayList<Pair<UUID, String>>(size);
            for (int i = 0; i < size; ++i) {
                UUID id = buf.method_10790();
                String name = buf.method_19772();
                Pair payload = Pair.of((Object)id, (Object)name);
                newDogsLs.add((Pair<UUID, String>)payload);
            }
            return new ConductingBoneData.ResponseDogsData(newDogsLs);
        }

        @Override
        public void handle(ConductingBoneData.ResponseDogsData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    class_437 patt0$temp;
                    class_310 mc = class_310.method_1551();
                    if (mc.field_1755 != null && (patt0$temp = mc.field_1755) instanceof ConductingBoneScreen) {
                        ConductingBoneScreen scr = (ConductingBoneScreen)patt0$temp;
                        scr.assignResponse(data.entries);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class RequestDogsPacket
    implements IPacket<ConductingBoneData.RequestDogsData> {
        @Override
        public void encode(ConductingBoneData.RequestDogsData data, class_2540 buf) {
        }

        @Override
        public ConductingBoneData.RequestDogsData decode(class_2540 buf) {
            return new ConductingBoneData.RequestDogsData();
        }

        @Override
        public void handle(ConductingBoneData.RequestDogsData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                    class_3222 sender = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                    DogLocationStorage storage = DogLocationStorage.get(sender.method_37908());
                    Stream<DogLocationData> dogLsStream = (Boolean)ConfigHandler.SERVER.CONDUCTING_BONE_CROSS_ORIGIN.get() != false ? storage.getDogs((class_1309)sender) : storage.getDogs((class_1309)sender, (class_5321<class_1937>)sender.method_37908().method_27983());
                    List<Pair<UUID, String>> dogLs = dogLsStream.map(dogLoc -> Pair.of((Object)dogLoc.getDogId(), (Object)dogLoc.getDogName())).collect(Collectors.toList());
                    PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new ConductingBoneData.ResponseDogsData(dogLs));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

