/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.AmnesiaBoneItem;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogMigrateOwnerData;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.util.PlayerUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class DogMigrateOwnerPacket
extends DogPacket<DogMigrateOwnerData> {
    @Override
    public void encode(DogMigrateOwnerData data, class_2540 buf) {
        buf.method_53002(data.entityId);
        buf.method_52964(data.confirmed);
    }

    @Override
    public DogMigrateOwnerData decode(class_2540 buf) {
        int id = buf.readInt();
        boolean confirmed = buf.readBoolean();
        return new DogMigrateOwnerData(id, confirmed);
    }

    @Override
    public void handleDog(Dog dog, DogMigrateOwnerData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        class_3222 sender = ctx.get().getSender();
        class_1799 stack = sender.method_6047();
        if (stack.method_7909() != DoggyItems.AMNESIA_BONE.get()) {
            return;
        }
        if (PlayerUtil.isOnCooldown((class_1657)sender, DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        UUID ownerUUID = dog.getOwnerUUID();
        if (ownerUUID == null) {
            return;
        }
        if (!ownerUUID.equals(sender.method_5667())) {
            return;
        }
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (tag == null) {
            return;
        }
        if (!tag.hasUUID("request_uuid")) {
            ItemUtil.modifyTag(stack, to_modify -> to_modify.remove("request_str"));
            return;
        }
        UUID uuid = tag.getUUID("request_uuid");
        ItemUtil.modifyTag(stack, to_modify -> {
            to_modify.remove("request_uuid");
            to_modify.remove("request_str");
        });
        if (ownerUUID.equals(uuid)) {
            return;
        }
        class_1657 requester = dog.method_37908().method_18470(uuid);
        if (requester == null) {
            return;
        }
        if (!data.confirmed) {
            PlayerUtil.sendSystemMessage((class_1309)requester, (class_2561)class_2561.method_43469((String)"item.doggytalents.amnesia_bone.migrate_owner.reject", (Object[])new Object[]{dog.method_5477().getString()}).method_27692(class_124.field_1061));
            return;
        }
        if (sender.field_7520 < AmnesiaBoneItem.getMigrateOwnerXPCost()) {
            return;
        }
        dog.migrateOwner(uuid);
        sender.method_7316(-AmnesiaBoneItem.getMigrateOwnerXPCost());
        PlayerUtil.addCooldown((class_1657)sender, DoggyItems.AMNESIA_BONE.get(), 60);
        int usedTime = tag.getInt("amnesia_bone_used_time");
        if (++usedTime >= AmnesiaBoneItem.getUseCap()) {
            stack.method_7934(1);
            sender.method_20235(stack.method_7909(), class_1304.field_6173);
        }
        tag.putInt("amnesia_bone_used_time", usedTime);
        PlayerUtil.sendSystemMessage((class_1309)requester, (class_2561)class_2561.method_43469((String)"item.doggytalents.amnesia_bone.migrate_owner.confirmed", (Object[])new Object[]{dog.method_5477().getString(), dog.getGenderPronoun()}));
        ItemUtil.putTag(stack, tag);
    }
}

