/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.DoggySounds;
import doggytalents.api.feature.DogMode;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogSoftHeelAction;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.HeelByNameData;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.util.PlayerUtil;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;

public class HeelByNamePacket
extends DogPacket<HeelByNameData> {
    @Override
    public void encode(HeelByNameData data, class_2540 buf) {
        buf.method_53002(data.entityId);
        buf.method_52964(data.heelAndSit);
        buf.method_52964(data.softHeel);
    }

    @Override
    public HeelByNameData decode(class_2540 buf) {
        return new HeelByNameData(buf.readInt(), buf.readBoolean(), buf.readBoolean());
    }

    @Override
    public void handleDog(Dog dog, HeelByNameData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        class_3222 owner = ctx.get().getSender();
        if (!dog.canInteract((class_1309)owner)) {
            return;
        }
        if (PlayerUtil.isOnCooldown((class_1657)owner, DoggyItems.WHISTLE.get())) {
            return;
        }
        if (dog.method_5765()) {
            dog.method_5848();
        }
        dog.clearTriggerableAction();
        DogMode mode = dog.getMode();
        if (mode.canWander()) {
            dog.setMode(mode.shouldAttack() ? DogMode.AGGRESIVE : DogMode.DOCILE);
        }
        if (data.softHeel) {
            if (dog.readyForNonTrivialAction()) {
                dog.triggerAction(new DogSoftHeelAction(dog, (class_1309)owner));
            }
        } else {
            dog.method_24346(data.heelAndSit);
            DogUtil.dynamicSearchAndTeleportToOwnwer(dog, (class_1309)owner, 2);
        }
        owner.method_37908().method_8396(null, owner.method_24515(), DoggySounds.WHISTLE_LONG.get(), class_3419.field_15248, 0.6f + owner.method_37908().field_9229.method_43057() * 0.1f, 0.4f + owner.method_37908().field_9229.method_43057() * 0.2f);
        PlayerUtil.sendSystemMessage((class_1309)owner, (class_2561)class_2561.method_43469((String)"dogcommand.heel_by_name", (Object[])new Object[]{dog.method_5477().getString()}));
        PlayerUtil.addCooldown((class_1657)owner, DoggyItems.WHISTLE.get(), 20);
        class_1799 stack = owner.method_6047();
        if (stack.method_7909() instanceof WhistleItem) {
            ItemUtil.modifyTag(stack, to_modify -> to_modify.putBoolean("soft_heel", data.softHeel));
        }
    }
}

