/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import com.google.common.collect.Maps;
import doggytalents.DoggyTalentsNext;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.LegacyNbtCodec_1_21_5;
import doggytalents.api.backward_imitate.ListTag_1_21_5;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogDuplicationDetection;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.OnlineDogLocationManager;
import doggytalents.common.util.NBTUtil;
import doggytalents.forge_imitate.event.ServerStoppedEvent;
import doggytalents.forge_imitate.event.ServerStoppingEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_10741;
import net.minecraft.class_1309;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class DogLocationStorage
extends class_18 {
    private Map<UUID, DogLocationData> locationDataMap = Maps.newHashMap();
    private final OnlineDogLocationManager onlineDogManager = new OnlineDogLocationManager(this);
    public final Map<UUID, Integer> grettingDogLimitMap = Maps.newHashMap();
    public final Map<UUID, Integer> bridgingDogLimitMap = Maps.newHashMap();

    public static DogLocationStorage get(class_1937 world) {
        if (!(world instanceof class_3218)) {
            throw new IllegalStateException("DogLocationStorage is being accessed from the Client Side. Please report to the DTN Team.");
        }
        class_3218 overworld = world.method_8503().method_3847(class_1937.field_25179);
        class_26 storage = overworld.method_17983();
        return (DogLocationStorage)storage.method_17924(DogLocationStorage.savedDataType_1_21_5("doggytalentsDogLocations"));
    }

    public static DogLocationStorage get(MinecraftServer server) {
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        class_26 storage = overworld.method_17983();
        return (DogLocationStorage)storage.method_17924(DogLocationStorage.savedDataType_1_21_5("doggytalentsDogLocations"));
    }

    public Stream<DogLocationData> getDogs(class_1309 owner) {
        UUID ownerId = owner.method_5667();
        return this.locationDataMap.values().stream().filter(data -> ownerId.equals(data.getOwnerId()));
    }

    public Stream<DogLocationData> getDogs(class_1309 owner, class_5321<class_1937> key) {
        UUID ownerId = owner.method_5667();
        return this.locationDataMap.values().stream().filter(data -> ownerId.equals(data.getOwnerId())).filter(data -> key.equals(data.getDimension()));
    }

    @Nullable
    public DogLocationData getData(Dog dogIn) {
        return this.getData(dogIn.method_5667());
    }

    @Nullable
    public DogLocationData getData(UUID uuid) {
        if (this.locationDataMap.containsKey(uuid)) {
            return this.locationDataMap.get(uuid);
        }
        return null;
    }

    @Nullable
    public DogLocationData remove(Dog dogIn) {
        return this.remove(dogIn.method_5667());
    }

    @Nullable
    public DogLocationData getOrCreateData(Dog dogIn) {
        UUID uuid = dogIn.method_5667();
        return this.locationDataMap.computeIfAbsent(uuid, k -> {
            this.method_80();
            return DogLocationData.from(this, dogIn);
        });
    }

    @Nullable
    public DogLocationData remove(UUID uuid) {
        if (this.locationDataMap.containsKey(uuid)) {
            DogLocationData storage = this.locationDataMap.remove(uuid);
            this.method_80();
            return storage;
        }
        return null;
    }

    @Nullable
    public DogLocationData putData(Dog dogIn) {
        UUID uuid = dogIn.method_5667();
        DogLocationData storage = new DogLocationData(this, uuid);
        this.locationDataMap.put(uuid, storage);
        this.method_80();
        return storage;
    }

    public Set<UUID> getAllUUID() {
        return Collections.unmodifiableSet(this.locationDataMap.keySet());
    }

    public Collection<DogLocationData> getAll() {
        return Collections.unmodifiableCollection(this.locationDataMap.values());
    }

    public static DogLocationStorage load(CompoundTag_1_21_5 nbt) {
        DogLocationStorage store = new DogLocationStorage();
        store.locationDataMap.clear();
        ListTag_1_21_5 list = nbt.getList("locationData", 10);
        if (list.isEmpty()) {
            list = nbt.getList("dog_locations", 10);
        }
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag_1_21_5 locationCompound = list.getCompound(i);
            UUID uuid = NBTUtil.getUniqueId(locationCompound, "uuid");
            if (uuid == null) {
                uuid = NBTUtil.getUniqueId(locationCompound, "entityId");
            }
            DogLocationData locationData = new DogLocationData(store, uuid);
            locationData.read(locationCompound);
            if (uuid == null) {
                DoggyTalentsNext.LOGGER.info("Failed to load dog location data. Please report to mod author...");
                DoggyTalentsNext.LOGGER.info((Object)locationData);
                continue;
            }
            store.locationDataMap.put(uuid, locationData);
        }
        return store;
    }

    public CompoundTag_1_21_5 save(CompoundTag_1_21_5 compound) {
        class_2499 list = new class_2499();
        for (Map.Entry<UUID, DogLocationData> entry : this.locationDataMap.entrySet()) {
            class_2487 locationCompound = new class_2487();
            DogLocationData locationData = entry.getValue();
            NBTUtil.putUniqueId(CompoundTag_1_21_5.wrap(locationCompound), "uuid", entry.getKey());
            locationData.write(locationCompound);
            list.add((Object)locationCompound);
        }
        compound.put("locationData", (class_2520)list);
        return compound;
    }

    public boolean method_79() {
        return true;
    }

    public static void setSessionUUIDFor(Dog dog, UUID sessionUUID) {
        DogLocationStorage storage = DogLocationStorage.get(dog.method_37908());
        if (storage == null) {
            return;
        }
        DogLocationData data = storage.getData(dog);
        if (data == null) {
            return;
        }
        data.setSessionUUID(sessionUUID);
        DogDuplicationDetection.onSessionUUIDUpdate(dog, sessionUUID);
    }

    public OnlineDogLocationManager getOnlineDogsManager() {
        return this.onlineDogManager;
    }

    public void onServerStop(ServerStoppingEvent event) {
        this.onlineDogManager.onServerStop();
        this.grettingDogLimitMap.clear();
    }

    public void onServerStopped(ServerStoppedEvent event) {
        this.onlineDogManager.onServerStopped();
    }

    public static class_10741<DogLocationStorage> savedDataType_1_21_5(String name) {
        return LegacyNbtCodec_1_21_5.createSavedDataType(name, DogLocationStorage::new, DogLocationStorage::save, DogLocationStorage::load);
    }
}

