/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import com.google.common.collect.Maps;
import doggytalents.DoggyTalentsNext;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.LegacyNbtCodec_1_21_5;
import doggytalents.api.backward_imitate.ListTag_1_21_5;
import doggytalents.common.entity.Dog;
import doggytalents.common.storage.DogRespawnData;
import doggytalents.common.util.NBTUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class DogRespawnStorage
extends class_18 {
    private Map<UUID, DogRespawnData> respawnDataMap = Maps.newHashMap();

    public static DogRespawnStorage get(class_1937 world) {
        if (!(world instanceof class_3218)) {
            throw new IllegalStateException("DogRespawnStorage is being accessed from the Client Side. Please report to the DTN Team.");
        }
        class_3218 overworld = world.method_8503().method_3847(class_1937.field_25179);
        class_26 storage = overworld.method_17983();
        return (DogRespawnStorage)storage.method_17924(DogRespawnStorage.savedDataType_1_21_5("doggytalentsDeadDogs"));
    }

    public static DogRespawnStorage get(MinecraftServer server) {
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        class_26 storage = overworld.method_17983();
        return (DogRespawnStorage)storage.method_17924(DogRespawnStorage.savedDataType_1_21_5("doggytalentsDeadDogs"));
    }

    public Stream<DogRespawnData> getDogs(@Nonnull UUID ownerId) {
        return this.respawnDataMap.values().stream().filter(data -> ownerId.equals(data.getOwnerId()));
    }

    @Nullable
    public DogRespawnData getData(UUID uuid) {
        if (this.respawnDataMap.containsKey(uuid)) {
            return this.respawnDataMap.get(uuid);
        }
        return null;
    }

    @Nullable
    public DogRespawnData remove(UUID uuid) {
        if (this.respawnDataMap.containsKey(uuid)) {
            DogRespawnData storage = this.respawnDataMap.remove(uuid);
            this.method_80();
            return storage;
        }
        return null;
    }

    @Nullable
    public DogRespawnData putData(Dog dogIn) {
        UUID uuid = dogIn.method_5667();
        DogRespawnData storage = new DogRespawnData(this, uuid);
        storage.populate(dogIn);
        this.respawnDataMap.put(uuid, storage);
        this.method_80();
        return storage;
    }

    public Set<UUID> getAllUUID() {
        return Collections.unmodifiableSet(this.respawnDataMap.keySet());
    }

    public Collection<DogRespawnData> getAll() {
        return Collections.unmodifiableCollection(this.respawnDataMap.values());
    }

    public static DogRespawnStorage load(CompoundTag_1_21_5 nbt) {
        DogRespawnStorage store = new DogRespawnStorage();
        store.respawnDataMap.clear();
        ListTag_1_21_5 list = nbt.getList("respawnData", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag_1_21_5 respawnCompound = list.getCompound(i);
            UUID uuid = NBTUtil.getUniqueId(respawnCompound, "uuid");
            DogRespawnData respawnData = new DogRespawnData(store, uuid);
            respawnData.read(respawnCompound);
            if (uuid == null) {
                DoggyTalentsNext.LOGGER.info("Failed to load dog respawn data. Please report to mod author...");
                DoggyTalentsNext.LOGGER.info((Object)respawnData);
                continue;
            }
            store.respawnDataMap.put(uuid, respawnData);
        }
        return store;
    }

    public CompoundTag_1_21_5 save(CompoundTag_1_21_5 compound) {
        class_2499 list = new class_2499();
        for (Map.Entry<UUID, DogRespawnData> entry : this.respawnDataMap.entrySet()) {
            class_2487 respawnCompound = new class_2487();
            DogRespawnData respawnData = entry.getValue();
            NBTUtil.putUniqueId(CompoundTag_1_21_5.wrap(respawnCompound), "uuid", entry.getKey());
            respawnData.write(respawnCompound);
            list.add((Object)respawnCompound);
        }
        compound.put("respawnData", (class_2520)list);
        return compound;
    }

    private static class_10741<DogRespawnStorage> savedDataType_1_21_5(String name) {
        return LegacyNbtCodec_1_21_5.createSavedDataType(name, DogRespawnStorage::new, DogRespawnStorage::save, DogRespawnStorage::load);
    }
}

