/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.ItemUtil_1_21_5;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.Screens;
import doggytalents.common.entity.Dog;
import doggytalents.common.fabric_helper.util.FabricUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9331;
import net.minecraft.class_9699;
import net.minecraft.class_9701;

public class DoggyArmorTalent
extends TalentInstance {
    protected int tickUntilXPSearch;
    protected final int SEARCH_RADIUS = 2;
    protected int spareValue;
    private boolean mayNeedsDataUpgrade = false;

    public DoggyArmorTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public boolean hasRenderer() {
        return true;
    }

    @Override
    public void init(AbstractDog dogIn) {
    }

    @Override
    public void set(AbstractDog dog, int levelBefore) {
        if (dog.method_37908().field_9236) {
            return;
        }
        if (levelBefore > 0 && this.level() <= 0) {
            this.dropArmor(dog);
        }
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, class_2487 compound) {
        super.writeToNBT(dogIn, compound);
        compound.method_10543(dogIn.dogArmors().serializeNBT((class_7225.class_7874)dogIn.method_56673()));
        compound.method_10569("armors_spareXp", this.level);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag_1_21_5 compound) {
        super.readFromNBT(dogIn, compound);
        try {
            dogIn.dogArmors().deserializeNBT((class_7225.class_7874)dogIn.method_56673(), compound.wrapped());
            if (compound.contains("armors_spareXp")) {
                this.spareValue = compound.getInt("armors_spareXp");
                this.mayNeedsDataUpgrade = false;
            } else {
                this.spareValue = 0;
                this.mayNeedsDataUpgrade = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onRead(AbstractDog dogIn, CompoundTag_1_21_5 compound) {
        if (!this.mayNeedsDataUpgrade) {
            return;
        }
        try {
            if (compound.contains("dogArmors", 9)) {
                dogIn.dogArmors().deserializeNBT((class_7225.class_7874)dogIn.method_56673(), compound.wrapped());
            }
            this.spareValue = compound.getInt("armors_spareXp");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void remove(AbstractDog dogIn) {
        if (dogIn.method_37908().field_9236) {
            return;
        }
    }

    private void dropArmor(AbstractDog dogIn) {
        for (int i = 0; i < dogIn.dogArmors().getSlots(); ++i) {
            class_1264.method_5449((class_1937)dogIn.method_37908(), (double)dogIn.method_23317(), (double)dogIn.method_23318(), (double)dogIn.method_23321(), (class_1799)dogIn.dogArmors().getStackInSlot(i));
            dogIn.dogArmors().setStackInSlot(i, class_1799.field_8037);
        }
    }

    @Override
    public DogInteractionResult processInteract(AbstractDog dogIn, class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        if (ItemUtil_1_21_5.isHumanoidArmor(playerIn.method_6047())) {
            class_1309 owner;
            if (!(dogIn instanceof Dog)) {
                return DogInteractionResult.PASS;
            }
            if (!worldIn.field_9236 && (owner = dogIn.method_35057()) instanceof class_3222) {
                class_3222 sOwner = (class_3222)owner;
                Screens.openArmorScreen(sOwner, (Dog)dogIn);
            }
            return DogInteractionResult.SUCCESS;
        }
        return DogInteractionResult.PASS;
    }

    @Override
    public void tick(AbstractDog dog) {
        if (this.level() >= 3) {
            this.scanForXpAndRepair(dog);
        }
    }

    @Override
    public void props(AbstractDog dog, DogAlterationProps props) {
        props.setCanWearArmor();
    }

    private void scanForXpAndRepair(AbstractDog dog) {
        if (dog.method_37908().field_9236) {
            return;
        }
        if (--this.tickUntilXPSearch <= 0) {
            this.tickUntilXPSearch = 10;
            Optional entry = class_1890.method_8204((class_9331)class_9701.field_51652, (class_1309)dog, class_1799::method_7986);
            if (!entry.isPresent()) {
                return;
            }
            class_1937 class_19372 = dog.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                return;
            }
            class_3218 sLevel = (class_3218)class_19372;
            class_9699 enchant_stack = (class_9699)entry.get();
            class_1799 itemstack = enchant_stack.comp_2682();
            if (this.spareValue > 0) {
                int i = Math.min(this.spareValue * FabricUtil.getRepairRatio(itemstack), itemstack.method_7919());
                i = class_1890.method_60168((class_3218)sLevel, (class_1799)itemstack, (int)i);
                itemstack.method_7974(itemstack.method_7919() - i);
                this.spareValue -= i / FabricUtil.getRepairRatio(itemstack);
            }
            if (!itemstack.method_7986()) {
                return;
            }
            List orbs = dog.method_37908().method_18467(class_1303.class, dog.method_5829().method_1014(2.0));
            for (class_1303 x : orbs) {
                if (itemstack.method_7919() <= 0) break;
                int j = Math.min(x.method_5919() * FabricUtil.getRepairRatio(itemstack), itemstack.method_7919());
                j = class_1890.method_60168((class_3218)sLevel, (class_1799)itemstack, (int)j);
                itemstack.method_7974(itemstack.method_7919() - j);
                dog.method_6103((class_1297)x, 1);
                this.spareValue += j / FabricUtil.getRepairRatio(itemstack);
                x.method_31472();
            }
        }
    }
}

