/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools.tool_actions;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogPathNavigation;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.talent.doggy_tools.DogBridging;
import doggytalents.common.talent.doggy_tools.DoggyToolsTalent;
import doggytalents.common.util.DogUtil;
import java.util.Optional;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_7;
import org.apache.commons.lang3.tuple.Pair;

public class DogBridgingAction
extends TriggerableAction {
    private Phase phase = Phase.GO_TO_INITIAL_POS;
    private final DoggyToolsTalent toolsTalent;
    private final class_1309 owner;
    private class_2338 initialPos;
    private class_2350 bridgingDir;
    private int bridgingY = 0;
    private class_2338 nextPos = null;
    private class_2338 prevPos = null;
    private int bridgeCooldown;

    public DogBridgingAction(Dog dog, class_1309 owner, float bridgingRot, class_2338 initialPos, DoggyToolsTalent talent) {
        super(dog, false, false);
        this.owner = owner;
        this.toolsTalent = talent;
        this.initialPos = initialPos;
        this.bridgingDir = class_2350.method_10150((double)bridgingRot);
    }

    @Override
    public void onStart() {
        class_11 path = this.dog.method_5942().method_6348(this.initialPos, 1);
        if (path == null || !DogUtil.canPathReachTargetBlock(this.dog, path, this.initialPos, 1, this.dog.method_5850())) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.phase = Phase.GO_TO_INITIAL_POS;
        this.dog.method_5942().method_6334(path, 1.0);
        class_1408 class_14082 = this.dog.method_5942();
        if (class_14082 instanceof DogPathNavigation) {
            DogPathNavigation dogNav = (DogPathNavigation)class_14082;
            dogNav.setDogMoveInTargetNode();
        }
        DogBridging.equipBridgingStack(this.toolsTalent, this.dog);
    }

    @Override
    public void tick() {
        if (!DogBridging.isValidBridgingDog(this.toolsTalent, this.dog)) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (this.phase == Phase.GO_TO_INITIAL_POS) {
            this.goToInitialPos();
        } else {
            this.doBridge();
        }
    }

    private void goToInitialPos() {
        if (this.dog.method_5942().method_6357()) {
            this.phase = Phase.BRIDGE;
            this.nextPos = this.getNextPos();
            this.bridgingY = this.dog.method_24515().method_10264();
            return;
        }
    }

    private void doBridge() {
        NextPosAction next_pos_action;
        if (this.bridgeCooldown > 0) {
            --this.bridgeCooldown;
        }
        if (this.dog.method_24515().method_10264() != this.bridgingY) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (!this.owner.method_5805() || this.owner.method_7325() || this.owner.method_5858((class_1297)this.dog) >= 144.0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (this.nextPos == null) {
            this.nextPos = this.getNextPos();
        }
        if ((next_pos_action = this.getNextPosAction(this.nextPos)) == NextPosAction.STOP) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.dog.method_5988().method_19615(class_243.method_24955((class_2382)this.nextPos));
        if (next_pos_action == NextPosAction.GO) {
            GoState go_state = this.getGoState(this.nextPos);
            if (go_state == GoState.TOO_FAR) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (go_state == GoState.NOT_REACHED) {
                class_243 go_pos = class_243.method_24955((class_2382)this.nextPos);
                this.dog.method_5962().method_6239(go_pos.field_1352, go_pos.field_1351, go_pos.field_1350, 0.5);
            } else {
                this.nextPos = null;
            }
        } else if (next_pos_action == NextPosAction.BRIDGE && this.bridgeCooldown <= 0 && !this.tryBridge(this.nextPos)) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
    }

    private class_2338 getNextPos() {
        return this.dog.method_24515().method_10093(this.bridgingDir);
    }

    private NextPosAction getNextPosAction(class_2338 pos) {
        class_7 path_type = this.dog.getBlockPathTypeViaAlterations(pos);
        if (path_type == class_7.field_7) {
            return NextPosAction.BRIDGE;
        }
        if (path_type == class_7.field_12) {
            return NextPosAction.GO;
        }
        return NextPosAction.STOP;
    }

    private GoState getGoState(class_2338 pos) {
        float near_dist = 0.45f;
        float far_dist = 2.0f;
        double dist_sqr = this.dog.method_5707(class_243.method_24955((class_2382)pos));
        if (dist_sqr >= 4.0) {
            return GoState.TOO_FAR;
        }
        if (dist_sqr <= 0.20249998569488525) {
            return GoState.REACHED;
        }
        return GoState.NOT_REACHED;
    }

    private boolean tryBridge(class_2338 pos) {
        pos = pos.method_10074();
        if (this.prevPos != null && this.prevPos.equals((Object)pos)) {
            return false;
        }
        class_2680 state = this.dog.method_37908().method_8320(pos);
        if (!state.method_26215()) {
            return false;
        }
        Optional<Pair<class_1799, class_1747>> pair_optional = DogBridging.getBridgingMaterial(this.toolsTalent, this.dog);
        if (!pair_optional.isPresent()) {
            return false;
        }
        Pair<class_1799, class_1747> pair = pair_optional.get();
        ((class_1747)pair.getRight()).method_7712(this.getBlockPlaceContext(pos, (class_1799)pair.getLeft()));
        if (((class_1799)pair.getLeft()).method_7960()) {
            DogBridging.getBridgingMaterial(this.toolsTalent, this.dog).ifPresent(x -> this.dog.method_6122(class_1268.field_5808, (class_1799)x.getLeft()));
        }
        this.bridgeCooldown = 15;
        this.prevPos = pos;
        return true;
    }

    private class_1750 getBlockPlaceContext(class_2338 place_pos, class_1799 stack) {
        return new class_1750(this.dog.method_37908(), null, class_1268.field_5808, stack, new class_3965(class_243.method_24955((class_2382)place_pos), class_2350.field_11036, place_pos, false));
    }

    @Override
    public void onStop() {
        if (this.isStarted()) {
            this.dog.method_6122(class_1268.field_5808, class_1799.field_8037);
        }
        DogBridging.onBridgingActionStop(this.owner);
    }

    @Override
    public void onDogGoesOfflineWhileActive() {
        DogBridging.onBridgingActionStop(this.owner);
    }

    private static enum Phase {
        GO_TO_INITIAL_POS,
        BRIDGE;

    }

    private static enum NextPosAction {
        GO,
        STOP,
        BRIDGE;

    }

    private static enum GoState {
        REACHED,
        NOT_REACHED,
        TOO_FAR;

    }
}

