/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.DoggyBlocks;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.api.registry.IDogBedMaterial;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.block.tileentity.DogBedTileEntity;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.util.NBTUtil;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;

public class DogBedUtil {
    private static final Random RANDOM = new Random(System.currentTimeMillis());

    public static void setBedVariant(DogBedTileEntity dogBedTileEntity, class_1799 stack) {
        Pair<ICasingMaterial, IBeddingMaterial> materials = DogBedUtil.getMaterials(stack);
        dogBedTileEntity.setCasing((ICasingMaterial)materials.getLeft());
        dogBedTileEntity.setBedding((IBeddingMaterial)materials.getRight());
    }

    public static class_1799 createRandomBed() {
        ICasingMaterial casing = DogBedMaterialManager.randomCasing();
        IBeddingMaterial bedding = DogBedMaterialManager.randomBedding();
        return DogBedUtil.createItemStack(casing, bedding);
    }

    public static Pair<ICasingMaterial, IBeddingMaterial> getMaterials(class_1799 stack) {
        CompoundTag_1_21_5 tag = ItemUtil.getTagElement(stack, "doggytalents");
        if (tag != null) {
            ICasingMaterial casingId = DogBedMaterialManager.getCasing(tag, "casingId");
            IBeddingMaterial beddingId = DogBedMaterialManager.getBedding(tag, "beddingId");
            return Pair.of((Object)casingId, (Object)beddingId);
        }
        return Pair.of((Object)DogBedMaterialManager.NaniCasing.NULL, (Object)DogBedMaterialManager.NaniBedding.NULL);
    }

    public static class_1799 createItemStack(ICasingMaterial casingId, IBeddingMaterial beddingId) {
        class_1799 stack = new class_1799((class_1935)DoggyBlocks.DOG_BED.get(), 1);
        class_2487 tag = new class_2487();
        NBTUtil.putRegistryValue(tag, "casingId", DogBedMaterialManager.getKey(casingId));
        NBTUtil.putRegistryValue(tag, "beddingId", DogBedMaterialManager.getKey(beddingId));
        class_2487 maintag = new class_2487();
        maintag.method_10566("doggytalents", (class_2520)tag);
        ItemUtil.putTag(stack, CompoundTag_1_21_5.wrap(maintag));
        return stack;
    }

    public static Optional<IBeddingMaterial> getBeddingFromStack(class_1799 stack) {
        return DogBedUtil.getBedMaterialFromStack(stack, DogBedMaterialManager::getBedding);
    }

    public static Optional<ICasingMaterial> getCasingFromStack(class_1799 stack) {
        return DogBedUtil.getBedMaterialFromStack(stack, DogBedMaterialManager::getCasing);
    }

    public static <T extends IDogBedMaterial> Optional<T> getBedMaterialFromStack(class_1799 stack, Function<class_2960, T> bed_material_getter) {
        if (stack.method_7960()) {
            return Optional.empty();
        }
        class_1792 item = stack.method_7909();
        if (!(item instanceof class_1747)) {
            return Optional.empty();
        }
        class_1747 block_item = (class_1747)item;
        class_2248 block = block_item.method_7711();
        if (block == null) {
            return Optional.empty();
        }
        class_2960 id = class_7923.field_41175.method_10221((Object)block);
        IDogBedMaterial material = (IDogBedMaterial)bed_material_getter.apply(id);
        if (material.isNani()) {
            return Optional.empty();
        }
        return material.getIngredient().filter(ingredient -> ingredient.method_8093(stack)).map(x -> material);
    }

    public static class_1799 createItemStackForced(class_2248 casing, class_2248 bedding) {
        class_1799 stack = new class_1799((class_1935)DoggyBlocks.DOG_BED.get(), 1);
        class_2487 tag = new class_2487();
        NBTUtil.putRegistryValue(tag, "casingId", class_7923.field_41175.method_10221((Object)casing));
        NBTUtil.putRegistryValue(tag, "beddingId", class_7923.field_41175.method_10221((Object)bedding));
        class_2487 maintag = new class_2487();
        maintag.method_10566("doggytalents", (class_2520)tag);
        ItemUtil.putTag(stack, CompoundTag_1_21_5.wrap(maintag));
        return stack;
    }
}

