/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.feature.FoodHandler;
import doggytalents.api.forge_imitate.inventory.ItemStackHandler;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.common.backward_imitate.DogFoodProperties_21_3;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.MeatFoodHandler;
import doggytalents.common.item.DogEddibleItem;
import doggytalents.common.item.IDogEddible;
import doggytalents.common.util.ItemUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3489;
import net.minecraft.class_4174;

public class DogFoodUtil {
    private static final MeatFoodHandler meat_food_handler_limited = new MeatFoodHandler();

    public static boolean isMeat(class_1799 stack) {
        return stack.method_31573(class_3489.field_49932) || (Boolean)ConfigHandler.SERVER.DOG_CAN_EAT_ALL_FOOD.get() != false && ItemUtil.food(stack) != null;
    }

    public static MeatFoodHandler limitedMeatFoodHandler() {
        return meat_food_handler_limited;
    }

    public static int dogFindFoodInInv(Dog dog, boolean findHealingFood, ItemStackHandler inv) {
        return DogFoodUtil.dogFindFoodInInv(dog, dog, findHealingFood, inv);
    }

    public static int dogFindFoodInInv(Dog finder, Dog target, boolean findHealingFood, ItemStackHandler inv) {
        int eddibleFoodId = DogFoodUtil.dogFindBestDogEddibleFood(finder, target, findHealingFood, inv);
        if (eddibleFoodId >= 0) {
            return eddibleFoodId;
        }
        int meatFoodId = DogFoodUtil.dogFindMeatFood(finder, target, inv);
        if (meatFoodId >= 0) {
            return meatFoodId;
        }
        return -1;
    }

    public static int dogFindBestDogEddibleFood(Dog finder, Dog target, boolean findHealingFood, ItemStackHandler inv) {
        ItemStackHandler inventory = inv;
        if (inventory == null) {
            return -1;
        }
        float minNutrition = -1.0f;
        int selectedStack = -1;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            DogEddibleItem eddible;
            class_1799 stack = inventory.getStackInSlot(i);
            class_1792 item = stack.method_7909();
            if (!(item instanceof DogEddibleItem) || !(eddible = (DogEddibleItem)item).canConsume(target, stack, (class_1297)finder)) continue;
            if (findHealingFood && DogFoodUtil.checkRegenEffects(target, stack, eddible)) {
                return i;
            }
            float addedNutrition = eddible.getAddedHungerWhenDogConsume(stack, target);
            if (minNutrition < 0.0f) {
                minNutrition = addedNutrition;
                selectedStack = i;
                continue;
            }
            if (!(minNutrition > addedNutrition)) continue;
            minNutrition = addedNutrition;
            selectedStack = i;
        }
        return selectedStack;
    }

    private static boolean checkRegenEffects(AbstractDog target, class_1799 stack, DogEddibleItem item) {
        List<DogFoodProperties_21_3.PossibleEffect_1_21_3> effects = item.getAdditionalEffectsWhenDogConsume(stack, target);
        for (DogFoodProperties_21_3.PossibleEffect_1_21_3 pair : effects) {
            class_1293 effect = pair.effect();
            if (effect.method_5579() != class_1294.field_5924) continue;
            return true;
        }
        return false;
    }

    public static int dogFindMeatFood(Dog finder, Dog target, ItemStackHandler inv) {
        ItemStackHandler inventory = inv;
        if (inventory == null) {
            return -1;
        }
        int minor_meat_id = -1;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            class_4174 food;
            class_1799 stack = inventory.getStackInSlot(i);
            if (!meat_food_handler_limited.canConsume(target, stack, (class_1297)finder) || (food = ItemUtil.food(stack)) == null) continue;
            if (food.comp_2491() >= 6) {
                return i;
            }
            if (minor_meat_id >= 0) continue;
            minor_meat_id = i;
        }
        return minor_meat_id;
    }

    public static boolean tryFeed(Dog dog, boolean findHealingFood, ItemStackHandler inv) {
        return DogFoodUtil.tryFeed(dog, dog, findHealingFood, inv);
    }

    public static boolean tryFeed(Dog dog, Dog feeder, boolean findHealingFood, ItemStackHandler inv) {
        int foodSlot = DogFoodUtil.dogFindFoodInInv(feeder, dog, findHealingFood, inv);
        if (foodSlot < 0) {
            return false;
        }
        class_1799 feedStack = inv.getStackInSlot(foodSlot).method_7972();
        class_1792 feedItem = feedStack.method_7909();
        if (feedItem instanceof IDogEddible) {
            IDogEddible eddible = (IDogEddible)feedItem;
            eddible.consume(dog, feedStack, (class_1297)feeder);
        } else {
            DogFoodUtil.limitedMeatFoodHandler().consume(dog, feedStack, (class_1297)feeder);
        }
        inv.setStackInSlot(foodSlot, feedStack);
        return true;
    }

    public static DogInteractionResult tryFeedAny(AbstractDog dog, @Nullable class_1297 feeder, ItemStackHandler inv) {
        int found_food_id = -1;
        IDogFoodHandler found_food = null;
        for (int i = 0; i < inv.getSlots(); ++i) {
            class_1799 stack = inv.getStackInSlot(i);
            Optional<IDogFoodHandler> food = FoodHandler.getMatch(dog, stack, feeder);
            if (!food.isPresent()) continue;
            found_food_id = i;
            found_food = food.get();
            break;
        }
        if (found_food_id < 0 || found_food == null) {
            return DogInteractionResult.PASS;
        }
        class_1799 feed_stack = inv.getStackInSlot(found_food_id).method_7972();
        DogInteractionResult response = found_food.consume(dog, feed_stack, feeder);
        inv.setStackInSlot(found_food_id, feed_stack);
        return response;
    }
}

