/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.forge_imitate.inventory.ItemStackHandler;
import doggytalents.common.item.IDyeableArmorItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10124;
import net.minecraft.class_10132;
import net.minecraft.class_10134;
import net.minecraft.class_10192;
import net.minecraft.class_10215;
import net.minecraft.class_10394;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_4174;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8103;
import net.minecraft.class_9279;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public class ItemUtil {
    private static int MAX_OVERVIEW = 3;

    public static ContentOverview getContentOverview(ItemStackHandler inventory) {
        HashMap<class_1792, Integer> retMap = new HashMap<class_1792, Integer>(MAX_OVERVIEW);
        int isMore = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            class_1799 stack = inventory.getStackInSlot(i);
            if (stack.method_7960()) continue;
            class_1792 item = stack.method_7909();
            Integer existing = retMap.get(item);
            if (existing != null) {
                retMap.put(item, existing + stack.method_7947());
                continue;
            }
            if (retMap.size() >= MAX_OVERVIEW) {
                ++isMore;
                continue;
            }
            retMap.put(item, stack.method_7947());
        }
        return new ContentOverview(retMap, isMore);
    }

    public static CompoundTag_1_21_5 getTag(class_1799 stack) {
        class_9279 custom_data = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        if (custom_data == class_9279.field_49302) {
            return CompoundTag_1_21_5.createEmpty();
        }
        return CompoundTag_1_21_5.wrap(custom_data.method_57461());
    }

    public static void clearTag(class_1799 stack) {
        stack.method_57379(class_9334.field_49628, null);
    }

    public static void putTag(class_1799 stack, CompoundTag_1_21_5 tag) {
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag.wrapped()));
    }

    public static void modifyTag(class_1799 stack, Consumer<CompoundTag_1_21_5> tag_modifier) {
        class_9279 custom_data = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        CompoundTag_1_21_5 current_tag = CompoundTag_1_21_5.createEmpty();
        if (custom_data != class_9279.field_49302) {
            current_tag = CompoundTag_1_21_5.wrap(custom_data.method_57461());
        }
        tag_modifier.accept(current_tag);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)current_tag.wrapped()));
    }

    public static CompoundTag_1_21_5 getTagElement(class_1799 stack, String id) {
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (!tag.contains(id, 10)) {
            return null;
        }
        return tag.getCompound(id);
    }

    public static boolean hasTag(class_1799 stack) {
        class_9279 custom = (class_9279)stack.method_58694(class_9334.field_49628);
        return custom != null && !custom.method_57458();
    }

    public static void copyTag(class_1799 from, class_1799 to) {
        class_2487 fromTag = ((class_9279)from.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        to.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)fromTag));
    }

    public static boolean fireResistant(class_1799 stack) {
        return stack.method_57826(class_9334.field_54273) && class_8103.field_42246.equals((Object)((class_10215)stack.method_58694(class_9334.field_54273)).comp_3210());
    }

    public static boolean isEddible(class_1799 stack) {
        return stack.method_57826(class_9334.field_50075);
    }

    public static boolean hasCustomHoverName(class_1799 stack) {
        return stack.method_57826(class_9334.field_49631);
    }

    public static class_2561 getCustomHoverName(class_1799 stack) {
        return (class_2561)stack.method_58694(class_9334.field_49631);
    }

    public static void clearCustomHoverName(class_1799 stack) {
        stack.method_57379(class_9334.field_49631, null);
    }

    public static int getDyeColorForStack(class_1799 stack) {
        int default_color = 0xFFFFFF;
        int color_mask = -16777216;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IDyeableArmorItem) {
            IDyeableArmorItem dye = (IDyeableArmorItem)class_17922;
            default_color = dye.getDefaultColor(stack);
        }
        if (!stack.method_57826(class_9334.field_49644)) {
            return default_color;
        }
        return ((class_9282)stack.method_58695(class_9334.field_49644, (Object)new class_9282(default_color))).comp_2384() | color_mask;
    }

    public static void setDyeColorForStack(class_1799 stack, int color) {
        stack.method_57379(class_9334.field_49644, (Object)new class_9282(color));
    }

    public static Optional<class_8053> getTrim(class_1799 stack) {
        if (!stack.method_57826(class_9334.field_49607) || !ItemUtil.isValidTrim_1_21_3(stack)) {
            return Optional.empty();
        }
        return Optional.ofNullable((class_8053)stack.method_58694(class_9334.field_49607));
    }

    public static class_4174 food(class_1799 stack) {
        return (class_4174)stack.method_58694(class_9334.field_50075);
    }

    public static class_9279 getWrappedTag(class_1799 stack) {
        class_9279 custom_data = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        return custom_data;
    }

    public static int getEnchantmentLevelForItem(class_5321<class_1887> key, class_5455 prov, class_1799 stack) {
        class_2378 reg = prov.method_30530(class_7924.field_41265);
        Optional holder = reg.method_46746(key);
        if (!holder.isPresent()) {
            return 0;
        }
        return stack.method_58657().method_57536((class_6880)holder.get());
    }

    public static Optional<class_1856> getBlockIngredient(class_2248 block) {
        return Optional.ofNullable(block.method_8389()).filter(item -> item != class_1802.field_8162).map(class_1856::method_8101);
    }

    public static class_1304 getEquipmentSlot(class_1799 stack) {
        class_10192 data = ItemUtil.getEquippable_1_21_3(stack);
        if (data == null) {
            return null;
        }
        return data.comp_3174();
    }

    public static class_10192 getEquippable_1_21_3(class_1799 stack) {
        return (class_10192)stack.method_58694(class_9334.field_54196);
    }

    public static boolean isValidTrim_1_21_3(class_1799 stack) {
        class_10192 equip = ItemUtil.getEquippable_1_21_3(stack);
        if (equip == null) {
            return false;
        }
        return equip.comp_3176().isPresent();
    }

    public static class_5321<class_10394> getEquippableModelUnsafe_1_21_3(class_1799 stack) {
        return (class_5321)ItemUtil.getEquippable_1_21_3(stack).comp_3176().get();
    }

    public static class_4174 food_1_21_3(class_1799 stack) {
        return (class_4174)stack.method_58694(class_9334.field_50075);
    }

    public static class_10124 consumable_1_21_3(class_1799 stack) {
        return (class_10124)stack.method_58694(class_9334.field_53964);
    }

    public static List<class_1293> foodEffect_1_21_3(class_1799 stack) {
        class_10124 consumable = ItemUtil.consumable_1_21_3(stack);
        if (consumable == null) {
            return List.of();
        }
        List effects = consumable.comp_3089();
        if (effects == null) {
            return List.of();
        }
        ArrayList<class_1293> mob_add_effects_list = new ArrayList<class_1293>();
        for (class_10134 x : effects) {
            if (!(x instanceof class_10132)) continue;
            class_10132 apply_status = (class_10132)x;
            mob_add_effects_list.addAll(apply_status.comp_3094());
        }
        return mob_add_effects_list;
    }

    public static class ContentOverview {
        private final Map<class_1792, Integer> contents;
        private int isMore = 0;

        private ContentOverview(Map<class_1792, Integer> contents, int isMore) {
            this.contents = contents;
            this.isMore = isMore;
        }

        public int isMore() {
            return this.isMore;
        }

        public Map<class_1792, Integer> contents() {
            return this.contents;
        }
    }
}

