/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.dogpromise.promise;

import doggytalents.common.entity.Dog;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.PlayerUtil;
import doggytalents.common.util.dogpromise.promise.AbstractPromise;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public class DogDistantTeleportToOwnerPromise
extends AbstractPromise {
    private static final int TIMEOUT = 200;
    private static final int SEARCH_INTERVAL = 10;
    private final class_2338 targetPos;
    private final class_2338 dogPos;
    private final UUID dogUUID;
    private final class_3218 level;
    private int timeOutTick;
    private int tickTillSearch;
    private Dog teleportedDog;
    private final class_1309 owner;

    public DogDistantTeleportToOwnerPromise(@Nonnull UUID dogUUID, @Nonnull class_1309 owner, @Nonnull class_2338 dogPos) {
        class_3218 sL;
        this.dogUUID = dogUUID;
        class_1937 class_19372 = owner.method_37908();
        this.level = class_19372 instanceof class_3218 ? (sL = (class_3218)class_19372) : null;
        this.targetPos = owner.method_24515();
        this.dogPos = dogPos;
        this.owner = owner;
    }

    @Override
    public void tick() {
        class_1297 dog = null;
        if (--this.tickTillSearch <= 0) {
            this.tickTillSearch = 10;
            dog = this.level.method_66347(this.dogUUID);
        }
        if (dog != null) {
            if (!(dog instanceof Dog)) {
                this.rejectedMsg = "WHAT?";
                this.setState(AbstractPromise.State.REJECTED);
                return;
            }
            boolean flag = DogUtil.dynamicSearchAndTeleportToBlockPos((Dog)dog, this.targetPos, 4);
            if (!flag) {
                this.rejectedMsg = "NOSAFEPOS";
                this.setState(AbstractPromise.State.REJECTED);
                return;
            }
            this.teleportedDog = (Dog)dog;
            this.setState(AbstractPromise.State.FULFILLED);
        } else if (--this.timeOutTick <= 0) {
            this.rejectedMsg = "TIMEOUT";
            this.setState(AbstractPromise.State.REJECTED);
        }
    }

    @Override
    public void onFulfilled() {
        if (this.teleportedDog == null || !this.teleportedDog.method_5805()) {
            return;
        }
        if (this.owner != null) {
            PlayerUtil.sendSystemMessage(this.owner, (class_2561)class_2561.method_43469((String)"item.doggytalents.conducting_bone.fulfilled.tp_self", (Object[])new Object[]{this.teleportedDog.method_5477().getString()}));
        }
        this.level.method_65096((class_2394)class_2398.field_11214, this.teleportedDog.method_23317(), this.teleportedDog.method_23318(), this.teleportedDog.method_23321(), 30, (double)this.teleportedDog.method_17681(), (double)0.8f, (double)this.teleportedDog.method_17681(), 0.1);
    }

    @Override
    public void onRejected() {
        if (this.owner != null) {
            PlayerUtil.sendSystemMessage(this.owner, (class_2561)class_2561.method_43469((String)"item.doggytalents.conducting_bone.rejected", (Object[])new Object[]{class_2561.method_43470((String)this.rejectedMsg).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10977(class_124.field_1061))}));
        }
    }

    @Override
    public void start() {
        if (this.level == null) {
            this.rejectedMsg = "CLIENTLEVEL";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        DogLocationStorage storage = DogLocationStorage.get((class_1937)this.level);
        DogLocationData data = storage.getData(this.dogUUID);
        if (data == null) {
            this.rejectedMsg = "WHAT?";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        class_5321<class_1937> dogDimKey = data.getDimension();
        class_5321 ownerDimKey = this.owner.method_37908().method_27983();
        if (ownerDimKey == null || dogDimKey == null) {
            this.rejectedMsg = "WHAT?";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        if (!dogDimKey.equals((Object)ownerDimKey)) {
            this.rejectedMsg = "DIFFERENTDIM";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        this.timeOutTick = 200;
        class_1923 chunkpos = new class_1923(this.dogPos);
        if (this.level.method_8393(chunkpos.field_9181, chunkpos.field_9180)) {
            this.rejectedMsg = "ALREADYREQUESTORLOADED";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        this.accquireChunk(this.level, chunkpos);
    }
}

