/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import doggytalents.api.anim.DogAnimation;
import doggytalents.client.entity.model.AnimatedSyncedAccessoryModel;
import doggytalents.client.entity.model.animation.DogAnimationRegistry;
import doggytalents.client.entity.model.animation.DogKeyframeAnimations;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimationManager;
import doggytalents.common.entity.anim.DogAnimationState;
import doggytalents.common.entity.anim.DogPose;
import java.util.Optional;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.joml.Vector3f;

public class ElytraCapeModel
extends AnimatedSyncedAccessoryModel {
    public ModelPart flyingParts;
    public ModelPart rWing;
    public ModelPart lWing;
    public ModelPart elytra;
    private Vector3f vecObj = new Vector3f(0.0f, 0.0f, 0.0f);

    public ElytraCapeModel(ModelPart root) {
        super(root);
    }

    @Override
    protected void populatePart(ModelPart box) {
        this.mane = Optional.of(box.getChild("upper_body"));
        this.flyingParts = ((ModelPart)this.mane.get()).getChild("elytra_rot");
        this.elytra = this.flyingParts.getChild("elytra");
        this.lWing = this.elytra.getChild("left_wing");
        this.rWing = this.elytra.getChild("right_wing");
    }

    @Override
    public Optional<ModelPart> searchForPartWithName(String name) {
        return DogKeyframeAnimations.searchForPartWithName(this.flyingParts, name, false);
    }

    @Override
    public void prepareMobModel(Dog dogIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        super.prepareMobModel(dogIn, limbSwing, limbSwingAmount, partialTickTime);
        DogPose pose = dogIn.getDogPose();
        if (pose == DogPose.FLYING) {
            this.elytra.offsetRotation(KeyframeAnimations.degreeVec((float)24.59f, (float)0.0f, (float)0.0f));
            this.elytra.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.24f, (float)1.45f));
            this.rWing.offsetRotation(KeyframeAnimations.degreeVec((float)-15.18f, (float)-46.68f, (float)11.36f));
            this.rWing.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f));
            this.lWing.offsetRotation(KeyframeAnimations.degreeVec((float)-15.18f, (float)46.68f, (float)-11.36f));
            this.lWing.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f));
        }
    }

    @Override
    public void setupAnim(Dog dog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        DogAnimationManager animationManager = dog.animationManager;
        DogAnimationState animState = animationManager.animationState;
        DogAnimation anim = dog.getAnim();
        if (anim == DogAnimation.NONE) {
            return;
        }
        AnimationDefinition sequence = DogAnimationRegistry.getSequence(anim);
        if (sequence == null) {
            return;
        }
        if (animState.isStarted()) {
            DogKeyframeAnimations.animate(this, dog, sequence, animState.getAccumulatedTimeMillis(), 1.0f, this.vecObj);
        }
    }

    @Override
    public void resetAllPose() {
        this.elytra.resetPose();
        this.lWing.resetPose();
        this.rWing.resetPose();
    }

    public static LayerDefinition cape() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition upper_body = partdefinition.addOrReplaceChild("upper_body", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition elytra_rot = upper_body.addOrReplaceChild("elytra_rot", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-3.75f, (float)-0.25f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition elytra = elytra_rot.addOrReplaceChild("elytra", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cape_r1 = elytra.addOrReplaceChild("cape_r1", CubeListBuilder.create().texOffs(40, 42).mirror().addBox(-2.8914f, 3.8079f, 2.3224f, 10.0f, 20.0f, 2.0f, new CubeDeformation(0.001f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)-1.0f, (float)1.6144f, (float)0.0f, (float)0.0f));
        PartDefinition right_wing = elytra.addOrReplaceChild("right_wing", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)1.0f, (float)2.0f));
        PartDefinition right_r1 = right_wing.addOrReplaceChild("right_r1", CubeListBuilder.create().texOffs(0, 42).addBox(-6.6851f, 3.7889f, 2.3232f, 10.0f, 20.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-3.0f, (float)1.6144f, (float)-0.1309f, (float)0.0f));
        PartDefinition left_wing = elytra.addOrReplaceChild("left_wing", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)1.0f, (float)2.0f));
        PartDefinition left_r1 = left_wing.addOrReplaceChild("left_r1", CubeListBuilder.create().texOffs(0, 42).mirror().addBox(-2.8914f, 3.8079f, 2.3224f, 10.0f, 20.0f, 2.0f, new CubeDeformation(0.001f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-3.0f, (float)1.6144f, (float)0.0873f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition bat() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition upper_body = partdefinition.addOrReplaceChild("upper_body", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition elytra_rot = upper_body.addOrReplaceChild("elytra_rot", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-3.75f, (float)-0.25f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition elytra = elytra_rot.addOrReplaceChild("elytra", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cape_r1 = elytra.addOrReplaceChild("cape_r1", CubeListBuilder.create().texOffs(40, 42).mirror().addBox(-2.8914f, 3.8079f, 2.3224f, 10.0f, 20.0f, 2.0f, new CubeDeformation(0.001f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)-1.0f, (float)1.6144f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing = elytra.addOrReplaceChild("left_wing", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)1.0f, (float)2.0f));
        PartDefinition left_wing_r1 = left_wing.addOrReplaceChild("left_wing_r1", CubeListBuilder.create().texOffs(20, 47).mirror().addBox(0.6329f, -8.4717f, 18.5f, 10.0f, 16.0f, 1.0f, new CubeDeformation(0.001f)).mirror(false).texOffs(0, 51).mirror().addBox(10.6329f, -7.4717f, 18.5f, 8.0f, 12.0f, 1.0f, new CubeDeformation(0.001f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)12.75f, (float)1.25f, (float)1.5708f, (float)-1.1345f, (float)0.0f));
        PartDefinition right_wing = elytra.addOrReplaceChild("right_wing", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)1.0f, (float)2.0f));
        PartDefinition right_wing_r1 = right_wing.addOrReplaceChild("right_wing_r1", CubeListBuilder.create().texOffs(20, 47).addBox(-10.6329f, -8.4717f, 18.5f, 10.0f, 16.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 51).addBox(-18.6329f, -7.4717f, 18.5f, 8.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)12.75f, (float)1.25f, (float)1.5708f, (float)1.1345f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition angel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition upper_body = partdefinition.addOrReplaceChild("upper_body", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition elytra_rot = upper_body.addOrReplaceChild("elytra_rot", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-3.75f, (float)-0.25f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition elytra = elytra_rot.addOrReplaceChild("elytra", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing = elytra.addOrReplaceChild("left_wing", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)1.0f, (float)2.0f));
        PartDefinition left_r1 = left_wing.addOrReplaceChild("left_r1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-2.8914f, 3.8079f, 2.3224f, 3.0f, 3.0f, 2.0f, new CubeDeformation(-0.599f)).mirror(false), PartPose.offsetAndRotation((float)0.25f, (float)-1.5f, (float)-6.0f, (float)1.6144f, (float)0.0873f, (float)0.0f));
        PartDefinition left_r2 = left_wing.addOrReplaceChild("left_r2", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-3.8914f, 3.8079f, 2.3224f, 4.0f, 3.0f, 2.0f, new CubeDeformation(-0.199f)).mirror(false), PartPose.offsetAndRotation((float)1.25f, (float)-1.5f, (float)-4.5f, (float)1.6144f, (float)0.0873f, (float)0.0f));
        PartDefinition left_r3 = left_wing.addOrReplaceChild("left_r3", CubeListBuilder.create().texOffs(3, 1).mirror().addBox(-0.8914f, 3.8079f, 3.3224f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.001f)).mirror(false), PartPose.offsetAndRotation((float)0.25f, (float)-1.0f, (float)-1.0f, (float)1.6144f, (float)0.0873f, (float)0.0f));
        PartDefinition left_r4 = left_wing.addOrReplaceChild("left_r4", CubeListBuilder.create().texOffs(2, 1).mirror().addBox(-6.8724f, 3.3725f, 3.3414f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.001f)).mirror(false), PartPose.offsetAndRotation((float)0.7f, (float)-1.0f, (float)3.25f, (float)1.8161f, (float)1.3909f, (float)0.2453f));
        PartDefinition left_r5 = left_wing.addOrReplaceChild("left_r5", CubeListBuilder.create().texOffs(2, 1).mirror().addBox(-6.8724f, 3.3725f, 3.3414f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.001f)).mirror(false), PartPose.offsetAndRotation((float)1.2f, (float)-1.0f, (float)3.25f, (float)1.9648f, (float)1.4574f, (float)0.3956f));
        PartDefinition left_r6 = left_wing.addOrReplaceChild("left_r6", CubeListBuilder.create().texOffs(2, 1).mirror().addBox(-6.8724f, 3.3725f, 3.3414f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.101f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)-1.0f, (float)4.0f, (float)1.9965f, (float)1.4654f, (float)0.4274f));
        PartDefinition left_r7 = left_wing.addOrReplaceChild("left_r7", CubeListBuilder.create().texOffs(20, 0).mirror().addBox(-7.8724f, 2.3725f, 3.3414f, 5.0f, 2.0f, 1.0f, new CubeDeformation(-0.399f)).mirror(false), PartPose.offsetAndRotation((float)0.25f, (float)-1.0f, (float)-3.25f, (float)1.3802f, (float)1.3494f, (float)-0.169f));
        PartDefinition left_r8 = left_wing.addOrReplaceChild("left_r8", CubeListBuilder.create().texOffs(0, 5).mirror().addBox(-7.8724f, 2.3725f, 3.3414f, 7.0f, 2.0f, 1.0f, new CubeDeformation(-0.399f)).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)-1.0f, (float)-0.75f, (float)1.3802f, (float)1.3494f, (float)-0.169f));
        PartDefinition left_r9 = left_wing.addOrReplaceChild("left_r9", CubeListBuilder.create().texOffs(0, 5).mirror().addBox(-7.8724f, 2.3725f, 3.3414f, 7.0f, 2.0f, 1.0f, new CubeDeformation(-0.099f)).mirror(false), PartPose.offsetAndRotation((float)0.75f, (float)-1.0f, (float)3.5f, (float)1.3802f, (float)1.3494f, (float)-0.169f));
        PartDefinition left_r10 = left_wing.addOrReplaceChild("left_r10", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-8.8724f, 2.3725f, 3.3414f, 8.0f, 2.0f, 1.0f, new CubeDeformation(-0.099f)).mirror(false), PartPose.offsetAndRotation((float)1.5f, (float)-1.0f, (float)5.5f, (float)1.3802f, (float)1.3494f, (float)-0.169f));
        PartDefinition left_r11 = left_wing.addOrReplaceChild("left_r11", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-8.8724f, 2.3725f, 3.3414f, 8.0f, 2.0f, 1.0f, new CubeDeformation(-0.099f)).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)-1.0f, (float)6.25f, (float)1.1222f, (float)1.4748f, (float)-0.4298f));
        PartDefinition left_r12 = left_wing.addOrReplaceChild("left_r12", CubeListBuilder.create().texOffs(0, 3).mirror().addBox(-8.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(-0.099f)).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)-1.0f, (float)8.0f, (float)-0.0164f, (float)1.5292f, (float)-1.5702f));
        PartDefinition left_r13 = left_wing.addOrReplaceChild("left_r13", CubeListBuilder.create().texOffs(0, 3).mirror().addBox(-8.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(-0.099f)).mirror(false), PartPose.offsetAndRotation((float)2.75f, (float)-1.0f, (float)8.0f, (float)-1.4117f, (float)1.3051f, (float)-2.971f));
        PartDefinition left_r14 = left_wing.addOrReplaceChild("left_r14", CubeListBuilder.create().texOffs(0, 3).mirror().addBox(-8.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(-0.199f)).mirror(false), PartPose.offsetAndRotation((float)2.75f, (float)-1.0f, (float)8.0f, (float)-1.481f, (float)1.0885f, (float)-3.045f));
        PartDefinition left_r15 = left_wing.addOrReplaceChild("left_r15", CubeListBuilder.create().texOffs(0, 3).mirror().addBox(-8.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(-0.199f)).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)-1.0f, (float)8.0f, (float)-1.5026f, (float)0.9145f, (float)-3.0705f));
        PartDefinition left_r16 = left_wing.addOrReplaceChild("left_r16", CubeListBuilder.create().texOffs(1, 1).mirror().addBox(-7.8724f, 2.3725f, 3.3414f, 5.0f, 2.0f, 1.0f, new CubeDeformation(-0.099f)).mirror(false), PartPose.offsetAndRotation((float)0.25f, (float)-1.0f, (float)-2.5f, (float)1.6973f, (float)1.2191f, (float)0.1226f));
        PartDefinition left_r17 = left_wing.addOrReplaceChild("left_r17", CubeListBuilder.create().texOffs(1, 1).mirror().addBox(-7.8724f, 2.3725f, 3.3414f, 7.0f, 2.0f, 1.0f, new CubeDeformation(-0.099f)).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)-1.0f, (float)0.0f, (float)1.6973f, (float)1.2191f, (float)0.1226f));
        PartDefinition left_r18 = left_wing.addOrReplaceChild("left_r18", CubeListBuilder.create().texOffs(1, 1).mirror().addBox(-7.8724f, 2.3725f, 3.3414f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.001f)).mirror(false), PartPose.offsetAndRotation((float)1.25f, (float)-1.0f, (float)4.0f, (float)1.6973f, (float)1.2191f, (float)0.1226f));
        PartDefinition left_r19 = left_wing.addOrReplaceChild("left_r19", CubeListBuilder.create().texOffs(0, 1).mirror().addBox(-8.8724f, 2.3725f, 3.3414f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.001f)).mirror(false), PartPose.offsetAndRotation((float)2.25f, (float)-1.0f, (float)4.75f, (float)1.6973f, (float)1.2191f, (float)0.1226f));
        PartDefinition left_r20 = left_wing.addOrReplaceChild("left_r20", CubeListBuilder.create().texOffs(0, 1).mirror().addBox(-8.8724f, 2.3725f, 3.3414f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.201f)).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)-1.0f, (float)7.25f, (float)1.769f, (float)1.3483f, (float)0.1973f));
        PartDefinition left_r21 = left_wing.addOrReplaceChild("left_r21", CubeListBuilder.create().texOffs(0, 1).mirror().addBox(-8.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.101f)).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)-1.0f, (float)8.75f, (float)-1.6576f, (float)1.0456f, (float)3.0703f));
        PartDefinition left_r22 = left_wing.addOrReplaceChild("left_r22", CubeListBuilder.create().texOffs(0, 1).mirror().addBox(-8.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.201f)).mirror(false), PartPose.offsetAndRotation((float)2.75f, (float)-1.0f, (float)8.75f, (float)-1.8926f, (float)1.433f, (float)2.8264f));
        PartDefinition left_r23 = left_wing.addOrReplaceChild("left_r23", CubeListBuilder.create().texOffs(0, 1).mirror().addBox(-8.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.101f)).mirror(false), PartPose.offsetAndRotation((float)2.75f, (float)-1.0f, (float)8.75f, (float)-1.6973f, (float)1.2192f, (float)3.0265f));
        PartDefinition left_r24 = left_wing.addOrReplaceChild("left_r24", CubeListBuilder.create().texOffs(0, 1).mirror().addBox(-8.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.201f)).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)-1.0f, (float)8.75f, (float)1.8923f, (float)1.4328f, (float)0.3224f));
        PartDefinition left_r25 = left_wing.addOrReplaceChild("left_r25", CubeListBuilder.create().texOffs(0, 1).mirror().addBox(-8.8724f, 2.3725f, 3.3414f, 5.0f, 2.0f, 1.0f, new CubeDeformation(0.201f)).mirror(false), PartPose.offsetAndRotation((float)-0.5f, (float)-1.0f, (float)3.5f, (float)-1.6421f, (float)0.9152f, (float)3.0888f));
        PartDefinition left_r26 = left_wing.addOrReplaceChild("left_r26", CubeListBuilder.create().texOffs(4, 1).mirror().addBox(-4.8724f, 3.3725f, 3.3414f, 4.0f, 1.0f, 1.0f, new CubeDeformation(-0.299f)).mirror(false), PartPose.offsetAndRotation((float)-1.3f, (float)-1.0f, (float)3.0f, (float)-1.6647f, (float)1.0891f, (float)3.0621f));
        PartDefinition left_r27 = left_wing.addOrReplaceChild("left_r27", CubeListBuilder.create().texOffs(2, 1).mirror().addBox(-6.8724f, 3.3725f, 3.3414f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.001f)).mirror(false), PartPose.offsetAndRotation((float)-1.8f, (float)-1.0f, (float)3.25f, (float)-1.6647f, (float)1.0891f, (float)3.0621f));
        PartDefinition left_r28 = left_wing.addOrReplaceChild("left_r28", CubeListBuilder.create().texOffs(4, 1).mirror().addBox(-4.8724f, 3.3725f, 3.3414f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.201f)).mirror(false), PartPose.offsetAndRotation((float)-0.55f, (float)-1.0f, (float)3.25f, (float)-1.6734f, (float)1.1325f, (float)3.0525f));
        PartDefinition left_r29 = left_wing.addOrReplaceChild("left_r29", CubeListBuilder.create().texOffs(4, 1).mirror().addBox(-4.8724f, 3.3725f, 3.3414f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.301f)).mirror(false), PartPose.offsetAndRotation((float)1.75f, (float)-1.0f, (float)1.0f, (float)-2.3211f, (float)1.4501f, (float)2.3785f));
        PartDefinition left_r30 = left_wing.addOrReplaceChild("left_r30", CubeListBuilder.create().texOffs(0, 1).mirror().addBox(-8.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.001f)).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)-1.0f, (float)3.0f, (float)-1.6647f, (float)1.0891f, (float)3.0621f));
        PartDefinition left_r31 = left_wing.addOrReplaceChild("left_r31", CubeListBuilder.create().texOffs(4, 1).mirror().addBox(-4.8724f, 3.3725f, 3.3414f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.401f)).mirror(false), PartPose.offsetAndRotation((float)0.75f, (float)-1.0f, (float)3.0f, (float)-2.3079f, (float)1.3905f, (float)2.3759f));
        PartDefinition left_r32 = left_wing.addOrReplaceChild("left_r32", CubeListBuilder.create().texOffs(1, 1).mirror().addBox(-2.8914f, 3.8079f, 3.3224f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.001f)).mirror(false), PartPose.offsetAndRotation((float)1.75f, (float)-1.0f, (float)-2.0f, (float)1.6144f, (float)0.0873f, (float)0.0f));
        PartDefinition left_r33 = left_wing.addOrReplaceChild("left_r33", CubeListBuilder.create().texOffs(2, 0).mirror().addBox(-0.8914f, 3.8079f, 2.3224f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.001f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)-3.0f, (float)1.6158f, (float)0.2616f, (float)0.0078f));
        PartDefinition right_wing = elytra.addOrReplaceChild("right_wing", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)1.0f, (float)2.0f));
        PartDefinition right_r1 = right_wing.addOrReplaceChild("right_r1", CubeListBuilder.create().texOffs(0, 1).addBox(0.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.101f)), PartPose.offsetAndRotation((float)-3.0f, (float)-1.0f, (float)8.75f, (float)-1.6576f, (float)-1.0456f, (float)-3.0703f));
        PartDefinition right_r2 = right_wing.addOrReplaceChild("right_r2", CubeListBuilder.create().texOffs(0, 1).addBox(0.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.101f)), PartPose.offsetAndRotation((float)-2.75f, (float)-1.0f, (float)8.75f, (float)-1.6973f, (float)-1.2192f, (float)-3.0265f));
        PartDefinition right_r3 = right_wing.addOrReplaceChild("right_r3", CubeListBuilder.create().texOffs(0, 1).addBox(0.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.201f)), PartPose.offsetAndRotation((float)-2.75f, (float)-1.0f, (float)8.75f, (float)-1.8926f, (float)-1.433f, (float)-2.8264f));
        PartDefinition right_r4 = right_wing.addOrReplaceChild("right_r4", CubeListBuilder.create().texOffs(0, 1).addBox(0.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.201f)), PartPose.offsetAndRotation((float)-3.0f, (float)-1.0f, (float)8.75f, (float)1.8923f, (float)-1.4328f, (float)-0.3224f));
        PartDefinition right_r5 = right_wing.addOrReplaceChild("right_r5", CubeListBuilder.create().texOffs(0, 1).addBox(0.8724f, 2.3725f, 3.3414f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.201f)), PartPose.offsetAndRotation((float)-3.0f, (float)-1.0f, (float)7.25f, (float)1.769f, (float)-1.3483f, (float)-0.1973f));
        PartDefinition right_r6 = right_wing.addOrReplaceChild("right_r6", CubeListBuilder.create().texOffs(0, 1).addBox(0.8724f, 2.3725f, 3.3414f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)-2.25f, (float)-1.0f, (float)4.75f, (float)1.6973f, (float)-1.2191f, (float)-0.1226f));
        PartDefinition right_r7 = right_wing.addOrReplaceChild("right_r7", CubeListBuilder.create().texOffs(1, 1).addBox(0.8724f, 2.3725f, 3.3414f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)-1.25f, (float)-1.0f, (float)4.0f, (float)1.6973f, (float)-1.2191f, (float)-0.1226f));
        PartDefinition right_r8 = right_wing.addOrReplaceChild("right_r8", CubeListBuilder.create().texOffs(1, 1).addBox(0.8724f, 2.3725f, 3.3414f, 7.0f, 2.0f, 1.0f, new CubeDeformation(-0.099f)), PartPose.offsetAndRotation((float)-1.0f, (float)-1.0f, (float)0.0f, (float)1.6973f, (float)-1.2191f, (float)-0.1226f));
        PartDefinition right_r9 = right_wing.addOrReplaceChild("right_r9", CubeListBuilder.create().texOffs(1, 1).addBox(2.8724f, 2.3725f, 3.3414f, 5.0f, 2.0f, 1.0f, new CubeDeformation(-0.099f)), PartPose.offsetAndRotation((float)-0.25f, (float)-1.0f, (float)-2.5f, (float)1.6973f, (float)-1.2191f, (float)-0.1226f));
        PartDefinition right_r10 = right_wing.addOrReplaceChild("right_r10", CubeListBuilder.create().texOffs(0, 0).addBox(-0.1086f, 3.8079f, 2.3224f, 3.0f, 3.0f, 2.0f, new CubeDeformation(-0.599f)), PartPose.offsetAndRotation((float)-0.25f, (float)-1.5f, (float)-6.0f, (float)1.6144f, (float)-0.0873f, (float)0.0f));
        PartDefinition right_r11 = right_wing.addOrReplaceChild("right_r11", CubeListBuilder.create().texOffs(0, 0).addBox(-0.1086f, 3.8079f, 2.3224f, 4.0f, 3.0f, 2.0f, new CubeDeformation(-0.199f)), PartPose.offsetAndRotation((float)-1.25f, (float)-1.5f, (float)-4.5f, (float)1.6144f, (float)-0.0873f, (float)0.0f));
        PartDefinition right_r12 = right_wing.addOrReplaceChild("right_r12", CubeListBuilder.create().texOffs(3, 1).addBox(-4.1086f, 3.8079f, 3.3224f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)-0.25f, (float)-1.0f, (float)-1.0f, (float)1.6144f, (float)-0.0873f, (float)0.0f));
        PartDefinition right_r13 = right_wing.addOrReplaceChild("right_r13", CubeListBuilder.create().texOffs(2, 1).addBox(0.8724f, 3.3725f, 3.3414f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)-0.7f, (float)-1.0f, (float)3.25f, (float)1.8161f, (float)-1.3909f, (float)-0.2453f));
        PartDefinition right_r14 = right_wing.addOrReplaceChild("right_r14", CubeListBuilder.create().texOffs(2, 1).addBox(0.8724f, 3.3725f, 3.3414f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)-1.2f, (float)-1.0f, (float)3.25f, (float)1.9648f, (float)-1.4574f, (float)-0.3956f));
        PartDefinition right_r15 = right_wing.addOrReplaceChild("right_r15", CubeListBuilder.create().texOffs(2, 1).addBox(0.8724f, 3.3725f, 3.3414f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.101f)), PartPose.offsetAndRotation((float)-2.0f, (float)-1.0f, (float)4.0f, (float)1.9965f, (float)-1.4654f, (float)-0.4274f));
        PartDefinition right_r16 = right_wing.addOrReplaceChild("right_r16", CubeListBuilder.create().texOffs(20, 0).addBox(2.8724f, 2.3725f, 3.3414f, 5.0f, 2.0f, 1.0f, new CubeDeformation(-0.399f)), PartPose.offsetAndRotation((float)-0.25f, (float)-1.0f, (float)-3.25f, (float)1.3802f, (float)-1.3494f, (float)0.169f));
        PartDefinition right_r17 = right_wing.addOrReplaceChild("right_r17", CubeListBuilder.create().texOffs(0, 5).addBox(0.8724f, 2.3725f, 3.3414f, 7.0f, 2.0f, 1.0f, new CubeDeformation(-0.399f)), PartPose.offsetAndRotation((float)-1.0f, (float)-1.0f, (float)-0.75f, (float)1.3802f, (float)-1.3494f, (float)0.169f));
        PartDefinition right_r18 = right_wing.addOrReplaceChild("right_r18", CubeListBuilder.create().texOffs(0, 5).addBox(0.8724f, 2.3725f, 3.3414f, 7.0f, 2.0f, 1.0f, new CubeDeformation(-0.099f)), PartPose.offsetAndRotation((float)-0.75f, (float)-1.0f, (float)3.5f, (float)1.3802f, (float)-1.3494f, (float)0.169f));
        PartDefinition right_r19 = right_wing.addOrReplaceChild("right_r19", CubeListBuilder.create().texOffs(0, 0).addBox(0.8724f, 2.3725f, 3.3414f, 8.0f, 2.0f, 1.0f, new CubeDeformation(-0.099f)), PartPose.offsetAndRotation((float)-1.5f, (float)-1.0f, (float)5.5f, (float)1.3802f, (float)-1.3494f, (float)0.169f));
        PartDefinition right_r20 = right_wing.addOrReplaceChild("right_r20", CubeListBuilder.create().texOffs(0, 0).addBox(0.8724f, 2.3725f, 3.3414f, 8.0f, 2.0f, 1.0f, new CubeDeformation(-0.099f)), PartPose.offsetAndRotation((float)-2.5f, (float)-1.0f, (float)6.25f, (float)1.1222f, (float)-1.4748f, (float)0.4298f));
        PartDefinition right_r21 = right_wing.addOrReplaceChild("right_r21", CubeListBuilder.create().texOffs(0, 3).addBox(0.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(-0.199f)), PartPose.offsetAndRotation((float)-3.0f, (float)-1.0f, (float)8.0f, (float)-1.5026f, (float)-0.9145f, (float)3.0705f));
        PartDefinition right_r22 = right_wing.addOrReplaceChild("right_r22", CubeListBuilder.create().texOffs(0, 3).addBox(0.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(-0.099f)), PartPose.offsetAndRotation((float)-2.75f, (float)-1.0f, (float)8.0f, (float)-1.4117f, (float)-1.3051f, (float)2.971f));
        PartDefinition right_r23 = right_wing.addOrReplaceChild("right_r23", CubeListBuilder.create().texOffs(0, 3).addBox(0.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(-0.199f)), PartPose.offsetAndRotation((float)-2.75f, (float)-1.0f, (float)8.0f, (float)-1.481f, (float)-1.0885f, (float)3.045f));
        PartDefinition right_r24 = right_wing.addOrReplaceChild("right_r24", CubeListBuilder.create().texOffs(0, 3).addBox(0.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(-0.099f)), PartPose.offsetAndRotation((float)-3.0f, (float)-1.0f, (float)8.0f, (float)-0.0164f, (float)-1.5292f, (float)1.5702f));
        PartDefinition right_r25 = right_wing.addOrReplaceChild("right_r25", CubeListBuilder.create().texOffs(0, 1).addBox(3.8724f, 2.3725f, 3.3414f, 5.0f, 2.0f, 1.0f, new CubeDeformation(0.201f)), PartPose.offsetAndRotation((float)0.5f, (float)-1.0f, (float)3.5f, (float)-1.6421f, (float)-0.9152f, (float)-3.0888f));
        PartDefinition right_r26 = right_wing.addOrReplaceChild("right_r26", CubeListBuilder.create().texOffs(4, 1).addBox(0.8724f, 3.3725f, 3.3414f, 4.0f, 1.0f, 1.0f, new CubeDeformation(-0.299f)), PartPose.offsetAndRotation((float)1.3f, (float)-1.0f, (float)3.0f, (float)-1.6647f, (float)-1.0891f, (float)-3.0621f));
        PartDefinition right_r27 = right_wing.addOrReplaceChild("right_r27", CubeListBuilder.create().texOffs(2, 1).addBox(0.8724f, 3.3725f, 3.3414f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)1.8f, (float)-1.0f, (float)3.25f, (float)-1.6647f, (float)-1.0891f, (float)-3.0621f));
        PartDefinition right_r28 = right_wing.addOrReplaceChild("right_r28", CubeListBuilder.create().texOffs(4, 1).addBox(0.8724f, 3.3725f, 3.3414f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.201f)), PartPose.offsetAndRotation((float)0.55f, (float)-1.0f, (float)3.25f, (float)-1.6734f, (float)-1.1325f, (float)-3.0525f));
        PartDefinition right_r29 = right_wing.addOrReplaceChild("right_r29", CubeListBuilder.create().texOffs(4, 1).addBox(0.8724f, 3.3725f, 3.3414f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.301f)), PartPose.offsetAndRotation((float)-1.75f, (float)-1.0f, (float)1.0f, (float)-2.3211f, (float)-1.4501f, (float)-2.3785f));
        PartDefinition right_r30 = right_wing.addOrReplaceChild("right_r30", CubeListBuilder.create().texOffs(0, 1).addBox(0.8724f, 3.3725f, 3.3414f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)3.0f, (float)-1.0f, (float)3.0f, (float)-1.6647f, (float)-1.0891f, (float)-3.0621f));
        PartDefinition right_r31 = right_wing.addOrReplaceChild("right_r31", CubeListBuilder.create().texOffs(4, 1).addBox(-0.1276f, 3.3725f, 3.3414f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.401f)), PartPose.offsetAndRotation((float)-0.75f, (float)-1.0f, (float)3.0f, (float)-2.3079f, (float)-1.3905f, (float)-2.3759f));
        PartDefinition right_r32 = right_wing.addOrReplaceChild("right_r32", CubeListBuilder.create().texOffs(1, 1).addBox(-3.1086f, 3.8079f, 3.3224f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)-1.75f, (float)-1.0f, (float)-2.0f, (float)1.6144f, (float)-0.0873f, (float)0.0f));
        PartDefinition right_r33 = right_wing.addOrReplaceChild("right_r33", CubeListBuilder.create().texOffs(2, 0).addBox(-5.1086f, 3.8079f, 2.3224f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)-3.0f, (float)1.6158f, (float)-0.2616f, (float)-0.0078f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    public static LayerDefinition dragon() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition upper_body = partdefinition.addOrReplaceChild("upper_body", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition elytra_rot = upper_body.addOrReplaceChild("elytra_rot", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-3.75f, (float)-0.25f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition elytra = elytra_rot.addOrReplaceChild("elytra", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing = elytra.addOrReplaceChild("left_wing", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)1.0f, (float)2.0f));
        PartDefinition cube_r1 = left_wing.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(14.745f, 0.8961f, 2.389f, 14.0f, 0.0f, 14.0f, new CubeDeformation(0.002f)).mirror(false).texOffs(0, 14).mirror().addBox(0.745f, 0.8961f, 2.389f, 14.0f, 0.0f, 14.0f, new CubeDeformation(0.002f)).mirror(false).texOffs(0, 28).addBox(0.745f, 0.1461f, 0.889f, 14.0f, 2.0f, 2.0f, new CubeDeformation(0.002f)).texOffs(0, 32).addBox(14.745f, 0.4961f, 1.389f, 14.0f, 1.0f, 1.0f, new CubeDeformation(0.002f)), PartPose.offsetAndRotation((float)2.7227f, (float)-4.875f, (float)-1.3808f, (float)0.0307f, (float)-0.8099f, (float)0.1613f));
        PartDefinition right_wing = elytra.addOrReplaceChild("right_wing", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)1.0f, (float)2.0f));
        PartDefinition cube_r2 = right_wing.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 0).addBox(-28.745f, 0.8961f, 2.389f, 14.0f, 0.0f, 14.0f, new CubeDeformation(0.002f)).texOffs(0, 14).addBox(-14.745f, 0.8961f, 2.389f, 14.0f, 0.0f, 14.0f, new CubeDeformation(0.002f)).texOffs(0, 28).mirror().addBox(-14.745f, 0.1461f, 0.889f, 14.0f, 2.0f, 2.0f, new CubeDeformation(0.002f)).mirror(false).texOffs(0, 32).mirror().addBox(-28.745f, 0.4961f, 1.389f, 14.0f, 1.0f, 1.0f, new CubeDeformation(0.002f)).mirror(false), PartPose.offsetAndRotation((float)-2.7227f, (float)-4.875f, (float)-1.3808f, (float)0.0307f, (float)0.8099f, (float)-0.1613f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)50, (int)50);
    }
}

