/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.AmnesiaBoneScreen.element.view.GeneralView;

import doggytalents.api.feature.DogSize;
import doggytalents.client.entity.render.DogScreenOverlays;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.common.entity.Dog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.StatFormatter;

public class DogStatusViewBoxElement
extends AbstractElement {
    private Dog dog;
    private Font font;

    public DogStatusViewBoxElement(AbstractElement parent, Screen screen, Dog dog) {
        super(parent, screen);
        this.dog = dog;
        Minecraft mc = this.getScreen().getMinecraft();
        this.font = mc.font;
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int e_mX = this.getRealX() + this.getSizeX() / 2;
        int e_mY = this.getRealY() + this.getSizeY() / 2;
        DogStatusViewBoxElement.renderDogInside(graphics, this.dog, e_mX, e_mY + 32, 50, e_mX - mouseX, e_mY - mouseY);
        this.renderHealthBar(graphics, this.dog, e_mX - 41, this.getRealY() + this.getSizeY() - 10);
        int points = this.dog.getSpendablePoints();
        graphics.drawString(this.font, "Pts: " + points, this.getRealX(), this.getRealY(), -1);
    }

    public static void renderDogInside(GuiGraphics graphics, Dog dog, int dog_mX, int dog_mY, int size, int lookX, int lookY) {
        boolean dogTooBig;
        DogSize currentDogSize = dog.getDogSize();
        boolean bl = dogTooBig = currentDogSize.getId() > DogSize.MODERATO.getId();
        if (dogTooBig) {
            dog.setDogSize(DogSize.MODERATO);
        }
        Component currentDogName = dog.getCustomName();
        String currentDogNameStr = "";
        boolean nameTooLong = false;
        if (currentDogName != null) {
            currentDogNameStr = currentDogName.getString();
            boolean bl2 = nameTooLong = currentDogNameStr.length() > 14;
        }
        if (nameTooLong) {
            String tempName = currentDogNameStr.substring(0, 13) + " ..";
            dog.setDogCustomName((Component)Component.literal((String)tempName));
        }
        ScreenUtil.renderEntityInInventoryFollowsMouse(graphics, dog_mX, dog_mY, size, lookX, lookY, dog);
        if (nameTooLong) {
            dog.setDogCustomName(currentDogName);
        }
        if (dogTooBig) {
            dog.setDogSize(currentDogSize);
        }
    }

    public void renderHealthBar(GuiGraphics graphics, Dog dog, int x, int y) {
        int pX = x;
        int pY = y;
        String healthStr = " x " + StatFormatter.DECIMAL_FORMAT.format(dog.getHealth()) + "/" + (int)dog.getMaxHealth();
        graphics.blit(DogScreenOverlays.GUI_ICONS_LOCATION, pX += (80 - (8 + this.font.width(healthStr))) / 2, pY, 16, 0, 9, 9);
        graphics.blit(DogScreenOverlays.GUI_ICONS_LOCATION, pX, pY, 52, 0, 9, 9);
        graphics.drawString(this.font, healthStr, pX += 9, ++pY, -1);
    }
}

