/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.EntityUtil;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;

public class DogBreedGoal
extends Goal {
    private static final TargetingConditions breedPredicate = TargetingConditions.forNonCombat().range(8.0).ignoreLineOfSight();
    private final Dog dog;
    private final Level world;
    private final double moveSpeed;
    protected Dog targetMate;
    private int spawnBabyDelay;

    public DogBreedGoal(Dog dog, double moveSpeed) {
        this.dog = dog;
        this.world = dog.level();
        this.moveSpeed = moveSpeed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.dog.isDoingFine()) {
            return false;
        }
        if (!this.dog.isInLove()) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean canContinueToUse() {
        if (!this.dog.isDoingFine()) {
            return false;
        }
        if (!this.targetMate.isDoingFine()) {
            return false;
        }
        return this.targetMate.isInLove() && this.spawnBabyDelay < 60;
    }

    public void stop() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void tick() {
        this.dog.getLookControl().setLookAt((Entity)this.targetMate, 10.0f, (float)this.dog.getMaxHeadXRot());
        this.dog.getNavigation().moveTo((Entity)this.targetMate, this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.dog.distanceToSqr((Entity)this.targetMate) < 9.0) {
            this.dog.spawnChildFromBreeding((ServerLevel)this.world, (Animal)this.targetMate);
        }
    }

    @Nullable
    private Dog getNearbyMate() {
        List entities = this.world.getEntitiesOfClass(Dog.class, this.dog.getBoundingBox().inflate(8.0), this::filterEntities);
        return (Dog)EntityUtil.getClosestTo((Entity)this.dog, entities);
    }

    private boolean filterEntities(Dog dog) {
        return breedPredicate.test((LivingEntity)this.dog, (LivingEntity)dog) && this.dog.canMate((Animal)dog);
    }
}

