/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.event;

import doggytalents.DogVariants;
import doggytalents.DoggyAccessories;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogDuplicationDetection;
import doggytalents.common.entity.DogSleepOnManager;
import doggytalents.common.entity.ai.WolfBegAtTreatGoal;
import doggytalents.common.entity.ai.triggerable.DogBackFlipAction;
import doggytalents.common.entity.ai.triggerable.DogPlayTagAction;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.TrainWolfToDogData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.talent.PackPuppyTalent;
import doggytalents.common.util.DogLocationStorageMigration;
import doggytalents.common.util.LangUtil;
import doggytalents.common.util.dogpromise.DogPromiseManager;
import doggytalents.common.util.dogpromise.chunk.DTNForcedChunkManager;
import doggytalents.common.util.dogpromise.promise.DogBatchTeleportToDimensionPromise;
import doggytalents.common.util.dogpromise.promise.DogHoldChunkToTeleportPromise;
import doggytalents.common.variant.DogVariant;
import doggytalents.common.variant.util.DogVariantUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.animal.WolfVariants;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class EventHandler {
    public final int COLLECT_RADIUS = 26;
    public final int MIN_DISTANCE_TO_TRIGGER_TELEPORT_SQR = 400;

    @SubscribeEvent
    public void onServerTickEnd(ServerTickEvent.Post event) {
        DogPromiseManager.tick();
        DogLocationStorage.get(event.getServer()).getOnlineDogsManager().tick();
        DogSleepOnManager.tickServer(event.getServer());
    }

    @SubscribeEvent
    public void onServerStop(ServerStoppingEvent event) {
        DogPromiseManager.forceStop();
        DTNForcedChunkManager.onServerStop();
        ServerLevel overworld = event.getServer().getLevel(Level.OVERWORLD);
        if (overworld != null) {
            DogLocationStorage.get((Level)overworld).onServerStop(event);
        }
        DogSleepOnManager.onServerStop(event.getServer());
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
        ServerLevel overworld = event.getServer().getLevel(Level.OVERWORLD);
        if (overworld != null) {
            DogLocationStorage.get((Level)overworld).onServerStopped(event);
        }
    }

    @SubscribeEvent
    public void onWolfRightClickWithTreat(PlayerInteractEvent.EntityInteract event) {
        Level level = event.getLevel();
        ItemStack stack = event.getItemStack();
        Entity target = event.getTarget();
        Player owner = event.getEntity();
        if (stack.getItem() != DoggyItems.TRAINING_TREAT.get()) {
            return;
        }
        if (!(target instanceof Wolf)) {
            return;
        }
        Wolf wolf = (Wolf)target;
        event.setCanceled(true);
        if (!EventHandler.checkValidWolf(wolf, owner)) {
            event.setCancellationResult(InteractionResult.FAIL);
            return;
        }
        if (level.isClientSide) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new TrainWolfToDogData(wolf.getId(), wolf.yBodyRot, wolf.yHeadRot));
        }
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    public static void checkAndTrainWolf(Player trainer, Wolf wolf, float yBodyRot, float yHeadRot) {
        Level level = trainer.level();
        if (level.isClientSide) {
            return;
        }
        ItemStack stack = trainer.getMainHandItem();
        if (stack.getItem() != DoggyItems.TRAINING_TREAT.get()) {
            return;
        }
        if (!EventHandler.checkValidWolf(wolf, trainer)) {
            return;
        }
        if (!EventHandler.isWithinTrainWolfLimit(trainer)) {
            level.broadcastEntityEvent((Entity)wolf, (byte)6);
            return;
        }
        if (!trainer.getAbilities().instabuild) {
            stack.shrink(1);
        }
        EventHandler.tameWolfIfNeccessary(wolf, trainer);
        EventHandler.rotateWolfIfNecceassary(wolf, yHeadRot, yBodyRot);
        EventHandler.trainWolf(wolf, trainer, level);
    }

    private static void rotateWolfIfNecceassary(Wolf wolf, float yHeadRot, float yBodyRot) {
        float wanted_yBodyRot = yHeadRot;
        float wanted_dYBodyRot = Mth.degreesDifference((float)yBodyRot, (float)wanted_yBodyRot);
        float approaching_dYBodyRot = Mth.clamp((float)wanted_dYBodyRot, (float)-25.0f, (float)25.0f);
        float approaching_yBodyRot = yBodyRot + approaching_dYBodyRot;
        wolf.yBodyRot = approaching_yBodyRot = Mth.wrapDegrees((float)approaching_yBodyRot);
    }

    private static boolean checkValidWolf(Wolf wolf, Player owner) {
        if (!wolf.isAlive()) {
            return false;
        }
        boolean trainUntamed = (Boolean)ConfigHandler.SERVER.DISABLE_TRAIN_UNTAMED_WOLF.get() == false;
        boolean condition1 = trainUntamed && !wolf.isTame();
        boolean condition2 = wolf.isTame() && wolf.isOwnedBy((LivingEntity)owner);
        return condition1 || condition2;
    }

    public static boolean isWithinTrainWolfLimit(Player owner) {
        int respawnCnt;
        int limit = (Integer)ConfigHandler.SERVER.TRAIN_WOLF_LIMIT.get();
        if (limit <= 0) {
            return true;
        }
        MinecraftServer server = owner.level().getServer();
        DogLocationStorage locStore = DogLocationStorage.get(server);
        DogRespawnStorage respawnStore = DogRespawnStorage.get(server);
        int locCnt = locStore.getDogs((LivingEntity)owner).collect(Collectors.toList()).size();
        int totalTrained = locCnt + (respawnCnt = respawnStore.getDogs(owner.getUUID()).collect(Collectors.toList()).size());
        return totalTrained < limit;
    }

    public static void tameWolfIfNeccessary(Wolf wolf, Player owner) {
        if (wolf.isTame()) {
            return;
        }
        wolf.tame(owner);
    }

    public static void trainWolf(Wolf wolf, Player owner, Level level) {
        Dog dog = (Dog)DoggyEntityTypes.DOG.get().create(level);
        if (dog == null) {
            throw new IllegalStateException("Creator function for the dog returned \"null\"");
        }
        dog.setTame(true, true);
        dog.setOwnerUUID(owner.getUUID());
        dog.maxHealth();
        dog.setOrderedToSit(false);
        dog.setAge(wolf.getAge());
        dog.moveTo(wolf.getX(), wolf.getY(), wolf.getZ(), wolf.getYRot(), wolf.getXRot());
        dog.setYHeadRot(wolf.yBodyRot);
        dog.setYBodyRot(wolf.yBodyRot);
        dog.setYRot(wolf.yBodyRot);
        DyeColor wolf_collar_color = wolf.getCollarColor();
        int color = wolf_collar_color.getTextureDiffuseColor();
        AccessoryInstance dog_collar = DoggyAccessories.DYEABLE_COLLAR_THICC.get().create(color);
        if (dog_collar != null) {
            dog.addAccessory(dog_collar);
        }
        EventHandler.migrateWolfVariant(wolf, dog);
        EventHandler.migrateWolfArmor(wolf, dog);
        if (wolf.hasCustomName()) {
            dog.setDogCustomName(wolf.getCustomName());
        }
        UUID wolf_uuid = wolf.getUUID();
        wolf.discard();
        if (level instanceof ServerLevel) {
            ServerLevel sL = (ServerLevel)level;
            EventHandler.migrateUUID(wolf_uuid, dog, sL);
        }
        level.addFreshEntity((Entity)dog);
        dog.triggerAnimationAction(new DogBackFlipAction(dog));
    }

    private static void migrateUUID(UUID uuid, Dog dog, ServerLevel level) {
        if (((Boolean)ConfigHandler.SERVER.DISABLE_PRESERVE_UUID.get()).booleanValue()) {
            return;
        }
        if (level.getEntity(uuid) != null) {
            return;
        }
        dog.setUUID(uuid);
    }

    private static void migrateWolfVariant(Wolf wolf, Dog dog) {
        boolean random_var_on_pale;
        DogVariant dog_variant = DogVariantUtil.fromVanila((ResourceKey<WolfVariant>)wolf.getVariant().unwrapKey().orElse(WolfVariants.PALE));
        boolean bl = random_var_on_pale = dog_variant == DogVariantUtil.getDefault() && (Boolean)ConfigHandler.SERVER.RANDOM_VAR_ON_PALE.get() != false;
        if (random_var_on_pale) {
            List<DogVariant> vanilla_variants = List.of(DogVariants.PALE.get(), DogVariants.RUSTY.get(), DogVariants.WOOD.get(), DogVariants.CHESTNUT.get(), DogVariants.STRIPED.get(), DogVariants.ASHEN.get(), DogVariants.SNOWY.get(), DogVariants.SPOTTED.get(), DogVariants.BLACK.get());
            dog_variant = LangUtil.getRandomItem(wolf.getRandom(), vanilla_variants).get();
        }
        dog.setDogVariant(dog_variant);
    }

    private static void migrateWolfArmor(Wolf wolf, Dog dog) {
        if (!wolf.hasArmor()) {
            return;
        }
        ItemStack armor_stack = wolf.getBodyArmorItem().copyWithCount(1);
        dog.setWolfArmor(armor_stack);
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        Level level = entity.level();
        if (level.isClientSide) {
            return;
        }
        if (entity instanceof AbstractSkeleton) {
            AbstractSkeleton skeleton = (AbstractSkeleton)entity;
            skeleton.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)skeleton, Dog.class, 6.0f, 1.0, 1.2));
        } else if (entity instanceof Wolf) {
            Wolf \u5927\u795e = (Wolf)entity;
            \u5927\u795e.goalSelector.addGoal(9, (Goal)new WolfBegAtTreatGoal(\u5927\u795e, 8.0f));
        }
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        if (this.isEnableStarterBundle()) {
            CompoundTag persistTag;
            Player player = event.getEntity();
            CompoundTag tag = player.getPersistentData();
            if (!tag.contains("PlayerPersisted")) {
                tag.put("PlayerPersisted", (Tag)new CompoundTag());
            }
            if (!(persistTag = tag.getCompound("PlayerPersisted")).getBoolean("gotDTStartingItems")) {
                persistTag.putBoolean("gotDTStartingItems", true);
                player.getInventory().add(new ItemStack((ItemLike)DoggyItems.STARTER_BUNDLE.get()));
            }
        }
    }

    private boolean isEnableStarterBundle() {
        MutableBoolean retMut = new MutableBoolean(false);
        if (FMLEnvironment.dist == Dist.CLIENT && ((Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.ENABLE_STARTER_BUNDLE_BY_DEFAULT)).booleanValue()) {
            retMut.setTrue();
        }
        if (retMut.getValue().booleanValue()) {
            return true;
        }
        return (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.STARTING_ITEMS);
    }

    @SubscribeEvent
    public void onProjectileHit(ProjectileImpactEvent event) {
        Projectile levelChecker = event.getProjectile();
        if (levelChecker == null) {
            return;
        }
        Level level = levelChecker.level();
        if (level.isClientSide) {
            return;
        }
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult hitEntity = (EntityHitResult)hitResult;
            this.proccessEntityProjectileHitEvent(event, hitEntity);
        } else if (hitResult instanceof BlockHitResult) {
            BlockHitResult hitBlock = (BlockHitResult)hitResult;
            this.proccessBlockProjectileHitEvent(event, hitBlock);
        }
    }

    private void proccessEntityProjectileHitEvent(ProjectileImpactEvent event, EntityHitResult hit) {
        Entity entity = hit.getEntity();
        if (entity instanceof Dog) {
            Dog dog = (Dog)entity;
            this.proccessDogProjectileHitEvent(event, hit, dog);
        }
    }

    private void proccessDogProjectileHitEvent(ProjectileImpactEvent event, EntityHitResult hit, Dog dog) {
        Projectile projectile = event.getProjectile();
        Entity projectileOnwer = projectile.getOwner();
        if (projectileOnwer == null) {
            return;
        }
        LivingEntity dogOwner = dog.getOwner();
        if (projectile instanceof Snowball) {
            if (projectileOnwer == dogOwner && ((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.PLAY_TAG_WITH_DOG)).booleanValue() && !dog.isBusy() && !dog.isOrderedToSit()) {
                dog.triggerAction(new DogPlayTagAction(dog, dogOwner));
            }
            return;
        }
    }

    private void proccessBlockProjectileHitEvent(ProjectileImpactEvent event, BlockHitResult hit) {
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof ThrownEgg)) {
            return;
        }
        Level level = projectile.level();
        BlockPos pos = hit.getBlockPos();
        Direction dir = hit.getDirection();
        if (dir != Direction.UP) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        if (!state.is(Blocks.WATER_CAULDRON)) {
            return;
        }
        BlockState state_under = level.getBlockState(pos.below());
        if (!WalkNodeEvaluator.isBurningBlock((BlockState)state_under)) {
            return;
        }
        ItemStack resultStack = new ItemStack((ItemLike)DoggyItems.ONSEN_TAMAGO.get());
        ItemEntity resultEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, resultStack);
        level.addFreshEntity((Entity)resultEntity);
        projectile.playSound(SoundEvents.TURTLE_EGG_CRACK, 0.5f, 0.9f + level.random.nextFloat() * 0.2f);
    }

    @SubscribeEvent
    public void onEntityChangeDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (entity.level().isClientSide) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer owner = (ServerPlayer)entity;
            this.onOwnerChangeDimension(event, owner);
        }
    }

    private void onOwnerChangeDimension(EntityTravelToDimensionEvent event, ServerPlayer owner) {
        Level level = owner.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        MinecraftServer mcServer = sLevel.getServer();
        ServerLevel fromLevel = sLevel;
        ServerLevel toLevel = mcServer.getLevel(event.getDimension());
        if (fromLevel == toLevel) {
            return;
        }
        List crossOriginTpList = fromLevel.getEntitiesOfClass(Dog.class, owner.getBoundingBox().inflate(26.0, 4.0, 26.0), d -> this.isDogReadyToTeleport((Dog)d, (LivingEntity)owner));
        if (crossOriginTpList.isEmpty()) {
            return;
        }
        DogPromiseManager.addPromiseWithOwnerAndStartImmediately(new DogBatchTeleportToDimensionPromise(crossOriginTpList, fromLevel, owner.getUUID(), (ResourceKey<Level>)event.getDimension(), d -> this.isDogReadyToTeleport((Dog)d, (LivingEntity)owner)), owner);
    }

    @SubscribeEvent
    public void onOwnerTeleport(EntityTeleportEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer owner = (ServerPlayer)entity;
        Level level = owner.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        if (this.distanceTooShortToTeleport(event.getPrev(), event.getTarget())) {
            return;
        }
        List crossOriginTpList = sLevel.getEntitiesOfClass(Dog.class, owner.getBoundingBox().inflate(26.0, 4.0, 26.0), d -> this.isDogReadyToTeleport((Dog)d, (LivingEntity)owner));
        if (crossOriginTpList.isEmpty()) {
            return;
        }
        DogPromiseManager.addPromiseWithOwnerAndStartImmediately(new DogHoldChunkToTeleportPromise(crossOriginTpList, sLevel), owner);
    }

    private boolean isDogReadyToTeleport(Dog dog, LivingEntity owner) {
        if (!dog.isDoingFine()) {
            return false;
        }
        if (owner == null || dog.getOwnerUUID() == null) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)dog.getOwnerUUID(), (Object)owner.getUUID())) {
            return false;
        }
        if (dog.isOrderedToSit()) {
            return false;
        }
        if (!dog.getMode().shouldFollowOwner()) {
            return false;
        }
        return dog.crossOriginTp();
    }

    private boolean distanceTooShortToTeleport(Vec3 from, Vec3 to) {
        return from.distanceToSqr(to) < 400.0;
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDropsEvent event) {
        PackPuppyTalent.mayNotifyNearbyPackPuppy(event);
    }

    @SubscribeEvent
    public void onTagsUpdated(TagsUpdatedEvent event) {
        DogBedMaterialManager.onTagsUpdated(event);
    }

    @SubscribeEvent
    public void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor level = event.getLevel();
        if (level == null) {
            return;
        }
        MinecraftServer server = level.getServer();
        if (server == null) {
            return;
        }
        ServerLevel level_overworld = server.getLevel(Level.OVERWORLD);
        if (level != level_overworld) {
            return;
        }
        DogLocationStorageMigration.checkAndMigrate(level_overworld);
    }

    @SubscribeEvent
    public void onLivingHurt(LivingDamageEvent.Pre event) {
        this.onDogPassenegerHurtInWall(event);
    }

    public void onDogPassenegerHurtInWall(LivingDamageEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (!entity.isPassenger()) {
            return;
        }
        DamageSource source = event.getContainer().getSource();
        if (!source.is(DamageTypes.IN_WALL)) {
            return;
        }
        Entity vehicle = entity.getVehicle();
        if (!(vehicle instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)vehicle;
        event.getContainer().setNewDamage(0.0f);
    }

    @SubscribeEvent
    public void onWolfSetTarget(LivingChangeTargetEvent event) {
        LivingEntity entity = event.getEntity();
        if (!((Boolean)ConfigHandler.SERVER.PREVENT_WILD_WOLVES_ANGRY.get()).booleanValue()) {
            return;
        }
        if (!(entity instanceof Wolf)) {
            return;
        }
        Wolf \u5927\u795e = (Wolf)entity;
        if (\u5927\u795e.isTame()) {
            return;
        }
        LivingEntity new_target = event.getNewAboutToBeSetTarget();
        if (!(new_target instanceof Player)) {
            return;
        }
        event.setCanceled(true);
    }

    public static void onWolfTame(Wolf wolf) {
        if (!((Boolean)ConfigHandler.SERVER.TAMED_WOLF_NON_MOB_CAP.get()).booleanValue()) {
            return;
        }
        wolf.setPersistenceRequired();
    }

    @SubscribeEvent
    public void canPlayerContinueSleeping(CanContinueSleepingEvent event) {
        DogSleepOnManager.canPlayerContinueSleeping(event);
    }

    @SubscribeEvent
    public void beforeAllPlayerWakeUp(SleepFinishedTimeEvent event) {
        DogSleepOnManager.beforeSleepFinishedForAllPlayer(event);
    }

    @SubscribeEvent
    public void playerWakeUpEvent(PlayerWakeUpEvent event) {
        if (!event.getEntity().level().isClientSide) {
            DogSleepOnManager.onPlayerWakeUp(event.getEntity());
        }
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        if (!player.isVehicle()) {
            return;
        }
        ArrayList<Dog> dog_list = new ArrayList<Dog>();
        for (Entity passenger : player.getPassengers()) {
            if (passenger.getType() != DoggyEntityTypes.DOG.get() || !(passenger instanceof Dog)) continue;
            Dog dog = (Dog)passenger;
            dog_list.add(dog);
        }
        for (Dog dog : dog_list) {
            dog.stopRiding();
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        DogDuplicationDetection.beforeEntityJoinLevel(event);
    }
}

