/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.DoggyRegistries;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.variant.DogVariant;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;

public class NetworkUtil {
    public static StreamCodec<RegistryFriendlyByteBuf, Talent> TALENT_STREAM_CODEC = ByteBufCodecs.registry(DoggyRegistries.Keys.TALENTS_REGISTRY);
    public static StreamCodec<RegistryFriendlyByteBuf, Accessory> ACCESSORY_CODEC = ByteBufCodecs.registry(DoggyRegistries.Keys.ACCESSORIES_REGISTRY);
    public static StreamCodec<RegistryFriendlyByteBuf, DogVariant> DOG_VARIANT_CODEC = ByteBufCodecs.registry(DoggyRegistries.Keys.DOG_VARIANT);
    public static StreamCodec<RegistryFriendlyByteBuf, TalentOption<?>> TALENT_OPTION_CODEC = ByteBufCodecs.registry(DoggyRegistries.Keys.TALENT_OPTION);
    public static StreamCodec<RegistryFriendlyByteBuf, SoundEvent> SOUND_EVENT_CODEC = ByteBufCodecs.registry((ResourceKey)Registries.SOUND_EVENT);

    public static void writeTalentToBuf(FriendlyByteBuf buf, Talent val) {
        RegistryFriendlyByteBuf reg_buf = (RegistryFriendlyByteBuf)buf;
        TALENT_STREAM_CODEC.encode((Object)reg_buf, (Object)val);
    }

    public static Talent readTalentFromBuf(FriendlyByteBuf buf) {
        RegistryFriendlyByteBuf reg_buf = (RegistryFriendlyByteBuf)buf;
        return (Talent)TALENT_STREAM_CODEC.decode((Object)reg_buf);
    }

    public static void writeAccessoryToBuf(FriendlyByteBuf buf, Accessory val) {
        RegistryFriendlyByteBuf reg_buf = (RegistryFriendlyByteBuf)buf;
        ACCESSORY_CODEC.encode((Object)reg_buf, (Object)val);
    }

    public static Accessory readAccessoryFromBuf(FriendlyByteBuf buf) {
        RegistryFriendlyByteBuf reg_buf = (RegistryFriendlyByteBuf)buf;
        return (Accessory)ACCESSORY_CODEC.decode((Object)reg_buf);
    }

    public static void writeTalentOptionToBuf(FriendlyByteBuf buf, TalentOption<?> val) {
        RegistryFriendlyByteBuf reg_buf = (RegistryFriendlyByteBuf)buf;
        TALENT_OPTION_CODEC.encode((Object)reg_buf, val);
    }

    public static TalentOption<?> readTalentOptionFromBuf(FriendlyByteBuf buf) {
        RegistryFriendlyByteBuf reg_buf = (RegistryFriendlyByteBuf)buf;
        return (TalentOption)TALENT_OPTION_CODEC.decode((Object)reg_buf);
    }

    public static void writeItemToBuf(FriendlyByteBuf buf, ItemStack stack) {
        RegistryFriendlyByteBuf reg_buf = (RegistryFriendlyByteBuf)buf;
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)reg_buf, (Object)stack);
    }

    public static ItemStack readItemFromBuf(FriendlyByteBuf buf) {
        RegistryFriendlyByteBuf reg_buf = (RegistryFriendlyByteBuf)buf;
        return (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)reg_buf);
    }

    public static <T> void writeRegistryId(FriendlyByteBuf buf, ResourceKey<Registry<T>> regKey, T val) {
        RegistryFriendlyByteBuf regBuf = (RegistryFriendlyByteBuf)buf;
        Registry reg = regBuf.registryAccess().registryOrThrow(regKey);
        int id = reg.getIdOrThrow(val);
        regBuf.writeInt(id);
    }

    public static <T> T readRegistryId(FriendlyByteBuf buf, ResourceKey<Registry<T>> regKey) {
        RegistryFriendlyByteBuf regBuf = (RegistryFriendlyByteBuf)buf;
        Registry reg = regBuf.registryAccess().registryOrThrow(regKey);
        int id = regBuf.readInt();
        return (T)reg.byIdOrThrow(id);
    }

    public static void writeDogVariantToBuf(FriendlyByteBuf buf, DogVariant val) {
        RegistryFriendlyByteBuf reg_buf = (RegistryFriendlyByteBuf)buf;
        DOG_VARIANT_CODEC.encode((Object)reg_buf, (Object)val);
    }

    public static DogVariant readDogVariantFromBuf(FriendlyByteBuf buf) {
        RegistryFriendlyByteBuf reg_buf = (RegistryFriendlyByteBuf)buf;
        return (DogVariant)DOG_VARIANT_CODEC.decode((Object)reg_buf);
    }

    public static void writeSoundEventToBuf(FriendlyByteBuf buf, SoundEvent val) {
        RegistryFriendlyByteBuf reg_buf = (RegistryFriendlyByteBuf)buf;
        SOUND_EVENT_CODEC.encode((Object)reg_buf, (Object)val);
    }

    public static SoundEvent readSoundEventFromBuf(FriendlyByteBuf buf) {
        RegistryFriendlyByteBuf reg_buf = (RegistryFriendlyByteBuf)buf;
        return (SoundEvent)SOUND_EVENT_CODEC.decode((Object)reg_buf);
    }
}

