/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.common.entity.Dog;
import doggytalents.common.fabric_helper.entity.network.container_sync.data.BlockPosData;
import doggytalents.common.fabric_helper.entity.network.container_sync.data.IntArrayData;
import doggytalents.common.fabric_helper.entity.network.container_sync.data.IntData;
import doggytalents.common.fabric_helper.entity.network.container_sync.data.ItemAndSlotData;
import doggytalents.common.inventory.container.DogArmorContainer;
import doggytalents.common.inventory.container.DogInventoriesContainer;
import doggytalents.common.inventory.container.DoggyToolsMenu;
import doggytalents.common.inventory.container.FoodBowlContainer;
import doggytalents.common.inventory.container.PackPuppyContainer;
import doggytalents.common.inventory.container.RiceMillMenu;
import doggytalents.common.inventory.container.TreatBagContainer;
import doggytalents.forge_imitate.registry.DeferredRegister;
import doggytalents.forge_imitate.registry.RegistryObject;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1297;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class DoggyContainerTypes {
    public static final DeferredRegister<class_3917<?>> CONTAINERS = DeferredRegister.create(() -> class_7923.field_41187, "doggytalents");
    public static final RegistryObject<class_3917<FoodBowlContainer>> FOOD_BOWL = DoggyContainerTypes.register("food_bowl", BlockPosData.class, (windowId, inv, data) -> {
        class_2338 pos = data.val;
        return new FoodBowlContainer(windowId, inv.field_7546.method_37908(), pos, inv, inv.field_7546);
    }, BlockPosData.CODEC);
    public static final RegistryObject<class_3917<PackPuppyContainer>> PACK_PUPPY = DoggyContainerTypes.register("pack_puppy", IntData.class, (windowId, inv, data) -> {
        class_1297 entity = inv.field_7546.method_37908().method_8469(data.val);
        return entity instanceof Dog ? new PackPuppyContainer(windowId, inv, (Dog)entity) : null;
    }, IntData.CODEC);
    public static final Supplier<class_3917<TreatBagContainer>> TREAT_BAG = DoggyContainerTypes.register("treat_bag", ItemAndSlotData.class, (windowId, inv, data) -> {
        int slotId = data.slot;
        return new TreatBagContainer(windowId, inv, slotId, data.val);
    }, ItemAndSlotData.CODEC);
    public static final RegistryObject<class_3917<DogInventoriesContainer>> DOG_INVENTORIES = DoggyContainerTypes.register("dog_inventories", IntArrayData.class, (windowId, inv, data) -> {
        int noDogs = data.val.size();
        ArrayList<Dog> dogs = new ArrayList<Dog>(noDogs);
        for (int i = 0; i < noDogs; ++i) {
            class_1297 entity = inv.field_7546.method_37908().method_8469(data.val.get(i).intValue());
            if (!(entity instanceof Dog)) continue;
            dogs.add((Dog)entity);
        }
        return !dogs.isEmpty() ? new DogInventoriesContainer(windowId, inv, dogs) : null;
    }, IntArrayData.CODEC);
    public static final RegistryObject<class_3917<DogArmorContainer>> DOG_ARMOR = DoggyContainerTypes.register("dog_armor", IntData.class, (windowId, inv, data) -> {
        int dogId = data.val;
        class_1297 e = inv.field_7546.method_37908().method_8469(dogId);
        if (!(e instanceof Dog)) {
            return null;
        }
        return new DogArmorContainer(windowId, inv, (Dog)e);
    }, IntData.CODEC);
    public static final RegistryObject<class_3917<DoggyToolsMenu>> DOG_TOOLS = DoggyContainerTypes.register("dog_tools", IntData.class, (windowId, inv, data) -> {
        int dogId = data.val;
        class_1297 e = inv.field_7546.method_37908().method_8469(dogId);
        if (!(e instanceof Dog)) {
            return null;
        }
        return new DoggyToolsMenu(windowId, inv, (Dog)e);
    }, IntData.CODEC);
    public static final RegistryObject<class_3917<RiceMillMenu>> RICE_MILL = DoggyContainerTypes.register("rice_mill", BlockPosData.class, (windowId, inv, data) -> {
        class_2338 pos = data.val;
        return new RiceMillMenu(windowId, inv, pos);
    }, BlockPosData.CODEC);

    private static <X extends class_1703, D> RegistryObject<class_3917<X>> register(String name, Class<D> dataType, ExtendedScreenHandlerType.ExtendedFactory<X, D> factory, class_9139<class_9129, D> codec) {
        return DoggyContainerTypes.register(name, () -> new ExtendedScreenHandlerType(factory, codec));
    }

    private static <T extends class_3917<?>> RegistryObject<T> register(String name, Supplier<T> sup) {
        return CONTAINERS.register(name, sup);
    }
}

