/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import org.joml.Vector3f;

public abstract class SyncedAccessoryModel
extends class_583<Dog> {
    public final class_630 root;
    private Vector3f pivot = DogModel.DEFAULT_ROOT_PIVOT;
    public Optional<class_630> head = Optional.empty();
    public Optional<class_630> realHead = Optional.empty();
    public Optional<class_630> body = Optional.empty();
    public Optional<class_630> mane = Optional.empty();
    public Optional<class_630> legBackRight = Optional.empty();
    public Optional<class_630> legBackLeft = Optional.empty();
    public Optional<class_630> legFrontRight = Optional.empty();
    public Optional<class_630> legFrontLeft = Optional.empty();
    public Optional<class_630> tail = Optional.empty();
    public Optional<class_630> realTail = Optional.empty();

    public SyncedAccessoryModel(class_630 root) {
        this.root = root;
        this.populatePart(root);
    }

    protected abstract void populatePart(class_630 var1);

    public void sync(DogModel dogModel) {
        this.syncPart(this.root, dogModel.root);
        this.syncPart(this.head, dogModel.head);
        this.syncPart(this.realHead, dogModel.realHead);
        this.syncPart(this.body, dogModel.body);
        this.syncPart(this.mane, dogModel.mane);
        this.syncPart(this.legBackRight, dogModel.legBackRight);
        this.syncPart(this.legBackLeft, dogModel.legBackLeft);
        this.syncPart(this.legFrontRight, dogModel.legFrontRight);
        this.syncPart(this.legFrontLeft, dogModel.legFrontLeft);
        this.syncPart(this.tail, dogModel.tail);
        this.syncPart(this.realTail, dogModel.realTail);
        this.pivot = DogModel.DEFAULT_ROOT_PIVOT;
        Vector3f custom_pivot = dogModel.getCustomRootPivotPoint();
        if (custom_pivot != null) {
            this.pivot = custom_pivot;
        }
    }

    private void syncPart(Optional<class_630> part, class_630 dogPart) {
        part.ifPresent(p -> this.syncPart((class_630)p, dogPart));
    }

    private void syncPart(class_630 part, class_630 dogPart) {
        part.method_17138(dogPart);
    }

    public void method_2828(class_4587 stack, class_4588 p_103014_, int p_103015_, int p_103016_, int color_overlay) {
        stack.method_22903();
        stack.method_22904((double)(this.root.field_3657 / 16.0f), (double)(this.root.field_3656 / 16.0f), (double)(this.root.field_3655 / 16.0f));
        stack.method_22904((double)(this.pivot.x / 16.0f), (double)(this.pivot.y / 16.0f), (double)(this.pivot.z / 16.0f));
        if (this.root.field_3674 != 0.0f) {
            stack.method_22907(class_7833.field_40718.rotation(this.root.field_3674));
        }
        if (this.root.field_3675 != 0.0f) {
            stack.method_22907(class_7833.field_40716.rotation(this.root.field_3675));
        }
        if (this.root.field_3654 != 0.0f) {
            stack.method_22907(class_7833.field_40714.rotation(this.root.field_3654));
        }
        float xRot0 = this.root.field_3654;
        float yRot0 = this.root.field_3675;
        float zRot0 = this.root.field_3674;
        float x0 = this.root.field_3657;
        float y0 = this.root.field_3656;
        float z0 = this.root.field_3655;
        this.root.field_3654 = 0.0f;
        this.root.field_3675 = 0.0f;
        this.root.field_3674 = 0.0f;
        this.root.field_3657 = 0.0f;
        this.root.field_3656 = 0.0f;
        this.root.field_3655 = 0.0f;
        stack.method_22903();
        stack.method_22904((double)(-this.pivot.x / 16.0f), (double)(-this.pivot.y / 16.0f), (double)(-this.pivot.z / 16.0f));
        if (this.field_3448) {
            boolean headSync = this.head.isPresent();
            boolean headVisible0 = false;
            if (headSync) {
                headVisible0 = this.head.get().field_3665;
                this.head.get().field_3665 = false;
            }
            stack.method_22903();
            this.root.method_22699(stack, p_103014_, p_103015_, p_103016_, color_overlay);
            stack.method_22909();
            if (headSync) {
                this.head.get().field_3665 = headVisible0;
                stack.method_22903();
                stack.method_22905(2.0f, 2.0f, 2.0f);
                stack.method_22904(0.0, -0.5, 0.15);
                this.head.get().method_22699(stack, p_103014_, p_103015_, p_103016_, color_overlay);
                stack.method_22909();
            }
        } else {
            this.root.method_22699(stack, p_103014_, p_103015_, p_103016_, color_overlay);
        }
        stack.method_22909();
        stack.method_22909();
        this.root.field_3654 = xRot0;
        this.root.field_3675 = yRot0;
        this.root.field_3674 = zRot0;
        this.root.field_3657 = x0;
        this.root.field_3656 = y0;
        this.root.field_3655 = z0;
    }

    public void prepareMobModel(Dog dogIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
    }

    public void setupAnim(Dog entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }
}

