/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework.element;

import doggytalents.client.screen.framework.AbstractSlice;
import doggytalents.client.screen.framework.Store;
import doggytalents.client.screen.framework.element.ElementPosition;
import doggytalents.client.screen.framework.element.ElementSize;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public abstract class AbstractElement
implements class_4068,
class_4069,
class_6379 {
    @Nullable
    private class_364 focused;
    private boolean isDragging;
    @Nullable
    private final AbstractElement parent;
    private final ArrayList<class_364> child = new ArrayList();
    private final ArrayList<Class<? extends AbstractSlice>> subscribedTo = new ArrayList();
    private final class_437 screen;
    private ElementPosition position;
    private ElementSize size;
    private int backgroundColor;

    public AbstractElement(AbstractElement parent, class_437 screen) {
        this.parent = this == parent ? null : parent;
        this.position = ElementPosition.getDefault(this);
        this.size = ElementSize.getDefault(this);
        this.screen = screen;
    }

    public void method_37020(class_6382 p_169152_) {
    }

    public AbstractElement init() {
        return this;
    }

    public List<? extends class_364> method_25396() {
        return this.child;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.backgroundColor != 0) {
            int aX = this.getRealX();
            int aY = this.getRealY();
            graphics.method_25294(aX, aY, aX + this.getSizeX(), aY + this.getSizeY(), this.backgroundColor);
        }
        this.renderElement(graphics, mouseX, mouseY, partialTicks);
        for (class_364 c : this.child) {
            if (!(c instanceof class_4068)) continue;
            class_4068 wid = (class_4068)c;
            wid.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public void renderElement(class_332 stack, int mouseX, int mouseY, float partialTicks) {
    }

    public AbstractElement setPosition(ElementPosition.PosType type, int left, int top) {
        this.position = new ElementPosition(this, left, top, type);
        return this;
    }

    public AbstractElement setSize(int width, int height) {
        this.size = new ElementSize(this, width, height);
        return this;
    }

    public AbstractElement setSize(float ratioX, float ratioY) {
        this.size = new ElementSize(this, ratioX, ratioY);
        return this;
    }

    public AbstractElement setSize(int width, float ratioY) {
        this.size = new ElementSize(this, width, ratioY);
        return this;
    }

    public AbstractElement setSize(float ratioX, int height) {
        this.size = new ElementSize(this, ratioX, height);
        return this;
    }

    public AbstractElement setSize(int size) {
        this.size = new ElementSize(this, size);
        return this;
    }

    public AbstractElement setSizeDynamicX(int sizeY) {
        this.size = ElementSize.createDynamicX(this, sizeY);
        return this;
    }

    public AbstractElement setSizeDynamicY(int sizeX) {
        this.size = ElementSize.createDynamicY(this, sizeX);
        return this;
    }

    public AbstractElement setBackgroundColor(int color) {
        this.backgroundColor = color;
        return this;
    }

    public boolean addChildren(class_364 element) {
        for (class_364 class_3642 : this.method_25396()) {
            if (class_3642 != element) continue;
            return false;
        }
        if (this.checkChildrenExistedInParents(element)) {
            this.child.add(element);
            ElementSize pos = this.getSize();
            if (pos.isDynamic()) {
                pos.updateSize();
            }
            return true;
        }
        return false;
    }

    private boolean checkChildrenExistedInParents(class_364 component) {
        for (AbstractElement p = this.getParent(); p != null; p = p.getParent()) {
            if (p != component) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public AbstractElement getParent() {
        return this.parent;
    }

    public ElementPosition getPosition() {
        return this.position;
    }

    public ElementSize getSize() {
        return this.size;
    }

    public int getRealX() {
        return this.position.getRealX();
    }

    public int getRealY() {
        return this.position.getRealY();
    }

    public int getSizeX() {
        return this.size.getWidth();
    }

    public int getSizeY() {
        return this.size.getHeight();
    }

    public class_437 getScreen() {
        return this.screen;
    }

    public boolean method_25405(double x, double y) {
        return x >= (double)this.getRealX() && y >= (double)this.getRealY() && x < (double)(this.getRealX() + this.getSizeX()) && y < (double)(this.getRealY() + this.getSizeY());
    }

    public void keyPressedRegardlessIfFocus(int keyCode, int scanCode, int modifiers) {
        this.onGlobalKeyPress(keyCode, scanCode, modifiers);
        for (class_364 c : this.child) {
            if (!(c instanceof AbstractElement)) continue;
            AbstractElement e = (AbstractElement)c;
            e.keyPressedRegardlessIfFocus(keyCode, scanCode, modifiers);
        }
    }

    public void KeyReleasedRegardlessIfFocus(int keyCode, int scanCode, int modifiers) {
        this.onGlobalKeyRelease(keyCode, scanCode, modifiers);
        for (class_364 c : this.child) {
            if (!(c instanceof AbstractElement)) continue;
            AbstractElement e = (AbstractElement)c;
            e.KeyReleasedRegardlessIfFocus(keyCode, scanCode, modifiers);
        }
    }

    public void onGlobalKeyPress(int keyCode, int scanCode, int modifiers) {
    }

    public void onGlobalKeyRelease(int keyCode, int scanCode, int modifiers) {
    }

    public boolean needsReRender(List<Class<? extends AbstractSlice>> changedSlices) {
        for (Class<? extends AbstractSlice> slice : changedSlices) {
            if (!this.subscribedTo.contains(slice)) continue;
            return true;
        }
        return false;
    }

    public void onStoreUpdated(List<Class<? extends AbstractSlice>> changedSlices) {
        if (this.needsReRender(changedSlices)) {
            this.reRender();
            return;
        }
        for (class_364 c : this.child) {
            if (!(c instanceof AbstractElement)) continue;
            AbstractElement e = (AbstractElement)c;
            e.onStoreUpdated(changedSlices);
        }
    }

    public void reRender() {
        if (this.child.contains(this.method_25399())) {
            this.method_25395(null);
        }
        this.child.clear();
        this.init();
    }

    public <T, S extends AbstractSlice> T getStateAndSubscribesTo(Class<S> slice, Class<T> cast, T defaultState) {
        if (!this.subscribedTo.contains(slice)) {
            this.subscribedTo.add(slice);
        }
        return Store.get(this.getScreen()).getStateOrDefault(slice, cast, defaultState);
    }

    public final boolean method_25397() {
        return this.isDragging;
    }

    public final void method_25398(boolean p_94681_) {
        this.isDragging = p_94681_;
    }

    @Nullable
    public class_364 method_25399() {
        return this.getScreen().method_25399();
    }

    public void method_25395(@Nullable class_364 guiEventListener) {
        this.getScreen().method_25395(guiEventListener);
    }
}

