/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block.tileentity;

import doggytalents.DoggyTileEntityTypes;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.block.DogBedBlock;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.block.tileentity.PlacedTileEntity;
import doggytalents.common.entity.Dog;
import doggytalents.common.fabric_helper.block.dogbed.DogBedModelData;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.WorldUtil;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class DogBedTileEntity
extends PlacedTileEntity {
    private ICasingMaterial casingType = DogBedMaterialManager.NaniCasing.NULL;
    private IBeddingMaterial beddingType = DogBedMaterialManager.NaniBedding.NULL;
    @Deprecated
    @javax.annotation.Nullable
    private Dog dog;
    @javax.annotation.Nullable
    private UUID dogUUID;
    @javax.annotation.Nullable
    private class_2561 name;
    @javax.annotation.Nullable
    private class_2561 ownerName;

    public DogBedTileEntity(class_2338 pos, class_2680 blockState) {
        super(DoggyTileEntityTypes.DOG_BED.get(), pos, blockState);
    }

    @Override
    public void method_11014(class_2487 compound, class_7225.class_7874 prov) {
        super.method_11014(compound, prov);
        this.casingType = DogBedMaterialManager.getCasing(compound, "casingId");
        this.beddingType = DogBedMaterialManager.getBedding(compound, "beddingId");
        this.dogUUID = NBTUtil.getUniqueId(compound, "ownerId");
        this.name = NBTUtil.getTextComponent(compound, "name");
        this.ownerName = NBTUtil.getTextComponent(compound, "ownerName");
    }

    @Override
    public void method_11007(class_2487 compound, class_7225.class_7874 prov) {
        super.method_11007(compound, prov);
        NBTUtil.putRegistryValue(compound, "casingId", DogBedMaterialManager.getKey(this.casingType));
        NBTUtil.putRegistryValue(compound, "beddingId", DogBedMaterialManager.getKey(this.beddingType));
        NBTUtil.putUniqueId(compound, "ownerId", this.dogUUID);
        NBTUtil.putTextComponent(compound, "name", this.name);
        NBTUtil.putTextComponent(compound, "ownerName", this.ownerName);
    }

    public void setCasing(ICasingMaterial casingType) {
        this.casingType = casingType;
        this.method_5431();
    }

    public void setBedding(IBeddingMaterial beddingType) {
        this.beddingType = beddingType;
        this.method_5431();
    }

    public ICasingMaterial getCasing() {
        return this.casingType;
    }

    public IBeddingMaterial getBedding() {
        return this.beddingType;
    }

    public void setOwner(@javax.annotation.Nullable Dog owner) {
        this.setOwner(owner == null ? null : owner.method_5667());
        this.dog = owner;
    }

    public void setOwner(@javax.annotation.Nullable UUID owner) {
        this.dog = null;
        this.dogUUID = owner;
        this.method_5431();
    }

    @javax.annotation.Nullable
    public UUID getOwnerUUID() {
        return this.dogUUID;
    }

    @javax.annotation.Nullable
    public Dog getOwner() {
        return WorldUtil.getCachedEntity(this.field_11863, Dog.class, this.dog, this.dogUUID);
    }

    @javax.annotation.Nullable
    public class_2561 getBedName() {
        return this.name;
    }

    @javax.annotation.Nullable
    public class_2561 getOwnerName() {
        class_2561 text;
        if (this.dogUUID == null || this.field_11863 == null) {
            return null;
        }
        DogLocationData locData = DogLocationStorage.get(this.field_11863).getData(this.dogUUID);
        if (locData != null && (text = locData.getName()) != null) {
            this.ownerName = text;
        }
        return this.ownerName;
    }

    public boolean shouldDisplayName(class_1309 camera) {
        return true;
    }

    public void setBedName(@javax.annotation.Nullable class_2561 nameIn) {
        this.name = nameIn;
        this.method_5431();
    }

    @Nullable
    public Object getRenderData() {
        class_2680 state = this.method_11010();
        class_2350 facing = class_2350.field_11043;
        if (state != null && state.method_28498((class_2769)DogBedBlock.FACING)) {
            facing = (class_2350)state.method_11654((class_2769)DogBedBlock.FACING);
        }
        return DogBedModelData.builder().casing(this.casingType).bedding(this.beddingType).facing(facing).build();
    }
}

