/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.api.impl.DogAlterationProps;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogSwimMoveControl;
import doggytalents.common.entity.ai.nav.DogWaterBoundNavigation;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.Util;
import doggytalents.forge_imitate.atrrib.ForgeMod;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1408;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class DogSwimmingManager {
    private final Dog dog;
    private static final class_2960 SWIM_BOOST_ID = Util.getResource("swim_boost");
    private DogSwimMoveControl moveControl_water;
    private DogWaterBoundNavigation navigator_water;
    private boolean swimming = false;
    private static final float baseSwimSpeedModifierAdd = 2.0f;
    public static final float swimSpeedModifierAddCap = 10.0f;
    private float swimSpeedModifierAdd = 2.0f;

    public DogSwimmingManager(Dog dog) {
        this.dog = dog;
    }

    public void tickServer() {
        if (!this.dog.canSwimUnderwater()) {
            return;
        }
        if (this.moveControl_water == null || this.navigator_water == null) {
            return;
        }
        if (this.swimming) {
            this.updateSwimming(this.dog);
        } else {
            this.updateNotSwimming(this.dog);
        }
    }

    public void onPropsUpdated(DogAlterationProps props) {
        if (this.swimming) {
            this.swimming = false;
            this.stopSwimming(this.dog);
        }
        if (props.canSwimUnderwater()) {
            this.moveControl_water = new DogSwimMoveControl(this.dog);
            this.navigator_water = new DogWaterBoundNavigation(this.dog, this.dog.method_37908());
            this.swimSpeedModifierAdd = 2.0f + class_3532.method_15363((float)props.bonusSwimSpeed(), (float)0.0f, (float)10.0f);
        } else {
            this.moveControl_water = null;
            this.navigator_water = null;
        }
    }

    private void updateSwimming(Dog dog) {
        if (!dog.method_5799() && dog.method_24828() || !dog.method_5782() && dog.isLowAirSupply() || dog.isDefeated() || this.hasNonControllingNonWaterBreathingPassenger(dog)) {
            this.swimming = false;
            this.stopSwimming(dog);
        }
    }

    private void updateNotSwimming(Dog dog) {
        if (dog.method_5799() && !dog.isDefeated() && this.readyToBeginSwimming(dog) && !this.hasNonControllingNonWaterBreathingPassenger(dog) && !dog.isDogSwimming()) {
            this.swimming = true;
            this.startSwimming(dog);
        }
    }

    private boolean readyToBeginSwimming(Dog dog) {
        return dog.method_5669() == dog.method_5748();
    }

    private boolean hasNonControllingNonWaterBreathingPassenger(Dog dog) {
        if (!dog.method_5782()) {
            return false;
        }
        if (dog.method_42148()) {
            return false;
        }
        class_1297 passenger = dog.method_31483();
        if (passenger == null) {
            return false;
        }
        if (!(passenger instanceof class_1309)) {
            return false;
        }
        class_1309 living = (class_1309)passenger;
        return !EntityUtil.isWaterBreathingEntity(living);
    }

    private void applySwimAttributes(Dog dog) {
        dog.setAttributeModifier(ForgeMod.SWIM_SPEED.holder(), SWIM_BOOST_ID, (dd, u) -> new class_1322(u, (double)this.swimSpeedModifierAdd, class_1322.class_1323.field_6328));
    }

    private void removeSwimAttributes(Dog dog) {
        dog.removeAttributeModifier(ForgeMod.SWIM_SPEED.holder(), SWIM_BOOST_ID);
    }

    private void startSwimming(Dog dog) {
        dog.method_6100(false);
        dog.setNavigation((class_1408)this.navigator_water);
        dog.setMoveControl(this.moveControl_water);
        if (dog.method_6172()) {
            dog.method_6179(false);
        }
        this.applySwimAttributes(dog);
        dog.setDogSwimming(true);
    }

    private void stopSwimming(Dog dog) {
        dog.resetMoveControl();
        dog.resetNavigation();
        this.removeSwimAttributes(dog);
        dog.setDogSwimming(false);
    }
}

