/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.accessory;

import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.AccessoryType;
import doggytalents.common.item.DoubleDyableAccessoryItem;
import doggytalents.common.util.ColourCache;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public class DoubleDyableAccessory
extends Accessory {
    public DoubleDyableAccessory(Supplier<? extends AccessoryType> typeIn, Supplier<? extends class_1935> itemIn) {
        super(typeIn, itemIn);
    }

    @Override
    public AccessoryInstance getDefault() {
        return new DoubleDyableAccessoryInstance((Accessory)this, 0, 0);
    }

    @Override
    public AccessoryInstance createInstance(class_2540 buf) {
        int bg_color = buf.readInt();
        int fg_color = buf.readInt();
        return new DoubleDyableAccessoryInstance((Accessory)this, bg_color, fg_color);
    }

    @Override
    public void write(AccessoryInstance instance, class_2540 buf) {
        if (!(instance instanceof DoubleDyableAccessoryInstance)) {
            buf.method_53002(0);
            buf.method_53002(0);
            return;
        }
        DoubleDyableAccessoryInstance inst = (DoubleDyableAccessoryInstance)instance;
        buf.method_53002(inst.getBgColorInteger());
        buf.method_53002(inst.getFgColorInteger());
    }

    @Override
    public void write(AccessoryInstance instance, class_2487 compound) {
        if (!(instance instanceof DoubleDyableAccessoryInstance)) {
            return;
        }
        DoubleDyableAccessoryInstance inst = (DoubleDyableAccessoryInstance)instance;
        compound.method_10569("dtn_bg_color", inst.getBgColorInteger());
        compound.method_10569("dtn_fg_color", inst.getFgColorInteger());
    }

    @Override
    public AccessoryInstance read(class_2487 compound) {
        int bg_color = 0;
        if (compound.method_10545("dtn_bg_color")) {
            bg_color = compound.method_10550("dtn_bg_color");
        } else if (compound.method_10545("color")) {
            bg_color = compound.method_10550("color");
        }
        int fg_color = 0;
        if (compound.method_10545("dtn_fg_color")) {
            fg_color = compound.method_10550("dtn_fg_color");
        } else if (compound.method_10545("bdhat_fg_color")) {
            fg_color = compound.method_10550("bdhat_fg_color");
        }
        return new DoubleDyableAccessoryInstance((Accessory)this, bg_color, fg_color);
    }

    @Override
    public AccessoryInstance createFromStack(class_1799 stackIn) {
        class_1792 item = stackIn.method_7909();
        if (item instanceof DoubleDyableAccessoryItem) {
            DoubleDyableAccessoryItem doubleAccessory = (DoubleDyableAccessoryItem)item;
            return new DoubleDyableAccessoryInstance((Accessory)this, doubleAccessory.getBgColor(stackIn), doubleAccessory.getFgColor(stackIn));
        }
        return this.getDefault();
    }

    @Override
    public class_1799 getReturnItem(AccessoryInstance instance) {
        class_1799 returnStack = super.getReturnItem(instance);
        if (!(instance instanceof DoubleDyableAccessoryInstance)) {
            return returnStack;
        }
        DoubleDyableAccessoryInstance inst = (DoubleDyableAccessoryInstance)instance;
        class_1792 class_17922 = returnStack.method_7909();
        if (class_17922 instanceof DoubleDyableAccessoryItem) {
            DoubleDyableAccessoryItem birthday = (DoubleDyableAccessoryItem)class_17922;
            birthday.setBgColor(returnStack, inst.getBgColorInteger());
            birthday.setFgColor(returnStack, inst.getFgColorInteger());
        }
        return returnStack;
    }

    public static class DoubleDyableAccessoryInstance
    extends AccessoryInstance {
        private ColourCache bgColor;
        private ColourCache fgColor;

        public DoubleDyableAccessoryInstance(Accessory typeIn, int bgColor, int fgColor) {
            this(typeIn, ColourCache.make(bgColor), ColourCache.make(fgColor));
        }

        public DoubleDyableAccessoryInstance(Accessory type, ColourCache bgColor, ColourCache fgColor) {
            super(type);
            this.bgColor = bgColor;
            this.fgColor = fgColor;
        }

        public float[] getBgColor() {
            return this.bgColor.getFloatArray();
        }

        public float[] getFgColor() {
            return this.fgColor.getFloatArray();
        }

        public int getBgColorInteger() {
            return this.bgColor.get();
        }

        public int getFgColorInteger() {
            return this.fgColor.get();
        }

        @Override
        public AccessoryInstance copy() {
            return new DoubleDyableAccessoryInstance(this.getAccessory(), this.bgColor, this.fgColor);
        }
    }
}

