/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.accessory;

import com.google.common.collect.Maps;
import doggytalents.DoggyAccessoryTypes;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.entity.render.AccessoryModelManager;
import doggytalents.client.entity.render.layer.accessory.modelrenderentry.AccessoryModelRenderEntries;
import doggytalents.client.entity.render.layer.accessory.modelrenderentry.IAccessoryHasModel;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogPose;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.apache.commons.lang3.tuple.Pair;

public class FieryReflector
extends Accessory
implements IAccessoryHasModel {
    private final Type type;

    public FieryReflector(Supplier<? extends class_1935> itemIn, Type type) {
        super(DoggyAccessoryTypes.WINGS, itemIn);
        this.setAccessoryRenderType(Accessory.AccessoryRenderType.MODEL);
        this.type = type;
    }

    public FieryReflector(Supplier<? extends class_1935> itemIn) {
        super(DoggyAccessoryTypes.WINGS, itemIn);
        this.setAccessoryRenderType(Accessory.AccessoryRenderType.MODEL);
        this.type = Type.DIVINE_RETRIBUTION;
    }

    @Override
    public AccessoryModelManager.Entry getRenderEntry() {
        return AccessoryModelRenderEntries.FIERY_REFL;
    }

    @Override
    public AccessoryInstance getDefault() {
        return new Inst(this, this.type);
    }

    public static enum Type {
        DIVINE_RETRIBUTION,
        SOUL_REFLECTOR;

    }

    public static class Inst
    extends AccessoryInstance
    implements IDogAlteration {
        public static final int MAX_COOKED = 10;
        public static final int COOK_RADIUS = 1;
        private final Map<class_1542, Integer> cooking = Maps.newHashMap();
        private int tickTillRefresh = 0;
        private final Type type;
        private final ArrayList<Pair<class_1792, class_2960>> recipeCache = new ArrayList(5);
        public boolean debugForceLowFlameRender = false;

        public Inst(Accessory typeIn, Type type) {
            super(typeIn);
            this.type = type;
        }

        @Override
        public void tick(AbstractDog dogIn) {
            this.invalidateCache();
            this.invalidateCooking(dogIn);
            this.tickReflectorEffect(dogIn);
            this.tickDoingCooking(dogIn);
        }

        @Override
        public class_1269 processInteract(AbstractDog dogIn, class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
            Dog dog;
            if (dogIn.method_37908().field_9236 && playerIn.method_5998(handIn).method_7909() == class_1802.field_8276 && dogIn instanceof Dog && (dog = (Dog)dogIn).isDogInAnimDebug()) {
                this.debugForceLowFlameRender = !this.debugForceLowFlameRender;
            }
            return class_1269.field_5811;
        }

        private void tickReflectorEffect(AbstractDog dogIn) {
            if (dogIn.isDefeated()) {
                return;
            }
            if (dogIn.method_37908().field_9236) {
                if (dogIn instanceof Dog) {
                    Dog dog = (Dog)dogIn;
                    this.addFlameParticles(dog);
                }
                this.playSizzleSound(dogIn);
            }
        }

        private void tickDoingCooking(AbstractDog dog) {
            if (dog.isDefeated()) {
                return;
            }
            if (--this.tickTillRefresh <= 0) {
                this.tickTillRefresh = 10;
                this.populateCooking(dog);
            }
            this.cookAllCooking(dog);
        }

        private void addFlameParticles(Dog dog) {
            boolean higher_flame;
            float offsetY = 0.24f;
            DogPose pose = dog.getDogPose();
            boolean bl = higher_flame = !(pose != DogPose.STAND && pose != DogPose.FLYING || this.debugForceLowFlameRender && dog.isDogInAnimDebug());
            if (higher_flame) {
                offsetY += dog.getDogVisualBbHeight();
            }
            float a1 = dog.getClientAnimatedYBodyRotInRadians();
            float dx1 = -class_3532.method_15374((float)a1);
            float dz1 = class_3532.method_15362((float)a1);
            float f1 = (dog.method_59922().method_43057() * 2.0f - 1.0f) * dog.getDogVisualBbWidth() * 0.5f;
            float f2 = (dog.method_59922().method_43057() * 2.0f - 1.0f) * dog.getDogVisualBbWidth() * 0.5f;
            class_2400 flame_particle = this.type == Type.SOUL_REFLECTOR ? class_2398.field_22246 : class_2398.field_11240;
            dog.method_37908().method_8406((class_2394)flame_particle, dog.method_23317() + (double)f1 - (double)dx1 * ((double)dog.getDogVisualBbWidth() * 1.8), dog.method_23318() + (double)offsetY, dog.method_23321() + (double)f2 - (double)dz1 * ((double)dog.getDogVisualBbWidth() * 1.8), (double)(-dx1) * 0.05, -0.01, (double)(-dz1) * 0.05);
        }

        private void playSizzleSound(AbstractDog dog) {
            class_5819 r = dog.method_59922();
            if (r.method_43048(24) == 0) {
                dog.method_37908().method_8486(dog.method_23317(), dog.method_23318() + (double)dog.method_17682() + 0.24, dog.method_23321(), class_3417.field_14993, class_3419.field_15256, 0.6f * r.method_43057(), r.method_43057() * 0.7f + 0.3f, false);
            }
        }

        private void populateCooking(AbstractDog dog) {
            if (this.cooking.size() >= 10) {
                return;
            }
            List<class_1542> checkingItems = this.getRandomNearbyItemEntities(dog);
            for (class_1542 e : checkingItems) {
                class_1799 item;
                class_3861 recipe;
                if (this.cooking.size() >= 10) break;
                if (this.cooking.containsKey(e) || (recipe = this.getCookedRecipe(dog, item = e.method_6983())) == null) continue;
                this.cooking.put(e, recipe.method_8167());
            }
        }

        private void invalidateCooking(AbstractDog dog) {
            if (this.cooking.isEmpty()) {
                return;
            }
            if (dog.isDefeated()) {
                this.cooking.clear();
                return;
            }
            ArrayList<class_1542> removeList = new ArrayList<class_1542>();
            for (Map.Entry<class_1542, Integer> entry : this.cooking.entrySet()) {
                if (this.stillValidCooking(dog, entry.getKey())) continue;
                removeList.add(entry.getKey());
            }
            for (class_1542 e : removeList) {
                this.cooking.remove(e);
            }
        }

        private void cookAllCooking(AbstractDog dog) {
            if (dog.method_37908().field_9236) {
                this.cookAllCookingClient(dog);
            } else {
                this.cookAllCookingServer(dog);
            }
        }

        private void cookAllCookingServer(AbstractDog dog) {
            if (this.cooking.isEmpty()) {
                return;
            }
            ArrayList<class_1542> finished = new ArrayList<class_1542>();
            for (Map.Entry<class_1542, Integer> entry : this.cooking.entrySet()) {
                entry.setValue(entry.getValue() - 1);
                if (entry.getValue() > 0) continue;
                this.finishCooking(dog, entry.getKey());
                finished.add(entry.getKey());
            }
            for (class_1542 e : finished) {
                this.cooking.remove(e);
            }
        }

        private void cookAllCookingClient(AbstractDog dog) {
            if (this.cooking.isEmpty()) {
                return;
            }
            if (dog.method_59922().method_43058() < 0.1) {
                dog.method_37908().method_8486(dog.method_23317(), dog.method_23318(), dog.method_23321(), class_3417.field_15006, class_3419.field_15256, 1.0f, 1.0f, false);
            }
            for (Map.Entry<class_1542, Integer> entry : this.cooking.entrySet()) {
                class_1542 e = entry.getKey();
                if (dog.method_59922().method_43048(3) != 0) continue;
                float f1 = (dog.method_59922().method_43057() * 2.0f - 1.0f) * e.method_17681() * 0.5f;
                float f2 = (dog.method_59922().method_43057() * 2.0f - 1.0f) * e.method_17681() * 0.5f;
                dog.method_37908().method_8406((class_2394)class_2398.field_11251, e.method_23317() + (double)f1, e.method_23318(), e.method_23321() + (double)f2, 0.0, 0.05, 0.0);
            }
        }

        private void finishCooking(AbstractDog dog, class_1542 e) {
            class_1799 uncookedItem = e.method_6983().method_7972();
            class_3861 recipe = this.getCookedRecipe(dog, uncookedItem);
            if (recipe == null) {
                return;
            }
            class_1799 cookedItem = recipe.method_8110((class_7225.class_7874)dog.method_37908().method_30349()).method_7972();
            class_1542 cookedItemEntity = new class_1542(dog.method_37908(), e.method_23317(), e.method_23318(), e.method_23321(), cookedItem);
            cookedItemEntity.method_6988();
            dog.method_37908().method_8649((class_1297)cookedItemEntity);
            uncookedItem.method_7934(1);
            if (uncookedItem.method_7960()) {
                e.method_31472();
            } else {
                e.method_6979(uncookedItem);
            }
        }

        private boolean stillValidCooking(AbstractDog dog, class_1542 e) {
            double maxDist = (double)(dog.method_17681() / 2.0f + 1.0f) + 0.5;
            return e.method_5805() && e.method_5858((class_1297)dog) <= maxDist * maxDist;
        }

        private class_3861 getCookedRecipe(AbstractDog dog, class_1799 stack) {
            if (stack.method_7960()) {
                return null;
            }
            class_1792 item = stack.method_7909();
            class_2960 firstCheck = this.getCachedRecipeLoc(item);
            Optional pairOptional = dog.method_37908().method_8433().method_42299(class_3956.field_17546, (class_9695)new class_9696(stack), dog.method_37908(), firstCheck);
            if (!pairOptional.isPresent()) {
                return null;
            }
            class_8786 pair = (class_8786)pairOptional.get();
            class_2960 res = pair.comp_1932();
            class_3861 recipe = (class_3861)pair.comp_1933();
            if (res == null || recipe == null) {
                return null;
            }
            this.cacheResult(item, res);
            return recipe;
        }

        private List<class_1542> getRandomNearbyItemEntities(AbstractDog dog) {
            int amount = 10;
            List cookingItems = dog.method_37908().method_18467(class_1542.class, dog.method_5829().method_1014(1.0));
            if (cookingItems.size() <= 10) {
                return cookingItems;
            }
            Collections.shuffle(cookingItems);
            return cookingItems.subList(0, 10);
        }

        private void invalidateCache() {
            this.recipeCache.clear();
        }

        private void cacheResult(class_1792 item, class_2960 res) {
            if (item == null || res == null) {
                return;
            }
            this.recipeCache.add((Pair<class_1792, class_2960>)Pair.of((Object)item, (Object)res));
        }

        @Nullable
        private class_2960 getCachedRecipeLoc(class_1792 item) {
            for (Pair<class_1792, class_2960> pair : this.recipeCache) {
                if (pair.getLeft() != item) continue;
                return (class_2960)pair.getRight();
            }
            return null;
        }
    }
}

