/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.feature.DogMode;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_7;

public class DogLowHealthGoal {

    public static class RunAway
    extends class_1352 {
        public static final int CAUTIOUS_RADIUS = 6;
        private Type type = Type.OWNER;
        private Dog dog;
        private float oldWaterCost;
        private int tickTillMoveAwayRecalc = 0;
        private int tickTillCheckTeleport = 0;
        private class_1309 owner;
        private class_2338 restrictPos;
        private class_243 moveAwayPos;
        private List<class_1308> enemies = List.of();
        private int tickTillUpdateEnemyRecalc = 0;

        public RunAway(Dog dog) {
            this.dog = dog;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.tickTillUpdateEnemyRecalc > 0) {
                --this.tickTillUpdateEnemyRecalc;
            }
            if (!this.dog.isDoingFine()) {
                return false;
            }
            if (this.dog.method_6172()) {
                return false;
            }
            if (!this.dog.isDogLowHealth()) {
                return false;
            }
            if (this.dog.getLowHealthStrategy() != Dog.LowHealthStrategy.RUN_AWAY) {
                return false;
            }
            if (this.dog.isMode(DogMode.GUARD, DogMode.GUARD_FLAT, DogMode.GUARD_MINOR)) {
                return false;
            }
            if (this.dog.getMode().shouldFollowOwner()) {
                class_1309 owner = this.dog.method_35057();
                if (owner == null) {
                    return false;
                }
                this.owner = owner;
                this.type = Type.OWNER;
            } else {
                if (!this.dog.getMode().canWander()) {
                    return false;
                }
                if (!this.dog.method_18410() || this.dog.method_18412() == null) {
                    return false;
                }
                this.restrictPos = this.dog.method_18412();
                this.type = Type.RESTRICT;
            }
            this.enemies = List.of();
            if (this.tickTillUpdateEnemyRecalc <= 0) {
                this.tickTillUpdateEnemyRecalc = 3;
                this.updateEnemies(6);
            }
            return !this.enemies.isEmpty();
        }

        public boolean method_6266() {
            if (this.enemies.isEmpty()) {
                return false;
            }
            if (this.type == Type.OWNER) {
                if (!this.dog.getMode().shouldFollowOwner()) {
                    return false;
                }
                if (!this.owner.method_36608()) {
                    return false;
                }
            } else {
                if (!this.dog.getMode().canWander()) {
                    return false;
                }
                if (!this.dog.method_18410() || this.dog.method_18412() == null) {
                    return false;
                }
                if (!this.restrictPos.equals((Object)this.dog.method_18412())) {
                    return false;
                }
            }
            return this.dog.isDogLowHealth();
        }

        public void method_6269() {
            this.oldWaterCost = this.dog.method_5944(class_7.field_18);
            this.dog.setDogFollowingSomeone(true);
            this.dog.method_5942().method_6340();
            this.moveAwayPos = this.findMoveAwayPos();
            if (this.moveAwayPos != null) {
                this.tickTillMoveAwayRecalc = 5;
                this.dog.method_5942().method_6337(this.moveAwayPos.field_1352, this.moveAwayPos.field_1351, this.moveAwayPos.field_1350, (double)this.dog.getUrgentSpeedModifier());
            }
        }

        public void method_6268() {
            class_1408 dogNav = this.dog.method_5942();
            if (--this.tickTillMoveAwayRecalc <= 0) {
                this.tickTillMoveAwayRecalc = 3 + this.dog.method_59922().method_43048(3);
                this.updateMoveAway();
                if (this.moveAwayPos != null) {
                    dogNav.method_6337(this.moveAwayPos.field_1352, this.moveAwayPos.field_1351, this.moveAwayPos.field_1350, (double)this.dog.getUrgentSpeedModifier());
                }
            }
            if (--this.tickTillCheckTeleport <= 0) {
                this.tickTillCheckTeleport = 5;
                if (this.type == Type.OWNER && this.dog.getMode().shouldFollowOwner() && this.dog.method_5858((class_1297)this.owner) > 400.0) {
                    DogUtil.dynamicSearchAndTeleportToOwnwer(this.dog, this.owner, 4);
                }
            }
        }

        private void updateEnemies(int search_radius) {
            this.enemies = this.dog.method_37908().method_8390(class_1308.class, this.dog.method_5829().method_1009((double)search_radius, 3.0, (double)search_radius), mob -> mob.method_5805() && mob.method_5968() == this.dog);
        }

        private void updateMoveAway() {
            this.moveAwayPos = null;
            this.updateEnemies(6);
            this.moveAwayPos = this.findMoveAwayPos();
        }

        private class_243 findMoveAwayPos() {
            class_243 moveAwayPos;
            class_243 centerPos = this.findAverageCenterOfAllTargetingEnemies();
            if (centerPos == null) {
                return null;
            }
            class_243 ownerPos = this.type == Type.OWNER ? this.owner.method_19538() : class_243.method_24955((class_2382)this.restrictPos);
            class_243 dogPos = this.dog.method_19538();
            class_243 avoid_offset = dogPos.method_1020(centerPos).method_1029().method_1021(8.0);
            class_243 v_dogPos_ownerPos = ownerPos.method_1020(dogPos);
            double alpha = v_dogPos_ownerPos.method_1026(avoid_offset) / (v_dogPos_ownerPos.method_1033() * avoid_offset.method_1033());
            if (alpha < -0.8) {
                moveAwayPos = this.dog.field_6012 % 2 == 0 ? dogPos.method_1031(avoid_offset.field_1350, 0.0, -avoid_offset.field_1352) : dogPos.method_1031(-avoid_offset.field_1350, 0.0, avoid_offset.field_1352);
            } else {
                class_243 avoidPos = dogPos.method_1019(avoid_offset);
                moveAwayPos = new class_243((avoidPos.field_1352 + ownerPos.field_1352) / 2.0, (avoidPos.field_1351 + ownerPos.field_1351) / 2.0, (avoidPos.field_1350 + ownerPos.field_1350) / 2.0);
            }
            return moveAwayPos;
        }

        public class_243 findAverageCenterOfAllTargetingEnemies() {
            if (this.enemies.isEmpty()) {
                return null;
            }
            double size = this.enemies.size();
            double avg_x = 0.0;
            double avg_y = 0.0;
            double avg_z = 0.0;
            for (class_1308 enemy : this.enemies) {
                avg_x += enemy.method_23317();
                avg_y += enemy.method_23318();
                avg_z += enemy.method_23321();
            }
            return new class_243(avg_x /= size, avg_y /= size, avg_z /= size);
        }

        public void method_6270() {
            this.dog.method_5942().method_6340();
            this.dog.setDogFollowingSomeone(false);
            this.owner = null;
            this.enemies = List.of();
            this.moveAwayPos = null;
        }

        private static enum Type {
            OWNER,
            RESTRICT;

        }
    }

    public static class StickToOwner
    extends class_1352 {
        private final Dog dog;
        private final float stopDist;
        private class_1309 owner;
        private int timeToRecalcPath;
        private int tickTillSearchForTp = 0;
        private int tickTillInitTeleport = 0;
        private int tickTillInitWhine = 0;
        private float oldWaterCost;
        private boolean whine = false;

        public StickToOwner(Dog dogIn) {
            this.dog = dogIn;
            this.stopDist = 1.5f;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 owner;
            if (this.tickTillInitTeleport > 0) {
                --this.tickTillInitTeleport;
            }
            if (this.tickTillInitWhine > 0) {
                --this.tickTillInitWhine;
            }
            if ((owner = this.dog.method_35057()) == null) {
                return false;
            }
            if (!this.dog.isDoingFine()) {
                return false;
            }
            if (!this.dog.isDogLowHealth()) {
                return false;
            }
            if (this.dog.getLowHealthStrategy() != Dog.LowHealthStrategy.STICK_TO_OWNER) {
                return false;
            }
            if (owner.method_7325()) {
                return false;
            }
            if (this.dog.method_6172()) {
                return false;
            }
            this.owner = owner;
            return true;
        }

        public boolean method_6266() {
            return this.dog.isDogLowHealth();
        }

        public void method_6269() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.dog.method_5944(class_7.field_18);
            this.dog.setDogFollowingSomeone(true);
            this.whine = true;
            if (this.tickTillInitTeleport <= 0) {
                this.tickTillInitTeleport = 10;
                DogUtil.dynamicSearchAndTeleportToOwnwer(this.dog, this.owner, 4);
            }
        }

        public void method_6270() {
            double distanceToOwner;
            if (this.dog.hasBone() && (distanceToOwner = this.owner.method_5858((class_1297)this.dog)) <= (double)(this.stopDist * this.stopDist)) {
                IThrowableItem throwableItem = this.dog.getThrowableItem();
                class_1799 fetchItem = throwableItem != null ? throwableItem.getReturnStack(this.dog.getBoneVariant()) : this.dog.getBoneVariant();
                this.dog.method_5699(fetchItem, 0.0f);
                this.dog.setBoneVariant(class_1799.field_8037);
            }
            this.owner = null;
            this.dog.method_5942().method_6340();
            this.dog.setDogFollowingSomeone(false);
            this.dog.setBegging(false);
            this.dog.dogSoundManager.interuptPlaying();
        }

        public void method_6268() {
            if (this.tickTillInitWhine > 0) {
                --this.tickTillInitWhine;
            }
            if (this.dog.method_5858((class_1297)this.owner) > (double)(this.stopDist * this.stopDist)) {
                this.dog.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.dog.method_5978());
                if (--this.timeToRecalcPath <= 0) {
                    this.timeToRecalcPath = 5;
                    DogUtil.moveToOwnerOrTeleportIfFarAway(this.dog, this.owner, this.dog.getUrgentSpeedModifier(), 25.0, false, --this.tickTillSearchForTp <= 0, 400.0, this.dog.method_5850());
                    if (this.tickTillSearchForTp <= 0) {
                        this.tickTillSearchForTp = 10;
                    }
                }
            } else {
                if (this.whine && this.tickTillInitWhine <= 0) {
                    this.whine = false;
                    this.owner.method_43496((class_2561)class_2561.method_43469((String)("dog.msg.low_health." + this.dog.method_59922().method_43048(4)), (Object[])new Object[]{this.dog.method_5477()}));
                    class_3414 sound = this.dog.dogMood.getWhineAttentionSound();
                    this.dog.dogSoundManager.playInterruptible(sound, this.dog.method_6107(), this.dog.method_6017());
                    this.tickTillInitWhine = 40;
                }
                this.dog.method_5988().method_35111((class_1297)this.owner);
            }
        }
    }
}

