/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.DogAiManager;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import net.minecraft.class_1352;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2356;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2527;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class DogRandomSniffGoal
extends class_1352
implements DogAiManager.IHasTickNonRunning {
    private Dog dog;
    private int stopTick;
    private class_2338 sniffAtPos;
    private class_2338 sniffUnderPos;
    private class_2680 sniffAtState;
    private class_2680 sniffUnderState;
    private class_2338 currentPos;
    private DogAnimation currentAnimation = DogAnimation.NONE;
    private int tickAnim = 0;
    private boolean isDoingAnim = false;
    private boolean shouldMoveSignificantly = false;
    private final int EXPLORE_RADIUS = 6;
    private int stillRememberBeingBurnedTick = 0;
    private boolean continueEvenWhenChanged = false;

    public DogRandomSniffGoal(Dog dog) {
        this.dog = dog;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (this.dog.getAnim() != DogAnimation.NONE) {
            return false;
        }
        if (this.dog.randomStrollCooldown > 0) {
            return false;
        }
        if (this.dog.method_5809()) {
            return false;
        }
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (!this.dog.method_24828()) {
            return false;
        }
        return !(this.dog.method_59922().method_43057() >= 0.01f);
    }

    @Override
    public void tickDogWhenNotRunning() {
        if (this.stillRememberBeingBurnedTick > 0) {
            --this.stillRememberBeingBurnedTick;
        }
    }

    public boolean method_6266() {
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (!this.isDoingAnim) {
            return true;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        if (this.dog.getAnim() != this.currentAnimation) {
            return false;
        }
        this.validateSniff();
        if (this.sniffAtPos == null) {
            return false;
        }
        return this.dog.field_6012 < this.stopTick;
    }

    public void method_6269() {
        this.isDoingAnim = false;
        class_2338 moveToPos = this.findMoveToPos();
        this.dog.method_5942().method_6337((double)moveToPos.method_10263(), (double)moveToPos.method_10264(), (double)moveToPos.method_10260(), 1.0);
        this.dog.setDogCurious(true);
        this.continueEvenWhenChanged = false;
        this.dog.dogSoundManager.setAmbientLocked(true);
    }

    public void method_6268() {
        if (this.isDoingAnim) {
            this.tickDoingAnim();
        } else {
            this.tickMoveTo();
        }
    }

    public void method_6270() {
        if (!this.dog.getAnim().interupting()) {
            this.dog.setAnim(DogAnimation.NONE);
        }
        this.dog.setDogCurious(false);
        this.resetSniffPos();
        this.dog.dogSoundManager.interuptPlaying();
        this.dog.method_5942().method_6340();
        this.dog.dogSoundManager.setAmbientLocked(false);
    }

    private void startDoingAnim() {
        this.currentAnimation = this.getSniffAnim();
        this.stopTick = this.dog.field_6012 + this.currentAnimation.getLengthTicks();
        this.dog.setAnimForIdle(this.currentAnimation);
        this.tickAnim = 0;
    }

    private void tickDoingAnim() {
        if (this.sniffAtPos == null) {
            return;
        }
        this.dog.method_5988().method_19615(class_243.method_24955((class_2382)this.sniffAtPos));
        switch (this.currentAnimation) {
            default: {
                if (this.tickAnim == 3) {
                    class_3414 sniff_sound = this.dog.dogMood.getSniffSound();
                    this.dog.dogSoundManager.playInterruptible(sniff_sound, 1.0f, this.dog.method_6017());
                }
                ++this.tickAnim;
                break;
            }
            case SNIFF_HOT: {
                float maxAwayDist = this.shouldMoveSignificantly ? 0.35f : 0.1f;
                class_243 current_center = class_243.method_24955((class_2382)this.currentPos);
                double d_sqr = this.dog.method_5707(current_center);
                double d_sqr_2 = this.dog.method_5649((float)this.sniffAtPos.method_10263() + 0.5f, this.dog.method_23318(), (float)this.sniffAtPos.method_10260() + 0.5f);
                if (this.tickAnim < 20 && (d_sqr < (double)maxAwayDist || d_sqr_2 > 1.0) && this.sniffAtState.method_26215()) {
                    this.dog.method_5962().method_6239((double)this.sniffAtPos.method_10263(), this.dog.method_23318(), (double)this.sniffAtPos.method_10260(), 0.5);
                }
                if (this.tickAnim == 25) {
                    class_243 pushBackVec = current_center.method_1020(this.dog.method_19538()).method_1029();
                    this.dog.method_5762(pushBackVec.method_10216() * 0.3, 0.0, pushBackVec.method_10215() * 0.3);
                    this.dog.method_5783(class_3417.field_15218, 0.6f, this.dog.method_6017());
                    this.dog.method_5783(class_3417.field_14821, 0.3f, 2.0f + this.dog.method_59922().method_43057() * 0.4f);
                    this.rememberBeingBurned();
                    this.continueEvenWhenChanged = true;
                }
                ++this.tickAnim;
                break;
            }
            case SNIFF_SNEEZE: {
                if (this.tickAnim == 25) {
                    class_3414 sneeze_sound = this.dog.dogMood.getSneezeSound();
                    this.dog.method_5783(sneeze_sound, 1.0f, this.dog.method_6017());
                    this.continueEvenWhenChanged = true;
                }
                ++this.tickAnim;
                break;
            }
            case TOUCHY_TOUCH: {
                if (this.tickAnim == 35) {
                    this.dog.method_5783(class_3417.field_15218, 0.6f, this.dog.method_6017());
                    this.dog.method_5783(class_3417.field_14821, 0.3f, 2.0f + this.dog.method_59922().method_43057() * 0.4f);
                    this.rememberBeingBurned();
                    this.continueEvenWhenChanged = true;
                }
                ++this.tickAnim;
                break;
            }
            case DOWN_THE_HOLE: {
                float maxAwayDist = 0.1f;
                class_243 current_center = class_243.method_24955((class_2382)this.currentPos);
                double d_sqr = this.dog.method_5707(current_center);
                double d_sqr_2 = this.dog.method_5649((float)this.sniffAtPos.method_10263() + 0.5f, this.dog.method_23318(), (float)this.sniffAtPos.method_10260() + 0.5f);
                if ((d_sqr < (double)maxAwayDist || d_sqr_2 > 1.0) && this.sniffAtState.method_26215()) {
                    this.dog.method_5962().method_6239((double)this.sniffAtPos.method_10263(), this.dog.method_23318(), (double)this.sniffAtPos.method_10260(), 0.5);
                }
                if (this.tickAnim == 30) {
                    class_3414 sound = this.dog.dogMood.getDownTheHoleSound();
                    this.dog.method_5783(sound, 1.0f, this.dog.method_6017());
                }
                ++this.tickAnim;
                break;
            }
            case SNIFF_AWW_HAPPY: {
                float max_close_dist = 1.2f;
                class_243 current_center = class_243.method_24955((class_2382)this.currentPos);
                class_243 sniff_center = class_243.method_24955((class_2382)this.sniffAtPos);
                double d_sqr = this.dog.method_5707(sniff_center);
                if (d_sqr < (double)1.2f) {
                    class_243 lookAtPos = class_243.method_24955((class_2382)this.sniffAtPos);
                    this.dog.method_5988().method_19615(lookAtPos);
                    this.dog.method_5962().method_6243(-0.25f, 0.0f);
                }
                if (this.tickAnim == 40) {
                    class_3414 sound = this.dog.dogMood.getAwwSound();
                    this.dog.dogSoundManager.playInterruptible(sound, 0.6f, this.dog.method_6017());
                }
                ++this.tickAnim;
                break;
            }
            case SPLASH: {
                boolean lava_effect;
                boolean bl = lava_effect = (this.tickAnim == 56 || this.tickAnim == 82 || this.tickAnim == 104) && this.dog.method_5771();
                if (lava_effect) {
                    class_5819 random = this.dog.method_59922();
                    float volume = this.tickAnim > 90 ? 10.0f : 4.0f;
                    this.dog.method_5783(class_3417.field_23206, volume, (random.method_43057() - random.method_43057()) * 0.2f + 1.0f);
                    ((class_3218)this.dog.method_37908()).method_14199((class_2394)class_2398.field_11239, this.dog.method_23317(), this.dog.method_23318(), this.dog.method_23321(), this.tickAnim > 90 ? 10 : 15, (double)this.dog.method_17681(), 1.0, (double)this.dog.method_17681(), 0.1);
                }
                if (this.tickAnim == 92) {
                    this.dog.method_5993().method_6233();
                    this.continueEvenWhenChanged = true;
                }
                ++this.tickAnim;
                break;
            }
        }
    }

    private void tickMoveTo() {
        if (this.dog.method_5942().method_6357() || this.almostOutOfRestrict() || this.checkMiningCautious()) {
            this.dog.method_5942().method_6340();
            this.isDoingAnim = true;
            if (!this.dog.method_24828()) {
                return;
            }
            this.findSniffPos();
            if (this.sniffAtPos != null) {
                this.startDoingAnim();
            }
        }
    }

    private boolean almostOutOfRestrict() {
        double restrict_d0_sqr;
        if (!this.dog.method_18410()) {
            return false;
        }
        class_2338 restrict_b0 = this.dog.method_18412();
        if (restrict_b0 == null) {
            return false;
        }
        float restrict_r = this.dog.method_18413();
        double d_inside_sqr = (double)(restrict_r * restrict_r) - (restrict_d0_sqr = this.dog.method_5707(class_243.method_24955((class_2382)restrict_b0)));
        return d_inside_sqr <= 1.0;
    }

    private boolean checkMiningCautious() {
        return this.dog.avoidGoInFrontOfOwnerManager.isActive() && DogUtil.pathGoingInFrontOfOwner(this.dog);
    }

    private class_2338 findMoveToPos() {
        if (this.dog.method_18410() && this.dog.method_18412() != null) {
            class_2338 restrict_b0 = this.dog.method_18412();
            float restrict_r = this.dog.method_18413();
            int explore_r = class_3532.method_15375((float)restrict_r) - 1;
            if (explore_r <= 0) {
                return this.dog.method_24515();
            }
            class_5819 r = this.dog.method_59922();
            int offX = r.method_39332(-explore_r, explore_r);
            int offY = r.method_39332(-1, 1);
            int offZ = r.method_39332(-explore_r, explore_r);
            return restrict_b0.method_10069(offX, offY, offZ);
        }
        class_5819 r = this.dog.method_59922();
        int offX = r.method_39332(-6, 6);
        int offY = r.method_39332(-1, 1);
        int offZ = r.method_39332(-6, 6);
        return this.dog.method_24515().method_10069(offX, offY, offZ);
    }

    private boolean findSniffPos() {
        class_2680 sniffStateUnder;
        class_2680 sniffState;
        int offset = this.dog.method_59922().method_43056() ? 1 : -1;
        boolean offsetX = this.dog.method_59922().method_43056();
        class_2338 currentPos = this.getSniffCurrentPos(this.dog);
        class_2338 sniffPos = offsetX ? currentPos.method_10069(offset, 0, 0) : currentPos.method_10069(0, 0, offset);
        if (!this.isBlockSniffable(sniffPos, sniffState = this.dog.method_37908().method_8320(sniffPos))) {
            return false;
        }
        class_2338 sniffPosUnder = this.getSniffPosUnder(this.dog, sniffPos.method_10263(), sniffPos.method_10260());
        if (!this.isBlockBelowSniffable(sniffPosUnder, sniffStateUnder = this.dog.method_37908().method_8320(sniffPosUnder))) {
            return false;
        }
        this.populateSniffPos(currentPos, sniffPos, sniffState, sniffPosUnder, sniffStateUnder);
        return true;
    }

    private class_2338 getSniffCurrentPos(Dog dog) {
        return dog.method_24515();
    }

    private class_2338 getSniffPosUnder(Dog dog, int sniffX, int sniffZ) {
        return class_2338.method_49637((double)sniffX, (double)(dog.method_23318() - 0.1), (double)sniffZ);
    }

    private boolean isBlockSniffable(class_2338 pos, class_2680 state) {
        if (state.method_26215()) {
            return true;
        }
        if (this.stillRememberBeingBurned() && class_14.method_57082((class_2680)state)) {
            return false;
        }
        return !state.method_26234((class_1922)this.dog.method_37908(), pos);
    }

    private boolean isBlockBelowSniffable(class_2338 posBelow, class_2680 state) {
        return !this.stillRememberBeingBurned() || !class_14.method_57082((class_2680)state);
    }

    private DogAnimation getSniffAnim() {
        boolean fireImmune = this.dog.method_5753();
        boolean bl = this.shouldMoveSignificantly = !this.sniffUnderState.method_26234((class_1922)this.dog.method_37908(), this.sniffUnderPos);
        if (!fireImmune && class_14.method_57082((class_2680)this.sniffUnderState) && this.sniffAtState.method_26215()) {
            return DogAnimation.SNIFF_HOT;
        }
        class_2248 atBlock = this.sniffAtState.method_26204();
        if (atBlock instanceof class_2527) {
            return DogAnimation.SNIFF_SNEEZE;
        }
        if (atBlock instanceof class_2356) {
            if (this.dog.method_59922().method_43056()) {
                return DogAnimation.SNIFF_AWW_HAPPY;
            }
            return DogAnimation.SNIFF_SNEEZE;
        }
        if (!fireImmune && class_14.method_57082((class_2680)this.sniffAtState)) {
            return DogAnimation.TOUCHY_TOUCH;
        }
        if (this.sniffAtState.method_26215() && this.sniffUnderState.method_26215()) {
            return DogAnimation.DOWN_THE_HOLE;
        }
        if (fireImmune && atBlock == class_2246.field_10164) {
            if (this.dog.method_59922().method_43056()) {
                return DogAnimation.SNIFF_SNEEZE;
            }
            return DogAnimation.SPLASH;
        }
        return DogAnimation.SNIFF_NEUTRAL;
    }

    private void validateSniff() {
        class_2680 newUnderState;
        class_2680 newAtState;
        boolean invalidated = false;
        if (this.sniffAtPos == null) {
            invalidated = true;
        }
        if (!invalidated) {
            double max_dist = 2.0;
            if (this.continueEvenWhenChanged) {
                max_dist = 6.0;
            }
            if (this.dog.method_5707(class_243.method_24955((class_2382)this.sniffAtPos)) > max_dist * max_dist) {
                invalidated = true;
            }
        }
        if (!invalidated && !this.continueEvenWhenChanged && (newAtState = this.dog.method_37908().method_8320(this.sniffAtPos)).method_26204() != this.sniffAtState.method_26204()) {
            invalidated = true;
        }
        if (!invalidated && !this.continueEvenWhenChanged && (newUnderState = this.dog.method_37908().method_8320(this.sniffUnderPos)).method_26204() != this.sniffUnderState.method_26204()) {
            invalidated = true;
        }
        if (invalidated) {
            this.resetSniffPos();
            return;
        }
    }

    private void populateSniffPos(class_2338 current, class_2338 sniffPos, class_2680 sniffState, class_2338 sniffUnderPos, class_2680 sniffUnderState) {
        if (sniffUnderPos == null || sniffUnderState == null || sniffState == null || current == null) {
            sniffPos = null;
        }
        this.sniffAtState = sniffState;
        this.sniffUnderState = sniffUnderState;
        this.sniffAtPos = sniffPos;
        this.sniffUnderPos = sniffUnderPos;
        this.currentPos = current;
    }

    private void resetSniffPos() {
        this.sniffAtPos = null;
        this.sniffAtState = null;
        this.sniffUnderPos = null;
        this.sniffUnderState = null;
        this.currentPos = null;
    }

    private void rememberBeingBurned() {
        this.stillRememberBeingBurnedTick = this.dog.method_59922().method_43048(5) * 10 * 20;
    }

    private boolean stillRememberBeingBurned() {
        return this.stillRememberBeingBurnedTick > 0;
    }

    public boolean method_38846() {
        return true;
    }
}

