/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.fabric_helper.entity.network;

import com.google.common.collect.Maps;
import doggytalents.common.entity.Dog;
import doggytalents.common.fabric_helper.entity.DogFabricHelper;
import doggytalents.common.fabric_helper.entity.network.SyncTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2540;
import net.minecraft.class_2941;
import net.minecraft.class_9129;

public class FabricSyncAllData {
    public final int dogId;
    private Map<SyncTypes.SyncType<?>, Object> dataMap;

    public FabricSyncAllData(int dogId) {
        this.dogId = dogId;
        this.dataMap = Maps.newHashMap();
    }

    private FabricSyncAllData(int dogId, Map<SyncTypes.SyncType<?>, Object> datMap) {
        this.dogId = dogId;
        this.dataMap = datMap;
    }

    public <T> T getVal(SyncTypes.SyncType<T> type) {
        return (T)this.dataMap.get(type);
    }

    public <T> void putVal(SyncTypes.SyncType<T> type, DogFabricHelper helper) {
        this.dataMap.put(type, type.getGetter().apply(helper));
    }

    public void updateDog(Dog dog) {
        DogFabricHelper fabric_helper = dog.getDogFabricHelper();
        for (Map.Entry<SyncTypes.SyncType<?>, Object> entry : this.dataMap.entrySet()) {
            SyncTypes.SyncType<?> type = entry.getKey();
            this.getValAndSetToDog(type, fabric_helper);
        }
    }

    public <T> void getValAndSetToDog(SyncTypes.SyncType<T> type, DogFabricHelper helper) {
        T val = this.getVal(type);
        BiConsumer<DogFabricHelper, DogFabricHelper> setter = type.getClientSetter();
        setter.accept(helper, (DogFabricHelper)val);
    }

    public <T> void getValAndWrite(SyncTypes.SyncType<T> type, class_2540 buf) {
        T val = this.getVal(type);
        class_2941<T> serializer = type.getSerializer();
        serializer.codec().encode((Object)((class_9129)buf), val);
    }

    public void writeToPacket(class_2540 buf) {
        buf.method_53002(this.dogId);
        buf.method_53002(this.dataMap.size());
        for (Map.Entry<SyncTypes.SyncType<?>, Object> entry : this.dataMap.entrySet()) {
            SyncTypes.SyncType<?> type = entry.getKey();
            buf.method_53002(type.getId());
            this.getValAndWrite(type, buf);
        }
    }

    public static FabricSyncAllData readFromPacket(class_2540 buf) {
        int dogId = buf.readInt();
        int mapSize = buf.readInt();
        HashMap dataMap = new HashMap(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            int typeId = buf.readInt();
            SyncTypes.SyncType<?> type = SyncTypes.fromId(typeId);
            Object val = FabricSyncAllData.readValFromPacket(type, buf);
            dataMap.put(type, val);
        }
        return new FabricSyncAllData(dogId, dataMap);
    }

    private static <T> T readValFromPacket(SyncTypes.SyncType<T> syncType, class_2540 buf) {
        Object val = syncType.getSerializer().codec().decode((Object)((class_9129)buf));
        return (T)val;
    }
}

