/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import com.google.common.collect.Lists;
import doggytalents.DoggyEntityTypes;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.feature.DogMode;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogDuplicationDetection;
import doggytalents.common.entity.DogIncapacitatedMananger;
import doggytalents.common.entity.ai.triggerable.DogDrownAction;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.storage.IDogData;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public class DogRespawnData
implements IDogData {
    private final DogRespawnStorage storage;
    private final UUID uuid;
    private UUID ownerUUID;
    private Optional<String> dogName = Optional.empty();
    private class_2487 data;
    private DogIncapacitatedMananger.IncapacitatedSyncState killedBy = DogIncapacitatedMananger.IncapacitatedSyncState.NONE;
    private static final List<String> TAGS_TO_REMOVE = Lists.newArrayList((Object[])new String[]{"Pos", "Health", "Motion", "Rotation", "FallDistance", "Fire", "Air", "OnGround", "Dimension", "PortalCooldown", "Passengers", "Leash", "InLove", "Leash", "HurtTime", "HurtByTimestamp", "DeathTime", "AbsorptionAmount", "FallFlying", "Brain", "Sitting", "ActiveEffects"});
    private static final List<String> IMPORTANT_TAGS = List.of("Owner", "friendlyFire", "UUID", "talents", "level_normal", "level_kami", "dogGender", "dogSize", "entityKills", "accessories", "doggytalents_dog_skin");
    private static final String STORAGE_AGE_TAG = "DogRespawn_Age";
    private static final String STORAGE_OWNER_TAG = "DogRespawn_ownerUUID";
    private static final String STORAGE_NAME_TAG = "DogRespawn_dogName";

    protected DogRespawnData(DogRespawnStorage storageIn, UUID uuid) {
        this.storage = storageIn;
        this.uuid = uuid;
    }

    @Override
    public UUID getDogId() {
        return this.uuid;
    }

    @Override
    public String getDogName() {
        String name = this.dogName.orElse(null);
        return name == null ? "noname" : name;
    }

    @Override
    public UUID getOwnerId() {
        return this.ownerUUID;
    }

    public void populate(Dog dogIn) {
        DataStrategy strategy;
        Optional<class_1282> deathCauseOptional;
        this.data = new class_2487();
        this.ownerUUID = dogIn.method_6139();
        class_2561 customName = dogIn.method_5797();
        if (customName != null) {
            this.dogName = Optional.ofNullable(customName.getString());
        }
        if ((deathCauseOptional = dogIn.getDogDeathCause()).isPresent()) {
            this.killedBy = dogIn.createIncapSyncState(deathCauseOptional.get());
        }
        if ((strategy = this.fetchDataStrategy()) == DataStrategy.KEEP_ALL_EXCEPT) {
            this.writeAlldataAndRemoveSpecific(dogIn, this.data);
        } else {
            this.writeImportantDataToKeep(dogIn, this.data);
        }
        this.data.method_10551("UUID");
        this.data.method_10551("LoveCause");
        this.data.method_10551("DTN_DupeDetect");
    }

    private void writeAlldataAndRemoveSpecific(Dog dog, class_2487 target) {
        dog.method_5647(target);
        for (String tag : TAGS_TO_REMOVE) {
            target.method_10551(tag);
        }
        target.method_10551(STORAGE_AGE_TAG);
        target.method_10551(STORAGE_OWNER_TAG);
        target.method_10551(STORAGE_NAME_TAG);
        try {
            List extraTagsToRemove = (List)ConfigHandler.RESPAWN_TAGS.TAGS_TO_REMOVE.get();
            for (String tag : extraTagsToRemove) {
                if (IMPORTANT_TAGS.contains(tag)) continue;
                target.method_10551(tag);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeImportantDataToKeep(Dog dog, class_2487 target) {
        class_2561 custom_name;
        dog.addDTNAdditionalSavedData(target);
        target.method_10569(STORAGE_AGE_TAG, dog.method_5618());
        UUID owner_uuid = dog.method_6139();
        if (owner_uuid != null) {
            target.method_25927(STORAGE_OWNER_TAG, owner_uuid);
        }
        if ((custom_name = dog.method_5797()) != null) {
            target.method_10582(STORAGE_NAME_TAG, class_2561.class_2562.method_10867((class_2561)custom_name, (class_7225.class_7874)dog.method_56673()));
        }
        this.keepAdditionalTag(target, dog);
    }

    private void keepAdditionalTag(class_2487 target, Dog dog) {
        try {
            List extraTagsToKeep = (List)ConfigHandler.RESPAWN_TAGS.TAGS_TO_KEEP.get();
            if (extraTagsToKeep == null || extraTagsToKeep.isEmpty()) {
                return;
            }
            class_2487 nonDTNTags = new class_2487();
            dog.addNonDTNAdditionalData(nonDTNTags);
            for (String toKeepStr : extraTagsToKeep) {
                if (!nonDTNTags.method_10545(toKeepStr) || target.method_10545(toKeepStr)) continue;
                class_2520 toKeep = nonDTNTags.method_10580(toKeepStr).method_10707();
                target.method_10566(toKeepStr, toKeep);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void restoreAndConsumeImportantDataIfNeeded(Dog dog, class_2487 tag) {
        if (tag.method_10573(STORAGE_AGE_TAG, 3)) {
            dog.method_5614(tag.method_10550(STORAGE_AGE_TAG));
            tag.method_10551(STORAGE_AGE_TAG);
        }
        if (tag.method_25928(STORAGE_OWNER_TAG)) {
            UUID correct_owner_uuid = this.ownerUUID;
            try {
                correct_owner_uuid = tag.method_25926(STORAGE_OWNER_TAG);
            }
            catch (Exception exception) {
                // empty catch block
            }
            dog.method_6174(correct_owner_uuid);
            dog.method_6173(correct_owner_uuid != null, true);
            tag.method_10551(STORAGE_OWNER_TAG);
        }
        if (tag.method_10545(STORAGE_NAME_TAG)) {
            try {
                String name_c1_str = tag.method_10558(STORAGE_NAME_TAG);
                dog.setDogCustomName((class_2561)class_2561.class_2562.method_10877((String)name_c1_str, (class_7225.class_7874)dog.method_56673()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            tag.method_10551(STORAGE_NAME_TAG);
        }
    }

    @Nullable
    public Dog respawn(class_3218 worldIn, class_1657 playerIn, class_2338 pos) {
        Dog dog = (Dog)DoggyEntityTypes.DOG.get().method_5883((class_1937)worldIn);
        if (dog == null) {
            return null;
        }
        dog.method_29495(class_243.method_24955((class_2382)pos));
        this.restoreAndConsumeImportantDataIfNeeded(dog, this.data);
        class_2487 compoundnbt = dog.method_5647(new class_2487());
        UUID uuid = dog.method_5667();
        compoundnbt.method_10543(this.data);
        dog.method_5651(compoundnbt);
        boolean useOldUUID = (Boolean)ConfigHandler.SERVER.DISABLE_PRESERVE_UUID.get() == false && worldIn.method_14190(this.uuid) == null;
        dog.method_5826(useOldUUID ? this.uuid : uuid);
        dog.method_24346(true);
        if (this.killedBy != null && this.killedBy != DogIncapacitatedMananger.IncapacitatedSyncState.NONE) {
            if (dog.getDogIncapValue() <= 0) {
                dog.setDogIncapValue(dog.getDefaultInitIncapVal());
            }
            dog.setDogHunger(0.0f);
            dog.setMode(DogMode.INJURED);
            dog.method_6033(1.0f);
            dog.setIncapSyncState(this.killedBy);
            if (dog.method_5799() || dog.method_5771()) {
                dog.triggerAnimationAction(new DogDrownAction(dog));
            } else {
                dog.setAnim(dog.incapacitatedMananger.getAnim());
            }
        } else {
            dog.setMode(DogMode.DOCILE);
            dog.setAnim(DogAnimation.STAND_QUICK);
            dog.maxHealth();
        }
        DogDuplicationDetection.onAboutToRespawn(dog);
        worldIn.method_30771((class_1297)dog);
        DogLocationStorage.setSessionUUIDFor(dog, uuid);
        return dog;
    }

    public void read(class_2487 compound) {
        this.data = compound.method_10562("data");
        if (compound.method_10573("dog_name", 8)) {
            try {
                String name_str = compound.method_10558("dog_name");
                this.dogName = Optional.ofNullable(name_str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (compound.method_25928("owner_uuid")) {
            this.ownerUUID = compound.method_25926("owner_uuid");
        }
        this.readKilledBy(compound);
    }

    public class_2487 write(class_2487 compound) {
        compound.method_10566("data", (class_2520)this.data);
        if (this.dogName.isPresent()) {
            compound.method_10582("dog_name", this.dogName.get());
        }
        if (this.ownerUUID != null) {
            compound.method_25927("owner_uuid", this.ownerUUID);
        }
        this.writeKilledBy(compound);
        return compound;
    }

    public void writeKilledBy(class_2487 compound) {
        if (this.killedBy == DogIncapacitatedMananger.IncapacitatedSyncState.NONE) {
            return;
        }
        if (this.killedBy == null) {
            return;
        }
        class_2487 killedByTag = new class_2487();
        killedByTag.method_10569("typeId", this.killedBy.type.getId());
        killedByTag.method_10569("poseId", this.killedBy.poseId);
        compound.method_10566("dog_killed_by", (class_2520)killedByTag);
    }

    public void readKilledBy(class_2487 compound) {
        if (!compound.method_10573("dog_killed_by", 10)) {
            return;
        }
        class_2487 killedByTag = compound.method_10562("dog_killed_by");
        int typeId = killedByTag.method_10550("typeId");
        int poseId = killedByTag.method_10550("poseId");
        this.killedBy = new DogIncapacitatedMananger.IncapacitatedSyncState(DogIncapacitatedMananger.DefeatedType.byId(typeId), DogIncapacitatedMananger.BandaidState.NONE, poseId);
    }

    private DataStrategy fetchDataStrategy() {
        Integer stategy_int = (Integer)ConfigHandler.RespawnTagConfig.getConfig(ConfigHandler.RESPAWN_TAGS.STRATEGY);
        if (stategy_int != 1) {
            return DataStrategy.REMOVE_ALL_EXCEPT;
        }
        return DataStrategy.KEEP_ALL_EXCEPT;
    }

    private static enum DataStrategy {
        REMOVE_ALL_EXCEPT,
        KEEP_ALL_EXCEPT;

    }
}

