/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTalents;
import doggytalents.TalentsOptions;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.inventory.PackPuppyItemHandler;
import doggytalents.common.talent.PackPuppyTalent;
import doggytalents.common.util.InventoryUtil;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import org.apache.commons.lang3.tuple.Pair;

public class DoggyTorchTalent
extends TalentInstance {
    private boolean placingTorch = true;
    private boolean renderTorch = true;

    public DoggyTorchTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (this.placingTorch && dogIn.field_6012 % 10 == 0 && dogIn.method_6181()) {
            class_2338 pos = dogIn.method_24515();
            class_2680 torchState = class_2246.field_10336.method_9564();
            if (dogIn.method_37908().method_22339(dogIn.method_24515()) < 8 && dogIn.method_37908().method_22347(pos) && torchState.method_26184((class_4538)dogIn.method_37908(), pos)) {
                Pair<class_1799, Integer> foundDetails;
                PackPuppyItemHandler inventory = dogIn.getTalent(DoggyTalents.PACK_PUPPY).map(inst -> inst.cast(PackPuppyTalent.class).inventory()).orElse(null);
                if (this.level() >= 5) {
                    dogIn.method_37908().method_8501(pos, torchState);
                } else if (inventory != null && (foundDetails = InventoryUtil.findStack((class_1263)inventory, stack -> stack.method_7909() == class_1802.field_8810)) != null && !((class_1799)foundDetails.getLeft()).method_7960()) {
                    class_1799 torchStack = (class_1799)foundDetails.getLeft();
                    dogIn.consumeItemFromStack((class_1297)dogIn, torchStack);
                    inventory.setStackInSlot((Integer)foundDetails.getRight(), torchStack);
                    dogIn.method_37908().method_8501(pos, torchState);
                }
            }
        }
    }

    public boolean canRenderTorch() {
        return this.level() >= 5;
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, class_2487 compound) {
        super.readFromNBT(dogIn, compound);
        this.placingTorch = compound.method_10577("placingTorch");
        this.renderTorch = compound.method_10577("renderTorch");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, class_2487 compound) {
        super.writeToNBT(dogIn, compound);
        compound.method_10556("placingTorch", this.placingTorch);
        compound.method_10556("renderTorch", this.renderTorch);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.DOGGY_TORCH_ENABLE.get()) {
            return this.placingTorch;
        }
        if (entry == TalentsOptions.DOGGY_TORCH_RENDER.get()) {
            return this.renderTorch;
        }
        return null;
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.DOGGY_TORCH_ENABLE.get()) {
            this.placingTorch = (Boolean)data;
        }
        if (entry == TalentsOptions.DOGGY_TORCH_RENDER.get()) {
            this.renderTorch = (Boolean)data;
        }
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.DOGGY_TORCH_ENABLE.get(), TalentsOptions.DOGGY_TORCH_RENDER.get());
    }

    public boolean placingTorch() {
        return this.placingTorch;
    }

    public void setPlacingTorch(boolean torch) {
        this.placingTorch = torch;
    }

    public boolean renderTorch() {
        return this.renderTorch;
    }

    public void setRenderTorch(boolean torch) {
        this.renderTorch = torch;
    }
}

