/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.client.entity.model.SyncedAccessoryModel;
import doggytalents.client.entity.model.dog.DogModel;
import java.util.Optional;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.joml.Vector3f;

public class SyncedRenderFunctionWithHeadModel
extends SyncedAccessoryModel {
    private Vector3f pivot = DogModel.DEFAULT_ROOT_PIVOT;

    public SyncedRenderFunctionWithHeadModel(ModelPart root) {
        super(root);
    }

    @Override
    public void sync(DogModel dogModel) {
        this.root.m_104315_(dogModel.root);
        this.syncPart(this.head, dogModel.head);
        this.syncPart(this.realHead, dogModel.realHead);
        this.pivot = DogModel.DEFAULT_ROOT_PIVOT;
        Vector3f custom_pivot = dogModel.getCustomRootPivotPoint();
        if (custom_pivot != null) {
            this.pivot = custom_pivot;
        }
    }

    private void syncPart(Optional<ModelPart> part, ModelPart dogPart) {
        part.ifPresent(p -> p.m_104315_(dogPart));
    }

    @Override
    protected void populatePart(ModelPart box) {
        this.head = Optional.of(box.m_171324_("head"));
        this.realHead = Optional.of(((ModelPart)this.head.get()).m_171324_("real_head"));
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)13.5f, (float)-7.0f));
        PartDefinition real_head = head.m_171599_("real_head", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    @Override
    public void m_7695_(PoseStack stack, VertexConsumer p_103014_, int p_103015_, int p_103016_, float p_103017_, float p_103018_, float p_103019_, float p_103020_) {
    }

    public void startRenderFromRoot(PoseStack stack, Renderer actualRendering) {
        DogModel.renderDogModelFromRootWithPivot(stack, this.createDogRenderContext(actualRendering));
    }

    public DogModel.DogModelRenderContext createDogRenderContext(Renderer actualRendering) {
        DogModel.AddtionalHeadRenderer additional_head_renderer = (stack, part_ctx) -> this.startRenderItemFromHead(stack, actualRendering);
        return new DogModel.DogModelRenderContext(this.root, this.pivot, SyncedAccessoryModel.getDogModelBabyHead(this.head, this.f_102610_), Optional.empty(), Optional.of(additional_head_renderer));
    }

    public void startRenderItemFromHead(PoseStack matrixStack, Renderer renderer) {
        matrixStack.m_85836_();
        ((ModelPart)this.head.get()).m_104299_(matrixStack);
        matrixStack.m_85836_();
        ((ModelPart)this.realHead.get()).m_104299_(matrixStack);
        renderer.doRender(matrixStack);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }

    public static interface Renderer {
        public void doRender(PoseStack var1);
    }
}

