/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.DoggyTalentsNext;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.block.tileentity.DogBedTileEntity;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogMoveToBedAction;
import doggytalents.common.storage.DogRespawnData;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.util.DogBedUtil;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.WorldUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DogBedBlock
extends BaseEntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SHAPE_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);

    public DogBedBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60913_(1.0f, 5.0f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        return SHAPE_COLLISION;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        return new DogBedTileEntity(pos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return null;
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        state = (BlockState)state.m_61124_((Property)FACING, (Comparable)Optional.ofNullable(placer).map(Entity::m_6350_).map(Direction::m_122424_).orElse(Direction.NORTH));
        DogBedTileEntity dogBedTileEntity = WorldUtil.getTileEntity((BlockGetter)worldIn, pos, DogBedTileEntity.class);
        if (dogBedTileEntity != null) {
            DogBedUtil.setBedVariant(dogBedTileEntity, stack);
            dogBedTileEntity.setPlacer(placer);
            CompoundTag tag = stack.m_41737_("doggytalents");
            if (tag != null) {
                Component name = NBTUtil.getTextComponent(tag, "name");
                UUID ownerId = NBTUtil.getUniqueId(tag, "ownerId");
                dogBedTileEntity.setBedName(name);
                dogBedTileEntity.setOwner(ownerId);
            }
        }
        worldIn.m_7731_(pos, state, 2);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        DogBedTileEntity tile = WorldUtil.getTileEntity((BlockGetter)level, pos, DogBedTileEntity.class);
        if (tile == null) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(handIn);
        if (this.handleNameTagBed(player, level, state, pos, tile, stack).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleDogRandomRespawn(player, level, state, pos, tile, stack).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleDogClaimBed(player, level, state, pos, tile, stack).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleDogRespawn(player, level, state, pos, tile, stack).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleDogReclaim(player, level, state, pos, tile, stack).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        if (tile.getOwnerUUID() != null) {
            Component name = tile.getOwnerName();
            player.m_213846_((Component)Component.m_237110_((String)"block.doggytalents.dog_bed.owner", (Object[])new Object[]{name != null ? name : "someone"}));
        } else {
            player.m_213846_((Component)Component.m_237115_((String)"block.doggytalents.dog_bed.set_owner_help"));
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleDogRandomRespawn(Player player, Level level, BlockState state, BlockPos pos, DogBedTileEntity tile, ItemStack stack) {
        if (tile.getOwnerUUID() != null) {
            return InteractionResult.PASS;
        }
        if (!stack.m_150930_(Items.f_42747_)) {
            return InteractionResult.PASS;
        }
        if (player.m_36335_().m_41519_(Items.f_42747_)) {
            return InteractionResult.PASS;
        }
        DogRespawnStorage storage = DogRespawnStorage.get(level);
        Predicate<DogRespawnData> isFromOwner = filter_data -> {
            UUID owner_id = filter_data.getOwnerId();
            if (owner_id == null) {
                return false;
            }
            return !ObjectUtils.notEqual((Object)owner_id, (Object)player.m_20148_());
        };
        List dataList = storage.getAll().stream().filter(isFromOwner).collect(Collectors.toList());
        if (dataList.isEmpty()) {
            return InteractionResult.PASS;
        }
        int dataListSize = dataList.size();
        int rIndx = player.m_217043_().m_188503_(dataListSize);
        UUID rUUID = ((DogRespawnData)dataList.get(rIndx)).getDogId();
        DogRespawnData dogData = storage.remove(rUUID);
        if (dogData == null) {
            return InteractionResult.SUCCESS;
        }
        Dog dog = dogData.respawn((ServerLevel)level, player, pos.m_7494_());
        if (dog == null) {
            return InteractionResult.SUCCESS;
        }
        tile.setOwner(dog);
        dog.setBedPos((ResourceKey<Level>)dog.m_9236_().m_46472_(), pos);
        dog.m_9236_().m_7605_((Entity)dog, (byte)35);
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        player.m_36335_().m_41524_(Items.f_42747_, 60);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleDogReclaim(Player player, Level level, BlockState state, BlockPos pos, DogBedTileEntity tile, ItemStack stack) {
        UUID owner_id = tile.getOwnerUUID();
        if (owner_id == null) {
            return InteractionResult.PASS;
        }
        if (!player.m_6144_()) {
            return InteractionResult.PASS;
        }
        this.reclaimBed(player, (ServerLevel)level, tile, pos);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleDogRespawn(Player player, Level level, BlockState state, BlockPos pos, DogBedTileEntity tile, ItemStack stack) {
        UUID owner_id = tile.getOwnerUUID();
        if (owner_id == null) {
            return InteractionResult.PASS;
        }
        DogRespawnStorage storage = DogRespawnStorage.get(level);
        DogRespawnData data = storage.remove(owner_id);
        if (data == null) {
            return InteractionResult.PASS;
        }
        Dog dog = data.respawn((ServerLevel)level, player, pos.m_7494_());
        if (dog == null) {
            return InteractionResult.SUCCESS;
        }
        tile.setOwner(dog);
        dog.setBedPos((ResourceKey<Level>)dog.m_9236_().m_46472_(), pos);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleDogClaimBed(Player player, Level level, BlockState state, BlockPos pos, DogBedTileEntity tile, ItemStack stack) {
        Dog closest;
        boolean isAssign;
        if (tile.getOwnerUUID() != null) {
            return InteractionResult.PASS;
        }
        boolean bl = isAssign = player.m_6144_() || stack.m_150930_(Items.f_42500_) || stack.m_150930_(DoggyItems.TRAINING_TREAT.get());
        if (!isAssign) {
            return InteractionResult.PASS;
        }
        Predicate<Dog> isValidDog = valid_dog -> valid_dog.isDoingFine() && valid_dog.m_21830_((LivingEntity)player) && !valid_dog.m_21827_();
        List dogs = level.m_142425_((EntityTypeTest)DoggyEntityTypes.DOG.get(), new AABB(pos).m_82400_(10.0), isValidDog);
        Collections.sort(dogs, new EntityUtil.Sorter(Vec3.m_82539_((Vec3i)pos)));
        Dog dog = closest = dogs.isEmpty() ? null : (Dog)dogs.get(0);
        if (pos != null && closest != null && closest.readyForNonTrivialAction()) {
            closest.triggerAction(new DogMoveToBedAction(closest, pos, true));
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleNameTagBed(Player player, Level level, BlockState state, BlockPos pos, DogBedTileEntity tile, ItemStack stack) {
        if (!stack.m_150930_(Items.f_42656_)) {
            return InteractionResult.PASS;
        }
        if (!stack.m_41788_()) {
            return InteractionResult.PASS;
        }
        tile.setBedName(stack.m_41786_());
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        level.m_7260_(pos, state, state, 3);
        return InteractionResult.SUCCESS;
    }

    private boolean reclaimBed(Player player, ServerLevel level, DogBedTileEntity bedEntity, BlockPos pos) {
        Entity e = level.m_8791_(bedEntity.getOwnerUUID());
        if (!(e instanceof Dog)) {
            return false;
        }
        Dog dog = (Dog)e;
        Optional<BlockPos> bedPosOptional = dog.getBedPos();
        if (!bedPosOptional.isPresent()) {
            return false;
        }
        BlockPos bedPos = bedPosOptional.get();
        if (bedPos.equals((Object)pos)) {
            return false;
        }
        dog.setBedPos(pos);
        player.m_213846_((Component)Component.m_237110_((String)"block.doggytalents.dog_bed.reclaim", (Object[])new Object[]{dog.m_7755_().getString(), dog.getGenderPossessiveAdj()}));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag;
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        Pair<ICasingMaterial, IBeddingMaterial> materials = DogBedUtil.getMaterials(stack);
        tooltip.add((Component)Component.m_237115_((String)"dogbed.casing.title"));
        tooltip.add((Component)(materials.getLeft() != null ? ((ICasingMaterial)materials.getLeft()).getTooltip() : Component.m_237115_((String)"dogbed.casing.null").m_130940_(ChatFormatting.RED)));
        tooltip.add((Component)Component.m_237115_((String)"dogbed.bedding.title"));
        tooltip.add((Component)(materials.getRight() != null ? ((IBeddingMaterial)materials.getRight()).getTooltip() : Component.m_237115_((String)"dogbed.bedding.null").m_130940_(ChatFormatting.RED)));
        if (materials.getLeft() == null && materials.getRight() == null) {
            tooltip.add((Component)Component.m_237115_((String)"dogbed.explain.missing").m_130940_(ChatFormatting.ITALIC));
        }
        if ((tag = stack.m_41737_("doggytalents")) != null) {
            UUID ownerId = NBTUtil.getUniqueId(tag, "ownerId");
            Component name = NBTUtil.getTextComponent(tag, "name");
            Component ownerName = NBTUtil.getTextComponent(tag, "ownerName");
            if (name != null) {
                tooltip.add((Component)Component.m_237113_((String)"Bed Name: ").m_130940_(ChatFormatting.WHITE).m_7220_(name));
            }
            if (ownerName != null) {
                tooltip.add((Component)Component.m_237113_((String)"Name: ").m_130940_(ChatFormatting.DARK_AQUA).m_7220_(ownerName));
            }
            if (ownerId != null && flagIn.m_7050_()) {
                tooltip.add((Component)Component.m_237113_((String)"UUID: ").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)ownerId.toString())));
            }
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        DogBedTileEntity dogBedTileEntity = WorldUtil.getTileEntity(world, pos, DogBedTileEntity.class);
        if (dogBedTileEntity != null) {
            return DogBedUtil.createItemStack(dogBedTileEntity.getCasing(), dogBedTileEntity.getBedding());
        }
        DoggyTalentsNext.LOGGER.debug("Unable to pick block on dog bed.");
        return ItemStack.f_41583_;
    }
}

