/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyTalents;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class DogThrownTrident
extends AbstractArrow {
    private static final int loyalty_amount = 3;
    private boolean isReturning;
    private boolean playedClientReturnSound;
    private int timeOutTick = 0;
    private ItemStack tridentStack = ItemStack.f_41583_;

    public DogThrownTrident(EntityType<DogThrownTrident> p_37561_, Level p_37562_) {
        super(p_37561_, p_37562_);
    }

    public DogThrownTrident(Dog dog, ItemStack trident_stack) {
        super(DoggyEntityTypes.DOG_TRIDENT_PROJ.get(), (LivingEntity)dog, dog.m_9236_());
        this.tridentStack = trident_stack;
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_8119_() {
        Optional<Dog> return_owner_optional = this.getDogOwnerForReturn();
        if (!this.m_9236_().f_46443_ && this.doDogTridentInvalidateSelf(return_owner_optional)) {
            return;
        }
        if (return_owner_optional.isPresent()) {
            Dog return_owner = return_owner_optional.get();
            this.updateReturning(return_owner);
            if (this.isReturning) {
                this.returnToDog(return_owner);
            }
        }
        super.m_8119_();
    }

    private void updateReturning(Dog return_dog) {
        if (this.isReturning) {
            return;
        }
        if (this.f_36704_ > 1 || this.m_36797_()) {
            this.switchToReturnToDog();
            return;
        }
    }

    private void returnToDog(Dog return_dog) {
        this.m_36790_(true);
        Vec3 pos = this.m_20182_();
        Vec3 dog_pos = return_dog.m_146892_();
        Vec3 v_self_dog = dog_pos.m_82546_(pos);
        Vec3 current_move_vec = this.m_20184_();
        double l_current_move_vec = current_move_vec.m_82553_();
        float max_speed = 1.2f;
        double acceleration = 0.15000000000000002;
        double return_speed = Mth.m_14008_((double)(l_current_move_vec + 0.15000000000000002), (double)0.0, (double)1.2f);
        Vec3 return_vec = v_self_dog.m_82541_().m_82490_(return_speed);
        this.m_20256_(return_vec);
        if (!this.playedClientReturnSound) {
            this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
            this.playedClientReturnSound = true;
        }
    }

    private void switchToReturnToDog() {
        this.isReturning = true;
    }

    private boolean doDogTridentInvalidateSelf(Optional<Dog> return_dog_optional) {
        ++this.timeOutTick;
        if (this.timeOutTick > DogThrownTrident.getDogTridentTimeout()) {
            this.m_146870_();
            return true;
        }
        if (!return_dog_optional.isPresent()) {
            this.m_146870_();
            return true;
        }
        Dog return_dog = return_dog_optional.get();
        if (this.isReturning && return_dog.m_20280_((Entity)this) <= 4.0) {
            this.m_146870_();
            return true;
        }
        return false;
    }

    public Optional<Dog> getDogOwnerForReturn() {
        Entity owner = this.m_19749_();
        if (!(owner instanceof Dog)) {
            return Optional.empty();
        }
        Dog dog = (Dog)owner;
        if (!dog.isDoingFine()) {
            return Optional.empty();
        }
        if (dog.m_20280_((Entity)this) > 900.0) {
            return Optional.empty();
        }
        if (dog.m_21825_()) {
            return Optional.empty();
        }
        return Optional.of(dog);
    }

    public boolean isFoil() {
        return true;
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 p_37575_, Vec3 p_37576_) {
        return this.isReturning ? null : super.m_6351_(p_37575_, p_37576_);
    }

    protected void m_5790_(EntityHitResult hit_result) {
        float sound_volume;
        Entity target = hit_result.m_82443_();
        boolean hurt_success = this.hurtDogTridentTarget(target);
        boolean did_lightning = this.maySummonLightningBolt(target);
        this.switchToReturnToDog();
        this.m_20256_(Vec3.f_82478_);
        Object play_sound = null;
        play_sound = did_lightning ? SoundEvents.f_12521_ : (hurt_success ? SoundEvents.f_12514_ : null);
        float f = sound_volume = did_lightning ? 5.0f : 1.0f;
        if (play_sound != null) {
            this.m_5496_((SoundEvent)play_sound, sound_volume, 1.0f);
        }
    }

    private boolean hurtDogTridentTarget(Entity target) {
        boolean result;
        Entity owner;
        float damage = 8.0f;
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            damage += EnchantmentHelper.m_44833_((ItemStack)this.tridentStack, (MobType)living.m_6336_());
        }
        DogThrownTrident indirect_entity_source = (owner = this.m_19749_()) == null ? this : owner;
        DamageSource trident_source = this.m_269291_().m_269418_((AbstractArrow)this, (Entity)indirect_entity_source);
        if (this.m_6060_()) {
            target.m_20254_(5);
        }
        if (!(result = target.m_6469_(trident_source, damage))) {
            return false;
        }
        this.doDogTridentEnchantDamageEffects(owner, target);
        this.killCreeperIfCreeperSweeper(target);
        return true;
    }

    private void doDogTridentEnchantDamageEffects(Entity owner, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity target_living = (LivingEntity)target;
            if (owner instanceof LivingEntity) {
                LivingEntity owner_living = (LivingEntity)owner;
                EnchantmentHelper.m_44823_((LivingEntity)target_living, (Entity)owner_living);
                EnchantmentHelper.m_44896_((LivingEntity)owner_living, (Entity)target_living);
            }
            this.m_7761_(target_living);
        }
    }

    private void killCreeperIfCreeperSweeper(Entity target) {
        Entity owner = this.m_19749_();
        if (!(owner instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)owner;
        if (dog.getDogLevel((Supplier)DoggyTalents.CREEPER_SWEEPER) < 5) {
            return;
        }
        if (!(target instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)target;
        creeper.m_21153_(0.0f);
        creeper.m_6667_(dog.m_269291_().m_269333_((LivingEntity)dog));
    }

    public boolean isChanneling() {
        return EnchantmentHelper.m_44936_((ItemStack)this.tridentStack);
    }

    private boolean maySummonLightningBolt(Entity target) {
        if (!(this.m_9236_() instanceof ServerLevel)) {
            return false;
        }
        if (!this.m_9236_().m_46470_()) {
            return false;
        }
        if (!this.isChanneling()) {
            return false;
        }
        BlockPos target_b0 = target.m_20183_();
        if (!this.m_9236_().m_45527_(target_b0)) {
            return false;
        }
        LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
        if (lightningbolt == null) {
            return false;
        }
        lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)target_b0));
        lightningbolt.m_20879_(null);
        this.m_9236_().m_7967_((Entity)lightningbolt);
        return true;
    }

    public static int getDogTridentTimeout() {
        return 50;
    }

    protected boolean m_142470_(Player player) {
        return false;
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42713_);
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public boolean m_142391_() {
        return false;
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double p_37588_, double p_37589_, double p_37590_) {
        return true;
    }
}

