/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyItems;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.item.ScentTreatItem;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.NBTUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class SnifferDogTalent
extends TalentInstance {
    private Block detectingBlock = Blocks.f_50016_;
    private Optional<BlockPos> suspiciousPos = Optional.empty();
    private int dontNotifyOwnerAgainTick = 0;
    private int tickTillDetect = 5;

    public SnifferDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (dogIn.m_9236_().f_46443_) {
            return;
        }
        if (!dogIn.isDoingFine()) {
            return;
        }
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        if (this.dontNotifyOwnerAgainTick > 0) {
            --this.dontNotifyOwnerAgainTick;
        }
        this.validateSuspiciousPos(dog);
        if (!this.suspiciousPos.isPresent() && !dog.m_21825_() && this.detectingBlock != Blocks.f_50016_) {
            this.detectBlocksAround(dog);
        }
        if (dog.isBusy()) {
            return;
        }
        if (this.suspiciousPos.isPresent() && this.dontNotifyOwnerAgainTick <= 0) {
            this.notifyOwner(dog);
        }
    }

    private void detectBlocksAround(Dog dog) {
        if (--this.tickTillDetect > 0) {
            return;
        }
        this.tickTillDetect = 10;
        this.doDetectBlockAround(dog);
    }

    private void doDetectBlockAround(Dog dog) {
        BlockPos dog_b0 = dog.m_20183_();
        int radius = this.getDetectRadius(dog);
        int start = 0;
        while (start + 2 <= radius) {
            for (int i = 0; i < 10; ++i) {
                RandomSource r = dog.m_217043_();
                int offSmall = 2;
                int offLarge = start + 2;
                int r1 = r.m_216332_(-offLarge, offLarge);
                int r2 = r.m_216332_(-offSmall, offSmall);
                r2 += Mth.m_14205_((double)r2) * start;
                int randXOff = r1;
                int randZOff = r2;
                if (r.m_188499_()) {
                    randXOff = r2;
                    randZOff = r1;
                }
                int randYOff = r.m_216332_(-3, 3);
                BlockPos rand_b0 = dog_b0.m_121955_(new Vec3i(randXOff, randYOff, randZOff));
                BlockState state = dog.m_9236_().m_8055_(rand_b0);
                if (state.m_60734_() != this.detectingBlock) continue;
                this.suspiciousPos = Optional.of(rand_b0);
                return;
            }
            start += 2;
        }
    }

    private int getDetectRadius(Dog dog) {
        if (this.level() >= 5) {
            return 28;
        }
        if (this.level() < 0) {
            return 0;
        }
        switch (this.level()) {
            case 1: {
                return 6;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 16;
            }
            case 4: {
                return 22;
            }
        }
        return 8;
    }

    public void setDetectBlock(Block block) {
        this.detectingBlock = block;
        if (block == null || block instanceof AirBlock) {
            this.detectingBlock = Blocks.f_50016_;
        }
    }

    public void clearDetectBlock() {
        this.detectingBlock = Blocks.f_50016_;
    }

    @Override
    public InteractionResult processInteract(AbstractDog dog, Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (!stack.m_150930_(DoggyItems.SCENT_TREAT.get())) {
            return InteractionResult.PASS;
        }
        if (dog.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (playerIn.m_6144_()) {
            if (this.detectingBlock == null) {
                this.detectingBlock = Blocks.f_50016_;
            }
            MutableComponent c1 = this.detectingBlock == Blocks.f_50016_ ? Component.m_237115_((String)"talent.doggytalents.sniffer_dog.detecting_block_status.none") : Component.m_237110_((String)"talent.doggytalents.sniffer_dog.detecting_block_status", (Object[])new Object[]{dog.m_7755_().getString(), Component.m_237115_((String)this.detectingBlock.m_5456_().m_5524_()).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)))});
            playerIn.m_213846_((Component)c1);
            return InteractionResult.SUCCESS;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(ScentTreatItem.SCENT_BLOCK_ID)) {
            this.clearDetectBlock();
        } else {
            Block block = (Block)NBTUtil.getRegistryValue(tag, ScentTreatItem.SCENT_BLOCK_ID, ForgeRegistries.BLOCKS);
            if (block == null) {
                return InteractionResult.SUCCESS;
            }
            this.setDetectBlock(block);
        }
        dog.m_5496_(SoundEvents.f_144181_, 1.0f, 1.0f);
        ItemStack retItem = new ItemStack((ItemLike)DoggyItems.DROOL_SCENT_TREAT.get());
        if (stack.m_41782_()) {
            retItem.m_41751_(stack.m_41783_().m_6426_());
        }
        dog.m_19983_(retItem);
        stack.m_41774_(1);
        return InteractionResult.SUCCESS;
    }

    public void validateSuspiciousPos(Dog dog) {
        if (!this.suspiciousPos.isPresent()) {
            return;
        }
        BlockPos pos = this.suspiciousPos.get();
        BlockState state = dog.m_9236_().m_8055_(pos);
        if (!state.m_60713_(this.detectingBlock)) {
            this.suspiciousPos = Optional.empty();
        }
    }

    public void notifyOwner(Dog dog) {
        LivingEntity owner = dog.m_269323_();
        if (owner == null) {
            return;
        }
        if (owner.m_20280_((Entity)dog) > 64.0) {
            return;
        }
        if (!dog.canDoIdileAnim()) {
            return;
        }
        dog.triggerAction(new DogGetOwnerAttentionAndInformAction(dog, owner, this));
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        if (this.detectingBlock == null) {
            this.detectingBlock = Blocks.f_50016_;
        }
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)this.detectingBlock);
        NBTUtil.putResourceLocation(compound, "snifferDog_detectingBlock", id);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        Block block = (Block)NBTUtil.getRegistryValue(compound, "snifferDog_detectingBlock", ForgeRegistries.BLOCKS);
        if (block == null) {
            block = Blocks.f_50016_;
        }
        this.detectingBlock = block;
    }

    public static class DogGetOwnerAttentionAndInformAction
    extends TriggerableAction {
        private SnifferDogTalent inst;
        private LivingEntity owner;
        private boolean isPointingToPos = false;
        private int timeOutTick = 0;
        private boolean notifiedOwner = false;
        private BlockPos targetPos;
        private int tickLookLeft = 0;
        private int tickAnim = 0;
        private DogAnimation currentAnimation = DogAnimation.SNIFFER_DOG_POINT_STRAIGHT;

        public DogGetOwnerAttentionAndInformAction(Dog dog, LivingEntity owner, SnifferDogTalent inst) {
            super(dog, false, false);
            this.inst = inst;
            this.owner = owner;
        }

        @Override
        public void onStart() {
            this.isPointingToPos = false;
            this.notifiedOwner = false;
            this.timeOutTick = 400 + this.dog.m_217043_().m_188503_(6) * 20;
            this.targetPos = this.inst.suspiciousPos.orElse(null);
            this.tickLookLeft = 10;
            this.tickAnim = 0;
        }

        @Override
        public void tick() {
            if (!this.owner.m_6084_() || this.owner.m_5833_()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.owner.m_20280_((Entity)this.dog) > 144.0) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            this.invalidateTargetPos();
            if (this.targetPos == null) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!this.isPointingToPos) {
                --this.timeOutTick;
                if (this.timeOutTick <= 0) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
            } else {
                boolean anim_end_or_interupted;
                boolean bl = anim_end_or_interupted = this.tickAnim >= this.currentAnimation.getLengthTicks() || this.dog.getAnim() != this.currentAnimation || !this.dog.m_20096_();
                if (this.tickLookLeft <= 0 && anim_end_or_interupted) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
            }
            if (this.isPointingToPos) {
                this.pointsTowardThePos();
            } else {
                this.getOwnerAttention();
            }
        }

        private void invalidateTargetPos() {
            if (this.targetPos == null) {
                return;
            }
            if (!this.inst.suspiciousPos.isPresent()) {
                this.targetPos = null;
                return;
            }
            if (!this.inst.suspiciousPos.get().equals((Object)this.targetPos)) {
                this.targetPos = null;
                return;
            }
        }

        private void getOwnerAttention() {
            if (this.targetPos == null) {
                return;
            }
            this.dog.m_21563_().m_148051_((Entity)this.owner);
            if (!this.notifiedOwner) {
                this.notifiedOwner = true;
                this.notifyOwner(this.dog, this.owner, this.dog.m_20238_(Vec3.m_82512_((Vec3i)this.targetPos)));
                this.moveBackIfNeeded(this.dog, this.targetPos);
            }
            if (this.dog.m_20280_((Entity)this.owner) > 16.0) {
                return;
            }
            if (!this.checkIfCanSeeOwner(this.dog, this.owner)) {
                return;
            }
            if (DogUtil.checkIfOwnerIsLooking(this.dog, this.owner)) {
                this.isPointingToPos = true;
            }
        }

        private void pointsTowardThePos() {
            if (this.targetPos == null) {
                return;
            }
            this.dog.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)this.targetPos));
            if (this.tickLookLeft > 0) {
                --this.tickLookLeft;
                if (this.tickLookLeft <= 0) {
                    this.currentAnimation = this.pickAnim(this.dog, this.targetPos);
                    this.dog.setAnim(this.currentAnimation);
                }
                return;
            }
            ++this.tickAnim;
        }

        private void moveBackIfNeeded(Dog dog, BlockPos pos) {
            Vec3 v_dog_pos = Vec3.m_82539_((Vec3i)pos).m_82546_(dog.m_20182_());
            Vec3 v_dog_pos_xz = new Vec3(v_dog_pos.f_82479_, 0.0, v_dog_pos.f_82481_).m_82541_();
            Vec3 wantedStandPos = Vec3.m_82539_((Vec3i)dog.m_20183_()).m_82546_(v_dog_pos_xz.m_82490_(0.5));
            dog.m_21566_().m_6849_(wantedStandPos.f_82479_, wantedStandPos.f_82480_, wantedStandPos.f_82481_, 0.5);
        }

        private DogAnimation pickAnim(Dog dog, BlockPos pos) {
            Vec3 v_dog_pos = Vec3.m_82512_((Vec3i)pos).m_82546_(dog.m_146892_());
            if (v_dog_pos.f_82480_ < -1.0) {
                return DogAnimation.SNIFFER_DOG_POINT_DOWNARD;
            }
            if (v_dog_pos.f_82480_ > 1.0) {
                return DogAnimation.SNIFFER_DOG_POINT_UPWARD;
            }
            return DogAnimation.SNIFFER_DOG_POINT_STRAIGHT;
        }

        private void notifyOwner(Dog dog, LivingEntity owner, double distanceAwaySqr) {
            MutableComponent c1 = Component.m_237110_((String)this.getStringStatus(dog, distanceAwaySqr), (Object[])new Object[]{dog.m_7755_().getString()});
            owner.m_213846_((Component)c1);
            if (distanceAwaySqr <= 64.0) {
                SoundEvent sound = dog.dogMood.getSnifferDogForteSound();
                dog.m_5496_(sound, 1.0f, 1.0f);
            } else {
                SoundEvent sound = dog.dogMood.getSnifferDogPianoSound();
                dog.m_5496_(sound, 1.0f, 1.5f);
            }
        }

        private String getStringStatus(Dog dog, double distanceAwaySqr) {
            int r = dog.m_217043_().m_188503_(3);
            String posfix = ".mid";
            if (distanceAwaySqr > 256.0) {
                posfix = ".far";
            } else if (distanceAwaySqr <= 64.0) {
                posfix = ".near";
            }
            return "talent.doggytalents.sniffer_dog.notify_owner." + r + posfix;
        }

        private boolean checkIfCanSeeOwner(Dog dog, LivingEntity owner) {
            if (dog.f_19797_ % 5 != 0) {
                return false;
            }
            return dog.m_21574_().m_148306_((Entity)owner);
        }

        @Override
        public void onStop() {
            this.inst.suspiciousPos = Optional.empty();
            this.inst.dontNotifyOwnerAgainTick = (5 + this.dog.m_217043_().m_188503_(10)) * 20;
        }
    }
}

