/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.CachedSearchUtil;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogNodeEvaluator;
import doggytalents.common.entity.ai.nav.DogPathNavigation;
import doggytalents.common.util.DogUtil;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.Pair;

public class DogGreedyFireSafeSearchPath
extends Path {
    private ArrayList<Node> nodes;
    private Dog dog;
    public boolean finished;
    private int maxLength;
    private Node startNode;
    private int walkableCount = 0;

    private DogGreedyFireSafeSearchPath(Dog dog, ArrayList<Node> nodes, int maxLength) {
        super(nodes, dog.m_20183_(), false);
        this.nodes = nodes;
        this.dog = dog;
        this.maxLength = maxLength;
    }

    public static DogGreedyFireSafeSearchPath create(Dog dog, int maxLength) {
        Optional<Pair<Boolean, Node>> start_node_pair = DogGreedyFireSafeSearchPath.getStartNode(dog);
        if (!start_node_pair.isPresent()) {
            return null;
        }
        boolean skip_start = (Boolean)start_node_pair.get().getLeft();
        Node start_node = (Node)start_node_pair.get().getRight();
        ArrayList<Node> initNodes = new ArrayList<Node>(maxLength);
        initNodes.add(start_node);
        DogGreedyFireSafeSearchPath ret = new DogGreedyFireSafeSearchPath(dog, initNodes, maxLength);
        ret.startNode = start_node;
        Optional<Node> node_optional = DogGreedyFireSafeSearchPath.scanSurroundingForNextPos(ret);
        if (!node_optional.isPresent()) {
            return null;
        }
        if (skip_start) {
            initNodes.clear();
            initNodes.add(node_optional.get());
        }
        if (initNodes.isEmpty()) {
            return null;
        }
        initNodes.get((int)0).f_77282_ = BlockPathTypes.WALKABLE;
        return ret;
    }

    private static Optional<Pair<Boolean, Node>> getStartNode(Dog dog) {
        BlockPos dog_b0_under;
        BlockPos dog_b0 = BlockPos.m_274446_((Position)DogPathNavigation.getTempDogPos(dog));
        if (!dog.m_20096_() && DogUtil.isWalkNodeEvaluatorOpenPos(dog, dog_b0_under = dog_b0.m_7495_())) {
            dog_b0 = dog_b0_under;
        }
        if (DogGreedyFireSafeSearchPath.isValidStart(dog, dog_b0)) {
            return DogGreedyFireSafeSearchPath.blockPosToNodeOptional(true, dog_b0);
        }
        AABB dog_bb = dog.m_20191_();
        BlockPos.MutableBlockPos check_pos = new BlockPos.MutableBlockPos().m_142448_(dog_b0.m_123342_());
        if (DogGreedyFireSafeSearchPath.setAndCheckValidStart(dog, check_pos, dog_bb.f_82288_, dog_bb.f_82290_)) {
            return DogGreedyFireSafeSearchPath.blockPosToNodeOptional(false, (BlockPos)check_pos);
        }
        if (DogGreedyFireSafeSearchPath.setAndCheckValidStart(dog, check_pos, dog_bb.f_82288_, dog_bb.f_82293_)) {
            return DogGreedyFireSafeSearchPath.blockPosToNodeOptional(false, (BlockPos)check_pos);
        }
        if (DogGreedyFireSafeSearchPath.setAndCheckValidStart(dog, check_pos, dog_bb.f_82291_, dog_bb.f_82290_)) {
            return DogGreedyFireSafeSearchPath.blockPosToNodeOptional(false, (BlockPos)check_pos);
        }
        if (DogGreedyFireSafeSearchPath.setAndCheckValidStart(dog, check_pos, dog_bb.f_82291_, dog_bb.f_82293_)) {
            return DogGreedyFireSafeSearchPath.blockPosToNodeOptional(false, (BlockPos)check_pos);
        }
        return Optional.empty();
    }

    private static boolean setAndCheckValidStart(Dog dog, BlockPos.MutableBlockPos pos_mut, double x, double z) {
        int y = pos_mut.m_123342_();
        pos_mut.m_122169_(x, (double)y, z);
        return DogGreedyFireSafeSearchPath.isValidStart(dog, (BlockPos)pos_mut);
    }

    private static boolean isValidStart(Dog dog, BlockPos pos) {
        BlockPos pos_below = pos.m_7495_();
        BlockState state_below = dog.m_9236_().m_8055_(pos_below);
        return state_below.m_60838_((BlockGetter)dog.m_9236_(), pos_below) || DogNodeEvaluator.dogGetPathTypeFromState((BlockGetter)dog.m_9236_(), pos_below) == BlockPathTypes.BLOCKED;
    }

    private static Optional<Pair<Boolean, Node>> blockPosToNodeOptional(boolean skipFirstNode, BlockPos pos) {
        Node ret_node = new Node(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        ret_node.f_77282_ = BlockPathTypes.WALKABLE;
        return Optional.of(Pair.of((Object)skipFirstNode, (Object)ret_node));
    }

    public void m_77374_() {
        super.m_77374_();
        if (this.finished) {
            return;
        }
        boolean append_result = this.tryAppendPath();
        if (!append_result) {
            this.finished = true;
        }
    }

    public int getWalkableCount() {
        return this.walkableCount;
    }

    public boolean m_77392_() {
        if (this.finished) {
            return true;
        }
        return this.m_77399_() >= this.nodes.size();
    }

    public boolean tryAppendPath() {
        if (this.m_77399_() >= this.maxLength) {
            return false;
        }
        if (this.nodes.isEmpty()) {
            return false;
        }
        Node old_end = this.nodes.get(this.nodes.size() - 1);
        Optional<Node> node_optional = DogGreedyFireSafeSearchPath.scanSurroundingForNextPos(this);
        if (!node_optional.isPresent()) {
            return false;
        }
        Node node = node_optional.get();
        if (node.f_77282_ != BlockPathTypes.WALKABLE && this.walkableCount > 0) {
            return false;
        }
        this.nodes.add(node);
        if (node.f_77282_ == BlockPathTypes.WALKABLE) {
            ++this.walkableCount;
        }
        if (old_end.f_77272_ == node.f_77272_ || this.nodes.size() <= 2) {
            node.f_77282_ = BlockPathTypes.WALKABLE;
        }
        return true;
    }

    private boolean containNode(Node node) {
        for (Node node1 : this.nodes) {
            if (!node1.equals((Object)node)) continue;
            return true;
        }
        return false;
    }

    private static Optional<Node> scanSurroundingForNextPos(DogGreedyFireSafeSearchPath path) {
        float malus;
        boolean is_last_resort;
        boolean clear_walkable;
        int j;
        int i;
        if (path.nodes.isEmpty()) {
            return Optional.empty();
        }
        BlockPos b0 = path.nodes.get(path.nodes.size() - 1).m_77288_();
        float malus_min = Float.MAX_VALUE;
        Node node_chosen = null;
        boolean[] BLOCKED_0_Z = new boolean[2];
        boolean[] BLOCKED_X_0 = new boolean[2];
        BlockPathTypes pathtype_above = WalkNodeEvaluator.m_77604_((BlockGetter)path.dog.m_9236_(), (BlockPos.MutableBlockPos)b0.m_7494_().m_122032_());
        Node last_resort = null;
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                boolean is_diagonally_block;
                if (i == 0 && j == 0 || i * j != 0) continue;
                Node node = DogGreedyFireSafeSearchPath.findDogNode(path.dog, b0.m_7918_(i, 0, j));
                boolean require_jump = node.f_77272_ > b0.m_123342_();
                boolean bl = is_diagonally_block = path.dog.m_21439_(node.f_77282_) < 0.0f || require_jump;
                if (is_diagonally_block) {
                    if (i != 0) {
                        BLOCKED_X_0[i > 0 ? 1 : 0] = true;
                    } else {
                        BLOCKED_0_Z[j > 0 ? 1 : 0] = true;
                    }
                }
                if (!DogGreedyFireSafeSearchPath.canAddNodeToPath(path, node) || require_jump && pathtype_above == BlockPathTypes.BLOCKED) continue;
                boolean bl2 = clear_walkable = node.f_77282_ == BlockPathTypes.WALKABLE && (!require_jump || pathtype_above == BlockPathTypes.OPEN);
                if (clear_walkable) {
                    return Optional.of(node);
                }
                boolean bl3 = is_last_resort = require_jump && pathtype_above != BlockPathTypes.BLOCKED;
                if (is_last_resort) {
                    last_resort = node;
                    continue;
                }
                malus = path.dog.m_21439_(node.f_77282_);
                if (node_chosen != null && !(malus < malus_min)) continue;
                node_chosen = node;
                malus_min = malus;
            }
        }
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                boolean require_jump;
                boolean diagonal_blocked;
                if (i == 0 && j == 0 || i * j == 0) continue;
                boolean bl = BLOCKED_0_Z[j > 0 ? 1 : 0] && BLOCKED_X_0[i > 0 ? 1 : 0] ? true : (diagonal_blocked = false);
                if (diagonal_blocked) continue;
                Node node = DogGreedyFireSafeSearchPath.findDogNode(path.dog, b0.m_7918_(i, 0, j));
                boolean bl4 = require_jump = node.f_77272_ > b0.m_123342_();
                if (!DogGreedyFireSafeSearchPath.canAddNodeToPath(path, node) || require_jump && pathtype_above == BlockPathTypes.BLOCKED) continue;
                boolean bl5 = clear_walkable = node.f_77282_ == BlockPathTypes.WALKABLE && (!require_jump || pathtype_above == BlockPathTypes.OPEN);
                if (clear_walkable) {
                    return Optional.of(node);
                }
                boolean bl6 = is_last_resort = require_jump && pathtype_above != BlockPathTypes.BLOCKED;
                if (is_last_resort) {
                    last_resort = node;
                    continue;
                }
                malus = path.dog.m_21439_(node.f_77282_);
                if (node_chosen != null && !(malus < malus_min)) continue;
                node_chosen = node;
                malus_min = malus;
            }
        }
        if (node_chosen != null) {
            return Optional.of(node_chosen);
        }
        if (last_resort != null) {
            return Optional.of(last_resort);
        }
        return Optional.empty();
    }

    private static Node findDogNode(Dog dog, BlockPos pos) {
        BlockPos.MutableBlockPos b1 = pos.m_122032_();
        BlockPathTypes b1_type = WalkNodeEvaluator.m_77604_((BlockGetter)dog.m_9236_(), (BlockPos.MutableBlockPos)b1.m_122032_());
        int offsetY = 0;
        if (b1_type == BlockPathTypes.BLOCKED) {
            offsetY = 1;
        } else if (b1_type == BlockPathTypes.OPEN) {
            offsetY = -1;
        }
        if (offsetY != 0) {
            b1.m_122184_(0, offsetY, 0);
            b1_type = WalkNodeEvaluator.m_77604_((BlockGetter)dog.m_9236_(), (BlockPos.MutableBlockPos)b1.m_122032_());
        }
        Node ret_node = new Node(b1.m_123341_(), b1.m_123342_(), b1.m_123343_());
        ret_node.f_77282_ = b1_type;
        return ret_node;
    }

    private static boolean canAddNodeToPath(DogGreedyFireSafeSearchPath path, Node node) {
        boolean already_in_path;
        boolean bl = already_in_path = path.containNode(node) || path.startNode.equals((Object)node);
        if (already_in_path) {
            return false;
        }
        if (node.f_77282_ == BlockPathTypes.OPEN) {
            return false;
        }
        return !(path.dog.m_21439_(node.f_77282_) < 0.0f);
    }
}

