/*
 * Decompiled with CFR 0.152.
 */
package liedge.bannercapes;

import liedge.bannercapes.registry.BannerCapesItems;
import liedge.bannercapes.registry.BannerCapesRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class BannerCapeRecipe
extends CustomRecipe {
    public BannerCapeRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        boolean foundHarness = false;
        boolean foundBanner = false;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof BannerItem) {
                if (!foundBanner) {
                    foundBanner = true;
                    continue;
                }
                return false;
            }
            if (stack.is(BannerCapesItems.CAPE_HARNESS)) {
                if (!foundHarness) {
                    foundHarness = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return foundHarness && foundBanner;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack stack;
        boolean foundHarness = false;
        ItemStack bannerStack = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof BannerItem) {
                if (bannerStack.isEmpty()) {
                    bannerStack = stack.copy();
                    continue;
                }
                return ItemStack.EMPTY;
            }
            if (stack.is(BannerCapesItems.CAPE_HARNESS)) {
                if (!foundHarness) {
                    foundHarness = true;
                    continue;
                }
                return ItemStack.EMPTY;
            }
            return ItemStack.EMPTY;
        }
        if (foundHarness && !bannerStack.isEmpty() && (stack = bannerStack.getItem()) instanceof BannerItem) {
            BannerItem bannerItem = (BannerItem)stack;
            ItemStack result = BannerCapesItems.BANNER_CAPES.get(bannerItem.getColor()).toStack();
            result.set(DataComponents.BANNER_PATTERNS, (Object)((BannerPatternLayers)bannerStack.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY)));
            return result;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)BannerCapesRecipeSerializers.BANNER_CAPE_CRAFTING.get();
    }
}

