/*
 * Decompiled with CFR 0.152.
 */
package sh.redkey.refiller.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import sh.redkey.refiller.config.RefillerConfig;
import sh.redkey.refiller.config.SortMode;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().create();

    private static File file() {
        return new File("./config/refiller.json");
    }

    public static void load() {
        try {
            File f = ConfigManager.file();
            if (!f.exists()) {
                ConfigManager.save();
                return;
            }
            try (FileReader r = new FileReader(f);){
                RefillerConfig cfg = (RefillerConfig)GSON.fromJson((Reader)r, RefillerConfig.class);
                if (cfg == null) {
                    cfg = new RefillerConfig();
                }
                if (cfg.sortMode == null) {
                    cfg.sortMode = SortMode.NAME;
                }
                RefillerConfig.set(cfg);
            }
        }
        catch (Exception e) {
            System.err.println("[Refiller] Error loading config, using defaults");
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            File f = ConfigManager.file();
            f.getParentFile().mkdirs();
            try (FileWriter w = new FileWriter(f);){
                GSON.toJson((Object)RefillerConfig.get(), (Appendable)w);
            }
        }
        catch (Exception e) {
            System.err.println("[Refiller] Error saving config");
            e.printStackTrace();
        }
    }
}

