/*
 * Decompiled with CFR 0.152.
 */
package sh.redkey.refiller.server;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import sh.redkey.refiller.config.RefillerConfig;
import sh.redkey.refiller.util.InvUtil;

public class RefillerServerLogic {
    public static void handleQuickStack(class_1657 player) {
        System.out.println("[Refiller] handleQuickStack called for player: " + player.method_5477().getString());
        class_1937 class_19372 = player.method_73183();
        if (!(class_19372 instanceof class_3218)) {
            System.out.println("[Refiller] Player not in ServerWorld, aborting");
            return;
        }
        class_3218 world = (class_3218)class_19372;
        RefillerConfig cfg = RefillerConfig.get();
        if (!cfg.enabled) {
            System.out.println("[Refiller] Mod is disabled in config");
            return;
        }
        class_2338 p = player.method_24515();
        System.out.println("[Refiller] Searching for containers around " + String.valueOf(p));
        int rx = Math.max(1, cfg.range);
        int ry = Math.max(1, cfg.rangeY);
        System.out.println("[Refiller] Search range: " + rx + " horizontal, " + ry + " vertical");
        Map<InvUtil.StackKey, Integer> snap = InvUtil.snapshotPlayerStacks(player, cfg.ignoreHotbar);
        System.out.println("[Refiller] Player has " + snap.size() + " different item types in inventory (ignoreHotbar=" + cfg.ignoreHotbar + ")");
        snap.forEach((key, count) -> System.out.println("  - " + String.valueOf(key.item) + " x" + count));
        int containerCount = 0;
        int containersFound = 0;
        for (class_2338 pos : class_2338.method_25996((class_2338)p, (int)rx, (int)ry, (int)rx)) {
            class_2586 be = world.method_8321(pos);
            if (!(be instanceof class_1263)) continue;
            class_1263 inv = (class_1263)be;
            System.out.println("[Refiller] Found container #" + ++containersFound + " at " + String.valueOf(pos) + " (" + inv.getClass().getSimpleName() + ") with " + inv.method_5439() + " slots");
            boolean moved = InvUtil.quickStackInto(player, inv, snap, cfg.allowEmptyDeposit, cfg.ignoreHotbar);
            if (moved) {
                System.out.println("[Refiller] \u2713 Items moved into container #" + containersFound + " (total containers with items: " + ++containerCount + ")");
                continue;
            }
            System.out.println("[Refiller] \u2717 No items moved into container #" + containersFound + " (full or no matching items)");
        }
        System.out.println("[Refiller] Summary: Found " + containersFound + " containers, moved items into " + containerCount + " of them");
        System.out.println("[Refiller] QuickStack complete. Sorted into " + containerCount + " container(s)");
        if (containerCount > 0 && cfg.playSound) {
            world.method_8396(null, p, class_3417.field_14823, class_3419.field_15248, 0.6f, 1.0f);
        }
        if (containerCount > 0 && cfg.showToast && player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            sp.method_7353((class_2561)class_2561.method_43470((String)("QuickStack: sorted into " + containerCount + " container(s)")), true);
        }
        if (containerCount == 0) {
            System.out.println("[Refiller] No items moved - check if containers exist and contain matching items");
        }
    }

    public static void handlePlayerSort(class_1657 player) {
        class_1937 class_19372;
        System.out.println("[Refiller] handlePlayerSort called for player: " + player.method_5477().getString());
        RefillerConfig cfg = RefillerConfig.get();
        if (!cfg.enabled) {
            System.out.println("[Refiller] Mod is disabled in config");
            return;
        }
        class_1661 inv = player.method_31548();
        int startSlot = 9;
        int endSlot = 36;
        System.out.println("[Refiller] Sorting player inventory from slot " + startSlot + " to " + (endSlot - 1));
        RefillerServerLogic.sortInventoryRange((class_1263)inv, startSlot, endSlot);
        if (cfg.playSound && (class_19372 = player.method_73183()) instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            world.method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.4f, 1.2f);
        }
        System.out.println("[Refiller] Player inventory sorted");
    }

    public static void handleContainerSort(class_1657 player) {
        class_1937 class_19372;
        System.out.println("[Refiller] handleContainerSort called for player: " + player.method_5477().getString());
        RefillerConfig cfg = RefillerConfig.get();
        if (!cfg.enabled) {
            System.out.println("[Refiller] Mod is disabled in config");
            return;
        }
        if (!(player instanceof class_3222)) {
            System.out.println("[Refiller] Player is not a ServerPlayerEntity");
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_1703 handler = serverPlayer.field_7512;
        if (handler == null || handler == serverPlayer.field_7498) {
            System.out.println("[Refiller] No container screen open");
            return;
        }
        ArrayList<class_1735> containerSlots = new ArrayList<class_1735>();
        for (class_1735 slot : handler.field_7761) {
            if (slot.field_7871 == player.method_31548()) continue;
            containerSlots.add(slot);
        }
        if (containerSlots.isEmpty()) {
            System.out.println("[Refiller] No container slots found");
            return;
        }
        class_1263 containerInv = ((class_1735)containerSlots.get((int)0)).field_7871;
        System.out.println("[Refiller] Sorting container with " + containerInv.method_5439() + " slots");
        RefillerServerLogic.sortInventoryRange(containerInv, 0, containerInv.method_5439());
        if (cfg.playSound && (class_19372 = player.method_73183()) instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            world.method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.4f, 1.2f);
        }
        System.out.println("[Refiller] Container sorted");
    }

    private static void sortInventoryRange(class_1263 inv, int startSlot, int endSlot) {
        RefillerConfig cfg = RefillerConfig.get();
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (int i = startSlot; i < endSlot; ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) continue;
            items.add(stack.method_7972());
        }
        ArrayList<class_1799> compacted = new ArrayList<class_1799>();
        for (class_1799 stack : items) {
            boolean merged = false;
            for (class_1799 existing : compacted) {
                if (!class_1799.method_31577((class_1799)stack, (class_1799)existing)) continue;
                int space = existing.method_7914() - existing.method_7947();
                int toAdd = Math.min(space, stack.method_7947());
                existing.method_7933(toAdd);
                stack.method_7934(toAdd);
                if (stack.method_7947() > 0) continue;
                merged = true;
                break;
            }
            if (merged || stack.method_7960()) continue;
            compacted.add(stack.method_7972());
        }
        switch (cfg.sortMode) {
            case NAME: {
                compacted.sort(Comparator.comparing(s -> s.method_7964().getString().toLowerCase()).thenComparing(s -> -s.method_7947()).thenComparing(s -> s.method_57353().toString()));
                break;
            }
            case CATEGORY: {
                compacted.sort(Comparator.comparing(s -> {
                    class_1792 item = s.method_7909();
                    String group = item.method_7854().method_7909().method_57347().toString();
                    return group;
                }).thenComparing(s -> s.method_7964().getString().toLowerCase()).thenComparing(s -> -s.method_7947()));
            }
        }
        for (int i = startSlot; i < endSlot; ++i) {
            inv.method_5447(i, class_1799.field_8037);
        }
        int slotIndex = startSlot;
        for (class_1799 stack : compacted) {
            if (slotIndex >= endSlot) break;
            inv.method_5447(slotIndex, stack.method_7972());
            ++slotIndex;
        }
        inv.method_5431();
    }
}

