/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mpc;

import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import net.mcreator.mpc.MpcMod;
import net.mcreator.mpc.init.MpcModGameRules;
import net.mcreator.mpc.procedures.GetAllOfflineTimersStringProcedure;
import net.mcreator.mpc.procedures.GetAllTakenAbilitiesStringProcedure;
import net.mcreator.mpc.procedures.GetBlacklistedAbilitiesProcedure;
import net.mcreator.mpc.procedures.SaveIsTakenProcedure;
import net.mcreator.mpc.procedures.SaveOfflineTimerProcedure;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CrystalAbilities {
    private static Random rng = new Random();
    private static ArrayList<CrystalAbility> allAbilities = new ArrayList();

    public CrystalAbilities() {
        this.addAbility("fire", "ability.mpc.fire");
        this.addAbility("explosion", "ability.mpc.explosion");
        this.addAbility("ice", "ability.mpc.ice");
        this.addAbility("static_shock", "ability.mpc.static_shock");
        this.addAbility("arrow", "ability.mpc.arrow");
        this.addAbility("water", "ability.mpc.water");
        this.addAbility("soap_bubble", "ability.mpc.soap_bubble");
        this.addAbility("life_steal", "ability.mpc.life_steal");
        this.addAbility("berserking", "ability.mpc.berserking");
        this.addAbility("shadow_demon", "ability.mpc.shadow_demon");
        this.addAbility("lightness", "ability.mpc.lightness");
        this.addAbility("swordsman", "ability.mpc.swordsman");
        this.addAbility("wind", "ability.mpc.wind");
        this.addAbility("lightning", "ability.mpc.lightning");
        this.addAbility("cooker", "ability.mpc.cooker");
        this.addAbility("black_hole", "ability.mpc.black_hole");
        this.addAbility("bone_meal", "ability.mpc.bone_meal");
        this.addAbility("healer", "ability.mpc.healer");
        this.addAbility("shield", "ability.mpc.shield");
        this.addAbility("smoke", "ability.mpc.smoke");
        this.addAbility("spatial", "ability.mpc.spatial");
        this.addAbility("weather", "ability.mpc.weather");
        this.addAbility("lava", "ability.mpc.lava");
        this.addAbility("sandstorm", "ability.mpc.sandstorm");
        this.addAbility("atomic", "ability.mpc.atomic");
        this.addAbility("mining", "ability.mpc.mining");
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        new CrystalAbilities();
    }

    private void addAbility(String name, String title) {
        if (CrystalAbilities.doesAbilityExist(name)) {
            return;
        }
        allAbilities.add(new CrystalAbility(name, title));
    }

    public static void countAbility(LevelAccessor world) {
        int daysThreshold = world.m_6106_().m_5470_().m_46215_(MpcModGameRules.DAYS_PLAYER_HAS_ABILITY_OFFLINE);
        if (daysThreshold > 0) {
            for (CrystalAbility item : allAbilities) {
                if (CrystalAbilities.isAbilityTaken(item.getName())) {
                    double daysOffline;
                    if (ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(UUID.fromString(item.getPlayerUUID())) == null) {
                        item.setTimePlayerOffline(item.getTimePlayerOffline() + 1);
                    } else {
                        item.setTimePlayerOffline(0);
                    }
                    if (!((daysOffline = (double)item.getTimePlayerOffline() / 60.0 / 60.0 / 24.0) > (double)daysThreshold)) continue;
                    CrystalAbilities.makeAbilityAvailable(world, item.getName());
                    continue;
                }
                item.setTimePlayerOffline(0);
            }
            CrystalAbilities.saveOfflineTimer(world);
        }
    }

    public static boolean isAbilityTaken(String ability) {
        for (CrystalAbility item : allAbilities) {
            if (!item.registeredName.equals(ability) || !item.getIsTaken() || item.getPlayerUUID().isBlank()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAbilityBlacklisted(String ability) {
        for (CrystalAbility item : allAbilities) {
            if (!item.registeredName.equals(ability) || !item.getIsBlacklisted()) continue;
            return true;
        }
        return false;
    }

    public static boolean doesPlayerOwnAbility(String playerUUID, String name) {
        if (!CrystalAbilities.doesAbilityExist(name)) {
            return false;
        }
        for (CrystalAbility ca : allAbilities) {
            if (!ca.getName().equals(name)) continue;
            return ca.getPlayerUUID().equals(playerUUID);
        }
        return false;
    }

    public static boolean areAllAbilitiesTaken() {
        int counter = 0;
        for (CrystalAbility ability : allAbilities) {
            if (!ability.getIsTaken() || ability.getPlayerUUID().isBlank()) continue;
            ++counter;
        }
        return counter == allAbilities.size();
    }

    public static boolean doesAbilityExist(String name) {
        for (CrystalAbility ca : allAbilities) {
            if (!ca.registeredName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static String giveAvailableAbility(LevelAccessor world, String playerUUID) {
        if (CrystalAbilities.areAllAbilitiesTaken()) {
            return "";
        }
        int index = 0;
        while (allAbilities.get(index = rng.nextInt(allAbilities.size())).getIsTaken() || allAbilities.get(index).getIsBlacklisted()) {
        }
        allAbilities.get(index).setIsTaken(true);
        allAbilities.get(index).setPlayerUUID(playerUUID);
        CrystalAbilities.saveIsTaken(world);
        return allAbilities.get(index).getName();
    }

    public static String giveSpecificAbility(LevelAccessor world, String playerUUID, String name, boolean considerBlacklist) {
        if (CrystalAbilities.isAbilityTaken(name) || CrystalAbilities.isAbilityBlacklisted(name) && considerBlacklist) {
            return "";
        }
        int index = 0;
        for (int i = 0; i < allAbilities.size(); ++i) {
            if (!allAbilities.get(i).getName().equals(name)) continue;
            index = i;
            break;
        }
        allAbilities.get(index).setIsTaken(true);
        allAbilities.get(index).setPlayerUUID(playerUUID);
        CrystalAbilities.saveIsTaken(world);
        return allAbilities.get(index).getName();
    }

    public static void makeAbilityAvailable(LevelAccessor world, String name) {
        if (!CrystalAbilities.doesAbilityExist(name)) {
            return;
        }
        int index = 0;
        for (int i = 0; i < allAbilities.size(); ++i) {
            if (!allAbilities.get(i).getName().equals(name)) continue;
            index = i;
            break;
        }
        allAbilities.get(index).setIsTaken(false);
        allAbilities.get(index).setPlayerUUID("");
        allAbilities.get(index).setTimePlayerOffline(0);
        CrystalAbilities.saveIsTaken(world);
    }

    public static void makeAllAbilitiesAvailable(LevelAccessor world) {
        for (int i = 0; i < allAbilities.size(); ++i) {
            allAbilities.get(i).setIsTaken(false);
            allAbilities.get(i).setPlayerUUID("");
        }
        CrystalAbilities.saveIsTaken(world);
    }

    public static String getTitleFromName(String name) {
        for (CrystalAbility ca : allAbilities) {
            if (!ca.registeredName.equals(name)) continue;
            return ca.getTitle();
        }
        return "[UNKNOWN_ABILITY]";
    }

    public static void setisTakenByName(String name, boolean isTaken) {
        if (!CrystalAbilities.doesAbilityExist(name)) {
            return;
        }
        for (CrystalAbility ca : allAbilities) {
            if (!ca.registeredName.equals(name)) continue;
            ca.setIsTaken(isTaken);
            return;
        }
    }

    public static void printAbilities() {
        for (CrystalAbility ca : allAbilities) {
            MpcMod.LOGGER.info(ca.toString());
        }
    }

    public static String getTakenAbilitiesStr() {
        Object str = "";
        int i = 0;
        for (CrystalAbility ca : allAbilities) {
            str = (String)str + ca.getName() + " = " + (ca.getPlayerUUID() == "" ? "\u00a7aFree" : "\u00a7cTaken") + "\u00a7r        " + (i % 2 == 1 ? "\n" : "");
            ++i;
        }
        return str;
    }

    public static void saveIsTaken(LevelAccessor world) {
        Object strToSave = "";
        for (CrystalAbility ca : allAbilities) {
            strToSave = (String)strToSave + ca.getName().replaceAll(" ", "") + "=\"" + ca.getPlayerUUID() + "\",";
        }
        if (((String)strToSave).endsWith(",")) {
            strToSave = ((String)strToSave).substring(0, ((String)strToSave).length() - 1);
        }
        SaveIsTakenProcedure.execute(world, (String)strToSave);
    }

    public static void saveOfflineTimer(LevelAccessor world) {
        Object strToSave = "";
        for (CrystalAbility ca : allAbilities) {
            strToSave = (String)strToSave + ca.getName().replaceAll(" ", "") + "=\"" + ca.getTimePlayerOffline() + "\",";
        }
        if (((String)strToSave).endsWith(",")) {
            strToSave = ((String)strToSave).substring(0, ((String)strToSave).length() - 1);
        }
        SaveOfflineTimerProcedure.execute(world, (String)strToSave);
    }

    public static boolean getSavedIsTaken(String name, LevelAccessor world) {
        String[] arrList;
        String list = GetAllTakenAbilitiesStringProcedure.execute(world).replaceAll(" ", "");
        for (String item : arrList = list.split(",")) {
            if (!item.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static void loadIsTaken(LevelAccessor world) {
        String list = GetAllTakenAbilitiesStringProcedure.execute(world).replaceAll(" ", "");
        String[] arrList = list.split(",");
        for (int i = 0; i < allAbilities.size(); ++i) {
            String uuid;
            try {
                uuid = arrList[i].split("=")[1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                uuid = "";
            }
            allAbilities.get(i).setIsTaken(!uuid.isBlank());
            allAbilities.get(i).setPlayerUUID(uuid.replace("\"", ""));
        }
    }

    public static void loadOfflineTimers(LevelAccessor world) {
        String list = GetAllOfflineTimersStringProcedure.execute(world).replaceAll(" ", "");
        String[] arrList = list.split(",");
        for (int i = 0; i < allAbilities.size(); ++i) {
            int timer = 0;
            try {
                timer = Integer.parseInt(arrList[i].split("=")[1].replaceAll("\"", ""));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                timer = 0;
            }
            catch (NumberFormatException e) {
                timer = 0;
            }
            allAbilities.get(i).setTimePlayerOffline(timer);
        }
    }

    public static void loadIsBlacklisted(LevelAccessor world) {
        String list = GetBlacklistedAbilitiesProcedure.execute(world).replaceAll(" ", "");
        String[] arrList = list.split(",");
        for (int i = 0; i < allAbilities.size(); ++i) {
            allAbilities.get(i).setIsBlacklisted(false);
        }
        block1: for (String item : arrList) {
            for (int i = 0; i < allAbilities.size(); ++i) {
                if (!item.equals(allAbilities.get(i).getName())) continue;
                allAbilities.get(i).setIsBlacklisted(true);
                continue block1;
            }
        }
    }

    public class CrystalAbility {
        private String registeredName;
        private String title;
        private String playerUUID = "";
        private int timePlayerOffline = 0;
        private boolean isTaken = false;
        private boolean isBlacklisted = false;

        public CrystalAbility(String registeredName, String title) {
            this.registeredName = registeredName;
            this.title = title;
        }

        public String getName() {
            return this.registeredName;
        }

        public String getTitle() {
            return this.title;
        }

        public String getPlayerUUID() {
            return this.playerUUID;
        }

        public int getTimePlayerOffline() {
            return this.timePlayerOffline;
        }

        public boolean getIsTaken() {
            return this.isTaken;
        }

        public boolean getIsBlacklisted() {
            return this.isBlacklisted;
        }

        public void setPlayerUUID(String uuid) {
            this.playerUUID = uuid;
            this.isTaken = !this.playerUUID.isBlank();
        }

        public void setTimePlayerOffline(int newTime) {
            this.timePlayerOffline = newTime;
        }

        public void setIsTaken(boolean newIsTaken) {
            this.isTaken = newIsTaken;
        }

        public void setIsBlacklisted(boolean newIsBlacklisted) {
            this.isBlacklisted = newIsBlacklisted;
        }

        public String toString() {
            return this.registeredName + "\t\t\tTimeOffline: " + this.timePlayerOffline + "\tUUID:" + this.playerUUID;
        }
    }

    @Mod.EventBusSubscriber
    private static class ForgeBusEvents {
        private ForgeBusEvents() {
        }

        @SubscribeEvent
        public static void serverLoad(ServerStartingEvent event) {
        }
    }
}

