/*
 * Decompiled with CFR 0.152.
 */
package io.github.fablabsmc.fablabs.impl.fiber.tree;

import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.SerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigBranch;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigLeaf;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigNode;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.NodeCollection;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import io.github.fablabsmc.fablabs.impl.fiber.tree.ConfigNodeImpl;
import io.github.fablabsmc.fablabs.impl.fiber.tree.IndexedNodeCollection;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConfigBranchImpl
extends ConfigNodeImpl
implements ConfigBranch {
    private final NodeCollection items = new IndexedNodeCollection(this);
    private final boolean serializeSeparately;

    public ConfigBranchImpl(String name, @Nullable String comment, @Nonnull Collection<ConfigNode> items, boolean serializeSeparately) {
        super(name, comment);
        this.serializeSeparately = serializeSeparately;
        this.items.addAll(items);
    }

    public ConfigBranchImpl(@Nonnull String name, @Nullable String comment) {
        this(name, comment, Collections.emptyList(), false);
    }

    public ConfigBranchImpl() {
        this(null, null, Collections.emptyList(), false);
    }

    @Override
    @Nonnull
    public NodeCollection getItems() {
        return this.items;
    }

    @Override
    @Nullable
    public ConfigNode lookup(String name) {
        return this.items.getByName(name);
    }

    @Override
    @Nullable
    public <T> ConfigLeaf<T> lookupLeaf(String name, SerializableType<T> type) {
        ConfigNode child = this.items.getByName(name);
        if (child instanceof ConfigLeaf && type.isAssignableFrom(((ConfigLeaf)child).getConfigType())) {
            ConfigLeaf leaf = (ConfigLeaf)child;
            return leaf;
        }
        return null;
    }

    @Override
    public boolean lookupAndBind(String name, PropertyMirror<?> mirror) {
        ConfigLeaf leaf = this.lookupLeaf(name, (SerializableType)mirror.getMirroredType().getSerializedType());
        if (leaf != null) {
            mirror.mirror(leaf);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public ConfigBranch lookupBranch(String name) {
        ConfigNode child = this.items.getByName(name);
        if (child instanceof ConfigBranch) {
            return (ConfigBranch)child;
        }
        return null;
    }

    @Override
    public boolean isSerializedSeparately() {
        return this.serializeSeparately;
    }
}

