/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCrimsonMosquito;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class EntityFly
extends AnimalEntity
implements IFlyingAnimal {
    private int conversionTime = 0;
    private static final DataParameter<Boolean> NO_DESPAWN = EntityDataManager.func_187226_a(EntityFly.class, (IDataSerializer)DataSerializers.field_187198_h);

    protected EntityFly(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 16.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("NoFlyDespawn", this.isNoDespawn());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setNoDespawn(compound.func_74767_n("NoFlyDespawn"));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(NO_DESPAWN, (Object)false);
    }

    public boolean isNoDespawn() {
        return (Boolean)this.field_70180_af.func_187225_a(NO_DESPAWN);
    }

    public void setNoDespawn(boolean despawn) {
        this.field_70180_af.func_187227_b(NO_DESPAWN, (Object)despawn);
    }

    public static boolean canFlySpawn(EntityType<EntityFly> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return reason == SpawnReason.SPAWNER || pos.func_177956_o() > 63 && random.nextInt(4) == 0 && worldIn.func_226659_b_(pos, 0) > 8 && worldIn.func_226658_a_(LightType.BLOCK, pos) == 0 && (BlockTags.field_203436_u.func_230235_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c()) || Tags.Blocks.DIRT.func_230235_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c()));
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_213392_I();
    }

    public boolean func_213392_I() {
        return this.isNoDespawn() || super.func_213392_I();
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.flySpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public boolean isInNether() {
        return this.field_70170_p.func_234923_W_() == World.field_234919_h_ && !this.func_175446_cd();
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.FLY_IDLE;
    }

    public int func_70627_aG() {
        return 30;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.FLY_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.FLY_HURT;
    }

    public int func_70641_bl() {
        return 2;
    }

    public boolean func_204209_c(int sizeIn) {
        return false;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 2.0).func_233815_a_(Attributes.field_233822_e_, (double)0.8f).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos).func_196958_f() ? 10.0f : 0.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151078_bh, Items.field_151102_aT}), false));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, SpiderEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (Goal)new AnnoyZombieGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new WanderGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new SwimGoal((MobEntity)this));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn){

            public boolean func_188555_b(BlockPos pos) {
                return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
            }
        };
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? sizeIn.field_220316_b * 0.5f : sizeIn.field_220316_b * 0.5f;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.field_70143_R = 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70631_g_() && this.func_70047_e() > this.func_213302_cg()) {
            this.func_213323_x_();
        }
        if (this.func_70880_s() && !this.isNoDespawn()) {
            this.setNoDespawn(true);
        }
        if (this.isInNether()) {
            this.setNoDespawn(true);
            ++this.conversionTime;
            if (this.conversionTime > 300) {
                EntityCrimsonMosquito mosquito = (EntityCrimsonMosquito)AMEntityRegistry.CRIMSON_MOSQUITO.func_200721_a(this.field_70170_p);
                mosquito.func_82149_j((Entity)this);
                if (!this.field_70170_p.field_72995_K) {
                    mosquito.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.CONVERSION, null, null);
                }
                this.field_70170_p.func_217376_c((Entity)mosquito);
                mosquito.onSpawnFromFly();
                this.func_70106_y();
            }
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack lvt_3_1_ = p_230254_1_.func_184586_b(p_230254_2_);
        if (lvt_3_1_.func_77973_b() == Items.field_151102_aT) {
            if (!p_230254_1_.func_184812_l_()) {
                lvt_3_1_.func_190918_g(1);
            }
            this.setNoDespawn(true);
            this.func_70691_i(2.0f);
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected boolean func_191957_ae() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    protected void func_180466_bG(ITag<Fluid> fluidTag) {
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.01, 0.0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, (double)(0.5f * this.func_70047_e()), (double)(this.func_213311_cf() * 0.2f));
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151078_bh;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)AMEntityRegistry.FLY.func_200721_a((World)p_241840_1_);
    }

    private class AnnoyZombieGoal
    extends Goal {
        protected final Sorter theNearestAttackableTargetSorter;
        protected final Predicate<? super Entity> targetEntitySelector;
        protected int executionChance = 8;
        protected boolean mustUpdate;
        private Entity targetEntity;
        private int cooldown = 0;
        private ITag tag;

        AnnoyZombieGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.tag = EntityTypeTags.func_219762_a().func_199910_a(AMTagRegistry.FLY_TARGETS);
            this.theNearestAttackableTargetSorter = new Sorter((Entity)EntityFly.this);
            this.targetEntitySelector = new Predicate<Entity>(){

                public boolean apply(@Nullable Entity e) {
                    return e.func_70089_S() && AnnoyZombieGoal.this.tag != null && e.func_200600_R().func_220341_a(AnnoyZombieGoal.this.tag) && (!(e instanceof LivingEntity) || (double)((LivingEntity)e).func_110143_aJ() >= 2.0);
                }
            };
        }

        public boolean func_75250_a() {
            List list;
            if (EntityFly.this.func_184218_aH() || EntityFly.this.func_184207_aI()) {
                return false;
            }
            if (!this.mustUpdate) {
                long worldTime = EntityFly.this.field_70170_p.func_82737_E() % 10L;
                if (EntityFly.this.func_70654_ax() >= 100 && worldTime != 0L) {
                    return false;
                }
                if (EntityFly.this.func_70681_au().nextInt(this.executionChance) != 0 && worldTime != 0L) {
                    return false;
                }
            }
            if ((list = EntityFly.this.field_70170_p.func_175647_a(Entity.class, this.getTargetableArea(this.getTargetDistance()), this.targetEntitySelector)).isEmpty()) {
                return false;
            }
            Collections.sort(list, this.theNearestAttackableTargetSorter);
            this.targetEntity = (Entity)list.get(0);
            this.mustUpdate = false;
            return true;
        }

        public boolean func_75253_b() {
            return this.targetEntity != null;
        }

        public void func_75251_c() {
            this.targetEntity = null;
        }

        public void func_75246_d() {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.targetEntity != null) {
                if (EntityFly.this.func_70661_as().func_75500_f()) {
                    int i = EntityFly.this.func_70681_au().nextInt(3) - 1;
                    int k = EntityFly.this.func_70681_au().nextInt(3) - 1;
                    int l = (int)((double)(EntityFly.this.func_70681_au().nextInt(3) - 1) * Math.ceil(this.targetEntity.func_213302_cg()));
                    EntityFly.this.func_70661_as().func_75492_a(this.targetEntity.func_226277_ct_() + (double)i, this.targetEntity.func_226278_cu_() + (double)l, this.targetEntity.func_226281_cx_() + (double)k, 1.0);
                }
                if (EntityFly.this.func_70068_e(this.targetEntity) < 3.0) {
                    if (this.targetEntity instanceof LivingEntity && (double)((LivingEntity)this.targetEntity).func_110143_aJ() > 2.0) {
                        if (this.cooldown == 0) {
                            this.targetEntity.func_70097_a(DamageSource.field_76377_j, 1.0f);
                            this.cooldown = 100;
                        }
                    } else {
                        this.func_75251_c();
                    }
                }
            }
        }

        protected double getTargetDistance() {
            return 16.0;
        }

        protected AxisAlignedBB getTargetableArea(double targetDistance) {
            Vector3d renderCenter = new Vector3d(EntityFly.this.func_226277_ct_() + 0.5, EntityFly.this.func_226278_cu_() + 0.5, EntityFly.this.func_226281_cx_() + 0.5);
            double renderRadius = 5.0;
            AxisAlignedBB aabb = new AxisAlignedBB(-renderRadius, -renderRadius, -renderRadius, renderRadius, renderRadius, renderRadius);
            return aabb.func_191194_a(renderCenter);
        }

        public class Sorter
        implements Comparator<Entity> {
            private final Entity theEntity;

            public Sorter(Entity theEntityIn) {
                this.theEntity = theEntityIn;
            }

            @Override
            public int compare(Entity p_compare_1_, Entity p_compare_2_) {
                double d1;
                double d0 = this.theEntity.func_70068_e(p_compare_1_);
                return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
            }
        }
    }

    class WanderGoal
    extends Goal {
        WanderGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return EntityFly.this.field_70699_by.func_75500_f() && EntityFly.this.field_70146_Z.nextInt(3) == 0;
        }

        public boolean func_75253_b() {
            return EntityFly.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            Vector3d vector3d = this.getRandomLocation();
            if (vector3d != null) {
                EntityFly.this.field_70699_by.func_75484_a(EntityFly.this.field_70699_by.func_179680_a(new BlockPos(vector3d), 1), 1.0);
            }
        }

        @Nullable
        private Vector3d getRandomLocation() {
            Vector3d vector3d = EntityFly.this.func_70676_i(0.0f);
            int i = 8;
            Vector3d vector3d2 = RandomPositionGenerator.func_226340_a_((CreatureEntity)EntityFly.this, (int)3, (int)3, (Vector3d)vector3d, (float)1.5707964f, (int)1, (int)1);
            return vector3d2 != null ? vector3d2 : RandomPositionGenerator.func_226338_a_((CreatureEntity)EntityFly.this, (int)3, (int)3, (int)-3, (Vector3d)vector3d, (double)1.5707963705062866);
        }
    }
}

