/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.api;

import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_attributes.impl.PercentBasedAttribute;
import dev.shadowsoffire.apothic_attributes.mob_effect.BleedingEffect;
import dev.shadowsoffire.apothic_attributes.mob_effect.DetonationEffect;
import dev.shadowsoffire.apothic_attributes.mob_effect.FlyingEffect;
import dev.shadowsoffire.apothic_attributes.mob_effect.GrievousEffect;
import dev.shadowsoffire.apothic_attributes.mob_effect.KnowledgeEffect;
import dev.shadowsoffire.apothic_attributes.mob_effect.SunderingEffect;
import dev.shadowsoffire.apothic_attributes.mob_effect.VitalityEffect;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.BooleanAttribute;
import org.jetbrains.annotations.ApiStatus;

public class ALObjects {
    @ApiStatus.Internal
    public static void bootstrap(IEventBus bus) {
        Attributes.bootstrap();
        MobEffects.bootstrap();
        Particles.bootstrap();
        Sounds.bootstrap();
        DamageTypes.bootstrap();
        Potions.bootstrap();
        Components.bootstrap();
        bus.register((Object)ApothicAttributes.R);
    }

    public static class Attributes {
        public static final Holder<Attribute> ARMOR_PIERCE = ApothicAttributes.R.attribute("armor_pierce", () -> new RangedAttribute("apothic_attributes:armor_pierce", 0.0, 0.0, 1000.0).setSyncable(true));
        public static final Holder<Attribute> ARMOR_SHRED = ApothicAttributes.R.attribute("armor_shred", () -> new PercentBasedAttribute("apothic_attributes:armor_shred", 0.0, 0.0, 2.0).setSyncable(true));
        public static final Holder<Attribute> ARROW_DAMAGE = ApothicAttributes.R.attribute("arrow_damage", () -> new PercentBasedAttribute("apothic_attributes:arrow_damage", 1.0, 0.0, 10.0).setSyncable(true));
        public static final Holder<Attribute> ARROW_VELOCITY = ApothicAttributes.R.attribute("arrow_velocity", () -> new PercentBasedAttribute("apothic_attributes:arrow_velocity", 1.0, 0.0, 10.0).setSyncable(true));
        public static final Holder<Attribute> COLD_DAMAGE = ApothicAttributes.R.attribute("cold_damage", () -> new RangedAttribute("apothic_attributes:cold_damage", 0.0, 0.0, 1000.0).setSyncable(true));
        public static final Holder<Attribute> CRIT_CHANCE = ApothicAttributes.R.attribute("crit_chance", () -> new PercentBasedAttribute("apothic_attributes:crit_chance", 0.05, 0.0, 10.0).setSyncable(true));
        public static final Holder<Attribute> CRIT_DAMAGE = ApothicAttributes.R.attribute("crit_damage", () -> new PercentBasedAttribute("apothic_attributes:crit_damage", 1.5, 1.0, 100.0).setSyncable(true));
        public static final Holder<Attribute> CURRENT_HP_DAMAGE = ApothicAttributes.R.attribute("current_hp_damage", () -> new PercentBasedAttribute("apothic_attributes:current_hp_damage", 0.0, 0.0, 1.0).setSyncable(true));
        public static final Holder<Attribute> DODGE_CHANCE = ApothicAttributes.R.attribute("dodge_chance", () -> new PercentBasedAttribute("apothic_attributes:dodge_chance", 0.0, 0.0, 1.0).setSyncable(true));
        public static final Holder<Attribute> DRAW_SPEED = ApothicAttributes.R.attribute("draw_speed", () -> new PercentBasedAttribute("apothic_attributes:draw_speed", 1.0, 0.0, 4.0).setSyncable(true));
        public static final Holder<Attribute> EXPERIENCE_GAINED = ApothicAttributes.R.attribute("experience_gained", () -> new PercentBasedAttribute("apothic_attributes:experience_gained", 1.0, 0.0, 1000.0).setSyncable(true));
        public static final Holder<Attribute> FIRE_DAMAGE = ApothicAttributes.R.attribute("fire_damage", () -> new RangedAttribute("apothic_attributes:fire_damage", 0.0, 0.0, 1000.0).setSyncable(true));
        public static final Holder<Attribute> GHOST_HEALTH = ApothicAttributes.R.attribute("ghost_health", () -> new RangedAttribute("apothic_attributes:ghost_health", 0.0, 0.0, 1000.0).setSyncable(true));
        public static final Holder<Attribute> HEALING_RECEIVED = ApothicAttributes.R.attribute("healing_received", () -> new PercentBasedAttribute("apothic_attributes:healing_received", 1.0, 0.0, 1000.0).setSyncable(true));
        public static final Holder<Attribute> LIFE_STEAL = ApothicAttributes.R.attribute("life_steal", () -> new PercentBasedAttribute("apothic_attributes:life_steal", 0.0, 0.0, 10.0).setSyncable(true));
        public static final Holder<Attribute> MINING_SPEED = ApothicAttributes.R.attribute("mining_speed", () -> new PercentBasedAttribute("apothic_attributes:mining_speed", 1.0, 0.0, 10.0).setSyncable(true));
        public static final Holder<Attribute> OVERHEAL = ApothicAttributes.R.attribute("overheal", () -> new PercentBasedAttribute("apothic_attributes:overheal", 0.0, 0.0, 10.0).setSyncable(true));
        public static final Holder<Attribute> PROT_PIERCE = ApothicAttributes.R.attribute("prot_pierce", () -> new RangedAttribute("apothic_attributes:prot_pierce", 0.0, 0.0, 34.0).setSyncable(true));
        public static final Holder<Attribute> PROT_SHRED = ApothicAttributes.R.attribute("prot_shred", () -> new PercentBasedAttribute("apothic_attributes:prot_shred", 0.0, 0.0, 1.0).setSyncable(true));
        public static final Holder<Attribute> ELYTRA_FLIGHT = ApothicAttributes.R.attribute("elytra_flight", () -> new BooleanAttribute("apothic_attributes:elytra_flight", false).setSyncable(true));

        @ApiStatus.Internal
        public static void bootstrap() {
        }
    }

    public static class MobEffects
    extends net.minecraft.world.effect.MobEffects {
        public static final Holder<MobEffect> BLEEDING = ApothicAttributes.R.effect("bleeding", BleedingEffect::new);
        public static final Holder<MobEffect> DETONATION = ApothicAttributes.R.effect("detonation", DetonationEffect::new);
        public static final Holder<MobEffect> GRIEVOUS = ApothicAttributes.R.effect("grievous", GrievousEffect::new);
        public static final Holder<MobEffect> KNOWLEDGE = ApothicAttributes.R.effect("knowledge", KnowledgeEffect::new);
        public static final Holder<MobEffect> SUNDERING = ApothicAttributes.R.effect("sundering", SunderingEffect::new);
        public static final Holder<MobEffect> VITALITY = ApothicAttributes.R.effect("vitality", VitalityEffect::new);
        public static final Holder<MobEffect> FLYING = ApothicAttributes.R.effect("flying", FlyingEffect::new);

        @ApiStatus.Internal
        public static void bootstrap() {
        }
    }

    public static class Particles {
        public static final Supplier<SimpleParticleType> APOTH_CRIT = ApothicAttributes.R.particle("apoth_crit", () -> new SimpleParticleType(false));

        @ApiStatus.Internal
        public static void bootstrap() {
        }
    }

    public static class Sounds {
        public static final Holder<SoundEvent> DODGE = ApothicAttributes.R.sound("dodge");

        @ApiStatus.Internal
        public static void bootstrap() {
        }
    }

    public static class DamageTypes {
        public static final ResourceKey<DamageType> BLEEDING = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ApothicAttributes.loc("bleeding"));
        public static final ResourceKey<DamageType> DETONATION = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ApothicAttributes.loc("detonation"));
        public static final ResourceKey<DamageType> CURRENT_HP_DAMAGE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ApothicAttributes.loc("current_hp_damage"));
        public static final ResourceKey<DamageType> FIRE_DAMAGE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ApothicAttributes.loc("fire_damage"));
        public static final ResourceKey<DamageType> COLD_DAMAGE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ApothicAttributes.loc("cold_damage"));

        @ApiStatus.Internal
        public static void bootstrap() {
        }
    }

    public static final class Potions {
        public static final Holder<Potion> RESISTANCE = ApothicAttributes.R.singlePotion("resistance", () -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 3600));
        public static final Holder<Potion> LONG_RESISTANCE = ApothicAttributes.R.singlePotion("long_resistance", () -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 9600));
        public static final Holder<Potion> STRONG_RESISTANCE = ApothicAttributes.R.singlePotion("strong_resistance", () -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1800, 1));
        public static final Holder<Potion> ABSORPTION = ApothicAttributes.R.singlePotion("absorption", () -> new MobEffectInstance(MobEffects.ABSORPTION, 1200, 1));
        public static final Holder<Potion> LONG_ABSORPTION = ApothicAttributes.R.singlePotion("long_absorption", () -> new MobEffectInstance(MobEffects.ABSORPTION, 3600, 1));
        public static final Holder<Potion> STRONG_ABSORPTION = ApothicAttributes.R.singlePotion("strong_absorption", () -> new MobEffectInstance(MobEffects.ABSORPTION, 600, 3));
        public static final Holder<Potion> HASTE = ApothicAttributes.R.singlePotion("haste", () -> new MobEffectInstance(MobEffects.DIG_SPEED, 3600));
        public static final Holder<Potion> LONG_HASTE = ApothicAttributes.R.singlePotion("long_haste", () -> new MobEffectInstance(MobEffects.DIG_SPEED, 9600));
        public static final Holder<Potion> STRONG_HASTE = ApothicAttributes.R.singlePotion("strong_haste", () -> new MobEffectInstance(MobEffects.DIG_SPEED, 1800, 1));
        public static final Holder<Potion> FATIGUE = ApothicAttributes.R.singlePotion("fatigue", () -> new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 3600));
        public static final Holder<Potion> LONG_FATIGUE = ApothicAttributes.R.singlePotion("long_fatigue", () -> new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 9600));
        public static final Holder<Potion> STRONG_FATIGUE = ApothicAttributes.R.singlePotion("strong_fatigue", () -> new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 1800, 1));
        public static final Holder<Potion> WITHER = ApothicAttributes.R.singlePotion("wither", () -> new MobEffectInstance(MobEffects.WITHER, 3600));
        public static final Holder<Potion> LONG_WITHER = ApothicAttributes.R.singlePotion("long_wither", () -> new MobEffectInstance(MobEffects.WITHER, 9600));
        public static final Holder<Potion> STRONG_WITHER = ApothicAttributes.R.singlePotion("strong_wither", () -> new MobEffectInstance(MobEffects.WITHER, 1800, 1));
        public static final Holder<Potion> SUNDERING = ApothicAttributes.R.singlePotion("sundering", () -> new MobEffectInstance(MobEffects.SUNDERING, 3600));
        public static final Holder<Potion> LONG_SUNDERING = ApothicAttributes.R.singlePotion("long_sundering", () -> new MobEffectInstance(MobEffects.SUNDERING, 9600));
        public static final Holder<Potion> STRONG_SUNDERING = ApothicAttributes.R.singlePotion("strong_sundering", () -> new MobEffectInstance(MobEffects.SUNDERING, 1800, 1));
        public static final Holder<Potion> KNOWLEDGE = ApothicAttributes.R.singlePotion("knowledge", () -> new MobEffectInstance(MobEffects.KNOWLEDGE, 2400));
        public static final Holder<Potion> LONG_KNOWLEDGE = ApothicAttributes.R.singlePotion("long_knowledge", () -> new MobEffectInstance(MobEffects.KNOWLEDGE, 4800));
        public static final Holder<Potion> STRONG_KNOWLEDGE = ApothicAttributes.R.singlePotion("strong_knowledge", () -> new MobEffectInstance(MobEffects.KNOWLEDGE, 1200, 3));
        public static final Holder<Potion> VITALITY = ApothicAttributes.R.singlePotion("vitality", () -> new MobEffectInstance(MobEffects.VITALITY, 4800));
        public static final Holder<Potion> LONG_VITALITY = ApothicAttributes.R.singlePotion("long_vitality", () -> new MobEffectInstance(MobEffects.VITALITY, 14400));
        public static final Holder<Potion> STRONG_VITALITY = ApothicAttributes.R.singlePotion("strong_vitality", () -> new MobEffectInstance(MobEffects.VITALITY, 3600, 1));
        public static final Holder<Potion> GRIEVOUS = ApothicAttributes.R.singlePotion("grievous", () -> new MobEffectInstance(MobEffects.GRIEVOUS, 4800));
        public static final Holder<Potion> LONG_GRIEVOUS = ApothicAttributes.R.singlePotion("long_grievous", () -> new MobEffectInstance(MobEffects.GRIEVOUS, 14400));
        public static final Holder<Potion> STRONG_GRIEVOUS = ApothicAttributes.R.singlePotion("strong_grievous", () -> new MobEffectInstance(MobEffects.GRIEVOUS, 3600, 1));
        public static final Holder<Potion> LEVITATION = ApothicAttributes.R.singlePotion("levitation", () -> new MobEffectInstance(MobEffects.LEVITATION, 2400));
        public static final Holder<Potion> FLYING = ApothicAttributes.R.singlePotion("flying", () -> new MobEffectInstance(MobEffects.FLYING, 9600));
        public static final Holder<Potion> LONG_FLYING = ApothicAttributes.R.singlePotion("long_flying", () -> new MobEffectInstance(MobEffects.FLYING, 18000));
        public static final Holder<Potion> EXTRA_LONG_FLYING = ApothicAttributes.R.singlePotion("extra_long_flying", () -> new MobEffectInstance(MobEffects.FLYING, 36000));

        @ApiStatus.Internal
        public static void bootstrap() {
        }
    }

    public static class Components {
        public static final DataComponentType<ItemAttributeModifiers> BONUS_ATTRIBUTE_MODIFIERS = ApothicAttributes.R.component("bonus_attribute_modifiers", builder -> builder.persistent(ItemAttributeModifiers.CODEC).networkSynchronized(ItemAttributeModifiers.STREAM_CODEC).cacheEncoding());

        @ApiStatus.Internal
        public static void bootstrap() {
        }
    }

    public static class Tags {
        public static final TagKey<Attribute> DYNAMIC_BASE_ATTRIBUTES = TagKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)ApothicAttributes.loc("dynamic_base"));
    }
}

